/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IPending;
import clojure.lang.Util;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Delay
implements IDeref,
IPending {
    Object val;
    Throwable exception;
    IFn fn;
    volatile Lock lock;

    public Delay(IFn f) {
        this.fn = f;
        this.val = null;
        this.exception = null;
        this.lock = new ReentrantLock();
    }

    public static Object force(Object x) {
        return x instanceof Delay ? ((Delay)x).deref() : x;
    }

    private void realize() {
        block6: {
            Lock l = this.lock;
            if (l != null) {
                l.lock();
                try {
                    if (this.fn == null) break block6;
                    try {
                        this.val = this.fn.invoke();
                    }
                    catch (Throwable t) {
                        this.exception = t;
                    }
                    this.fn = null;
                    this.lock = null;
                }
                finally {
                    l.unlock();
                }
            }
        }
    }

    @Override
    public Object deref() {
        if (this.lock != null) {
            this.realize();
        }
        if (this.exception != null) {
            throw Util.sneakyThrow(this.exception);
        }
        return this.val;
    }

    @Override
    public boolean isRealized() {
        return this.lock == null;
    }
}

