/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.common;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MultiDateFormat
extends DateFormat {
    protected SimpleDateFormat[] m_formats;

    public MultiDateFormat(String ... patterns) {
        this.m_formats = new SimpleDateFormat[patterns.length];
        for (int index = 0; index < patterns.length; ++index) {
            this.m_formats[index] = new SimpleDateFormat(patterns[index]);
        }
    }

    @Override
    public Date parse(String str, ParsePosition pos) {
        Date result;
        if (str == null || str.trim().length() == 0) {
            result = null;
            pos.setIndex(-1);
        } else {
            result = this.parseNonNullDate(str, pos);
        }
        return result;
    }

    protected Date parseNonNullDate(String str, ParsePosition pos) {
        Date result = null;
        for (SimpleDateFormat format : this.m_formats) {
            result = format.parse(str, pos);
            if (pos.getIndex() != 0) break;
            result = null;
        }
        return result;
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        return this.m_formats[0].format(date, toAppendTo, fieldPosition);
    }
}

