﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/transcribe/TranscribeServiceRequest.h>
#include <aws/transcribe/TranscribeService_EXPORTS.h>

#include <utility>

namespace Aws {
namespace TranscribeService {
namespace Model {

/**
 */
class GetTranscriptionJobRequest : public TranscribeServiceRequest {
 public:
  AWS_TRANSCRIBESERVICE_API GetTranscriptionJobRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetTranscriptionJob"; }

  AWS_TRANSCRIBESERVICE_API Aws::String SerializePayload() const override;

  AWS_TRANSCRIBESERVICE_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The name of the transcription job you want information about. Job names are
   * case sensitive.</p>
   */
  inline const Aws::String& GetTranscriptionJobName() const { return m_transcriptionJobName; }
  inline bool TranscriptionJobNameHasBeenSet() const { return m_transcriptionJobNameHasBeenSet; }
  template <typename TranscriptionJobNameT = Aws::String>
  void SetTranscriptionJobName(TranscriptionJobNameT&& value) {
    m_transcriptionJobNameHasBeenSet = true;
    m_transcriptionJobName = std::forward<TranscriptionJobNameT>(value);
  }
  template <typename TranscriptionJobNameT = Aws::String>
  GetTranscriptionJobRequest& WithTranscriptionJobName(TranscriptionJobNameT&& value) {
    SetTranscriptionJobName(std::forward<TranscriptionJobNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_transcriptionJobName;
  bool m_transcriptionJobNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace TranscribeService
}  // namespace Aws
