﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/securityhub/model/ParameterConfiguration.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SecurityHub {
namespace Model {

/**
 * <p> A list of security controls and control parameter values that are included
 * in a configuration policy. </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/SecurityControlCustomParameter">AWS
 * API Reference</a></p>
 */
class SecurityControlCustomParameter {
 public:
  AWS_SECURITYHUB_API SecurityControlCustomParameter() = default;
  AWS_SECURITYHUB_API SecurityControlCustomParameter(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API SecurityControlCustomParameter& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> The ID of the security control. </p>
   */
  inline const Aws::String& GetSecurityControlId() const { return m_securityControlId; }
  inline bool SecurityControlIdHasBeenSet() const { return m_securityControlIdHasBeenSet; }
  template <typename SecurityControlIdT = Aws::String>
  void SetSecurityControlId(SecurityControlIdT&& value) {
    m_securityControlIdHasBeenSet = true;
    m_securityControlId = std::forward<SecurityControlIdT>(value);
  }
  template <typename SecurityControlIdT = Aws::String>
  SecurityControlCustomParameter& WithSecurityControlId(SecurityControlIdT&& value) {
    SetSecurityControlId(std::forward<SecurityControlIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> An object that specifies parameter values for a control in a configuration
   * policy. </p>
   */
  inline const Aws::Map<Aws::String, ParameterConfiguration>& GetParameters() const { return m_parameters; }
  inline bool ParametersHasBeenSet() const { return m_parametersHasBeenSet; }
  template <typename ParametersT = Aws::Map<Aws::String, ParameterConfiguration>>
  void SetParameters(ParametersT&& value) {
    m_parametersHasBeenSet = true;
    m_parameters = std::forward<ParametersT>(value);
  }
  template <typename ParametersT = Aws::Map<Aws::String, ParameterConfiguration>>
  SecurityControlCustomParameter& WithParameters(ParametersT&& value) {
    SetParameters(std::forward<ParametersT>(value));
    return *this;
  }
  template <typename ParametersKeyT = Aws::String, typename ParametersValueT = ParameterConfiguration>
  SecurityControlCustomParameter& AddParameters(ParametersKeyT&& key, ParametersValueT&& value) {
    m_parametersHasBeenSet = true;
    m_parameters.emplace(std::forward<ParametersKeyT>(key), std::forward<ParametersValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_securityControlId;

  Aws::Map<Aws::String, ParameterConfiguration> m_parameters;
  bool m_securityControlIdHasBeenSet = false;
  bool m_parametersHasBeenSet = false;
};

}  // namespace Model
}  // namespace SecurityHub
}  // namespace Aws
