/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.state;

import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.security.securityconf.impl.CType;

public class SecurityConfig
implements Writeable,
ToXContent {
    private final CType<?> type;
    private final Instant lastModified;
    private final String hash;

    public SecurityConfig(CType<?> type, String hash, Instant lastModified) {
        this.type = type;
        this.hash = hash;
        this.lastModified = lastModified;
    }

    public SecurityConfig(StreamInput in) throws IOException {
        this.type = CType.fromOrd(in.readVInt());
        this.hash = in.readString();
        this.lastModified = in.readOptionalInstant();
    }

    public Optional<Instant> lastModified() {
        return Optional.ofNullable(this.lastModified);
    }

    public CType<?> type() {
        return this.type;
    }

    public String hash() {
        return this.hash;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.type.getOrd());
        out.writeString(this.hash);
        out.writeOptionalInstant(this.lastModified);
    }

    public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        xContentBuilder.startObject(this.type.toLCString()).field("hash", this.hash);
        if (this.lastModified != null) {
            xContentBuilder.field("last_modified", DateTimeFormatter.ISO_INSTANT.format(this.lastModified));
        } else {
            xContentBuilder.nullField("last_modified");
        }
        return xContentBuilder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityConfig that = (SecurityConfig)o;
        return this.type == that.type && Objects.equals(this.lastModified, that.lastModified) && Objects.equals(this.hash, that.hash);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.lastModified, this.hash);
    }

    public static Builder from(SecurityConfig securityConfig) {
        return new Builder(securityConfig);
    }

    public static final class Builder {
        private final CType<?> type;
        private Instant lastModified;
        private String hash;

        Builder(SecurityConfig securityConfig) {
            this.type = securityConfig.type;
            this.lastModified = securityConfig.lastModified;
            this.hash = securityConfig.hash;
        }

        public Builder withHash(String hash) {
            this.hash = hash;
            return this;
        }

        public Builder withLastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public SecurityConfig build() {
            return new SecurityConfig(this.type, this.hash, this.lastModified);
        }
    }
}

