/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.protocol;

import java.io.IOException;
import org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.config.RequestConfig;
import org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.protocol.HttpClientContext;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.annotation.Contract;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.annotation.ThreadingBehavior;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.EntityDetails;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.HttpException;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.HttpRequest;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.HttpRequestInterceptor;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.HttpVersion;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.ProtocolVersion;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.protocol.HttpContext;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect")) {
            RequestConfig config;
            ProtocolVersion version;
            HttpClientContext clientContext = HttpClientContext.cast(context);
            ProtocolVersion protocolVersion = version = request.getVersion() != null ? request.getVersion() : clientContext.getProtocolVersion();
            if (entity != null && entity.getContentLength() != 0L && !version.lessEquals(HttpVersion.HTTP_1_0) && (config = clientContext.getRequestConfigOrDefault()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

