/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.FormatMetricAggregationBase;
import org.opensearch.client.opensearch._types.aggregations.HdrMethod;
import org.opensearch.client.opensearch._types.aggregations.TDigest;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class PercentileRanksAggregation
extends FormatMetricAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, PercentileRanksAggregation> {
    @Nullable
    private final HdrMethod hdr;
    @Nullable
    private final Boolean keyed;
    @Nullable
    private final TDigest tdigest;
    @Nonnull
    private final List<Double> values;
    public static final JsonpDeserializer<PercentileRanksAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PercentileRanksAggregation::setupPercentileRanksAggregationDeserializer);

    private PercentileRanksAggregation(Builder builder) {
        super(builder);
        this.hdr = builder.hdr;
        this.keyed = builder.keyed;
        this.tdigest = builder.tdigest;
        this.values = ApiTypeHelper.unmodifiable(builder.values);
    }

    public static PercentileRanksAggregation of(Function<Builder, ObjectBuilder<PercentileRanksAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.PercentileRanks;
    }

    @Nullable
    public final HdrMethod hdr() {
        return this.hdr;
    }

    @Nullable
    public final Boolean keyed() {
        return this.keyed;
    }

    @Nullable
    public final TDigest tdigest() {
        return this.tdigest;
    }

    @Nonnull
    public final List<Double> values() {
        return this.values;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.hdr != null) {
            generator.writeKey("hdr");
            this.hdr.serialize(generator, mapper);
        }
        if (this.keyed != null) {
            generator.writeKey("keyed");
            generator.write(this.keyed.booleanValue());
        }
        if (this.tdigest != null) {
            generator.writeKey("tdigest");
            this.tdigest.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.values)) {
            generator.writeKey("values");
            generator.writeStartArray();
            for (Double item0 : this.values) {
                generator.write(item0.doubleValue());
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPercentileRanksAggregationDeserializer(ObjectDeserializer<Builder> op) {
        PercentileRanksAggregation.setupFormatMetricAggregationBaseDeserializer(op);
        op.add(Builder::hdr, HdrMethod._DESERIALIZER, "hdr");
        op.add(Builder::keyed, JsonpDeserializer.booleanDeserializer(), "keyed");
        op.add(Builder::tdigest, TDigest._DESERIALIZER, "tdigest");
        op.add(Builder::values, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "values");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.hdr);
        result = 31 * result + Objects.hashCode(this.keyed);
        result = 31 * result + Objects.hashCode(this.tdigest);
        result = 31 * result + Objects.hashCode(this.values);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PercentileRanksAggregation other = (PercentileRanksAggregation)o;
        return Objects.equals(this.hdr, other.hdr) && Objects.equals(this.keyed, other.keyed) && Objects.equals(this.tdigest, other.tdigest) && Objects.equals(this.values, other.values);
    }

    public static class Builder
    extends FormatMetricAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, PercentileRanksAggregation> {
        @Nullable
        private HdrMethod hdr;
        @Nullable
        private Boolean keyed;
        @Nullable
        private TDigest tdigest;
        @Nullable
        private List<Double> values;

        public Builder() {
        }

        private Builder(PercentileRanksAggregation o) {
            super(o);
            this.hdr = o.hdr;
            this.keyed = o.keyed;
            this.tdigest = o.tdigest;
            this.values = Builder._listCopy(o.values);
        }

        private Builder(Builder o) {
            super(o);
            this.hdr = o.hdr;
            this.keyed = o.keyed;
            this.tdigest = o.tdigest;
            this.values = Builder._listCopy(o.values);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder hdr(@Nullable HdrMethod value) {
            this.hdr = value;
            return this;
        }

        @Nonnull
        public final Builder hdr(Function<HdrMethod.Builder, ObjectBuilder<HdrMethod>> fn) {
            return this.hdr(fn.apply(new HdrMethod.Builder()).build());
        }

        @Nonnull
        public final Builder keyed(@Nullable Boolean value) {
            this.keyed = value;
            return this;
        }

        @Nonnull
        public final Builder tdigest(@Nullable TDigest value) {
            this.tdigest = value;
            return this;
        }

        @Nonnull
        public final Builder tdigest(Function<TDigest.Builder, ObjectBuilder<TDigest>> fn) {
            return this.tdigest(fn.apply(new TDigest.Builder()).build());
        }

        @Nonnull
        public final Builder values(List<Double> list) {
            this.values = Builder._listAddAll(this.values, list);
            return this;
        }

        @Nonnull
        public final Builder values(Double value, Double ... values) {
            this.values = Builder._listAdd(this.values, value, values);
            return this;
        }

        @Override
        @Nonnull
        public PercentileRanksAggregation build() {
            this._checkSingleUse();
            return new PercentileRanksAggregation(this);
        }
    }
}

