/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.command;

import com.oracle.labs.mlrg.olcut.command.CommandInterface;
import com.oracle.labs.mlrg.olcut.command.LayeredCommandInterpreter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jline.reader.impl.completer.StringsCompleter;

public class CommandCompleter
extends StringsCompleter {
    public CommandCompleter(Map<String, CommandInterface> cmdMap, Deque<LayeredCommandInterpreter> interpreters) {
        super(CommandCompleter.createSupplier(cmdMap, interpreters));
    }

    private static Supplier<Collection<String>> createSupplier(Map<String, CommandInterface> cmdMap, Deque<LayeredCommandInterpreter> interpreters) {
        Objects.requireNonNull(cmdMap);
        Objects.requireNonNull(interpreters);
        return () -> {
            ArrayList<Object> output = new ArrayList<Object>();
            output.addAll(cmdMap.keySet());
            for (LayeredCommandInterpreter lci : interpreters) {
                output.addAll(lci.commands.keySet().stream().map(c -> c + "." + lci.getLayerTag()).collect(Collectors.toList()));
            }
            for (LayeredCommandInterpreter lci : interpreters) {
                for (String command : lci.commands.keySet()) {
                    if (output.contains(command) || output.stream().filter(c -> c.startsWith(command + ".")).count() != 1L) continue;
                    output.add(command);
                    output.remove(command + "." + lci.getLayerTag());
                }
            }
            return output;
        };
    }
}

