/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.jvm.toolchain.internal.FileBasedInstallationFactory;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.InstallationSupplier;
import org.gradle.jvm.toolchain.internal.ToolchainConfiguration;

public class SdkmanInstallationSupplier
implements InstallationSupplier {
    private final ToolchainConfiguration toolchainConfiguration;

    @Inject
    public SdkmanInstallationSupplier(ToolchainConfiguration toolchainConfiguration) {
        this.toolchainConfiguration = toolchainConfiguration;
    }

    @Override
    public String getSourceName() {
        return "SDKMAN!";
    }

    @Override
    public Set<InstallationLocation> get() {
        return this.findJavaCandidates(this.toolchainConfiguration.getSdkmanCandidatesDirectory());
    }

    private Set<InstallationLocation> findJavaCandidates(File candidatesDir) {
        File root = new File(candidatesDir, "java");
        return FileBasedInstallationFactory.fromDirectory(root, this.getSourceName(), InstallationLocation::autoDetected);
    }
}

