/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes.immutable.artifact;

import com.google.common.collect.ImmutableMap;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.artifact.ImmutableArtifactTypeRegistry;
import org.gradle.internal.model.InMemoryCacheFactory;
import org.gradle.internal.model.InMemoryInterner;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildSession.class})
public class ImmutableArtifactTypeRegistryFactory {
    private final AttributesFactory attributesFactory;
    private final InMemoryInterner<ImmutableArtifactTypeRegistry> registries;

    public ImmutableArtifactTypeRegistryFactory(InMemoryCacheFactory cacheFactory, AttributesFactory attributesFactory) {
        this.attributesFactory = attributesFactory;
        this.registries = cacheFactory.createInterner();
    }

    public ImmutableArtifactTypeRegistry create(ArtifactTypeRegistry registry) {
        ImmutableMap<String, ImmutableAttributes> artifactTypeMappings = registry.getArtifactTypeMappings();
        return (ImmutableArtifactTypeRegistry)this.registries.intern((Object)new ImmutableArtifactTypeRegistry(this.attributesFactory, artifactTypeMappings, registry.getDefaultArtifactAttributes().asImmutable()));
    }
}

