﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mediapackage-vod/MediaPackageVod_EXPORTS.h>
#include <aws/mediapackage-vod/model/EncryptionMethod.h>
#include <aws/mediapackage-vod/model/SpekeKeyProvider.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace MediaPackageVod {
namespace Model {

/**
 * An HTTP Live Streaming (HLS) encryption configuration.<p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/mediapackage-vod-2018-11-07/HlsEncryption">AWS
 * API Reference</a></p>
 */
class HlsEncryption {
 public:
  AWS_MEDIAPACKAGEVOD_API HlsEncryption() = default;
  AWS_MEDIAPACKAGEVOD_API HlsEncryption(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEDIAPACKAGEVOD_API HlsEncryption& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEDIAPACKAGEVOD_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * A constant initialization vector for encryption (optional).
When not specified
   * the initialization vector will be periodically rotated.

   */
  inline const Aws::String& GetConstantInitializationVector() const { return m_constantInitializationVector; }
  inline bool ConstantInitializationVectorHasBeenSet() const { return m_constantInitializationVectorHasBeenSet; }
  template <typename ConstantInitializationVectorT = Aws::String>
  void SetConstantInitializationVector(ConstantInitializationVectorT&& value) {
    m_constantInitializationVectorHasBeenSet = true;
    m_constantInitializationVector = std::forward<ConstantInitializationVectorT>(value);
  }
  template <typename ConstantInitializationVectorT = Aws::String>
  HlsEncryption& WithConstantInitializationVector(ConstantInitializationVectorT&& value) {
    SetConstantInitializationVector(std::forward<ConstantInitializationVectorT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The encryption method to use.
   */
  inline EncryptionMethod GetEncryptionMethod() const { return m_encryptionMethod; }
  inline bool EncryptionMethodHasBeenSet() const { return m_encryptionMethodHasBeenSet; }
  inline void SetEncryptionMethod(EncryptionMethod value) {
    m_encryptionMethodHasBeenSet = true;
    m_encryptionMethod = value;
  }
  inline HlsEncryption& WithEncryptionMethod(EncryptionMethod value) {
    SetEncryptionMethod(value);
    return *this;
  }
  ///@}

  ///@{

  inline const SpekeKeyProvider& GetSpekeKeyProvider() const { return m_spekeKeyProvider; }
  inline bool SpekeKeyProviderHasBeenSet() const { return m_spekeKeyProviderHasBeenSet; }
  template <typename SpekeKeyProviderT = SpekeKeyProvider>
  void SetSpekeKeyProvider(SpekeKeyProviderT&& value) {
    m_spekeKeyProviderHasBeenSet = true;
    m_spekeKeyProvider = std::forward<SpekeKeyProviderT>(value);
  }
  template <typename SpekeKeyProviderT = SpekeKeyProvider>
  HlsEncryption& WithSpekeKeyProvider(SpekeKeyProviderT&& value) {
    SetSpekeKeyProvider(std::forward<SpekeKeyProviderT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_constantInitializationVector;

  EncryptionMethod m_encryptionMethod{EncryptionMethod::NOT_SET};

  SpekeKeyProvider m_spekeKeyProvider;
  bool m_constantInitializationVectorHasBeenSet = false;
  bool m_encryptionMethodHasBeenSet = false;
  bool m_spekeKeyProviderHasBeenSet = false;
};

}  // namespace Model
}  // namespace MediaPackageVod
}  // namespace Aws
