# This file has been autogenerated by the pywayland scanner

# Copyright © 2019 Christopher Billington
# Copyright © 2020 Ilia Bozhinov
# Copyright © 2022 Victoria Brekenfeld
#
# Permission to use, copy, modify, distribute, and sell this
# software and its documentation for any purpose is hereby granted
# without fee, provided that the above copyright notice appear in
# all copies and that both that copyright notice and this permission
# notice appear in supporting documentation, and that the name of
# the copyright holders not be used in advertising or publicity
# pertaining to distribution of the software without specific,
# written prior permission.  The copyright holders make no
# representations about the suitability of this software for any
# purpose.  It is provided "as is" without express or implied
# warranty.
#
# THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
# SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
# SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
# THIS SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlOutput
from .ext_workspace_handle_v1 import ExtWorkspaceHandleV1


class ExtWorkspaceGroupHandleV1(Interface):
    """A workspace group assigned to a set of outputs

    A :class:`ExtWorkspaceGroupHandleV1` object represents a workspace group
    that is assigned a set of outputs and contains a number of workspaces.

    The set of outputs assigned to the workspace group is conveyed to the
    client via output_enter and output_leave events, and its workspaces are
    conveyed with workspace events.

    For example, a compositor which has a set of workspaces for each output may
    advertise a workspace group (and its workspaces) per output, whereas a
    compositor where a workspace spans all outputs may advertise a single
    workspace group for all outputs.
    """

    name = "ext_workspace_group_handle_v1"
    version = 1

    class group_capabilities(enum.IntFlag):
        create_workspace = 1


class ExtWorkspaceGroupHandleV1Proxy(Proxy[ExtWorkspaceGroupHandleV1]):
    interface = ExtWorkspaceGroupHandleV1

    @ExtWorkspaceGroupHandleV1.request(
        Argument(ArgumentType.String),
    )
    def create_workspace(self, workspace: str) -> None:
        """Create a new workspace

        Request that the compositor create a new workspace with the given name
        and assign it to this group.

        There is no guarantee that the compositor will create a new workspace,
        or that the created workspace will have the provided name.

        :param workspace:
        :type workspace:
            `ArgumentType.String`
        """
        self._marshal(0, workspace)

    @ExtWorkspaceGroupHandleV1.request()
    def destroy(self) -> None:
        """Destroy the :class:`ExtWorkspaceGroupHandleV1` object

        Destroys the :class:`ExtWorkspaceGroupHandleV1` object.

        This request should be send either when the client does not want to use
        the workspace group object any more or after the removed event to
        finalize the destruction of the object.
        """
        self._marshal(1)
        self._destroy()


class ExtWorkspaceGroupHandleV1Resource(Resource):
    interface = ExtWorkspaceGroupHandleV1

    @ExtWorkspaceGroupHandleV1.event(
        Argument(ArgumentType.Uint),
    )
    def capabilities(self, capabilities: int) -> None:
        """Compositor capabilities

        This event advertises the capabilities supported by the compositor. If
        a capability isn't supported, clients should hide or disable the UI
        elements that expose this functionality. For instance, if the
        compositor doesn't advertise support for creating workspaces, a button
        triggering the create_workspace request should not be displayed.

        The compositor will ignore requests it doesn't support. For instance, a
        compositor which doesn't advertise support for creating workspaces will
        ignore create_workspace requests.

        Compositors must send this event once after creation of an
        :class:`ExtWorkspaceGroupHandleV1`. When the capabilities change,
        compositors must send this event again.

        :param capabilities:
            capabilities
        :type capabilities:
            `ArgumentType.Uint`
        """
        self._post_event(0, capabilities)

    @ExtWorkspaceGroupHandleV1.event(
        Argument(ArgumentType.Object, interface=WlOutput),
    )
    def output_enter(self, output: WlOutput) -> None:
        """Output assigned to workspace group

        This event is emitted whenever an output is assigned to the workspace
        group or a new `:class:`~pywayland.protocol.wayland.WlOutput`` object
        is bound by the client, which was already assigned to this
        workspace_group.

        :param output:
        :type output:
            :class:`~pywayland.protocol.wayland.WlOutput`
        """
        self._post_event(1, output)

    @ExtWorkspaceGroupHandleV1.event(
        Argument(ArgumentType.Object, interface=WlOutput),
    )
    def output_leave(self, output: WlOutput) -> None:
        """Output removed from workspace group

        This event is emitted whenever an output is removed from the workspace
        group.

        :param output:
        :type output:
            :class:`~pywayland.protocol.wayland.WlOutput`
        """
        self._post_event(2, output)

    @ExtWorkspaceGroupHandleV1.event(
        Argument(ArgumentType.Object, interface=ExtWorkspaceHandleV1),
    )
    def workspace_enter(self, workspace: ExtWorkspaceHandleV1) -> None:
        """Workspace added to workspace group

        This event is emitted whenever a workspace is assigned to this group. A
        workspace may only ever be assigned to a single group at a single point
        in time, but can be re-assigned during it's lifetime.

        :param workspace:
        :type workspace:
            :class:`~pywayland.protocol.ext_workspace_v1.ExtWorkspaceHandleV1`
        """
        self._post_event(3, workspace)

    @ExtWorkspaceGroupHandleV1.event(
        Argument(ArgumentType.Object, interface=ExtWorkspaceHandleV1),
    )
    def workspace_leave(self, workspace: ExtWorkspaceHandleV1) -> None:
        """Workspace removed from workspace group

        This event is emitted whenever a workspace is removed from this group.

        :param workspace:
        :type workspace:
            :class:`~pywayland.protocol.ext_workspace_v1.ExtWorkspaceHandleV1`
        """
        self._post_event(4, workspace)

    @ExtWorkspaceGroupHandleV1.event()
    def removed(self) -> None:
        """This workspace group has been removed

        This event is send when the group associated with the
        :class:`ExtWorkspaceGroupHandleV1` has been removed. After sending this
        request the compositor will immediately consider the object inert. Any
        requests will be ignored except the destroy request. It is guaranteed
        there won't be any more events referencing this
        :class:`ExtWorkspaceGroupHandleV1`.

        The compositor must remove all workspaces belonging to a workspace
        group via a workspace_leave event before removing the workspace group.
        """
        self._post_event(5)


class ExtWorkspaceGroupHandleV1Global(Global):
    interface = ExtWorkspaceGroupHandleV1


ExtWorkspaceGroupHandleV1._gen_c()
ExtWorkspaceGroupHandleV1.proxy_class = ExtWorkspaceGroupHandleV1Proxy
ExtWorkspaceGroupHandleV1.resource_class = ExtWorkspaceGroupHandleV1Resource
ExtWorkspaceGroupHandleV1.global_class = ExtWorkspaceGroupHandleV1Global
