/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Mon Jan 25 12:52:11 2021

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_37 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 7295, "epsg", 7295,
        "NAD83(2011) / InGCS Fayette-Franklin-Union (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.25 +lon_0=-85.05 +k=1.000038 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Fayette-Franklin-Union (m)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_R");
    add_srs_wkt (p, 2,
        "eference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",39.25],PARAMETER[\"central_meridian\",-85.05],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1.000038],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",240000],PARAMETER[\"false_northing\",36000],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 13,
        "295\"]]");
    p = add_epsg_def_ex (filter, first, last, 7296, "epsg", 7296,
        "NAD83(2011) / InGCS Fayette-Franklin-Union (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.25 +lon_0=-85.05 +k=1.000038 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Fayette-Franklin-Union (ftU");
    add_srs_wkt (p, 1,
        "S)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spati");
    add_srs_wkt (p, 2,
        "al_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",39.25],PARAMETER[\"central_meridian\",-85.05]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",1.000038],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",787400],PARAMETER[\"false_northing\",118110],U");
    add_srs_wkt (p, 11,
        "NIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"7296\"]]");
    p = add_epsg_def_ex (filter, first, last, 7297, "epsg", 7297,
        "NAD83(2011) / InGCS Fountain-Warren (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.95 +lon_0=-87.3 +k=1.000025 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Fountain-Warren (m)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",39.95],PARAMETER[\"central_meridian\",-87.3],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1.000025],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 10,
        "40000],PARAMETER[\"false_northing\",36000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7297\"]]");
    p = add_epsg_def_ex (filter, first, last, 7298, "epsg", 7298,
        "NAD83(2011) / InGCS Fountain-Warren (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.95 +lon_0=-87.3 +k=1.000025 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Fountain-Warren (ftUS)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refe");
    add_srs_wkt (p, 2,
        "rence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",39.95],PARAMETER[\"central_meridian\",-87.3],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1.000025],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",787400],PARAMETER[\"false_northing\",118110],UNIT[\"U");
    add_srs_wkt (p, 11,
        "S survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"7298\"]]");
    p = add_epsg_def_ex (filter, first, last, 7299, "epsg", 7299,
        "NAD83(2011) / InGCS Fulton-Marshall-St. Joseph (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.9 +lon_0=-86.3 +k=1.000031 +x_0=24");
    add_proj4text (p, 1,
        "0000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Fulton-Marshall-St. Joseph ");
    add_srs_wkt (p, 1,
        "(m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spat");
    add_srs_wkt (p, 2,
        "ial_Reference_System_2011\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",40.9],PARAMETER[\"central_meridian\",-86.3]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",1.000031],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",240000],PARAMETER[\"false_northing\",36000],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"7299\"]]");
    p = add_epsg_def_ex (filter, first, last, 7300, "epsg", 7300,
        "NAD83(2011) / InGCS Fulton-Marshall-St. Joseph (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.9 +lon_0=-86.3 +k=1.000031 +x_0=24");
    add_proj4text (p, 1,
        "0000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Fulton-Marshall-St. Joseph ");
    add_srs_wkt (p, 1,
        "(ftUS)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_S");
    add_srs_wkt (p, 2,
        "patial_Reference_System_2011\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 3,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",40.9],PARAMETER[\"central_meridian\",-86");
    add_srs_wkt (p, 9,
        ".3],PARAMETER[\"scale_factor\",1.000031],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",787400],PARAMETER[\"false_northing\",118110");
    add_srs_wkt (p, 11,
        "],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"7300\"]]");
    p = add_epsg_def_ex (filter, first, last, 7301, "epsg", 7301,
        "NAD83(2011) / InGCS Gibson (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.15 +lon_0=-87.65000000000001 +k=1.");
    add_proj4text (p, 1,
        "000013 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Gibson (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",38.15],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",-87.65],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1.000013],PARAMETER[\"false_easting\",240000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",36000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7301\"]]");
    p = add_epsg_def_ex (filter, first, last, 7302, "epsg", 7302,
        "NAD83(2011) / InGCS Gibson (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.15 +lon_0=-87.65000000000001 +k=1.");
    add_proj4text (p, 1,
        "000013 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Gibson (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",38.1");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"central_meridian\",-87.65],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",1.000013],PARAMETER[\"false_easting\",78740");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",118110],UNIT[\"US survey");
    add_srs_wkt (p, 11,
        " foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"7302\"]]");
    p = add_epsg_def_ex (filter, first, last, 7303, "epsg", 7303,
        "NAD83(2011) / InGCS Grant (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.35 +lon_0=-85.7 +k=1.000034 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Grant (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",40.35],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-85.7],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1.000034],PARAMETER[\"false_easting\",240000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",36000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"7303\"]]");
    p = add_epsg_def_ex (filter, first, last, 7304, "epsg", 7304,
        "NAD83(2011) / InGCS Grant (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.35 +lon_0=-85.7 +k=1.000034 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Grant (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",40.35");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-85.7],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1.000034],PARAMETER[\"false_easting\",787400]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",118110],UNIT[\"US survey f");
    add_srs_wkt (p, 11,
        "oot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"7304\"]]");
    p = add_epsg_def_ex (filter, first, last, 7305, "epsg", 7305,
        "NAD83(2011) / InGCS Hamilton-Tipton (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.9 +lon_0=-86 +k=1.000034 +x_0=2400");
    add_proj4text (p, 1,
        "00 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Hamilton-Tipton (m)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",39.9],PARAMETER[\"central_meridian\",-86],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1.000034],PARAMETER[\"false_easting\",2400");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",36000],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7305\"]]");
    p = add_epsg_def_ex (filter, first, last, 7306, "epsg", 7306,
        "NAD83(2011) / InGCS Hamilton-Tipton (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.9 +lon_0=-86 +k=1.000034 +x_0=2400");
    add_proj4text (p, 1,
        "00 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Hamilton-Tipton (ftUS)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refe");
    add_srs_wkt (p, 2,
        "rence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",39.9],PARAMETER[\"central_meridian\",-86],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",1.000034],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "787400],PARAMETER[\"false_northing\",118110],UNIT[\"US s");
    add_srs_wkt (p, 11,
        "urvey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"7306\"]]");
    p = add_epsg_def_ex (filter, first, last, 7307, "epsg", 7307,
        "NAD83(2011) / InGCS Hancock-Madison (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.65 +lon_0=-85.8 +k=1.000036 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Hancock-Madison (m)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",39.65],PARAMETER[\"central_meridian\",-85.8],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1.000036],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 10,
        "40000],PARAMETER[\"false_northing\",36000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7307\"]]");
    p = add_epsg_def_ex (filter, first, last, 7308, "epsg", 7308,
        "NAD83(2011) / InGCS Hancock-Madison (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.65 +lon_0=-85.8 +k=1.000036 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Hancock-Madison (ftUS)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refe");
    add_srs_wkt (p, 2,
        "rence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",39.65],PARAMETER[\"central_meridian\",-85.8],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1.000036],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",787400],PARAMETER[\"false_northing\",118110],UNIT[\"U");
    add_srs_wkt (p, 11,
        "S survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"7308\"]]");
    p = add_epsg_def_ex (filter, first, last, 7309, "epsg", 7309,
        "NAD83(2011) / InGCS Harrison-Washington (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.95 +lon_0=-86.15000000000001 +k=1.");
    add_proj4text (p, 1,
        "000027 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Harrison-Washington (m)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",37.95],PARAMETER[\"central_meridian\",-86.15],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"scale_factor\",1.000027],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",240000],PARAMETER[\"false_northing\",36000],UNIT[\"m");
    add_srs_wkt (p, 11,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7309");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 7310, "epsg", 7310,
        "NAD83(2011) / InGCS Harrison-Washington (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.95 +lon_0=-86.15000000000001 +k=1.");
    add_proj4text (p, 1,
        "000027 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Harrison-Washington (ftUS)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_R");
    add_srs_wkt (p, 2,
        "eference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",37.95],PARAMETER[\"central_meridian\",-86.15],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1.000027],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",787400],PARAMETER[\"false_northing\",118110],UNIT");
    add_srs_wkt (p, 11,
        "[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"7310\"]]");
    p = add_epsg_def_ex (filter, first, last, 7311, "epsg", 7311,
        "NAD83(2011) / InGCS Henry (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.75 +lon_0=-85.45 +k=1.000043 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Henry (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",39.75],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-85.45],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",1.000043],PARAMETER[\"false_easting\",240000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",36000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7311\"]]");
    p = add_epsg_def_ex (filter, first, last, 7312, "epsg", 7312,
        "NAD83(2011) / InGCS Henry (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.75 +lon_0=-85.45 +k=1.000043 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Henry (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",39.75");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-85.45],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",1.000043],PARAMETER[\"false_easting\",787400");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",118110],UNIT[\"US survey ");
    add_srs_wkt (p, 11,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"7312\"]]");
    p = add_epsg_def_ex (filter, first, last, 7313, "epsg", 7313,
        "NAD83(2011) / InGCS Howard-Miami (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.35 +lon_0=-86.15000000000001 +k=1.");
    add_proj4text (p, 1,
        "000031 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Howard-Miami (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",40");
    add_srs_wkt (p, 8,
        ".35],PARAMETER[\"central_meridian\",-86.15],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1.000031],PARAMETER[\"false_easting\",240");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",36000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7313\"]]");
    p = add_epsg_def_ex (filter, first, last, 7314, "epsg", 7314,
        "NAD83(2011) / InGCS Howard-Miami (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.35 +lon_0=-86.15000000000001 +k=1.");
    add_proj4text (p, 1,
        "000031 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Howard-Miami (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",40.35],PARAMETER[\"central_meridian\",-86.15],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",1.000031],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "787400],PARAMETER[\"false_northing\",118110],UNIT[\"US s");
    add_srs_wkt (p, 11,
        "urvey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"7314\"]]");
    p = add_epsg_def_ex (filter, first, last, 7315, "epsg", 7315,
        "NAD83(2011) / InGCS Huntington-Whitley (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.65 +lon_0=-85.5 +k=1.000034 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Huntington-Whitley (m)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refe");
    add_srs_wkt (p, 2,
        "rence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",40.65],PARAMETER[\"central_meridian\",-85.5],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1.000034],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",240000],PARAMETER[\"false_northing\",36000],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7315\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 7316, "epsg", 7316,
        "NAD83(2011) / InGCS Huntington-Whitley (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.65 +lon_0=-85.5 +k=1.000034 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Huntington-Whitley (ftUS)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_R");
    add_srs_wkt (p, 2,
        "eference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",40.65],PARAMETER[\"central_meridian\",-85.5],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1.000034],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",787400],PARAMETER[\"false_northing\",118110],UNIT[");
    add_srs_wkt (p, 11,
        "\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"7316\"]]");
    p = add_epsg_def_ex (filter, first, last, 7317, "epsg", 7317,
        "NAD83(2011) / InGCS Jackson (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.7 +lon_0=-85.95 +k=1.000022 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Jackson (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",38.7],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",-85.95],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1.000022],PARAMETER[\"false_easting\",240000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",36000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7317\"]]");
    p = add_epsg_def_ex (filter, first, last, 7318, "epsg", 7318,
        "NAD83(2011) / InGCS Jackson (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.7 +lon_0=-85.95 +k=1.000022 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Jackson (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",38.7");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-85.95],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",1.000022],PARAMETER[\"false_easting\",787400");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",118110],UNIT[\"US survey ");
    add_srs_wkt (p, 11,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"7318\"]]");
    p = add_epsg_def_ex (filter, first, last, 7319, "epsg", 7319,
        "NAD83(2011) / InGCS Jasper-Porter (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.7 +lon_0=-87.09999999999999 +k=1.0");
    add_proj4text (p, 1,
        "00027 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Jasper-Porter (m)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 8,
        "0.7],PARAMETER[\"central_meridian\",-87.1],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1.000027],PARAMETER[\"false_easting\",2400");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",36000],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7319\"]]");
    p = add_epsg_def_ex (filter, first, last, 7320, "epsg", 7320,
        "NAD83(2011) / InGCS Jasper-Porter (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.7 +lon_0=-87.09999999999999 +k=1.0");
    add_proj4text (p, 1,
        "00027 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Jasper-Porter (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refere");
    add_srs_wkt (p, 2,
        "nce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",40.7],PARAMETER[\"central_meridian\",-87.1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1.000027],PARAMETER[\"false_easting\",787");
    add_srs_wkt (p, 10,
        "400],PARAMETER[\"false_northing\",118110],UNIT[\"US surv");
    add_srs_wkt (p, 11,
        "ey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"7320\"]]");
    p = add_epsg_def_ex (filter, first, last, 7321, "epsg", 7321,
        "NAD83(2011) / InGCS Jay (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.3 +lon_0=-85 +k=1.000038 +x_0=2400");
    add_proj4text (p, 1,
        "00 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Jay (m)\",GEOGCS[\"NAD83(20");
    add_srs_wkt (p, 1,
        "11)\",DATUM[\"NAD83_National_Spatial_Reference_System_20");
    add_srs_wkt (p, 2,
        "11\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",40.3],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-85],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",1.000038],PARAMETER[\"false_easting\",240000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",36000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"7321\"]]");
    p = add_epsg_def_ex (filter, first, last, 7322, "epsg", 7322,
        "NAD83(2011) / InGCS Jay (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.3 +lon_0=-85 +k=1.000038 +x_0=2400");
    add_proj4text (p, 1,
        "00 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Jay (ftUS)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",40.3],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-85],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",1.000038],PARAMETER[\"false_easting\",787400],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",118110],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 11,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"7322\"]]");
    p = add_epsg_def_ex (filter, first, last, 7323, "epsg", 7323,
        "NAD83(2011) / InGCS Jefferson (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.55 +lon_0=-85.34999999999999 +k=1.");
    add_proj4text (p, 1,
        "000028 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Jefferson (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",38.5");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"central_meridian\",-85.35],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",1.000028],PARAMETER[\"false_easting\",24000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",36000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7323\"]]");
    p = add_epsg_def_ex (filter, first, last, 7324, "epsg", 7324,
        "NAD83(2011) / InGCS Jefferson (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.55 +lon_0=-85.34999999999999 +k=1.");
    add_proj4text (p, 1,
        "000028 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Jefferson (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",38");
    add_srs_wkt (p, 8,
        ".55],PARAMETER[\"central_meridian\",-85.35],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1.000028],PARAMETER[\"false_easting\",787");
    add_srs_wkt (p, 10,
        "400],PARAMETER[\"false_northing\",118110],UNIT[\"US surv");
    add_srs_wkt (p, 11,
        "ey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"7324\"]]");
    p = add_epsg_def_ex (filter, first, last, 7325, "epsg", 7325,
        "NAD83(2011) / InGCS Jennings (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.8 +lon_0=-85.8 +k=1.000025 +x_0=24");
    add_proj4text (p, 1,
        "0000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Jennings (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",38.8]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-85.8],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1.000025],PARAMETER[\"false_easting\",240000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",36000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7325\"]]");
    p = add_epsg_def_ex (filter, first, last, 7326, "epsg", 7326,
        "NAD83(2011) / InGCS Jennings (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.8 +lon_0=-85.8 +k=1.000025 +x_0=24");
    add_proj4text (p, 1,
        "0000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Jennings (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",38");
    add_srs_wkt (p, 8,
        ".8],PARAMETER[\"central_meridian\",-85.8],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",1.000025],PARAMETER[\"false_easting\",78740");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",118110],UNIT[\"US survey");
    add_srs_wkt (p, 11,
        " foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"7326\"]]");
    p = add_epsg_def_ex (filter, first, last, 7327, "epsg", 7327,
        "NAD83(2011) / InGCS Johnson-Marion (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.3 +lon_0=-86.15000000000001 +k=1.0");
    add_proj4text (p, 1,
        "00031 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Johnson-Marion (m)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "39.3],PARAMETER[\"central_meridian\",-86.15],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1.000031],PARAMETER[\"false_easting\",240");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",36000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7327\"]]");
    p = add_epsg_def_ex (filter, first, last, 7328, "epsg", 7328,
        "NAD83(2011) / InGCS Johnson-Marion (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.3 +lon_0=-86.15000000000001 +k=1.0");
    add_proj4text (p, 1,
        "00031 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Johnson-Marion (ftUS)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",39.3],PARAMETER[\"central_meridian\",-86.15],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1.000031],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",787400],PARAMETER[\"false_northing\",118110],UNIT[\"US ");
    add_srs_wkt (p, 11,
        "survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "3\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"7328\"]]");
    p = add_epsg_def_ex (filter, first, last, 7329, "epsg", 7329,
        "NAD83(2011) / InGCS Knox (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.4 +lon_0=-87.45 +k=1.000015 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Knox (m)\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",38.4],PARA");
    add_srs_wkt (p, 8,
        "METER[\"central_meridian\",-87.45],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",1.000015],PARAMETER[\"false_easting\",240000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",36000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"7329\"]]");
    p = add_epsg_def_ex (filter, first, last, 7330, "epsg", 7330,
        "NAD83(2011) / InGCS Knox (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.4 +lon_0=-87.45 +k=1.000015 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Knox (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",38.4],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",-87.45],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1.000015],PARAMETER[\"false_easting\",787400],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",118110],UNIT[\"US survey fo");
    add_srs_wkt (p, 11,
        "ot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"7330\"]]");
    p = add_epsg_def_ex (filter, first, last, 7331, "epsg", 7331,
        "NAD83(2011) / InGCS LaGrange-Noble (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.25 +lon_0=-85.45 +k=1.000037 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS LaGrange-Noble (m)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "41.25],PARAMETER[\"central_meridian\",-85.45],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1.000037],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 10,
        "40000],PARAMETER[\"false_northing\",36000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7331\"]]");
    p = add_epsg_def_ex (filter, first, last, 7332, "epsg", 7332,
        "NAD83(2011) / InGCS LaGrange-Noble (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.25 +lon_0=-85.45 +k=1.000037 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS LaGrange-Noble (ftUS)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",41.25],PARAMETER[\"central_meridian\",-85.45],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1.000037],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",787400],PARAMETER[\"false_northing\",118110],UNIT[\"U");
    add_srs_wkt (p, 11,
        "S survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"7332\"]]");
    p = add_epsg_def_ex (filter, first, last, 7333, "epsg", 7333,
        "NAD83(2011) / InGCS Lake-Newton (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.7 +lon_0=-87.40000000000001 +k=1.0");
    add_proj4text (p, 1,
        "00026 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Lake-Newton (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",40");
    add_srs_wkt (p, 8,
        ".7],PARAMETER[\"central_meridian\",-87.4],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",1.000026],PARAMETER[\"false_easting\",24000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",36000],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7333\"]]");
    p = add_epsg_def_ex (filter, first, last, 7334, "epsg", 7334,
        "NAD83(2011) / InGCS Lake-Newton (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.7 +lon_0=-87.40000000000001 +k=1.0");
    add_proj4text (p, 1,
        "00026 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Lake-Newton (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "40.7],PARAMETER[\"central_meridian\",-87.4],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1.000026],PARAMETER[\"false_easting\",787");
    add_srs_wkt (p, 10,
        "400],PARAMETER[\"false_northing\",118110],UNIT[\"US surv");
    add_srs_wkt (p, 11,
        "ey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"7334\"]]");
    p = add_epsg_def_ex (filter, first, last, 7335, "epsg", 7335,
        "NAD83(2011) / InGCS LaPorte-Pulaski-Starke (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.9 +lon_0=-86.75 +k=1.000027 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS LaPorte-Pulaski-Starke (m)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_R");
    add_srs_wkt (p, 2,
        "eference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",40.9],PARAMETER[\"central_meridian\",-86.75],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1.000027],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",240000],PARAMETER[\"false_northing\",36000],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"733");
    add_srs_wkt (p, 13,
        "5\"]]");
    p = add_epsg_def_ex (filter, first, last, 7336, "epsg", 7336,
        "NAD83(2011) / InGCS LaPorte-Pulaski-Starke (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.9 +lon_0=-86.75 +k=1.000027 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS LaPorte-Pulaski-Starke (ftU");
    add_srs_wkt (p, 1,
        "S)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spati");
    add_srs_wkt (p, 2,
        "al_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",40.9],PARAMETER[\"central_meridian\",-86.75],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1.000027],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",787400],PARAMETER[\"false_northing\",118110],UN");
    add_srs_wkt (p, 11,
        "IT[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"7336\"]]");
    p = add_epsg_def_ex (filter, first, last, 7337, "epsg", 7337,
        "NAD83(2011) / InGCS Monroe-Morgan (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.95 +lon_0=-86.5 +k=1.000028 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Monroe-Morgan (m)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",3");
    add_srs_wkt (p, 8,
        "8.95],PARAMETER[\"central_meridian\",-86.5],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1.000028],PARAMETER[\"false_easting\",240");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",36000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7337\"]]");
    p = add_epsg_def_ex (filter, first, last, 7338, "epsg", 7338,
        "NAD83(2011) / InGCS Monroe-Morgan (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.95 +lon_0=-86.5 +k=1.000028 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Monroe-Morgan (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refere");
    add_srs_wkt (p, 2,
        "nce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",38.95],PARAMETER[\"central_meridian\",-86.5],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1.000028],PARAMETER[\"false_easting\",7");
    add_srs_wkt (p, 10,
        "87400],PARAMETER[\"false_northing\",118110],UNIT[\"US su");
    add_srs_wkt (p, 11,
        "rvey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"7338\"]]");
    p = add_epsg_def_ex (filter, first, last, 7339, "epsg", 7339,
        "NAD83(2011) / InGCS Montgomery-Putnam (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.45 +lon_0=-86.95 +k=1.000031 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Montgomery-Putnam (m)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",39.45],PARAMETER[\"central_meridian\",-86.95],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1.000031],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",240000],PARAMETER[\"false_northing\",36000],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7339\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 7340, "epsg", 7340,
        "NAD83(2011) / InGCS Montgomery-Putnam (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.45 +lon_0=-86.95 +k=1.000031 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Montgomery-Putnam (ftUS)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",39.45],PARAMETER[\"central_meridian\",-86.95],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1.000031],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",787400],PARAMETER[\"false_northing\",118110],UNIT[");
    add_srs_wkt (p, 11,
        "\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"7340\"]]");
    p = add_epsg_def_ex (filter, first, last, 7341, "epsg", 7341,
        "NAD83(2011) / InGCS Owen (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.15 +lon_0=-86.90000000000001 +k=1.");
    add_proj4text (p, 1,
        "000026 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Owen (m)\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",39.15],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-86.9],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",1.000026],PARAMETER[\"false_easting\",240000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",36000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"7341\"]]");
    p = add_epsg_def_ex (filter, first, last, 7342, "epsg", 7342,
        "NAD83(2011) / InGCS Owen (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.15 +lon_0=-86.90000000000001 +k=1.");
    add_proj4text (p, 1,
        "000026 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Owen (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",39.15]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-86.9],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1.000026],PARAMETER[\"false_easting\",787400],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",118110],UNIT[\"US survey fo");
    add_srs_wkt (p, 11,
        "ot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"7342\"]]");
    p = add_epsg_def_ex (filter, first, last, 7343, "epsg", 7343,
        "NAD83(2011) / InGCS Parke-Vermillion (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.6 +lon_0=-87.34999999999999 +k=1.0");
    add_proj4text (p, 1,
        "00022 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Parke-Vermillion (m)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refere");
    add_srs_wkt (p, 2,
        "nce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",39.6],PARAMETER[\"central_meridian\",-87.35],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1.000022],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 10,
        "40000],PARAMETER[\"false_northing\",36000],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7343\"]]");
    p = add_epsg_def_ex (filter, first, last, 7344, "epsg", 7344,
        "NAD83(2011) / InGCS Parke-Vermillion (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.6 +lon_0=-87.34999999999999 +k=1.0");
    add_proj4text (p, 1,
        "00022 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Parke-Vermillion (ftUS)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",39.6],PARAMETER[\"central_meridian\",-87.35],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1.000022],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",787400],PARAMETER[\"false_northing\",118110],UNIT[\"U");
    add_srs_wkt (p, 11,
        "S survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"7344\"]]");
    p = add_epsg_def_ex (filter, first, last, 7345, "epsg", 7345,
        "NAD83(2011) / InGCS Perry (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.8 +lon_0=-86.7 +k=1.00002 +x_0=240");
    add_proj4text (p, 1,
        "000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Perry (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",37.8],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-86.7],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1.00002],PARAMETER[\"false_easting\",240000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",36000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"7345\"]]");
    p = add_epsg_def_ex (filter, first, last, 7346, "epsg", 7346,
        "NAD83(2011) / InGCS Perry (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.8 +lon_0=-86.7 +k=1.00002 +x_0=240");
    add_proj4text (p, 1,
        "000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Perry (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",37.8]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-86.7],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1.00002],PARAMETER[\"false_easting\",787400],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",118110],UNIT[\"US survey foo");
    add_srs_wkt (p, 11,
        "t\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"7346\"]]");
    p = add_epsg_def_ex (filter, first, last, 7347, "epsg", 7347,
        "NAD83(2011) / InGCS Pike-Warrick (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.85 +lon_0=-87.3 +k=1.000015 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Pike-Warrick (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",37");
    add_srs_wkt (p, 8,
        ".85],PARAMETER[\"central_meridian\",-87.3],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1.000015],PARAMETER[\"false_easting\",2400");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",36000],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7347\"]]");
    p = add_epsg_def_ex (filter, first, last, 7348, "epsg", 7348,
        "NAD83(2011) / InGCS Pike-Warrick (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.85 +lon_0=-87.3 +k=1.000015 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Pike-Warrick (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",37.85],PARAMETER[\"central_meridian\",-87.3],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1.000015],PARAMETER[\"false_easting\",7");
    add_srs_wkt (p, 10,
        "87400],PARAMETER[\"false_northing\",118110],UNIT[\"US su");
    add_srs_wkt (p, 11,
        "rvey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"7348\"]]");
    p = add_epsg_def_ex (filter, first, last, 7349, "epsg", 7349,
        "NAD83(2011) / InGCS Posey (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.75 +lon_0=-87.95 +k=1.000013 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Posey (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",37.75],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-87.95],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",1.000013],PARAMETER[\"false_easting\",240000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",36000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7349\"]]");
    p = add_epsg_def_ex (filter, first, last, 7350, "epsg", 7350,
        "NAD83(2011) / InGCS Posey (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.75 +lon_0=-87.95 +k=1.000013 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Posey (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",37.75");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-87.95],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",1.000013],PARAMETER[\"false_easting\",787400");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",118110],UNIT[\"US survey ");
    add_srs_wkt (p, 11,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"7350\"]]");
    p = add_epsg_def_ex (filter, first, last, 7351, "epsg", 7351,
        "NAD83(2011) / InGCS Randolph-Wayne (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.7 +lon_0=-85.05 +k=1.000044 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Randolph-Wayne (m)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "39.7],PARAMETER[\"central_meridian\",-85.05],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1.000044],PARAMETER[\"false_easting\",240");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",36000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7351\"]]");
    p = add_epsg_def_ex (filter, first, last, 7352, "epsg", 7352,
        "NAD83(2011) / InGCS Randolph-Wayne (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.7 +lon_0=-85.05 +k=1.000044 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Randolph-Wayne (ftUS)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",39.7],PARAMETER[\"central_meridian\",-85.05],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1.000044],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",787400],PARAMETER[\"false_northing\",118110],UNIT[\"US ");
    add_srs_wkt (p, 11,
        "survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "3\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"7352\"]]");
    p = add_epsg_def_ex (filter, first, last, 7353, "epsg", 7353,
        "NAD83(2011) / InGCS Ripley (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.9 +lon_0=-85.3 +k=1.000038 +x_0=24");
    add_proj4text (p, 1,
        "0000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Ripley (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",38.9],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-85.3],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1.000038],PARAMETER[\"false_easting\",240000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",36000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"7353\"]]");
    p = add_epsg_def_ex (filter, first, last, 7354, "epsg", 7354,
        "NAD83(2011) / InGCS Ripley (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.9 +lon_0=-85.3 +k=1.000038 +x_0=24");
    add_proj4text (p, 1,
        "0000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Ripley (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",38.9");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-85.3],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1.000038],PARAMETER[\"false_easting\",787400]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",118110],UNIT[\"US survey f");
    add_srs_wkt (p, 11,
        "oot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"7354\"]]");
    p = add_epsg_def_ex (filter, first, last, 7355, "epsg", 7355,
        "NAD83(2011) / InGCS Shelby (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.3 +lon_0=-85.90000000000001 +k=1.0");
    add_proj4text (p, 1,
        "0003 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Shelby (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",39.3],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-85.9],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1.00003],PARAMETER[\"false_easting\",240000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",36000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"7355\"]]");
    p = add_epsg_def_ex (filter, first, last, 7356, "epsg", 7356,
        "NAD83(2011) / InGCS Shelby (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.3 +lon_0=-85.90000000000001 +k=1.0");
    add_proj4text (p, 1,
        "0003 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Shelby (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",39.3");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-85.9],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1.00003],PARAMETER[\"false_easting\",787400],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",118110],UNIT[\"US survey fo");
    add_srs_wkt (p, 11,
        "ot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"7356\"]]");
    p = add_epsg_def_ex (filter, first, last, 7357, "epsg", 7357,
        "NAD83(2011) / InGCS Spencer (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.75 +lon_0=-87.05 +k=1.000014 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Spencer (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",37.75]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-87.05],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1.000014],PARAMETER[\"false_easting\",240000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",36000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7357\"]]");
    p = add_epsg_def_ex (filter, first, last, 7358, "epsg", 7358,
        "NAD83(2011) / InGCS Spencer (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.75 +lon_0=-87.05 +k=1.000014 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Spencer (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",37.7");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"central_meridian\",-87.05],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",1.000014],PARAMETER[\"false_easting\",78740");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",118110],UNIT[\"US survey");
    add_srs_wkt (p, 11,
        " foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"7358\"]]");
    p = add_epsg_def_ex (filter, first, last, 7359, "epsg", 7359,
        "NAD83(2011) / InGCS Steuben (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.5 +lon_0=-85 +k=1.000041 +x_0=2400");
    add_proj4text (p, 1,
        "00 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Steuben (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",41.5],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",-85],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1.000041],PARAMETER[\"false_easting\",240000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",36000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"7359\"]]");
    p = add_epsg_def_ex (filter, first, last, 7360, "epsg", 7360,
        "NAD83(2011) / InGCS Steuben (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.5 +lon_0=-85 +k=1.000041 +x_0=2400");
    add_proj4text (p, 1,
        "00 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Steuben (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",41.5");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-85],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",1.000041],PARAMETER[\"false_easting\",787400],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",118110],UNIT[\"US survey foo");
    add_srs_wkt (p, 11,
        "t\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"7360\"]]");
    p = add_epsg_def_ex (filter, first, last, 7361, "epsg", 7361,
        "NAD83(2011) / InGCS Sullivan (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.9 +lon_0=-87.5 +k=1.000017 +x_0=24");
    add_proj4text (p, 1,
        "0000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Sullivan (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",38.9]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-87.5],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1.000017],PARAMETER[\"false_easting\",240000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",36000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7361\"]]");
    p = add_epsg_def_ex (filter, first, last, 7362, "epsg", 7362,
        "NAD83(2011) / InGCS Sullivan (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.9 +lon_0=-87.5 +k=1.000017 +x_0=24");
    add_proj4text (p, 1,
        "0000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Sullivan (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",38");
    add_srs_wkt (p, 8,
        ".9],PARAMETER[\"central_meridian\",-87.5],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",1.000017],PARAMETER[\"false_easting\",78740");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",118110],UNIT[\"US survey");
    add_srs_wkt (p, 11,
        " foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"7362\"]]");
    p = add_epsg_def_ex (filter, first, last, 7363, "epsg", 7363,
        "NAD83(2011) / InGCS Tippecanoe-White (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.2 +lon_0=-86.90000000000001 +k=1.0");
    add_proj4text (p, 1,
        "00026 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Tippecanoe-White (m)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refere");
    add_srs_wkt (p, 2,
        "nce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",40.2],PARAMETER[\"central_meridian\",-86.9],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1.000026],PARAMETER[\"false_easting\",240");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",36000],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7363\"]]");
    p = add_epsg_def_ex (filter, first, last, 7364, "epsg", 7364,
        "NAD83(2011) / InGCS Tippecanoe-White (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.2 +lon_0=-86.90000000000001 +k=1.0");
    add_proj4text (p, 1,
        "00026 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Tippecanoe-White (ftUS)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 8,
        "in\",40.2],PARAMETER[\"central_meridian\",-86.9],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1.000026],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",787400],PARAMETER[\"false_northing\",118110],UNIT[\"US ");
    add_srs_wkt (p, 11,
        "survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "3\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"7364\"]]");
    p = add_epsg_def_ex (filter, first, last, 7365, "epsg", 7365,
        "NAD83(2011) / InGCS Vanderburgh (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.8 +lon_0=-87.55 +k=1.000015 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Vanderburgh (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",37");
    add_srs_wkt (p, 8,
        ".8],PARAMETER[\"central_meridian\",-87.55],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",1.000015],PARAMETER[\"false_easting\",2400");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",36000],UNIT[\"metre\",1");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7365\"]]");
    p = add_epsg_def_ex (filter, first, last, 7366, "epsg", 7366,
        "NAD83(2011) / InGCS Vanderburgh (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.8 +lon_0=-87.55 +k=1.000015 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Vanderburgh (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "37.8],PARAMETER[\"central_meridian\",-87.55],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1.000015],PARAMETER[\"false_easting\",787");
    add_srs_wkt (p, 10,
        "400],PARAMETER[\"false_northing\",118110],UNIT[\"US surv");
    add_srs_wkt (p, 11,
        "ey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"7366\"]]");
    p = add_epsg_def_ex (filter, first, last, 7367, "epsg", 7367,
        "NAD83(2011) / InGCS Vigo (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.25 +lon_0=-87.45 +k=1.00002 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Vigo (m)\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",39.25],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-87.45],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1.00002],PARAMETER[\"false_easting\",240000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",36000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 12,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"7367\"]]");
    p = add_epsg_def_ex (filter, first, last, 7368, "epsg", 7368,
        "NAD83(2011) / InGCS Vigo (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.25 +lon_0=-87.45 +k=1.00002 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Vigo (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",39.25]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-87.45],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1.00002],PARAMETER[\"false_easting\",787400],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",118110],UNIT[\"US survey fo");
    add_srs_wkt (p, 11,
        "ot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"7368\"]]");
    p = add_epsg_def_ex (filter, first, last, 7369, "epsg", 7369,
        "NAD83(2011) / InGCS Wells (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.55 +lon_0=-85.25 +k=1.000034 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Wells (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 7,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",40.55],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-85.25],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",1.000034],PARAMETER[\"false_easting\",240000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",36000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"7369\"]]");
    p = add_epsg_def_ex (filter, first, last, 7370, "epsg", 7370,
        "NAD83(2011) / InGCS Wells (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.55 +lon_0=-85.25 +k=1.000034 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Wells (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",40.55");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-85.25],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",1.000034],PARAMETER[\"false_easting\",787400");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",118110],UNIT[\"US survey ");
    add_srs_wkt (p, 11,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"7370\"]]");
    p = add_epsg_def_ex (filter, first, last, 7372, "epsg", 7372,
        "ONGD14", 1, 1,
        "GRS 1980", "Greenwich",
        "Oman_National_Geodetic_Datum_2014", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ONGD14\",DATUM[\"Oman National Geodetic Datum ");
    add_srs_wkt (p, 1,
        "2014\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENG");
    add_srs_wkt (p, 2,
        "THUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"");
    add_srs_wkt (p, 3,
        "degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"g");
    add_srs_wkt (p, 4,
        "eodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 5,
        "ee\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon");
    add_srs_wkt (p, 6,
        ")\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 7,
        "3]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUN");
    add_srs_wkt (p, 8,
        "IT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Oman -");
    add_srs_wkt (p, 9,
        " onshore and offshore.\"],BBOX[14.33,51.99,26.74,63.38]]");
    add_srs_wkt (p, 10,
        ",ID[\"EPSG\",7372]]");
    p = add_epsg_def_ex (filter, first, last, 7373, "epsg", 7373,
        "ONGD14", 1, 1,
        "GRS 1980", "Greenwich",
        "Oman_National_Geodetic_Datum_2014", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ONGD14\",DATUM[\"Oman_National_Geodetic_Datum_2");
    add_srs_wkt (p, 1,
        "014\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1147\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"7373\"]]");
    p = add_epsg_def_ex (filter, first, last, 7374, "epsg", 7374,
        "ONGD14 / UTM zone 39N", 0, 0,
        "GRS 1980", "Greenwich",
        "Oman_National_Geodetic_Datum_2014", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ONGD14 / UTM zone 39N\",GEOGCS[\"ONGD14\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Oman_National_Geodetic_Datum_2014\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"1147\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"7373\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "7374\"]]");
    p = add_epsg_def_ex (filter, first, last, 7375, "epsg", 7375,
        "ONGD14 / UTM zone 40N", 0, 0,
        "GRS 1980", "Greenwich",
        "Oman_National_Geodetic_Datum_2014", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ONGD14 / UTM zone 40N\",GEOGCS[\"ONGD14\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Oman_National_Geodetic_Datum_2014\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"1147\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"7373\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "7375\"]]");
    p = add_epsg_def_ex (filter, first, last, 7376, "epsg", 7376,
        "ONGD14 / UTM zone 41N", 0, 0,
        "GRS 1980", "Greenwich",
        "Oman_National_Geodetic_Datum_2014", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=41 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ONGD14 / UTM zone 41N\",GEOGCS[\"ONGD14\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Oman_National_Geodetic_Datum_2014\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"1147\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"7373\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "7376\"]]");
    p = add_epsg_def_ex (filter, first, last, 7400, "epsg", 7400,
        "NTF (Paris)", 1, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "none", "grad",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-168,-60,");
    add_proj4text (p, 1,
        "320,0,0,0,0 +pm=paris +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) + NGF IGN69 height\",GEOGCS[\"NTF");
    add_srs_wkt (p, 1,
        " (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Pari");
    add_srs_wkt (p, 2,
        "s\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212");
    add_srs_wkt (p, 3,
        "93627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9105\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4807\"]],VERT_CS[\"NGF-");
    add_srs_wkt (p, 8,
        "IGN69 height\",VERT_DATUM[\"Nivellement General de la Fr");
    add_srs_wkt (p, 9,
        "ance - IGN69\",2005,AUTHORITY[\"EPSG\",\"5119\"]],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-r");
    add_srs_wkt (p, 11,
        "elated height\",UP],AUTHORITY[\"EPSG\",\"5720\"]],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"7400\"]]");
    p = add_epsg_def_ex (filter, first, last, 7401, "epsg", 7401,
        "NTF (Paris) / Lambert zone II", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +vunits=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / Lambert zone II + NGF Lallemand");
    add_srs_wkt (p, 1,
        " height\",PROJCS[\"NTF (Paris) / Lambert zone II\",GEOGC");
    add_srs_wkt (p, 2,
        "S[\"NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francai");
    add_srs_wkt (p, 3,
        "se_Paris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.");
    add_srs_wkt (p, 4,
        "466021293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",52],PARAMETER[\"central_meridian\",0");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"scale_factor\",0.99987742],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",600000],PARAMETER[\"false_northing\",220000");
    add_srs_wkt (p, 12,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"27572\"]],VERT_CS[\"NGF Lallemand height\",VERT_DA");
    add_srs_wkt (p, 15,
        "TUM[\"Nivellement General de la France - Lallemand\",200");
    add_srs_wkt (p, 16,
        "5,AUTHORITY[\"EPSG\",\"5118\"]],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 17,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",U");
    add_srs_wkt (p, 18,
        "P],AUTHORITY[\"EPSG\",\"5719\"]],AUTHORITY[\"EPSG\",\"74");
    add_srs_wkt (p, 19,
        "11\"]]");
    p = add_epsg_def_ex (filter, first, last, 7402, "epsg", 7402,
        "NTF (Paris) / Lambert zone II", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +vunits=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / Lambert zone II + NGF IGN69\",P");
    add_srs_wkt (p, 1,
        "ROJCS[\"NTF (Paris) / Lambert zone II\",GEOGCS[\"NTF (Pa");
    add_srs_wkt (p, 2,
        "ris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602129362");
    add_srs_wkt (p, 4,
        "7,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"680");
    add_srs_wkt (p, 5,
        "7\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 6,
        "903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 9,
        "_origin\",52],PARAMETER[\"central_meridian\",0],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"scale_factor\",0.99987742],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",600000],PARAMETER[\"false_northing\",2200000],UNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"275");
    add_srs_wkt (p, 14,
        "72\"]],VERT_CS[\"NGF Lallemand height\",VERT_DATUM[\"Niv");
    add_srs_wkt (p, 15,
        "ellement General de la France - Lallemand\",2005,AUTHORI");
    add_srs_wkt (p, 16,
        "TY[\"EPSG\",\"5118\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 17,
        "\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHOR");
    add_srs_wkt (p, 18,
        "ITY[\"EPSG\",\"5719\"]],AUTHORITY[\"EPSG\",\"7412\"]]");
    p = add_epsg_def_ex (filter, first, last, 7403, "epsg", 7403,
        "NTF (Paris) / Lambert zone III", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=3200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / Lambert zone III + NGF IGN69\",");
    add_srs_wkt (p, 1,
        "PROJCS[\"NTF (Paris) / Lambert zone III\",GEOGCS[\"NTF (");
    add_srs_wkt (p, 2,
        "Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 3,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 4,
        "27,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"68");
    add_srs_wkt (p, 5,
        "07\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJECTION");
    add_srs_wkt (p, 8,
        "[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",49],PARAMETER[\"central_meridian\",0],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",0.999877499],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",600000],PARAMETER[\"false_northing\",3200000],UNIT[");
    add_srs_wkt (p, 12,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 14,
        "7573\"]],VERT_CS[\"NGF Lallemand height\",VERT_DATUM[\"N");
    add_srs_wkt (p, 15,
        "ivellement General de la France - Lallemand\",2005,AUTHO");
    add_srs_wkt (p, 16,
        "RITY[\"EPSG\",\"5118\"]],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 17,
        "SG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"5719\"]],AUTHORITY[\"EPSG\",\"7413\"]]");
    p = add_epsg_def_ex (filter, first, last, 7404, "epsg", 7404,
        "RT90", 1, 0,
        "Bessel 1841", "Greenwich",
        "Rikets_koordinatsystem_1990", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=414.1,41.3,603.1,-0");
    add_proj4text (p, 1,
        ".855,2.141,-7.023,0 +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"RT90 + RH70 height\",GEOGCS[\"RT90\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Rikets_koordinatsystem_1990\",SPHEROID[\"Bessel 1841\",6");
    add_srs_wkt (p, 2,
        "377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6124\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 6,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4124\"]]");
    add_srs_wkt (p, 7,
        ",VERT_CS[\"RH70 height\",VERT_DATUM[\"Rikets hojdsystem ");
    add_srs_wkt (p, 8,
        "1970\",2005,AUTHORITY[\"EPSG\",\"5117\"]],UNIT[\"metre\"");
    add_srs_wkt (p, 9,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related ");
    add_srs_wkt (p, 10,
        "height\",UP],AUTHORITY[\"EPSG\",\"5718\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"7404\"]]");
    p = add_epsg_def_ex (filter, first, last, 7405, "epsg", 7405,
        "OSGB 1936 / British National Grid", 0, 0,
        "Airy 1830", "Greenwich",
        "OSGB_1936", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=49 +lon_0=-2 +k=0.9996012717 +x_0=400");
    add_proj4text (p, 1,
        "000 +y_0=-100000 +ellps=airy +towgs84=446.448,-125.157,5");
    add_proj4text (p, 2,
        "42.06,0.15,0.247,0.842,-20.489 +units=m +vunits=m +no_de");
    add_proj4text (p, 3,
        "fs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"OSGB 1936 / British National Grid + ODN heigh");
    add_srs_wkt (p, 1,
        "t\",PROJCS[\"OSGB 1936 / British National Grid\",GEOGCS[");
    add_srs_wkt (p, 2,
        "\"OSGB 1936\",DATUM[\"OSGB_1936\",SPHEROID[\"Airy 1830\"");
    add_srs_wkt (p, 3,
        ",6377563.396,299.3249646,AUTHORITY[\"EPSG\",\"7001\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6277\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4277\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",49],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-2],PARAMETER[\"scale_factor\",0.9996012717],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",400000],PARAMETER[\"false_northing\",-10");
    add_srs_wkt (p, 11,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"27700\"]],VERT_CS[\"ODN height\",VERT_DATUM[\"O");
    add_srs_wkt (p, 14,
        "rdnance Datum Newlyn\",2005,AUTHORITY[\"EPSG\",\"5101\"]");
    add_srs_wkt (p, 15,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 16,
        "Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"5701\"");
    add_srs_wkt (p, 17,
        "]],AUTHORITY[\"EPSG\",\"7405\"]]");
    p = add_epsg_def_ex (filter, first, last, 7406, "epsg", 7406,
        "NAD27", 1, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +datum=NAD27 +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD27 + NGVD29 height (ftUS)\",GEOGCS[\"NAD27");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 2,
        " 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 6,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4267\"]],VERT_CS[\"NGVD29 height (ftUS)\",VERT_DATUM[");
    add_srs_wkt (p, 8,
        "\"National Geodetic Vertical Datum 1929\",2005,AUTHORITY");
    add_srs_wkt (p, 9,
        "[\"EPSG\",\"5102\"]],UNIT[\"US survey foot\",0.304800609");
    add_srs_wkt (p, 10,
        "601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Gravity-rela");
    add_srs_wkt (p, 11,
        "ted height\",UP],AUTHORITY[\"EPSG\",\"5702\"]],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"7406\"]]");
    p = add_epsg_def_ex (filter, first, last, 7407, "epsg", 7407,
        "NAD27 / Texas North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.65 +lat_2=36.18333333333333 +lat_0=3");
    add_proj4text (p, 1,
        "4 +lon_0=-101.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD");
    add_proj4text (p, 2,
        "27 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD27 / Texas North + NGVD29 height (ftUS)\",");
    add_srs_wkt (p, 1,
        "PROJCS[\"NAD27 / Texas North\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 2,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 3,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",34],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-101.5],PARAMETER[\"standard_parallel_1\",34.65]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"standard_parallel_2\",36.1833333333333],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",2000000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"32037\"]],VERT_CS");
    add_srs_wkt (p, 15,
        "[\"NGVD29 height (ftUS)\",VERT_DATUM[\"National Geodetic");
    add_srs_wkt (p, 16,
        " Vertical Datum 1929\",2005,AUTHORITY[\"EPSG\",\"5102\"]");
    add_srs_wkt (p, 17,
        "],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"");
    add_srs_wkt (p, 18,
        "EPSG\",\"9003\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 19,
        "THORITY[\"EPSG\",\"5702\"]],AUTHORITY[\"EPSG\",\"7407\"]");
    add_srs_wkt (p, 20,
        "]");
    p = add_epsg_def_ex (filter, first, last, 7408, "epsg", 7408,
        "Amersfoort / RD New", 0, 0,
        "Bessel 1841", "Greenwich",
        "Amersfoort", "Oblique_Stereographic", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=565.2369,50.0087,46");
    add_proj4text (p, 1,
        "5.658,-0.406857,0.350733,-1.87035,4.0812 +vunits=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"Amersfoort / RD New + NAP height\",PROJCS[\"A");
    add_srs_wkt (p, 1,
        "mersfoort / RD New\",GEOGCS[\"Amersfoort\",DATUM[\"Amers");
    add_srs_wkt (p, 2,
        "foort\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6289");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4289\"]],PROJECTION[\"Ob");
    add_srs_wkt (p, 7,
        "lique_Stereographic\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "52.1561605555556],PARAMETER[\"central_meridian\",5.38763");
    add_srs_wkt (p, 9,
        "888888889],PARAMETER[\"scale_factor\",0.9999079],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",155000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",463000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"28992\"]],VERT_CS[\"NAP height\",VERT_DATUM");
    add_srs_wkt (p, 14,
        "[\"Normaal Amsterdams Peil\",2005,AUTHORITY[\"EPSG\",\"5");
    add_srs_wkt (p, 15,
        "109\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 16,
        "XIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 17,
        "5709\"]],AUTHORITY[\"EPSG\",\"7415\"]]");
    p = add_epsg_def_ex (filter, first, last, 7409, "epsg", 7409,
        "ETRS89", 1, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + EVRF2000 height\",GEOGCS[\"ETRS89\",");
    add_srs_wkt (p, 1,
        "DATUM[\"European_Terrestrial_Reference_System_1989\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4258\"]],VERT_CS[\"EVRF2000 height\",VERT_DATUM[");
    add_srs_wkt (p, 8,
        "\"European Vertical Reference Frame 2000\",2005,AUTHORIT");
    add_srs_wkt (p, 9,
        "Y[\"EPSG\",\"5129\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 10,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"5730\"]],AUTHORITY[\"EPSG\",\"7409\"]]");
    p = add_epsg_def_ex (filter, first, last, 7410, "epsg", 7410,
        "PSD93", 1, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "PDO_Survey_Datum_1993", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-180.624,-225.516,1");
    add_proj4text (p, 1,
        "73.919,-0.81,-1.898,8.336,16.71006 +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"PSHD93\",GEOGCS[\"PSD93\",DATUM[\"PDO_Survey_");
    add_srs_wkt (p, 1,
        "Datum_1993\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,");
    add_srs_wkt (p, 2,
        "293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6134\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4134\"]],VERT_CS[\"PHD9");
    add_srs_wkt (p, 7,
        "3 height\",VERT_DATUM[\"PDO Height Datum 1993\",2005,AUT");
    add_srs_wkt (p, 8,
        "HORITY[\"EPSG\",\"5123\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 9,
        "EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"5724\"]],AUTHORITY[\"EPSG\",\"7410\"]");
    add_srs_wkt (p, 11,
        "]");
    p = add_epsg_def_ex (filter, first, last, 7411, "epsg", 7411,
        "NTF (Paris) / Lambert zone II", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +vunits=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / Lambert zone II + NGF Lallemand");
    add_srs_wkt (p, 1,
        " height\",PROJCS[\"NTF (Paris) / Lambert zone II\",GEOGC");
    add_srs_wkt (p, 2,
        "S[\"NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francai");
    add_srs_wkt (p, 3,
        "se_Paris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.");
    add_srs_wkt (p, 4,
        "466021293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",52],PARAMETER[\"central_meridian\",0");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"scale_factor\",0.99987742],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",600000],PARAMETER[\"false_northing\",220000");
    add_srs_wkt (p, 12,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"27572\"]],VERT_CS[\"NGF Lallemand height\",VERT_DA");
    add_srs_wkt (p, 15,
        "TUM[\"Nivellement General de la France - Lallemand\",200");
    add_srs_wkt (p, 16,
        "5,AUTHORITY[\"EPSG\",\"5118\"]],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 17,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related height\",U");
    add_srs_wkt (p, 18,
        "P],AUTHORITY[\"EPSG\",\"5719\"]],AUTHORITY[\"EPSG\",\"74");
    add_srs_wkt (p, 19,
        "11\"]]");
    p = add_epsg_def_ex (filter, first, last, 7412, "epsg", 7412,
        "NTF (Paris) / Lambert zone II", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +vunits=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / Lambert zone II + NGF-IGN69 hei");
    add_srs_wkt (p, 1,
        "ght\",PROJCS[\"NTF (Paris) / Lambert zone II\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_P");
    add_srs_wkt (p, 3,
        "aris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660");
    add_srs_wkt (p, 4,
        "21293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",52],PARAMETER[\"central_meridian\",0],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",0.99987742],PARAMETER[\"false_e");
    add_srs_wkt (p, 11,
        "asting\",600000],PARAMETER[\"false_northing\",2200000],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 13,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"27572\"]],VERT_CS[\"NGF-IGN69 height\",VERT_DATUM[\"N");
    add_srs_wkt (p, 15,
        "ivellement General de la France - IGN69\",2005,AUTHORITY");
    add_srs_wkt (p, 16,
        "[\"EPSG\",\"5119\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHORIT");
    add_srs_wkt (p, 18,
        "Y[\"EPSG\",\"5720\"]],AUTHORITY[\"EPSG\",\"7421\"]]");
    p = add_epsg_def_ex (filter, first, last, 7413, "epsg", 7413,
        "NTF (Paris) / Lambert zone III", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=3200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / Lambert zone III + NGF-IGN69 he");
    add_srs_wkt (p, 1,
        "ight\",PROJCS[\"NTF (Paris) / Lambert zone III\",GEOGCS[");
    add_srs_wkt (p, 2,
        "\"NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise");
    add_srs_wkt (p, 3,
        "_Paris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46");
    add_srs_wkt (p, 4,
        "6021293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"6807\"]],PRIMEM[\"Paris\",2.33722917,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"8903\"]],UNIT[\"grad\",0.0157079632679489,AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"9105\"]],AUTHORITY[\"EPSG\",\"4807\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 9,
        "titude_of_origin\",49],PARAMETER[\"central_meridian\",0]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"scale_factor\",0.999877499],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",600000],PARAMETER[\"false_northing\",320000");
    add_srs_wkt (p, 12,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"27573\"]],VERT_CS[\"NGF-IGN69 height\",VERT_DATUM[");
    add_srs_wkt (p, 15,
        "\"Nivellement General de la France - IGN69\",2005,AUTHOR");
    add_srs_wkt (p, 16,
        "ITY[\"EPSG\",\"5119\"]],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 17,
        "G\",\"9001\"]],AXIS[\"Gravity-related height\",UP],AUTHO");
    add_srs_wkt (p, 18,
        "RITY[\"EPSG\",\"5720\"]],AUTHORITY[\"EPSG\",\"7422\"]]");
    p = add_epsg_def_ex (filter, first, last, 7414, "epsg", 7414,
        "Tokyo", 1, 0,
        "Bessel 1841", "Greenwich",
        "Tokyo", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-146.414,507.337,68");
    add_proj4text (p, 1,
        "0.507,0,0,0,0 +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"Tokyo + JSLD69 height\",GEOGCS[\"Tokyo\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377397.155,299.152");
    add_srs_wkt (p, 2,
        "8128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 6,
        "\",EAST],AUTHORITY[\"EPSG\",\"4301\"]],VERT_CS[\"JSLD69 ");
    add_srs_wkt (p, 7,
        "height\",VERT_DATUM[\"Japanese Standard Levelling Datum ");
    add_srs_wkt (p, 8,
        "1969\",2005,AUTHORITY[\"EPSG\",\"5122\"]],UNIT[\"metre\"");
    add_srs_wkt (p, 9,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related ");
    add_srs_wkt (p, 10,
        "height\",UP],AUTHORITY[\"EPSG\",\"5723\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"7414\"]]");
    p = add_epsg_def_ex (filter, first, last, 7415, "epsg", 7415,
        "Amersfoort / RD New", 0, 0,
        "Bessel 1841", "Greenwich",
        "Amersfoort", "Oblique_Stereographic", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=52.15616055555555 +lon_0=5.387638888");
    add_proj4text (p, 1,
        "88889 +k=0.9999079 +x_0=155000 +y_0=463000 +ellps=bessel");
    add_proj4text (p, 2,
        " +towgs84=565.2369,50.0087,465.658,-0.406857,0.350733,-1");
    add_proj4text (p, 3,
        ".87035,4.0812 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"Amersfoort / RD New + NAP height\",PROJCS[\"A");
    add_srs_wkt (p, 1,
        "mersfoort / RD New\",GEOGCS[\"Amersfoort\",DATUM[\"Amers");
    add_srs_wkt (p, 2,
        "foort\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6289");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4289\"]],PROJECTION[\"Ob");
    add_srs_wkt (p, 7,
        "lique_Stereographic\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "52.1561605555556],PARAMETER[\"central_meridian\",5.38763");
    add_srs_wkt (p, 9,
        "888888889],PARAMETER[\"scale_factor\",0.9999079],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",155000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",463000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"28992\"]],VERT_CS[\"NAP height\",VERT_DATUM");
    add_srs_wkt (p, 14,
        "[\"Normaal Amsterdams Peil\",2005,AUTHORITY[\"EPSG\",\"5");
    add_srs_wkt (p, 15,
        "109\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 16,
        "XIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 17,
        "5709\"]],AUTHORITY[\"EPSG\",\"7415\"]]");
    p = add_epsg_def_ex (filter, first, last, 7416, "epsg", 7416,
        "ETRS89 / UTM zone 32N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 32N + DVR90 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / UTM zone 32N\",GEOGCS[\"ETRS89\",DATUM[\"Eur");
    add_srs_wkt (p, 2,
        "opean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "25832\"]],VERT_CS[\"DVR90 height\",VERT_DATUM[\"Dansk Ve");
    add_srs_wkt (p, 14,
        "rtikal Reference 1990\",2005,AUTHORITY[\"EPSG\",\"5206\"");
    add_srs_wkt (p, 15,
        "]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 16,
        "Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"5799\"");
    add_srs_wkt (p, 17,
        "]],AUTHORITY[\"EPSG\",\"7416\"]]");
    p = add_epsg_def_ex (filter, first, last, 7417, "epsg", 7417,
        "ETRS89 / UTM zone 33N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 33N + DVR90 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / UTM zone 33N\",GEOGCS[\"ETRS89\",DATUM[\"Eur");
    add_srs_wkt (p, 2,
        "opean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",15],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 11,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"25833\"]],VERT_CS[\"DVR90 height\",VERT_DATUM[\"Dansk ");
    add_srs_wkt (p, 14,
        "Vertikal Reference 1990\",2005,AUTHORITY[\"EPSG\",\"5206");
    add_srs_wkt (p, 15,
        "\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 16,
        "[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"579");
    add_srs_wkt (p, 17,
        "9\"]],AUTHORITY[\"EPSG\",\"7417\"]]");
    p = add_epsg_def_ex (filter, first, last, 7418, "epsg", 7418,
        "ETRS89 / Kp2000 Jutland", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9.5 +k=0.99995 +x_0=200000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vuni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / Kp2000 Jutland + DVR90 height\",PROJ");
    add_srs_wkt (p, 1,
        "CS[\"ETRS89 / Kp2000 Jutland\",GEOGCS[\"ETRS89\",DATUM[\"");
    add_srs_wkt (p, 2,
        "European_Terrestrial_Reference_System_1989\",SPHEROID[\"");
    add_srs_wkt (p, 3,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 4,
        "19\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",9.5],PARAMETER[\"scale_factor\",0.99995],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",200000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"2196\"]],VERT_CS[\"DVR90 height\",VERT_DATUM[\"D");
    add_srs_wkt (p, 14,
        "ansk Vertikal Reference 1990\",2005,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 15,
        "5206\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 16,
        "AXIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 17,
        "5799\"]],AUTHORITY[\"EPSG\",\"7418\"]]");
    p = add_epsg_def_ex (filter, first, last, 7419, "epsg", 7419,
        "ETRS89 / Kp2000 Zealand", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.99995 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / Kp2000 Zealand + DVR90 height\",PROJ");
    add_srs_wkt (p, 1,
        "CS[\"ETRS89 / Kp2000 Zealand\",GEOGCS[\"ETRS89\",DATUM[\"");
    add_srs_wkt (p, 2,
        "European_Terrestrial_Reference_System_1989\",SPHEROID[\"");
    add_srs_wkt (p, 3,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 4,
        "19\"]],AUTHORITY[\"EPSG\",\"6258\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4258\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",12],PARAMETER[\"scale_factor\",0.99995],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"2197\"]],VERT_CS[\"DVR90 height\",VERT_DATUM[\"Dan");
    add_srs_wkt (p, 14,
        "sk Vertikal Reference 1990\",2005,AUTHORITY[\"EPSG\",\"5");
    add_srs_wkt (p, 15,
        "206\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 16,
        "XIS[\"Gravity-related height\",UP],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 17,
        "5799\"]],AUTHORITY[\"EPSG\",\"7419\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

