Please read the README file in this directory first.
.ex
.Id $Id: formail.man,v 1.39.2.1 1999/12/14 01:41:48 guenther Exp $
.TH FORMAIL 1 \*(Dt BuGless
.na
.SH NAME
formail \- mail (re)formatter
.SH SYNOPSIS
.B formail
.RI [ "\fB\@FM_SKIP@\fPskip" ]
.RI [ "\fB\@FM_TOTAL@\fPtotal" ]
.RB [ \-@FM_VERSION@@FM_BOGUS@@FM_CONCATENATE@@FM_ZAPWHITE@@FM_FORCE@@FM_REPLY@@FM_KEEPB@@FM_TRUST@@FM_EVERY@@FM_DIGEST@@FM_QUIET@@FM_BABYL@@FM_BERKELEY@ ]
.RB [ \-@FM_QPREFIX@
.IR prefix ]
.if n .ti +0.5i
.RB [ \-@FM_DUPLICATE@
.IR "maxlen idcache" ]
.if n .ti +0.5i
.RB [ \-@FM_EXTRACT@
.IR headerfield ]
.RB [ \-@FM_EXTRC_KEEP@
.IR headerfield ]
.if n .ti +0.5i
.RB [ \-@FM_ADD_IFNOT@
.IR headerfield ]
.RB [ \-@FM_ADD_ALWAYS@
.IR headerfield ]
.if n .ti +0.5i
.RB [ \-@FM_REN_INSERT@
.IR headerfield ]
.RB [ \-@FM_DEL_INSERT@
.IR headerfield ]
.if n .ti +0.5i
.RB [ \-@FM_FIRST_UNIQ@
.IR headerfield ]
.RB [ \-@FM_LAST_UNIQ@
.IR headerfield ]
.if n .ti +0.5i
.RB [ \-@FM_ReNAME@
.I oldfield
.IR newfield ]
.if n .ti +0.5i
.RB [ \-@FM_NOWAIT@
.RI [ maxprocs
]]
.RB [ \-@FM_MINFIELDS@
.IR minfields ]
.RB [ \-@FM_SPLIT@
.RI [ command
.RI [ arg
\&.\|.\|.\|]]]
.ad
.SH DESCRIPTION
.B formail
is a filter that can be used to force mail into mailbox format, perform
`@FROM@' escaping, generate auto-replying headers, do simple
header munging/extracting or split up a
mailbox/digest/articles file.  The mail/mailbox/article contents will be
expected on stdin.
.PP
If formail is supposed to determine the sender of the mail, but is unable
to find any, it will substitute `@UNKNOWN@'.
.PP
If formail is started without any command line options, it will force any
mail coming from stdin into mailbox format and will escape
.B all
bogus `@FROM@' lines with a `@ESCAP@'.
.SH OPTIONS
.TP 0.5i
.B \-@FM_VERSION@
Formail will print its version number and exit.
.TP
.B \-@FM_BOGUS@
Don't escape any bogus mailbox headers (i.e. lines starting with `@FROM@').
.TP
.I "\fB\-@FM_QPREFIX@\fP prefix"
Define a different quotation prefix.  If unspecified it defaults to `@ESCAP@'.
.TP
.B \-@FM_BERKELEY@
Assume traditional Berkeley mailbox format, ignoring any
.B Content-Length:
fields.
.TP
.B \-@FM_CONCATENATE@
Concatenate continued fields in the header.  Might be convenient when
postprocessing mail with standard (line oriented) text utilities.
.TP
.B \-@FM_ZAPWHITE@
Ensure a whitespace exists between field name and content.
Zap fields which contain only a single whitespace character.
Zap leading and trailing whitespace on fields extracted with
.BR \-@FM_EXTRACT@ .
.TP
.B \-@FM_FORCE@
Force formail to simply pass along any non-mailbox format (i.e. don't
generate a `@FROM@' line as the first line).
.TP
.B \-@FM_REPLY@
Generate an auto-reply header.  This will normally throw away all the existing
fields (except X-Loop:) in the original message, fields you wish to preserve
need to be named using the
.B \-@FM_REN_INSERT@
option.  If you use this option in conjunction with
.BR \-@FM_KEEPB@ ,
you can prevent the body from being `escaped' by also specifying
.BR \-@FM_BOGUS@ .
.TP
.B \-@FM_KEEPB@
When generating the auto-reply header or when extracting fields, keep
the body as well.
.TP
.B \-@FM_TRUST@
Trust the sender to have used a valid return address in his header.  This
causes formail to select the
.I header sender
instead of the
.I envelope sender
for the reply.  This option should be used when generating auto-reply
headers from news articles or when the sender of the message is
expecting a reply.
.TP
.B \-@FM_SPLIT@
The input will be split up into separate mail messages, and piped into
a program one by one (a new program is started for every part).
.B \-@FM_SPLIT@
has to be the last option specified, the first argument following it is
expected to be the name of a program, any other arguments will be
passed along to it.  If you omit the program, then formail will simply
concatenate the splitted mails on stdout again.  See
.BR @FILENO@ .
.TP
.I "\fB\-@FM_NOWAIT@\fP [maxprocs]"
Tell formail not to wait for every program to finish before starting
the next (causes splits to be processed in parallel).
.I Maxprocs
optionally specifies an upper limit on the number of concurrently
running processes.
.TP
.B \-@FM_EVERY@
Do not require empty lines to be preceding the header of a new message
(i.e.  the messages could start on every line).
.TP
.B \-@FM_DIGEST@
Tell formail that the messages it is supposed to split need not be in
strict mailbox format (i.e. allows you to split digests/articles or
non-standard mailbox formats).  This disables recognition of the
.B Content-Length:
field.
.TP
.B \-@FM_BABYL@
Makes formail assume that it is splitting up a BABYL rmail file.
.TP
.I "\fB\-@FM_MINFIELDS@\fP minfields"
Allows you to specify the number of consecutive headerfields formail
needs to find before it decides it found the start of a new message, it
defaults to @DEFminfields@.
.TP
.B \-@FM_QUIET@
Tells formail to (still detect but) be quiet about write errors,
duplicate messages and mismatched
.B Content-Length:
fields.  This option is on by default, to make it display the messages
use
.BR \-@FM_QUIET@\- .
.TP
.I "\fB\-@FM_DUPLICATE@\fP maxlen idcache"
Formail will detect if the Message-ID of the current message has
already been seen using an
.I idcache
file of approximately
.I maxlen
size.  If not splitting, it will return success if a duplicate has been
found.  If splitting, it will not output duplicate messages.  If used
in conjunction with
.BR \-@FM_REPLY@ ,
formail will look at the
.I mail address
of the envelope sender
.I instead
at the Message-ID.
.TP
.I "\fB\-@FM_EXTRACT@\fP headerfield"
Extract the contents of this
.I headerfield
from the header, display it as a single line.
.TP
.I "\fB\-@FM_EXTRC_KEEP@\fP headerfield"
Same as
.BR \-@FM_EXTRACT@ ,
but also preserves the field name.
.TP
.I "\fB\-@FM_ADD_IFNOT@\fP headerfield"
Append a custom
.I headerfield
onto the header; but only if a similar field does not exist yet.  If
you specify either one of the field names
.B Message-ID:
or
.B Resent-Message-ID:
with no field contents, then formail will generate a unique message-ID
for you.
.TP
.I "\fB\-@FM_ADD_ALWAYS@\fP headerfield"
Append a custom
.I headerfield
onto the header in any case.
.TP
.I "\fB\-@FM_REN_INSERT@\fP headerfield"
Same as
.BR \-@FM_ADD_ALWAYS@ ,
except that any existing similar fields are renamed by prepending an
``@OLD_PREFIX@'' prefix.  If
.I headerfield
consists only of a field-name, it will not be appended.
.TP
.I "\fB\-@FM_DEL_INSERT@\fP headerfield"
Same as
.BR \-@FM_REN_INSERT@ ,
except that any existing similar fields are simply removed.  If
.I headerfield
consists only of a field-name, it effectively deletes the field.
.TP
.I "\fB\-@FM_FIRST_UNIQ@\fP headerfield"
Make the first occurrence of this field unique, and thus delete all
subsequent occurrences of it.
.TP
.I "\fB\-@FM_LAST_UNIQ@\fP headerfield"
Make the last occurrence of this field unique, and thus delete all
preceding occurrences of it.
.TP
.I "\fB\-@FM_ReNAME@\fP oldfield newfield"
Renames all occurrences of the fieldname
.I oldfield
into
.IR newfield .
.TP
.I "\fB\@FM_SKIP@\fPskip"
Skip the first
.I skip
messages while splitting.
.TP
.I "\fB\@FM_TOTAL@\fPtotal"
Output at most
.I total
messages while splitting.
.SH NOTES
When renaming, removing, or extracting fields, partial fieldnames may
be used to specify all fields that start with the specified value.
.PP
By default, when generating an auto-reply header procmail selects the
envelope sender from the input message.  This is correct for vacation
messages and other automatic replies regarding the routing or delivery
of the original message.  If the sender is expecting a reply or the
reply is being generated in response to the contents of the original
message then the \-@FM_TRUST@ option should be used.
.PP
RFC822, the original standard governing the format of Internet mail
messages, did not specify whether Resent header fields (those that
begin with `Resent\-', such as `Resent\-From:') should be considered
when generating a reply.  Since then, the recommended usage of the
Resent headers has evolved to consider them as purely informational and
not for use when normally generating a reply.  While formail now
ignores Resent headers when generating header replies, versions of
formail prior to 3.14 gave such headers a high precedence.  If the old
behavior is needed for established applications it can be specified by
calling formail with the option `-@FM_ADD_IFNOT@ Resent-' in addition
to the \-@FM_REPLY@ and \-@FM_TRUST@ options.  This usage is deprecated
and should not be used in new applications.
.SH ENVIRONMENT
.TP .5i
.B @FILENO@
While splitting, formail assigns the message number currently being output to
this variable.  By presetting @FILENO@, you can change the initial message
number being used and the width of the zero-padded output.  If @FILENO@ is
unset it will default to @DEFfileno@.  If @FILENO@ is non-empty and
does not contain a number, @FILENO@ generation is disabled.
.SH EXAMPLES
To split up a digest one usually uses:
.RS
formail @FM_SKIP@1 \-@FM_DIGEST@@FM_SPLIT@ >>the_mailbox_of_your_choice
.RE
or
.RS
formail @FM_SKIP@1 \-@FM_DIGEST@@FM_SPLIT@ procmail
.RE
.PP
To remove all Received: fields from the header:
.RS
formail \-@FM_DEL_INSERT@ Received:
.RE
.PP
To remove all fields except From: and Subject: from the header:
.RS
formail \-@FM_KEEPB@ \-@FM_EXTRC_KEEP@ From: \-@FM_EXTRC_KEEP@ Subject:
.RE
.PP
To supersede the Reply-To: field in a header you could use:
.RS
formail \-@FM_REN_INSERT@ "Reply-To: foo@bar"
.RE
.PP
To convert a non-standard mailbox file into a standard mailbox file you can
use:
.RS
formail \-@FM_DIGEST@@FM_SPLIT@ <old_mailbox >>new_mailbox
.RE
.PP
Or, if you have a very tolerant mailer:
.RS
formail \-@FM_ADD_IFNOT@ Date: \-@FM_DIGEST@@FM_SPLIT@ <old_mailbox >>new_mailbox
.RE
.PP
To extract the header from a message:
.RS
formail \-@FM_EXTRC_KEEP@ ""
.RE
or
.RS
sed \-e '/^$/ q'
.RE
.PP
To extract the body from a message:
.RS
formail \-@FM_DEL_INSERT@ ""
.RE
or
.RS
sed \-e '1,/^$/ d'
.RE
.SH "SEE ALSO"
.na
.nh
.BR mail (1),
.BR binmail (1),
.BR sendmail (8),
.BR procmail (1),
.BR sed (1),
.BR sh (1),
.BR RFC822 ,
.B RFC1123
.hy
.ad
.SH DIAGNOSTICS
.TP 2.3i
Can't fork
Too many processes on this machine.
.TP
Content-Length: field exceeds actual length by nnn bytes
The Content-Length: field in the header specified a length that was longer
than the actual body.  This causes this message to absorb a number of
subsequent messages following it in the same mailbox.
.TP
Couldn't write to stdout
The program that formail was trying to pipe into didn't accept all the data
formail sent to it; this diagnostic can be suppressed by the
.B \-@FM_QUIET@
option.
.TP
Duplicate key found: x
The Message-ID or sender x in this message was found in the idcache; this
diagnostic can be suppressed by the
.B \-@FM_QUIET@
option.
.TP
Failed to execute "x"
Program not in path, or not executable.
.TP
File table full
Too many open files on this machine.
.TP
Invalid field-name: "x"
The specified field-name "x" contains control characters, or cannot be a
partial field-name for this option.
.SH WARNINGS
You can save yourself and others a lot of grief if you try to avoid using
this autoreply feature on mails coming through mailinglists.  Depending
on the format of the incoming mail (which in turn depends on both the
original sender's mail agent and the mailinglist setup) formail could
decide to generate an autoreply header that replies to the list.
.SH BUGS
When formail has to generate a leading `@FROM@' line it normally will contain
the current date.  If formail is given the option `\-@FM_ADD_IFNOT@ Date:',
it will use the date from the `Date:' field in the header (if present).
However, since formail copies it verbatim, the format will differ from that
expected by most mail readers.
.PP
If formail is instructed to delete or rename the leading `@FROM@' line, it
will not automatically regenerate it as usual.  To force formail to regenerate
it in this case, include \fB\-@FM_ADD_IFNOT@ '@FROM@'\fP.
.PP
If formail is not called as the first program in a pipe and it is told to
split up the input in several messages, then formail will not terminate until
the program it receives the input from closes its output or terminates itself.
.PP
If formail is instructed to generate an autoreply mail, it will
.B never
put more than one address in the `To:' field.
.SH MISCELLANEOUS
Formail is eight-bit clean.
.PP
When formail has to determine the sender's address, every
.B RFC822
conforming
mail address is allowed.  Formail will always strip down the address to
its minimal form (deleting excessive comments and whitespace).
.PP
The regular expression that is used to find `real' postmarks is:
.RS
"\en\en@FROM@[\et ]*[^\et\en ]+[\et ]+[^\en\et ]"
.RE
.PP
If a
.B Content-Length:
field is found in a header, formail will copy the number of specified bytes in
the body verbatim before resuming the regular scanning for message boundaries
(except when splitting digests or Berkeley mailbox format is assumed).
.SH NOTES
Calling up formail with the \-@HELPOPT1@ or \-@HELPOPT2@ options will cause
it to display a command-line help page.
