/*
 * Copyright 2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.gradle.binarycompatibility.transforms

import org.gradle.api.artifacts.transform.ArtifactTransform
import javax.inject.Inject
import groovy.transform.CompileStatic

@CompileStatic
class FindGradleJar extends ArtifactTransform {
    private final String target

    @Inject
    FindGradleJar(String target) {
        this.target = target
    }

    @Override
    List<File> transform(final File file) {
        if (file.name == 'gradle-jars') {
            (file.listFiles().findAll { it.name.startsWith("gradle-${target}-") } as List<File>).sort { it.name }
        } else {
            []
        }
    }
}
