// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists contact evaluations in the specified Amazon Connect instance.
func (c *Client) ListContactEvaluations(ctx context.Context, params *ListContactEvaluationsInput, optFns ...func(*Options)) (*ListContactEvaluationsOutput, error) {
	if params == nil {
		params = &ListContactEvaluationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListContactEvaluations", params, optFns, c.addOperationListContactEvaluationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListContactEvaluationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListContactEvaluationsInput struct {

	// The identifier of the contact in this instance of Amazon Connect.
	//
	// This member is required.
	ContactId *string

	// The identifier of the Amazon Connect instance. You can find the instance ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// This member is required.
	InstanceId *string

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results. This is not
	// expected to be set because the value returned in the previous response is always
	// null.
	NextToken *string

	noSmithyDocumentSerde
}

type ListContactEvaluationsOutput struct {

	// Provides details about a list of contact evaluations belonging to an instance.
	//
	// This member is required.
	EvaluationSummaryList []types.EvaluationSummary

	// If there are additional results, this is the token for the next set of results.
	// This is always returned as null in the response.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListContactEvaluationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListContactEvaluations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListContactEvaluations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListContactEvaluations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListContactEvaluationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListContactEvaluations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListContactEvaluationsAPIClient is a client that implements the
// ListContactEvaluations operation.
type ListContactEvaluationsAPIClient interface {
	ListContactEvaluations(context.Context, *ListContactEvaluationsInput, ...func(*Options)) (*ListContactEvaluationsOutput, error)
}

var _ ListContactEvaluationsAPIClient = (*Client)(nil)

// ListContactEvaluationsPaginatorOptions is the paginator options for
// ListContactEvaluations
type ListContactEvaluationsPaginatorOptions struct {
	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListContactEvaluationsPaginator is a paginator for ListContactEvaluations
type ListContactEvaluationsPaginator struct {
	options   ListContactEvaluationsPaginatorOptions
	client    ListContactEvaluationsAPIClient
	params    *ListContactEvaluationsInput
	nextToken *string
	firstPage bool
}

// NewListContactEvaluationsPaginator returns a new ListContactEvaluationsPaginator
func NewListContactEvaluationsPaginator(client ListContactEvaluationsAPIClient, params *ListContactEvaluationsInput, optFns ...func(*ListContactEvaluationsPaginatorOptions)) *ListContactEvaluationsPaginator {
	if params == nil {
		params = &ListContactEvaluationsInput{}
	}

	options := ListContactEvaluationsPaginatorOptions{}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListContactEvaluationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListContactEvaluationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListContactEvaluations page.
func (p *ListContactEvaluationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListContactEvaluationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	result, err := p.client.ListContactEvaluations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListContactEvaluations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListContactEvaluations",
	}
}
