// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A unique identifier for an attribute.
type AttributeKey struct {

	// The name of the facet that the attribute exists within.
	//
	// This member is required.
	FacetName *string

	// The name of the attribute.
	//
	// This member is required.
	Name *string

	// The Amazon Resource Name (ARN) of the schema that contains the facet and
	// attribute.
	//
	// This member is required.
	SchemaArn *string

	noSmithyDocumentSerde
}

// The combination of an attribute key and an attribute value.
type AttributeKeyAndValue struct {

	// The key of the attribute.
	//
	// This member is required.
	Key *AttributeKey

	// The value of the attribute.
	//
	// This member is required.
	Value TypedAttributeValue

	noSmithyDocumentSerde
}

// Identifies the attribute name and value for a typed link.
type AttributeNameAndValue struct {

	// The attribute name of the typed link.
	//
	// This member is required.
	AttributeName *string

	// The value for the typed link.
	//
	// This member is required.
	Value TypedAttributeValue

	noSmithyDocumentSerde
}

// Represents the output of a batch add facet to object operation.
type BatchAddFacetToObject struct {

	// The attributes to set on the object.
	//
	// This member is required.
	ObjectAttributeList []AttributeKeyAndValue

	// A reference to the object being mutated.
	//
	// This member is required.
	ObjectReference *ObjectReference

	// Represents the facet being added to the object.
	//
	// This member is required.
	SchemaFacet *SchemaFacet

	noSmithyDocumentSerde
}

// The result of a batch add facet to object operation.
type BatchAddFacetToObjectResponse struct {
	noSmithyDocumentSerde
}

// Represents the output of an AttachObject operation.
type BatchAttachObject struct {

	// The child object reference that is to be attached to the object.
	//
	// This member is required.
	ChildReference *ObjectReference

	// The name of the link.
	//
	// This member is required.
	LinkName *string

	// The parent object reference.
	//
	// This member is required.
	ParentReference *ObjectReference

	noSmithyDocumentSerde
}

// Represents the output batch AttachObject response operation.
type BatchAttachObjectResponse struct {

	// The ObjectIdentifier of the object that has been attached.
	AttachedObjectIdentifier *string

	noSmithyDocumentSerde
}

// Attaches a policy object to a regular object inside a BatchRead operation. For
// more information, see AttachPolicy and BatchReadRequest$Operations .
type BatchAttachPolicy struct {

	// The reference that identifies the object to which the policy will be attached.
	//
	// This member is required.
	ObjectReference *ObjectReference

	// The reference that is associated with the policy object.
	//
	// This member is required.
	PolicyReference *ObjectReference

	noSmithyDocumentSerde
}

// Represents the output of an AttachPolicy response operation.
type BatchAttachPolicyResponse struct {
	noSmithyDocumentSerde
}

// Attaches the specified object to the specified index inside a BatchRead
// operation. For more information, see AttachToIndex and
// BatchReadRequest$Operations .
type BatchAttachToIndex struct {

	// A reference to the index that you are attaching the object to.
	//
	// This member is required.
	IndexReference *ObjectReference

	// A reference to the object that you are attaching to the index.
	//
	// This member is required.
	TargetReference *ObjectReference

	noSmithyDocumentSerde
}

// Represents the output of a AttachToIndex response operation.
type BatchAttachToIndexResponse struct {

	// The ObjectIdentifier of the object that was attached to the index.
	AttachedObjectIdentifier *string

	noSmithyDocumentSerde
}

// Attaches a typed link to a specified source and target object inside a BatchRead
// operation. For more information, see AttachTypedLink and
// BatchReadRequest$Operations .
type BatchAttachTypedLink struct {

	// A set of attributes that are associated with the typed link.
	//
	// This member is required.
	Attributes []AttributeNameAndValue

	// Identifies the source object that the typed link will attach to.
	//
	// This member is required.
	SourceObjectReference *ObjectReference

	// Identifies the target object that the typed link will attach to.
	//
	// This member is required.
	TargetObjectReference *ObjectReference

	// Identifies the typed link facet that is associated with the typed link.
	//
	// This member is required.
	TypedLinkFacet *TypedLinkSchemaAndFacetName

	noSmithyDocumentSerde
}

// Represents the output of a AttachTypedLink response operation.
type BatchAttachTypedLinkResponse struct {

	// Returns a typed link specifier as output.
	TypedLinkSpecifier *TypedLinkSpecifier

	noSmithyDocumentSerde
}

// Creates an index object inside of a BatchRead operation. For more information,
// see CreateIndex and BatchReadRequest$Operations .
type BatchCreateIndex struct {

	// Indicates whether the attribute that is being indexed has unique values or not.
	//
	// This member is required.
	IsUnique bool

	// Specifies the attributes that should be indexed on. Currently only a single
	// attribute is supported.
	//
	// This member is required.
	OrderedIndexedAttributeList []AttributeKey

	// The batch reference name. See Transaction Support (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html)
	// for more information.
	BatchReferenceName *string

	// The name of the link between the parent object and the index object.
	LinkName *string

	// A reference to the parent object that contains the index object.
	ParentReference *ObjectReference

	noSmithyDocumentSerde
}

// Represents the output of a CreateIndex response operation.
type BatchCreateIndexResponse struct {

	// The ObjectIdentifier of the index created by this operation.
	ObjectIdentifier *string

	noSmithyDocumentSerde
}

// Represents the output of a CreateObject operation.
type BatchCreateObject struct {

	// An attribute map, which contains an attribute ARN as the key and attribute
	// value as the map value.
	//
	// This member is required.
	ObjectAttributeList []AttributeKeyAndValue

	// A list of FacetArns that will be associated with the object. For more
	// information, see arns .
	//
	// This member is required.
	SchemaFacet []SchemaFacet

	// The batch reference name. See Transaction Support (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html)
	// for more information.
	BatchReferenceName *string

	// The name of the link.
	LinkName *string

	// If specified, the parent reference to which this object will be attached.
	ParentReference *ObjectReference

	noSmithyDocumentSerde
}

// Represents the output of a CreateObject response operation.
type BatchCreateObjectResponse struct {

	// The ID that is associated with the object.
	ObjectIdentifier *string

	noSmithyDocumentSerde
}

// Represents the output of a DeleteObject operation.
type BatchDeleteObject struct {

	// The reference that identifies the object.
	//
	// This member is required.
	ObjectReference *ObjectReference

	noSmithyDocumentSerde
}

// Represents the output of a DeleteObject response operation.
type BatchDeleteObjectResponse struct {
	noSmithyDocumentSerde
}

// Detaches the specified object from the specified index inside a BatchRead
// operation. For more information, see DetachFromIndex and
// BatchReadRequest$Operations .
type BatchDetachFromIndex struct {

	// A reference to the index object.
	//
	// This member is required.
	IndexReference *ObjectReference

	// A reference to the object being detached from the index.
	//
	// This member is required.
	TargetReference *ObjectReference

	noSmithyDocumentSerde
}

// Represents the output of a DetachFromIndex response operation.
type BatchDetachFromIndexResponse struct {

	// The ObjectIdentifier of the object that was detached from the index.
	DetachedObjectIdentifier *string

	noSmithyDocumentSerde
}

// Represents the output of a DetachObject operation.
type BatchDetachObject struct {

	// The name of the link.
	//
	// This member is required.
	LinkName *string

	// Parent reference from which the object with the specified link name is detached.
	//
	// This member is required.
	ParentReference *ObjectReference

	// The batch reference name. See Transaction Support (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html)
	// for more information.
	BatchReferenceName *string

	noSmithyDocumentSerde
}

// Represents the output of a DetachObject response operation.
type BatchDetachObjectResponse struct {

	// The ObjectIdentifier of the detached object.
	DetachedObjectIdentifier *string

	noSmithyDocumentSerde
}

// Detaches the specified policy from the specified directory inside a BatchWrite
// operation. For more information, see DetachPolicy and
// BatchWriteRequest$Operations .
type BatchDetachPolicy struct {

	// Reference that identifies the object whose policy object will be detached.
	//
	// This member is required.
	ObjectReference *ObjectReference

	// Reference that identifies the policy object.
	//
	// This member is required.
	PolicyReference *ObjectReference

	noSmithyDocumentSerde
}

// Represents the output of a DetachPolicy response operation.
type BatchDetachPolicyResponse struct {
	noSmithyDocumentSerde
}

// Detaches a typed link from a specified source and target object inside a
// BatchRead operation. For more information, see DetachTypedLink and
// BatchReadRequest$Operations .
type BatchDetachTypedLink struct {

	// Used to accept a typed link specifier as input.
	//
	// This member is required.
	TypedLinkSpecifier *TypedLinkSpecifier

	noSmithyDocumentSerde
}

// Represents the output of a DetachTypedLink response operation.
type BatchDetachTypedLinkResponse struct {
	noSmithyDocumentSerde
}

// Retrieves attributes that are associated with a typed link inside a BatchRead
// operation. For more information, see GetLinkAttributes and
// BatchReadRequest$Operations .
type BatchGetLinkAttributes struct {

	// A list of attribute names whose values will be retrieved.
	//
	// This member is required.
	AttributeNames []string

	// Allows a typed link specifier to be accepted as input.
	//
	// This member is required.
	TypedLinkSpecifier *TypedLinkSpecifier

	noSmithyDocumentSerde
}

// Represents the output of a GetLinkAttributes response operation.
type BatchGetLinkAttributesResponse struct {

	// The attributes that are associated with the typed link.
	Attributes []AttributeKeyAndValue

	noSmithyDocumentSerde
}

// Retrieves attributes within a facet that are associated with an object inside
// an BatchRead operation. For more information, see GetObjectAttributes and
// BatchReadRequest$Operations .
type BatchGetObjectAttributes struct {

	// List of attribute names whose values will be retrieved.
	//
	// This member is required.
	AttributeNames []string

	// Reference that identifies the object whose attributes will be retrieved.
	//
	// This member is required.
	ObjectReference *ObjectReference

	// Identifier for the facet whose attributes will be retrieved. See SchemaFacet
	// for details.
	//
	// This member is required.
	SchemaFacet *SchemaFacet

	noSmithyDocumentSerde
}

// Represents the output of a GetObjectAttributes response operation.
type BatchGetObjectAttributesResponse struct {

	// The attribute values that are associated with an object.
	Attributes []AttributeKeyAndValue

	noSmithyDocumentSerde
}

// Retrieves metadata about an object inside a BatchRead operation. For more
// information, see GetObjectInformation and BatchReadRequest$Operations .
type BatchGetObjectInformation struct {

	// A reference to the object.
	//
	// This member is required.
	ObjectReference *ObjectReference

	noSmithyDocumentSerde
}

// Represents the output of a GetObjectInformation response operation.
type BatchGetObjectInformationResponse struct {

	// The ObjectIdentifier of the specified object.
	ObjectIdentifier *string

	// The facets attached to the specified object.
	SchemaFacets []SchemaFacet

	noSmithyDocumentSerde
}

// Lists indices attached to an object inside a BatchRead operation. For more
// information, see ListAttachedIndices and BatchReadRequest$Operations .
type BatchListAttachedIndices struct {

	// A reference to the object that has indices attached.
	//
	// This member is required.
	TargetReference *ObjectReference

	// The maximum number of results to retrieve.
	MaxResults *int32

	// The pagination token.
	NextToken *string

	noSmithyDocumentSerde
}

// Represents the output of a ListAttachedIndices response operation.
type BatchListAttachedIndicesResponse struct {

	// The indices attached to the specified object.
	IndexAttachments []IndexAttachment

	// The pagination token.
	NextToken *string

	noSmithyDocumentSerde
}

// Returns a paginated list of all the incoming TypedLinkSpecifier information for
// an object inside a BatchRead operation. For more information, see
// ListIncomingTypedLinks and BatchReadRequest$Operations .
type BatchListIncomingTypedLinks struct {

	// The reference that identifies the object whose attributes will be listed.
	//
	// This member is required.
	ObjectReference *ObjectReference

	// Provides range filters for multiple attributes. When providing ranges to typed
	// link selection, any inexact ranges must be specified at the end. Any attributes
	// that do not have a range specified are presumed to match the entire range.
	FilterAttributeRanges []TypedLinkAttributeRange

	// Filters are interpreted in the order of the attributes on the typed link facet,
	// not the order in which they are supplied to any API calls.
	FilterTypedLink *TypedLinkSchemaAndFacetName

	// The maximum number of results to retrieve.
	MaxResults *int32

	// The pagination token.
	NextToken *string

	noSmithyDocumentSerde
}

// Represents the output of a ListIncomingTypedLinks response operation.
type BatchListIncomingTypedLinksResponse struct {

	// Returns one or more typed link specifiers as output.
	LinkSpecifiers []TypedLinkSpecifier

	// The pagination token.
	NextToken *string

	noSmithyDocumentSerde
}

// Lists objects attached to the specified index inside a BatchRead operation. For
// more information, see ListIndex and BatchReadRequest$Operations .
type BatchListIndex struct {

	// The reference to the index to list.
	//
	// This member is required.
	IndexReference *ObjectReference

	// The maximum number of results to retrieve.
	MaxResults *int32

	// The pagination token.
	NextToken *string

	// Specifies the ranges of indexed values that you want to query.
	RangesOnIndexedValues []ObjectAttributeRange

	noSmithyDocumentSerde
}

// Represents the output of a ListIndex response operation.
type BatchListIndexResponse struct {

	// The objects and indexed values attached to the index.
	IndexAttachments []IndexAttachment

	// The pagination token.
	NextToken *string

	noSmithyDocumentSerde
}

// Represents the output of a ListObjectAttributes operation.
type BatchListObjectAttributes struct {

	// Reference of the object whose attributes need to be listed.
	//
	// This member is required.
	ObjectReference *ObjectReference

	// Used to filter the list of object attributes that are associated with a certain
	// facet.
	FacetFilter *SchemaFacet

	// The maximum number of items to be retrieved in a single call. This is an
	// approximate number.
	MaxResults *int32

	// The pagination token.
	NextToken *string

	noSmithyDocumentSerde
}

// Represents the output of a ListObjectAttributes response operation.
type BatchListObjectAttributesResponse struct {

	// The attributes map that is associated with the object. AttributeArn is the key;
	// attribute value is the value.
	Attributes []AttributeKeyAndValue

	// The pagination token.
	NextToken *string

	noSmithyDocumentSerde
}

// Represents the output of a ListObjectChildren operation.
type BatchListObjectChildren struct {

	// Reference of the object for which child objects are being listed.
	//
	// This member is required.
	ObjectReference *ObjectReference

	// Maximum number of items to be retrieved in a single call. This is an
	// approximate number.
	MaxResults *int32

	// The pagination token.
	NextToken *string

	noSmithyDocumentSerde
}

// Represents the output of a ListObjectChildren response operation.
type BatchListObjectChildrenResponse struct {

	// The children structure, which is a map with the key as the LinkName and
	// ObjectIdentifier as the value.
	Children map[string]string

	// The pagination token.
	NextToken *string

	noSmithyDocumentSerde
}

// Retrieves all available parent paths for any object type such as node, leaf
// node, policy node, and index node objects inside a BatchRead operation. For
// more information, see ListObjectParentPaths and BatchReadRequest$Operations .
type BatchListObjectParentPaths struct {

	// The reference that identifies the object whose attributes will be listed.
	//
	// This member is required.
	ObjectReference *ObjectReference

	// The maximum number of results to retrieve.
	MaxResults *int32

	// The pagination token.
	NextToken *string

	noSmithyDocumentSerde
}

// Represents the output of a ListObjectParentPaths response operation.
type BatchListObjectParentPathsResponse struct {

	// The pagination token.
	NextToken *string

	// Returns the path to the ObjectIdentifiers that are associated with the
	// directory.
	PathToObjectIdentifiersList []PathToObjectIdentifiers

	noSmithyDocumentSerde
}

// Lists parent objects that are associated with a given object in pagination
// fashion.
type BatchListObjectParents struct {

	// The reference that identifies an object.
	//
	// This member is required.
	ObjectReference *ObjectReference

	// The maximum number of items to be retrieved in a single call. This is an
	// approximate number.
	MaxResults *int32

	// The pagination token.
	NextToken *string

	noSmithyDocumentSerde
}

// Represents the output of a ListObjectParents response operation.
type BatchListObjectParentsResponse struct {

	// The pagination token.
	NextToken *string

	// Returns a list of parent reference and LinkName Tuples.
	ParentLinks []ObjectIdentifierAndLinkNameTuple

	noSmithyDocumentSerde
}

// Returns policies attached to an object in pagination fashion inside a BatchRead
// operation. For more information, see ListObjectPolicies and
// BatchReadRequest$Operations .
type BatchListObjectPolicies struct {

	// The reference that identifies the object whose attributes will be listed.
	//
	// This member is required.
	ObjectReference *ObjectReference

	// The maximum number of results to retrieve.
	MaxResults *int32

	// The pagination token.
	NextToken *string

	noSmithyDocumentSerde
}

// Represents the output of a ListObjectPolicies response operation.
type BatchListObjectPoliciesResponse struct {

	// A list of policy ObjectIdentifiers , that are attached to the object.
	AttachedPolicyIds []string

	// The pagination token.
	NextToken *string

	noSmithyDocumentSerde
}

// Returns a paginated list of all the outgoing TypedLinkSpecifier information for
// an object inside a BatchRead operation. For more information, see
// ListOutgoingTypedLinks and BatchReadRequest$Operations .
type BatchListOutgoingTypedLinks struct {

	// The reference that identifies the object whose attributes will be listed.
	//
	// This member is required.
	ObjectReference *ObjectReference

	// Provides range filters for multiple attributes. When providing ranges to typed
	// link selection, any inexact ranges must be specified at the end. Any attributes
	// that do not have a range specified are presumed to match the entire range.
	FilterAttributeRanges []TypedLinkAttributeRange

	// Filters are interpreted in the order of the attributes defined on the typed
	// link facet, not the order they are supplied to any API calls.
	FilterTypedLink *TypedLinkSchemaAndFacetName

	// The maximum number of results to retrieve.
	MaxResults *int32

	// The pagination token.
	NextToken *string

	noSmithyDocumentSerde
}

// Represents the output of a ListOutgoingTypedLinks response operation.
type BatchListOutgoingTypedLinksResponse struct {

	// The pagination token.
	NextToken *string

	// Returns a typed link specifier as output.
	TypedLinkSpecifiers []TypedLinkSpecifier

	noSmithyDocumentSerde
}

// Returns all of the ObjectIdentifiers to which a given policy is attached inside
// a BatchRead operation. For more information, see ListPolicyAttachments and
// BatchReadRequest$Operations .
type BatchListPolicyAttachments struct {

	// The reference that identifies the policy object.
	//
	// This member is required.
	PolicyReference *ObjectReference

	// The maximum number of results to retrieve.
	MaxResults *int32

	// The pagination token.
	NextToken *string

	noSmithyDocumentSerde
}

// Represents the output of a ListPolicyAttachments response operation.
type BatchListPolicyAttachmentsResponse struct {

	// The pagination token.
	NextToken *string

	// A list of ObjectIdentifiers to which the policy is attached.
	ObjectIdentifiers []string

	noSmithyDocumentSerde
}

// Lists all policies from the root of the Directory to the object specified
// inside a BatchRead operation. For more information, see LookupPolicy and
// BatchReadRequest$Operations .
type BatchLookupPolicy struct {

	// Reference that identifies the object whose policies will be looked up.
	//
	// This member is required.
	ObjectReference *ObjectReference

	// The maximum number of results to retrieve.
	MaxResults *int32

	// The pagination token.
	NextToken *string

	noSmithyDocumentSerde
}

// Represents the output of a LookupPolicy response operation.
type BatchLookupPolicyResponse struct {

	// The pagination token.
	NextToken *string

	// Provides list of path to policies. Policies contain PolicyId , ObjectIdentifier
	// , and PolicyType . For more information, see Policies (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies)
	// .
	PolicyToPathList []PolicyToPath

	noSmithyDocumentSerde
}

// The batch read exception structure, which contains the exception type and
// message.
type BatchReadException struct {

	// An exception message that is associated with the failure.
	Message *string

	// A type of exception, such as InvalidArnException .
	Type BatchReadExceptionType

	noSmithyDocumentSerde
}

// Represents the output of a BatchRead operation.
type BatchReadOperation struct {

	// Retrieves attributes that are associated with a typed link.
	GetLinkAttributes *BatchGetLinkAttributes

	// Retrieves attributes within a facet that are associated with an object.
	GetObjectAttributes *BatchGetObjectAttributes

	// Retrieves metadata about an object.
	GetObjectInformation *BatchGetObjectInformation

	// Lists indices attached to an object.
	ListAttachedIndices *BatchListAttachedIndices

	// Returns a paginated list of all the incoming TypedLinkSpecifier information for
	// an object. It also supports filtering by typed link facet and identity
	// attributes. For more information, see Typed Links (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink)
	// .
	ListIncomingTypedLinks *BatchListIncomingTypedLinks

	// Lists objects attached to the specified index.
	ListIndex *BatchListIndex

	// Lists all attributes that are associated with an object.
	ListObjectAttributes *BatchListObjectAttributes

	// Returns a paginated list of child objects that are associated with a given
	// object.
	ListObjectChildren *BatchListObjectChildren

	// Retrieves all available parent paths for any object type such as node, leaf
	// node, policy node, and index node objects. For more information about objects,
	// see Directory Structure (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html)
	// .
	ListObjectParentPaths *BatchListObjectParentPaths

	// Lists parent objects that are associated with a given object in pagination
	// fashion.
	ListObjectParents *BatchListObjectParents

	// Returns policies attached to an object in pagination fashion.
	ListObjectPolicies *BatchListObjectPolicies

	// Returns a paginated list of all the outgoing TypedLinkSpecifier information for
	// an object. It also supports filtering by typed link facet and identity
	// attributes. For more information, see Typed Links (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink)
	// .
	ListOutgoingTypedLinks *BatchListOutgoingTypedLinks

	// Returns all of the ObjectIdentifiers to which a given policy is attached.
	ListPolicyAttachments *BatchListPolicyAttachments

	// Lists all policies from the root of the Directory to the object specified. If
	// there are no policies present, an empty list is returned. If policies are
	// present, and if some objects don't have the policies attached, it returns the
	// ObjectIdentifier for such objects. If policies are present, it returns
	// ObjectIdentifier , policyId , and policyType . Paths that don't lead to the root
	// from the target object are ignored. For more information, see Policies (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies)
	// .
	LookupPolicy *BatchLookupPolicy

	noSmithyDocumentSerde
}

// Represents the output of a BatchRead response operation.
type BatchReadOperationResponse struct {

	// Identifies which operation in a batch has failed.
	ExceptionResponse *BatchReadException

	// Identifies which operation in a batch has succeeded.
	SuccessfulResponse *BatchReadSuccessfulResponse

	noSmithyDocumentSerde
}

// Represents the output of a BatchRead success response operation.
type BatchReadSuccessfulResponse struct {

	// The list of attributes to retrieve from the typed link.
	GetLinkAttributes *BatchGetLinkAttributesResponse

	// Retrieves attributes within a facet that are associated with an object.
	GetObjectAttributes *BatchGetObjectAttributesResponse

	// Retrieves metadata about an object.
	GetObjectInformation *BatchGetObjectInformationResponse

	// Lists indices attached to an object.
	ListAttachedIndices *BatchListAttachedIndicesResponse

	// Returns a paginated list of all the incoming TypedLinkSpecifier information for
	// an object. It also supports filtering by typed link facet and identity
	// attributes. For more information, see Typed Links (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink)
	// .
	ListIncomingTypedLinks *BatchListIncomingTypedLinksResponse

	// Lists objects attached to the specified index.
	ListIndex *BatchListIndexResponse

	// Lists all attributes that are associated with an object.
	ListObjectAttributes *BatchListObjectAttributesResponse

	// Returns a paginated list of child objects that are associated with a given
	// object.
	ListObjectChildren *BatchListObjectChildrenResponse

	// Retrieves all available parent paths for any object type such as node, leaf
	// node, policy node, and index node objects. For more information about objects,
	// see Directory Structure (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html)
	// .
	ListObjectParentPaths *BatchListObjectParentPathsResponse

	// The list of parent objects to retrieve.
	ListObjectParents *BatchListObjectParentsResponse

	// Returns policies attached to an object in pagination fashion.
	ListObjectPolicies *BatchListObjectPoliciesResponse

	// Returns a paginated list of all the outgoing TypedLinkSpecifier information for
	// an object. It also supports filtering by typed link facet and identity
	// attributes. For more information, see Typed Links (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink)
	// .
	ListOutgoingTypedLinks *BatchListOutgoingTypedLinksResponse

	// Returns all of the ObjectIdentifiers to which a given policy is attached.
	ListPolicyAttachments *BatchListPolicyAttachmentsResponse

	// Lists all policies from the root of the Directory to the object specified. If
	// there are no policies present, an empty list is returned. If policies are
	// present, and if some objects don't have the policies attached, it returns the
	// ObjectIdentifier for such objects. If policies are present, it returns
	// ObjectIdentifier , policyId , and policyType . Paths that don't lead to the root
	// from the target object are ignored. For more information, see Policies (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies)
	// .
	LookupPolicy *BatchLookupPolicyResponse

	noSmithyDocumentSerde
}

// A batch operation to remove a facet from an object.
type BatchRemoveFacetFromObject struct {

	// A reference to the object whose facet will be removed.
	//
	// This member is required.
	ObjectReference *ObjectReference

	// The facet to remove from the object.
	//
	// This member is required.
	SchemaFacet *SchemaFacet

	noSmithyDocumentSerde
}

// An empty result that represents success.
type BatchRemoveFacetFromObjectResponse struct {
	noSmithyDocumentSerde
}

// Updates a given typed link’s attributes inside a BatchRead operation.
// Attributes to be updated must not contribute to the typed link’s identity, as
// defined by its IdentityAttributeOrder . For more information, see
// UpdateLinkAttributes and BatchReadRequest$Operations .
type BatchUpdateLinkAttributes struct {

	// The attributes update structure.
	//
	// This member is required.
	AttributeUpdates []LinkAttributeUpdate

	// Allows a typed link specifier to be accepted as input.
	//
	// This member is required.
	TypedLinkSpecifier *TypedLinkSpecifier

	noSmithyDocumentSerde
}

// Represents the output of a UpdateLinkAttributes response operation.
type BatchUpdateLinkAttributesResponse struct {
	noSmithyDocumentSerde
}

// Represents the output of a BatchUpdate operation.
type BatchUpdateObjectAttributes struct {

	// Attributes update structure.
	//
	// This member is required.
	AttributeUpdates []ObjectAttributeUpdate

	// Reference that identifies the object.
	//
	// This member is required.
	ObjectReference *ObjectReference

	noSmithyDocumentSerde
}

// Represents the output of a BatchUpdate response operation.
type BatchUpdateObjectAttributesResponse struct {

	// ID that is associated with the object.
	ObjectIdentifier *string

	noSmithyDocumentSerde
}

// Represents the output of a BatchWrite operation.
type BatchWriteOperation struct {

	// A batch operation that adds a facet to an object.
	AddFacetToObject *BatchAddFacetToObject

	// Attaches an object to a Directory .
	AttachObject *BatchAttachObject

	// Attaches a policy object to a regular object. An object can have a limited
	// number of attached policies.
	AttachPolicy *BatchAttachPolicy

	// Attaches the specified object to the specified index.
	AttachToIndex *BatchAttachToIndex

	// Attaches a typed link to a specified source and target object. For more
	// information, see Typed Links (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink)
	// .
	AttachTypedLink *BatchAttachTypedLink

	// Creates an index object. See Indexing and search (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.htm)
	// for more information.
	CreateIndex *BatchCreateIndex

	// Creates an object.
	CreateObject *BatchCreateObject

	// Deletes an object in a Directory .
	DeleteObject *BatchDeleteObject

	// Detaches the specified object from the specified index.
	DetachFromIndex *BatchDetachFromIndex

	// Detaches an object from a Directory .
	DetachObject *BatchDetachObject

	// Detaches a policy from a Directory .
	DetachPolicy *BatchDetachPolicy

	// Detaches a typed link from a specified source and target object. For more
	// information, see Typed Links (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink)
	// .
	DetachTypedLink *BatchDetachTypedLink

	// A batch operation that removes a facet from an object.
	RemoveFacetFromObject *BatchRemoveFacetFromObject

	// Updates a given object's attributes.
	UpdateLinkAttributes *BatchUpdateLinkAttributes

	// Updates a given object's attributes.
	UpdateObjectAttributes *BatchUpdateObjectAttributes

	noSmithyDocumentSerde
}

// Represents the output of a BatchWrite response operation.
type BatchWriteOperationResponse struct {

	// The result of an add facet to object batch operation.
	AddFacetToObject *BatchAddFacetToObjectResponse

	// Attaches an object to a Directory .
	AttachObject *BatchAttachObjectResponse

	// Attaches a policy object to a regular object. An object can have a limited
	// number of attached policies.
	AttachPolicy *BatchAttachPolicyResponse

	// Attaches the specified object to the specified index.
	AttachToIndex *BatchAttachToIndexResponse

	// Attaches a typed link to a specified source and target object. For more
	// information, see Typed Links (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink)
	// .
	AttachTypedLink *BatchAttachTypedLinkResponse

	// Creates an index object. See Indexing and search (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.htm)
	// for more information.
	CreateIndex *BatchCreateIndexResponse

	// Creates an object in a Directory .
	CreateObject *BatchCreateObjectResponse

	// Deletes an object in a Directory .
	DeleteObject *BatchDeleteObjectResponse

	// Detaches the specified object from the specified index.
	DetachFromIndex *BatchDetachFromIndexResponse

	// Detaches an object from a Directory .
	DetachObject *BatchDetachObjectResponse

	// Detaches a policy from a Directory .
	DetachPolicy *BatchDetachPolicyResponse

	// Detaches a typed link from a specified source and target object. For more
	// information, see Typed Links (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink)
	// .
	DetachTypedLink *BatchDetachTypedLinkResponse

	// The result of a batch remove facet from object operation.
	RemoveFacetFromObject *BatchRemoveFacetFromObjectResponse

	// Represents the output of a BatchWrite response operation.
	UpdateLinkAttributes *BatchUpdateLinkAttributesResponse

	// Updates a given object’s attributes.
	UpdateObjectAttributes *BatchUpdateObjectAttributesResponse

	noSmithyDocumentSerde
}

// Directory structure that includes the directory name and directory ARN.
type Directory struct {

	// The date and time when the directory was created.
	CreationDateTime *time.Time

	// The Amazon Resource Name (ARN) that is associated with the directory. For more
	// information, see arns .
	DirectoryArn *string

	// The name of the directory.
	Name *string

	// The state of the directory. Can be either Enabled , Disabled , or Deleted .
	State DirectoryState

	noSmithyDocumentSerde
}

// A structure that contains Name , ARN , Attributes , Rule s , and ObjectTypes .
// See Facets (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_whatarefacets.html)
// for more information.
type Facet struct {

	// There are two different styles that you can define on any given facet, Static
	// and Dynamic . For static facets, all attributes must be defined in the schema.
	// For dynamic facets, attributes can be defined during data plane operations.
	FacetStyle FacetStyle

	// The name of the Facet .
	Name *string

	// The object type that is associated with the facet. See
	// CreateFacetRequest$ObjectType for more details.
	ObjectType ObjectType

	noSmithyDocumentSerde
}

// An attribute that is associated with the Facet .
type FacetAttribute struct {

	// The name of the facet attribute.
	//
	// This member is required.
	Name *string

	// A facet attribute consists of either a definition or a reference. This
	// structure contains the attribute definition. See Attribute References (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html)
	// for more information.
	AttributeDefinition *FacetAttributeDefinition

	// An attribute reference that is associated with the attribute. See Attribute
	// References (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html)
	// for more information.
	AttributeReference *FacetAttributeReference

	// The required behavior of the FacetAttribute .
	RequiredBehavior RequiredAttributeBehavior

	noSmithyDocumentSerde
}

// A facet attribute definition. See Attribute References (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html)
// for more information.
type FacetAttributeDefinition struct {

	// The type of the attribute.
	//
	// This member is required.
	Type FacetAttributeType

	// The default value of the attribute (if configured).
	DefaultValue TypedAttributeValue

	// Whether the attribute is mutable or not.
	IsImmutable bool

	// Validation rules attached to the attribute definition.
	Rules map[string]Rule

	noSmithyDocumentSerde
}

// The facet attribute reference that specifies the attribute definition that
// contains the attribute facet name and attribute name.
type FacetAttributeReference struct {

	// The target attribute name that is associated with the facet reference. See
	// Attribute References (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html)
	// for more information.
	//
	// This member is required.
	TargetAttributeName *string

	// The target facet name that is associated with the facet reference. See
	// Attribute References (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_attributereferences.html)
	// for more information.
	//
	// This member is required.
	TargetFacetName *string

	noSmithyDocumentSerde
}

// A structure that contains information used to update an attribute.
type FacetAttributeUpdate struct {

	// The action to perform when updating the attribute.
	Action UpdateActionType

	// The attribute to update.
	Attribute *FacetAttribute

	noSmithyDocumentSerde
}

// Represents an index and an attached object.
type IndexAttachment struct {

	// The indexed attribute values.
	IndexedAttributes []AttributeKeyAndValue

	// In response to ListIndex , the ObjectIdentifier of the object attached to the
	// index. In response to ListAttachedIndices , the ObjectIdentifier of the index
	// attached to the object. This field will always contain the ObjectIdentifier of
	// the object on the opposite side of the attachment specified in the query.
	ObjectIdentifier *string

	noSmithyDocumentSerde
}

// The action to take on a typed link attribute value. Updates are only supported
// for attributes which don’t contribute to link identity.
type LinkAttributeAction struct {

	// A type that can be either UPDATE_OR_CREATE or DELETE .
	AttributeActionType UpdateActionType

	// The value that you want to update to.
	AttributeUpdateValue TypedAttributeValue

	noSmithyDocumentSerde
}

// Structure that contains attribute update information.
type LinkAttributeUpdate struct {

	// The action to perform as part of the attribute update.
	AttributeAction *LinkAttributeAction

	// The key of the attribute being updated.
	AttributeKey *AttributeKey

	noSmithyDocumentSerde
}

// The action to take on the object attribute.
type ObjectAttributeAction struct {

	// A type that can be either Update or Delete .
	ObjectAttributeActionType UpdateActionType

	// The value that you want to update to.
	ObjectAttributeUpdateValue TypedAttributeValue

	noSmithyDocumentSerde
}

// A range of attributes.
type ObjectAttributeRange struct {

	// The key of the attribute that the attribute range covers.
	AttributeKey *AttributeKey

	// The range of attribute values being selected.
	Range *TypedAttributeValueRange

	noSmithyDocumentSerde
}

// Structure that contains attribute update information.
type ObjectAttributeUpdate struct {

	// The action to perform as part of the attribute update.
	ObjectAttributeAction *ObjectAttributeAction

	// The key of the attribute being updated.
	ObjectAttributeKey *AttributeKey

	noSmithyDocumentSerde
}

// A pair of ObjectIdentifier and LinkName.
type ObjectIdentifierAndLinkNameTuple struct {

	// The name of the link between the parent and the child object.
	LinkName *string

	// The ID that is associated with the object.
	ObjectIdentifier *string

	noSmithyDocumentSerde
}

// The reference that identifies an object.
type ObjectReference struct {

	// A path selector supports easy selection of an object by the parent/child links
	// leading to it from the directory root. Use the link names from each parent/child
	// link to construct the path. Path selectors start with a slash (/) and link names
	// are separated by slashes. For more information about paths, see Access Objects (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_access_objects.html)
	// . You can identify an object in one of the following ways:
	//   - $ObjectIdentifier - An object identifier is an opaque string provided by
	//   Amazon Cloud Directory. When creating objects, the system will provide you with
	//   the identifier of the created object. An object’s identifier is immutable and no
	//   two objects will ever share the same object identifier. To identify an object
	//   with ObjectIdentifier, the ObjectIdentifier must be wrapped in double quotes.
	//   - /some/path - Identifies the object based on path
	//   - #SomeBatchReference - Identifies the object in a batch call
	Selector *string

	noSmithyDocumentSerde
}

// Returns the path to the ObjectIdentifiers that is associated with the directory.
type PathToObjectIdentifiers struct {

	// Lists ObjectIdentifiers starting from directory root to the object in the
	// request.
	ObjectIdentifiers []string

	// The path that is used to identify the object starting from directory root.
	Path *string

	noSmithyDocumentSerde
}

// Contains the PolicyType , PolicyId , and the ObjectIdentifier to which it is
// attached. For more information, see Policies (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies)
// .
type PolicyAttachment struct {

	// The ObjectIdentifier that is associated with PolicyAttachment .
	ObjectIdentifier *string

	// The ID of PolicyAttachment .
	PolicyId *string

	// The type of policy that can be associated with PolicyAttachment .
	PolicyType *string

	noSmithyDocumentSerde
}

// Used when a regular object exists in a Directory and you want to find all of
// the policies that are associated with that object and the parent to that object.
type PolicyToPath struct {

	// The path that is referenced from the root.
	Path *string

	// List of policy objects.
	Policies []PolicyAttachment

	noSmithyDocumentSerde
}

// Contains an Amazon Resource Name (ARN) and parameters that are associated with
// the rule.
type Rule struct {

	// The minimum and maximum parameters that are associated with the rule.
	Parameters map[string]string

	// The type of attribute validation rule.
	Type RuleType

	noSmithyDocumentSerde
}

// A facet.
type SchemaFacet struct {

	// The name of the facet. If this value is set, SchemaArn must also be set.
	FacetName *string

	// The ARN of the schema that contains the facet with no minor component. See arns
	// and In-Place Schema Upgrade (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_inplaceschemaupgrade.html)
	// for a description of when to provide minor versions. If this value is set,
	// FacetName must also be set.
	SchemaArn *string

	noSmithyDocumentSerde
}

// The tag structure that contains a tag key and value.
type Tag struct {

	// The key that is associated with the tag.
	Key *string

	// The value that is associated with the tag.
	Value *string

	noSmithyDocumentSerde
}

// Represents the data for a typed attribute. You can set one, and only one, of
// the elements. Each attribute in an item is a name-value pair. Attributes have a
// single value.
//
// The following types satisfy this interface:
//
//	TypedAttributeValueMemberBinaryValue
//	TypedAttributeValueMemberBooleanValue
//	TypedAttributeValueMemberDatetimeValue
//	TypedAttributeValueMemberNumberValue
//	TypedAttributeValueMemberStringValue
type TypedAttributeValue interface {
	isTypedAttributeValue()
}

// A binary data value.
type TypedAttributeValueMemberBinaryValue struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*TypedAttributeValueMemberBinaryValue) isTypedAttributeValue() {}

// A Boolean data value.
type TypedAttributeValueMemberBooleanValue struct {
	Value bool

	noSmithyDocumentSerde
}

func (*TypedAttributeValueMemberBooleanValue) isTypedAttributeValue() {}

// A date and time value.
type TypedAttributeValueMemberDatetimeValue struct {
	Value time.Time

	noSmithyDocumentSerde
}

func (*TypedAttributeValueMemberDatetimeValue) isTypedAttributeValue() {}

// A number data value.
type TypedAttributeValueMemberNumberValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*TypedAttributeValueMemberNumberValue) isTypedAttributeValue() {}

// A string data value.
type TypedAttributeValueMemberStringValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*TypedAttributeValueMemberStringValue) isTypedAttributeValue() {}

// A range of attribute values. For more information, see Range Filters (https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_range_filters.html)
// .
type TypedAttributeValueRange struct {

	// The inclusive or exclusive range end.
	//
	// This member is required.
	EndMode RangeMode

	// The inclusive or exclusive range start.
	//
	// This member is required.
	StartMode RangeMode

	// The attribute value to terminate the range at.
	EndValue TypedAttributeValue

	// The value to start the range at.
	StartValue TypedAttributeValue

	noSmithyDocumentSerde
}

// A typed link attribute definition.
type TypedLinkAttributeDefinition struct {

	// The unique name of the typed link attribute.
	//
	// This member is required.
	Name *string

	// The required behavior of the TypedLinkAttributeDefinition .
	//
	// This member is required.
	RequiredBehavior RequiredAttributeBehavior

	// The type of the attribute.
	//
	// This member is required.
	Type FacetAttributeType

	// The default value of the attribute (if configured).
	DefaultValue TypedAttributeValue

	// Whether the attribute is mutable or not.
	IsImmutable bool

	// Validation rules that are attached to the attribute definition.
	Rules map[string]Rule

	noSmithyDocumentSerde
}

// Identifies the range of attributes that are used by a specified filter.
type TypedLinkAttributeRange struct {

	// The range of attribute values that are being selected.
	//
	// This member is required.
	Range *TypedAttributeValueRange

	// The unique name of the typed link attribute.
	AttributeName *string

	noSmithyDocumentSerde
}

// Defines the typed links structure and its attributes. To create a typed link
// facet, use the CreateTypedLinkFacet API.
type TypedLinkFacet struct {

	// A set of key-value pairs associated with the typed link. Typed link attributes
	// are used when you have data values that are related to the link itself, and not
	// to one of the two objects being linked. Identity attributes also serve to
	// distinguish the link from others of the same type between the same objects.
	//
	// This member is required.
	Attributes []TypedLinkAttributeDefinition

	// The set of attributes that distinguish links made from this facet from each
	// other, in the order of significance. Listing typed links can filter on the
	// values of these attributes. See ListOutgoingTypedLinks and
	// ListIncomingTypedLinks for details.
	//
	// This member is required.
	IdentityAttributeOrder []string

	// The unique name of the typed link facet.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// A typed link facet attribute update.
type TypedLinkFacetAttributeUpdate struct {

	// The action to perform when updating the attribute.
	//
	// This member is required.
	Action UpdateActionType

	// The attribute to update.
	//
	// This member is required.
	Attribute *TypedLinkAttributeDefinition

	noSmithyDocumentSerde
}

// Identifies the schema Amazon Resource Name (ARN) and facet name for the typed
// link.
type TypedLinkSchemaAndFacetName struct {

	// The Amazon Resource Name (ARN) that is associated with the schema. For more
	// information, see arns .
	//
	// This member is required.
	SchemaArn *string

	// The unique name of the typed link facet.
	//
	// This member is required.
	TypedLinkName *string

	noSmithyDocumentSerde
}

// Contains all the information that is used to uniquely identify a typed link.
// The parameters discussed in this topic are used to uniquely specify the typed
// link being operated on. The AttachTypedLink API returns a typed link specifier
// while the DetachTypedLink API accepts one as input. Similarly, the
// ListIncomingTypedLinks and ListOutgoingTypedLinks API operations provide typed
// link specifiers as output. You can also construct a typed link specifier from
// scratch.
type TypedLinkSpecifier struct {

	// Identifies the attribute value to update.
	//
	// This member is required.
	IdentityAttributeValues []AttributeNameAndValue

	// Identifies the source object that the typed link will attach to.
	//
	// This member is required.
	SourceObjectReference *ObjectReference

	// Identifies the target object that the typed link will attach to.
	//
	// This member is required.
	TargetObjectReference *ObjectReference

	// Identifies the typed link facet that is associated with the typed link.
	//
	// This member is required.
	TypedLinkFacet *TypedLinkSchemaAndFacetName

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isTypedAttributeValue() {}
