// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// The client token input parameter was matched one used with a previous call to
// the operation, but at least one of the other input parameters is different from
// the previous call.
type IdempotentParameterMismatchException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *IdempotentParameterMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IdempotentParameterMismatchException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IdempotentParameterMismatchException) ErrorCode() string {
	return "IdempotentParameterMismatchException"
}
func (e *IdempotentParameterMismatchException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The client token is not valid.
type InvalidClientTokenException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidClientTokenException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidClientTokenException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidClientTokenException) ErrorCode() string             { return "InvalidClientTokenException" }
func (e *InvalidClientTokenException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified value for MaxResults is not valid.
type InvalidMaxResultsException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidMaxResultsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidMaxResultsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidMaxResultsException) ErrorCode() string             { return "InvalidMaxResultsException" }
func (e *InvalidMaxResultsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified value for NextToken is not valid.
type InvalidNextTokenException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidNextTokenException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidNextTokenException) ErrorCode() string             { return "InvalidNextTokenException" }
func (e *InvalidNextTokenException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A parameter is not valid.
type InvalidParameterException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidParameterException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidParameterException) ErrorCode() string             { return "InvalidParameterException" }
func (e *InvalidParameterException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified resource type is not valid.
type InvalidResourceTypeException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidResourceTypeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidResourceTypeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidResourceTypeException) ErrorCode() string             { return "InvalidResourceTypeException" }
func (e *InvalidResourceTypeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested state transition is not valid.
type InvalidStateTransitionException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *InvalidStateTransitionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidStateTransitionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidStateTransitionException) ErrorCode() string {
	return "InvalidStateTransitionException"
}
func (e *InvalidStateTransitionException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The format of an Amazon Resource Name (ARN) is not valid.
type MalformedArnException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *MalformedArnException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MalformedArnException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MalformedArnException) ErrorCode() string             { return "MalformedArnException" }
func (e *MalformedArnException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A required input parameter is missing.
type MissingRequiredParameterException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *MissingRequiredParameterException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MissingRequiredParameterException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MissingRequiredParameterException) ErrorCode() string {
	return "MissingRequiredParameterException"
}
func (e *MissingRequiredParameterException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested operation is not permitted.
type OperationNotPermittedException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *OperationNotPermittedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OperationNotPermittedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OperationNotPermittedException) ErrorCode() string             { return "OperationNotPermittedException" }
func (e *OperationNotPermittedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified Amazon Resource Name (ARN) was not found.
type ResourceArnNotFoundException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ResourceArnNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceArnNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceArnNotFoundException) ErrorCode() string             { return "ResourceArnNotFoundException" }
func (e *ResourceArnNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified invitation was already accepted.
type ResourceShareInvitationAlreadyAcceptedException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ResourceShareInvitationAlreadyAcceptedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceShareInvitationAlreadyAcceptedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceShareInvitationAlreadyAcceptedException) ErrorCode() string {
	return "ResourceShareInvitationAlreadyAcceptedException"
}
func (e *ResourceShareInvitationAlreadyAcceptedException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified invitation was already rejected.
type ResourceShareInvitationAlreadyRejectedException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ResourceShareInvitationAlreadyRejectedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceShareInvitationAlreadyRejectedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceShareInvitationAlreadyRejectedException) ErrorCode() string {
	return "ResourceShareInvitationAlreadyRejectedException"
}
func (e *ResourceShareInvitationAlreadyRejectedException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified Amazon Resource Name (ARN) for an invitation was not found.
type ResourceShareInvitationArnNotFoundException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ResourceShareInvitationArnNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceShareInvitationArnNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceShareInvitationArnNotFoundException) ErrorCode() string {
	return "ResourceShareInvitationArnNotFoundException"
}
func (e *ResourceShareInvitationArnNotFoundException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified invitation is expired.
type ResourceShareInvitationExpiredException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ResourceShareInvitationExpiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceShareInvitationExpiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceShareInvitationExpiredException) ErrorCode() string {
	return "ResourceShareInvitationExpiredException"
}
func (e *ResourceShareInvitationExpiredException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// This request would exceed the limit for resource shares for your account.
type ResourceShareLimitExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ResourceShareLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceShareLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceShareLimitExceededException) ErrorCode() string {
	return "ResourceShareLimitExceededException"
}
func (e *ResourceShareLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The service could not respond to the request due to an internal problem.
type ServerInternalException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ServerInternalException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServerInternalException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServerInternalException) ErrorCode() string             { return "ServerInternalException" }
func (e *ServerInternalException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// The service is not available.
type ServiceUnavailableException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServiceUnavailableException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServiceUnavailableException) ErrorCode() string             { return "ServiceUnavailableException" }
func (e *ServiceUnavailableException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// This request would exceed the limit for tags for your account.
type TagLimitExceededException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TagLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TagLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TagLimitExceededException) ErrorCode() string             { return "TagLimitExceededException" }
func (e *TagLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified tag key is a reserved word and can't be used.
type TagPolicyViolationException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *TagPolicyViolationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TagPolicyViolationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TagPolicyViolationException) ErrorCode() string             { return "TagPolicyViolationException" }
func (e *TagPolicyViolationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You exceeded the rate at which you are allowed to perform this operation. Please
// try again later.
type ThrottlingException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ThrottlingException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ThrottlingException) ErrorCode() string             { return "ThrottlingException" }
func (e *ThrottlingException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A specified resource was not found.
type UnknownResourceException struct {
	Message *string

	noSmithyDocumentSerde
}

func (e *UnknownResourceException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnknownResourceException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnknownResourceException) ErrorCode() string             { return "UnknownResourceException" }
func (e *UnknownResourceException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
