// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// An Access Control List. You can authenticate users with Access Contol Lists.
// ACLs enable you to control cluster access by grouping users. These Access
// control lists are designed as a way to organize access to clusters.
type ACL struct {

	// The Amazon Resource Name (ARN) of the ACL
	ARN *string

	// A list of clusters associated with the ACL.
	Clusters []string

	// The minimum engine version supported for the ACL
	MinimumEngineVersion *string

	// The name of the Access Control List
	Name *string

	// A list of updates being applied to the ACL.
	PendingChanges *ACLPendingChanges

	// Indicates ACL status. Can be "creating", "active", "modifying", "deleting".
	Status *string

	// The list of user names that belong to the ACL.
	UserNames []string

	noSmithyDocumentSerde
}

// Returns the updates being applied to the ACL.
type ACLPendingChanges struct {

	// A list of users being added to the ACL
	UserNamesToAdd []string

	// A list of user names being removed from the ACL
	UserNamesToRemove []string

	noSmithyDocumentSerde
}

// The status of the ACL update
type ACLsUpdateStatus struct {

	// A list of ACLs pending to be applied.
	ACLToApply *string

	noSmithyDocumentSerde
}

// Denotes the user's authentication properties, such as whether it requires a
// password to authenticate. Used in output responses.
type Authentication struct {

	// The number of passwords belonging to the user. The maximum is two.
	PasswordCount *int32

	// Indicates whether the user requires a password to authenticate.
	Type AuthenticationType

	noSmithyDocumentSerde
}

// Denotes the user's authentication properties, such as whether it requires a
// password to authenticate. Used in output responses.
type AuthenticationMode struct {

	// The password(s) used for authentication
	Passwords []string

	// Indicates whether the user requires a password to authenticate. All
	// newly-created users require a password.
	Type InputAuthenticationType

	noSmithyDocumentSerde
}

// Indicates if the cluster has a Multi-AZ configuration (multiaz) or not
// (singleaz).
type AvailabilityZone struct {

	// The name of the Availability Zone.
	Name *string

	noSmithyDocumentSerde
}

// Contains all of the attributes of a specific cluster.
type Cluster struct {

	// The name of the Access Control List associated with this cluster.
	ACLName *string

	// The Amazon Resource Name (ARN) of the cluster.
	ARN *string

	// When set to true, the cluster will automatically receive minor engine version
	// upgrades after launch.
	AutoMinorVersionUpgrade *bool

	// Indicates if the cluster has a Multi-AZ configuration (multiaz) or not
	// (singleaz).
	AvailabilityMode AZStatus

	// The cluster's configuration endpoint
	ClusterEndpoint *Endpoint

	// A description of the cluster
	Description *string

	// The Redis engine patch version used by the cluster
	EnginePatchVersion *string

	// The Redis engine version used by the cluster
	EngineVersion *string

	// The ID of the KMS key used to encrypt the cluster
	KmsKeyId *string

	// Specifies the weekly time range during which maintenance on the cluster is
	// performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H
	// Clock UTC). The minimum maintenance window is a 60 minute period.
	MaintenanceWindow *string

	// The user-supplied name of the cluster. This identifier is a unique key that
	// identifies a cluster.
	Name *string

	// The cluster's node type
	NodeType *string

	// The number of shards in the cluster
	NumberOfShards *int32

	// The name of the parameter group used by the cluster
	ParameterGroupName *string

	// The status of the parameter group used by the cluster, for example 'active' or
	// 'applying'.
	ParameterGroupStatus *string

	// A group of settings that are currently being applied.
	PendingUpdates *ClusterPendingUpdates

	// A list of security groups used by the cluster
	SecurityGroups []SecurityGroupMembership

	// A list of shards that are members of the cluster.
	Shards []Shard

	// The number of days for which MemoryDB retains automatic snapshots before
	// deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot
	// that was taken today is retained for 5 days before being deleted.
	SnapshotRetentionLimit *int32

	// The daily time range (in UTC) during which MemoryDB begins taking a daily
	// snapshot of your shard. Example: 05:00-09:00 If you do not specify this
	// parameter, MemoryDB automatically chooses an appropriate time range.
	SnapshotWindow *string

	// The Amazon Resource Name (ARN) of the SNS notification topic
	SnsTopicArn *string

	// The SNS topic must be in Active status to receive notifications
	SnsTopicStatus *string

	// The status of the cluster. For example, Available, Updating, Creating.
	Status *string

	// The name of the subnet group used by the cluster
	SubnetGroupName *string

	// A flag to indicate if In-transit encryption is enabled
	TLSEnabled *bool

	noSmithyDocumentSerde
}

// A list of cluster configuration options.
type ClusterConfiguration struct {

	// The description of the cluster configuration
	Description *string

	// The Redis engine version used by the cluster
	EngineVersion *string

	// The specified maintenance window for the cluster
	MaintenanceWindow *string

	// The name of the cluster
	Name *string

	// The node type used for the cluster
	NodeType *string

	// The number of shards in the cluster
	NumShards *int32

	// The name of parameter group used by the cluster
	ParameterGroupName *string

	// The port used by the cluster
	Port *int32

	// The list of shards in the cluster
	Shards []ShardDetail

	// The snapshot retention limit set by the cluster
	SnapshotRetentionLimit *int32

	// The snapshot window set by the cluster
	SnapshotWindow *string

	// The name of the subnet group used by the cluster
	SubnetGroupName *string

	// The Amazon Resource Name (ARN) of the SNS notification topic for the cluster
	TopicArn *string

	// The ID of the VPC the cluster belongs to
	VpcId *string

	noSmithyDocumentSerde
}

// A list of updates being applied to the cluster
type ClusterPendingUpdates struct {

	// A list of ACLs associated with the cluster that are being updated
	ACLs *ACLsUpdateStatus

	// The status of an online resharding operation.
	Resharding *ReshardingStatus

	// A list of service updates being applied to the cluster
	ServiceUpdates []PendingModifiedServiceUpdate

	noSmithyDocumentSerde
}

// Represents the information required for client programs to connect to the
// cluster and its nodes.
type Endpoint struct {

	// The DNS hostname of the node.
	Address *string

	// The port number that the engine is listening on.
	Port int32

	noSmithyDocumentSerde
}

// Provides details of the Redis engine version
type EngineVersionInfo struct {

	// The patched engine version
	EnginePatchVersion *string

	// The engine version
	EngineVersion *string

	// Specifies the name of the parameter group family to which the engine default
	// parameters apply.
	ParameterGroupFamily *string

	noSmithyDocumentSerde
}

// Represents a single occurrence of something interesting within the system. Some
// examples of events are creating a cluster or adding or removing a node.
type Event struct {

	// The date and time when the event occurred.
	Date *time.Time

	// The text of the event.
	Message *string

	// The name for the source of the event. For example, if the event occurred at the
	// cluster level, the identifier would be the name of the cluster.
	SourceName *string

	// Specifies the origin of this event - a cluster, a parameter group, a security
	// group, etc.
	SourceType SourceType

	noSmithyDocumentSerde
}

// Used to streamline results of a search based on the property being filtered.
type Filter struct {

	// The property being filtered. For example, UserName.
	//
	// This member is required.
	Name *string

	// The property values to filter on. For example, "user-123".
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Represents an individual node within a cluster. Each node runs its own instance
// of the cluster's protocol-compliant caching software.
type Node struct {

	// The Availability Zone in which the node resides
	AvailabilityZone *string

	// The date and time when the node was created.
	CreateTime *time.Time

	// The hostname for connecting to this node.
	Endpoint *Endpoint

	// The node identifier. A node name is a numeric identifier (0001, 0002, etc.). The
	// combination of cluster name, shard name and node name uniquely identifies every
	// node used in a customer's Amazon account.
	Name *string

	// The status of the service update on the node
	Status *string

	noSmithyDocumentSerde
}

// Describes an individual setting that controls some aspect of MemoryDB behavior.
type Parameter struct {

	// The valid range of values for the parameter.
	AllowedValues *string

	// The parameter's data type
	DataType *string

	// A description of the parameter
	Description *string

	// The earliest engine version to which the parameter can apply.
	MinimumEngineVersion *string

	// The name of the parameter
	Name *string

	// The value of the parameter
	Value *string

	noSmithyDocumentSerde
}

// Represents the output of a CreateParameterGroup operation. A parameter group
// represents a combination of specific values for the parameters that are passed
// to the engine software during startup.
type ParameterGroup struct {

	// The Amazon Resource Name (ARN) of the parameter group
	ARN *string

	// A description of the parameter group
	Description *string

	// The name of the parameter group family that this parameter group is compatible
	// with.
	Family *string

	// The name of the parameter group
	Name *string

	noSmithyDocumentSerde
}

// Describes a name-value pair that is used to update the value of a parameter.
type ParameterNameValue struct {

	// The name of the parameter
	ParameterName *string

	// The value of the parameter
	ParameterValue *string

	noSmithyDocumentSerde
}

// Update action that has yet to be processed for the corresponding apply/stop
// request
type PendingModifiedServiceUpdate struct {

	// The unique ID of the service update
	ServiceUpdateName *string

	// The status of the service update
	Status ServiceUpdateStatus

	noSmithyDocumentSerde
}

// A request to configure the number of replicas in a shard
type ReplicaConfigurationRequest struct {

	// The number of replicas to scale up or down to
	ReplicaCount int32

	noSmithyDocumentSerde
}

// The status of the online resharding
type ReshardingStatus struct {

	// The status of the online resharding slot migration
	SlotMigration *SlotMigration

	noSmithyDocumentSerde
}

// Represents a single security group and its status.
type SecurityGroupMembership struct {

	// The identifier of the security group.
	SecurityGroupId *string

	// The status of the security group membership. The status changes whenever a
	// security group is modified, or when the security groups assigned to a cluster
	// are modified.
	Status *string

	noSmithyDocumentSerde
}

// An update that you can apply to your MemoryDB clusters.
type ServiceUpdate struct {

	// The date at which the service update will be automatically applied
	AutoUpdateStartDate *time.Time

	// The name of the cluster to which the service update applies
	ClusterName *string

	// Provides details of the service update
	Description *string

	// A list of nodes updated by the service update
	NodesUpdated *string

	// The date when the service update is initially available
	ReleaseDate *time.Time

	// The unique ID of the service update
	ServiceUpdateName *string

	// The status of the service update
	Status ServiceUpdateStatus

	// Reflects the nature of the service update
	Type ServiceUpdateType

	noSmithyDocumentSerde
}

// A request to apply a service update
type ServiceUpdateRequest struct {

	// The unique ID of the service update
	ServiceUpdateNameToApply *string

	noSmithyDocumentSerde
}

// Represents a collection of nodes in a cluster. One node in the node group is the
// read/write primary node. All the other nodes are read-only Replica nodes.
type Shard struct {

	// The name of the shard
	Name *string

	// A list containing information about individual nodes within the shard
	Nodes []Node

	// The number of nodes in the shard
	NumberOfNodes *int32

	// The keyspace for this shard.
	Slots *string

	// The current state of this replication group - creating, available, modifying,
	// deleting.
	Status *string

	noSmithyDocumentSerde
}

// Shard configuration options. Each shard configuration has the following: Slots
// and ReplicaCount.
type ShardConfiguration struct {

	// The number of read replica nodes in this shard.
	ReplicaCount *int32

	// A string that specifies the keyspace for a particular node group. Keyspaces
	// range from 0 to 16,383. The string is in the format startkey-endkey.
	Slots *string

	noSmithyDocumentSerde
}

// A request to configure the sharding properties of a cluster
type ShardConfigurationRequest struct {

	// The number of shards in the cluster
	ShardCount int32

	noSmithyDocumentSerde
}

// Provides details of a shard in a snapshot
type ShardDetail struct {

	// The configuration details of the shard
	Configuration *ShardConfiguration

	// The name of the shard
	Name *string

	// The size of the shard's snapshot
	Size *string

	// The date and time that the shard's snapshot was created
	SnapshotCreationTime *time.Time

	noSmithyDocumentSerde
}

// Represents the progress of an online resharding operation.
type SlotMigration struct {

	// The percentage of the slot migration that is complete.
	ProgressPercentage float64

	noSmithyDocumentSerde
}

// Represents a copy of an entire cluster as of the time when the snapshot was
// taken.
type Snapshot struct {

	// The ARN (Amazon Resource Name) of the snapshot.
	ARN *string

	// The configuration of the cluster from which the snapshot was taken
	ClusterConfiguration *ClusterConfiguration

	// The ID of the KMS key used to encrypt the snapshot.
	KmsKeyId *string

	// The name of the snapshot
	Name *string

	// Indicates whether the snapshot is from an automatic backup (automated) or was
	// created manually (manual).
	Source *string

	// The status of the snapshot. Valid values: creating | available | restoring |
	// copying | deleting.
	Status *string

	noSmithyDocumentSerde
}

// Represents the subnet associated with a cluster. This parameter refers to
// subnets defined in Amazon Virtual Private Cloud (Amazon VPC) and used with
// MemoryDB.
type Subnet struct {

	// The Availability Zone where the subnet resides
	AvailabilityZone *AvailabilityZone

	// The unique identifier for the subnet.
	Identifier *string

	noSmithyDocumentSerde
}

// Represents the output of one of the following operations:
//
// *
// CreateSubnetGroup
//
// * UpdateSubnetGroup
//
// A subnet group is a collection of
// subnets (typically private) that you can designate for your clusters running in
// an Amazon Virtual Private Cloud (VPC) environment.
type SubnetGroup struct {

	// The ARN (Amazon Resource Name) of the subnet group.
	ARN *string

	// A description of the subnet group
	Description *string

	// The name of the subnet group
	Name *string

	// A list of subnets associated with the subnet group.
	Subnets []Subnet

	// The Amazon Virtual Private Cloud identifier (VPC ID) of the subnet group.
	VpcId *string

	noSmithyDocumentSerde
}

// A tag that can be added to an MemoryDB resource. Tags are composed of a
// Key/Value pair. You can use tags to categorize and track all your MemoryDB
// resources. When you add or remove tags on clusters, those actions will be
// replicated to all nodes in the cluster. A tag with a null Value is permitted.
// For more information, see Tagging your MemoryDB resources
// (https://docs.aws.amazon.com/MemoryDB/latest/devguide/tagging-resources.html)
type Tag struct {

	// The key for the tag. May not be null.
	Key *string

	// The tag's value. May be null.
	Value *string

	noSmithyDocumentSerde
}

// A cluster whose updates have failed
type UnprocessedCluster struct {

	// The name of the cluster
	ClusterName *string

	// The error message associated with the update failure
	ErrorMessage *string

	// The error type associated with the update failure
	ErrorType *string

	noSmithyDocumentSerde
}

// You create users and assign them specific permissions by using an access string.
// You assign the users to Access Control Lists aligned with a specific role
// (administrators, human resources) that are then deployed to one or more MemoryDB
// clusters.
type User struct {

	// The names of the Access Control Lists to which the user belongs
	ACLNames []string

	// The Amazon Resource Name (ARN) of the user.
	ARN *string

	// Access permissions string used for this user.
	AccessString *string

	// Denotes whether the user requires a password to authenticate.
	Authentication *Authentication

	// The minimum engine version supported for the user
	MinimumEngineVersion *string

	// The name of the user
	Name *string

	// Indicates the user status. Can be "active", "modifying" or "deleting".
	Status *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
