// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// A resource that is used to connect third-party source providers with services
// like AWS CodePipeline. Note: A connection created through CloudFormation, the
// CLI, or the SDK is in `PENDING` status by default. You can make its status
// `AVAILABLE` by updating the connection in the console.
type Connection struct {

	// The Amazon Resource Name (ARN) of the connection. The ARN is used as the
	// connection reference when the connection is shared between AWS services. The ARN
	// is never reused if the connection is deleted.
	ConnectionArn *string

	// The name of the connection. Connection names must be unique in an AWS user
	// account.
	ConnectionName *string

	// The current status of the connection.
	ConnectionStatus ConnectionStatus

	// The Amazon Resource Name (ARN) of the host associated with the connection.
	HostArn *string

	// The identifier of the external provider where your third-party code repository
	// is configured. For Bitbucket, this is the account ID of the owner of the
	// Bitbucket repository.
	OwnerAccountId *string

	// The name of the external provider where your third-party code repository is
	// configured.
	ProviderType ProviderType

	noSmithyDocumentSerde
}

// A resource that represents the infrastructure where a third-party provider is
// installed. The host is used when you create connections to an installed
// third-party provider type, such as GitHub Enterprise Server. You create one host
// for all connections to that provider. A host created through the CLI or the SDK
// is in `PENDING` status by default. You can make its status `AVAILABLE` by
// setting up the host in the console.
type Host struct {

	// The Amazon Resource Name (ARN) of the host.
	HostArn *string

	// The name of the host.
	Name *string

	// The endpoint of the infrastructure where your provider type is installed.
	ProviderEndpoint *string

	// The name of the installed provider to be associated with your connection. The
	// host resource represents the infrastructure where your provider type is
	// installed. The valid provider type is GitHub Enterprise Server.
	ProviderType ProviderType

	// The status of the host, such as PENDING, AVAILABLE, VPC_CONFIG_DELETING,
	// VPC_CONFIG_INITIALIZING, and VPC_CONFIG_FAILED_INITIALIZATION.
	Status *string

	// The status description for the host.
	StatusMessage *string

	// The VPC configuration provisioned for the host.
	VpcConfiguration *VpcConfiguration

	noSmithyDocumentSerde
}

// A tag is a key-value pair that is used to manage the resource. This tag is
// available for use by AWS services that support tags.
type Tag struct {

	// The tag's key.
	//
	// This member is required.
	Key *string

	// The tag's value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The VPC configuration provisioned for the host.
type VpcConfiguration struct {

	// The ID of the security group or security groups associated with the Amazon VPC
	// connected to the infrastructure where your provider type is installed.
	//
	// This member is required.
	SecurityGroupIds []string

	// The ID of the subnet or subnets associated with the Amazon VPC connected to the
	// infrastructure where your provider type is installed.
	//
	// This member is required.
	SubnetIds []string

	// The ID of the Amazon VPC connected to the infrastructure where your provider
	// type is installed.
	//
	// This member is required.
	VpcId *string

	// The value of the Transport Layer Security (TLS) certificate associated with the
	// infrastructure where your provider type is installed.
	TlsCertificate *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
