=begin
#OpenBao API

#HTTP API that gives you full access to OpenBao. All API routes are prefixed with `/v1/`.

The version of the OpenAPI document: 2.0.0

Generated by: https://openapi-generator.tech
Generator version: 7.7.0

=end

require 'cgi'

module OpenbaoClient
  class SystemApi
    attr_accessor :api_client

    def initialize(api_client = ApiClient.default)
      @api_client = api_client
    end
    # @param path [String] The name of the backend. Cannot be delimited. Example: \&quot;mysql\&quot;
    # @param auditing_calculate_hash_request [AuditingCalculateHashRequest]
    # @param [Hash] opts the optional parameters
    # @return [AuditingCalculateHashResponse]
    def auditing_calculate_hash(path, auditing_calculate_hash_request, opts = {})
      data, _status_code, _headers = auditing_calculate_hash_with_http_info(path, auditing_calculate_hash_request, opts)
      data
    end

    # @param path [String] The name of the backend. Cannot be delimited. Example: \&quot;mysql\&quot;
    # @param auditing_calculate_hash_request [AuditingCalculateHashRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(AuditingCalculateHashResponse, Integer, Hash)>] AuditingCalculateHashResponse data, response status code and response headers
    def auditing_calculate_hash_with_http_info(path, auditing_calculate_hash_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.auditing_calculate_hash ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SystemApi.auditing_calculate_hash"
      end
      # verify the required parameter 'auditing_calculate_hash_request' is set
      if @api_client.config.client_side_validation && auditing_calculate_hash_request.nil?
        fail ArgumentError, "Missing the required parameter 'auditing_calculate_hash_request' when calling SystemApi.auditing_calculate_hash"
      end
      # resource path
      local_var_path = '/sys/audit-hash/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(auditing_calculate_hash_request)

      # return_type
      return_type = opts[:debug_return_type] || 'AuditingCalculateHashResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.auditing_calculate_hash",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#auditing_calculate_hash\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Disable the audit device at the given path.
    # @param path [String] The name of the backend. Cannot be delimited. Example: \&quot;mysql\&quot;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def auditing_disable_device(path, opts = {})
      auditing_disable_device_with_http_info(path, opts)
      nil
    end

    # Disable the audit device at the given path.
    # @param path [String] The name of the backend. Cannot be delimited. Example: \&quot;mysql\&quot;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def auditing_disable_device_with_http_info(path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.auditing_disable_device ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SystemApi.auditing_disable_device"
      end
      # resource path
      local_var_path = '/sys/audit/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.auditing_disable_device",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#auditing_disable_device\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Disable auditing of the given request header.
    # @param header [String]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def auditing_disable_request_header(header, opts = {})
      auditing_disable_request_header_with_http_info(header, opts)
      nil
    end

    # Disable auditing of the given request header.
    # @param header [String]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def auditing_disable_request_header_with_http_info(header, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.auditing_disable_request_header ...'
      end
      # verify the required parameter 'header' is set
      if @api_client.config.client_side_validation && header.nil?
        fail ArgumentError, "Missing the required parameter 'header' when calling SystemApi.auditing_disable_request_header"
      end
      # resource path
      local_var_path = '/sys/config/auditing/request-headers/{header}'.sub('{' + 'header' + '}', CGI.escape(header.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.auditing_disable_request_header",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#auditing_disable_request_header\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Enable a new audit device at the supplied path.
    # @param path [String] The name of the backend. Cannot be delimited. Example: \&quot;mysql\&quot;
    # @param auditing_enable_device_request [AuditingEnableDeviceRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def auditing_enable_device(path, auditing_enable_device_request, opts = {})
      auditing_enable_device_with_http_info(path, auditing_enable_device_request, opts)
      nil
    end

    # Enable a new audit device at the supplied path.
    # @param path [String] The name of the backend. Cannot be delimited. Example: \&quot;mysql\&quot;
    # @param auditing_enable_device_request [AuditingEnableDeviceRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def auditing_enable_device_with_http_info(path, auditing_enable_device_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.auditing_enable_device ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SystemApi.auditing_enable_device"
      end
      # verify the required parameter 'auditing_enable_device_request' is set
      if @api_client.config.client_side_validation && auditing_enable_device_request.nil?
        fail ArgumentError, "Missing the required parameter 'auditing_enable_device_request' when calling SystemApi.auditing_enable_device"
      end
      # resource path
      local_var_path = '/sys/audit/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(auditing_enable_device_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.auditing_enable_device",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#auditing_enable_device\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Enable auditing of a header.
    # @param header [String]
    # @param auditing_enable_request_header_request [AuditingEnableRequestHeaderRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def auditing_enable_request_header(header, auditing_enable_request_header_request, opts = {})
      auditing_enable_request_header_with_http_info(header, auditing_enable_request_header_request, opts)
      nil
    end

    # Enable auditing of a header.
    # @param header [String]
    # @param auditing_enable_request_header_request [AuditingEnableRequestHeaderRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def auditing_enable_request_header_with_http_info(header, auditing_enable_request_header_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.auditing_enable_request_header ...'
      end
      # verify the required parameter 'header' is set
      if @api_client.config.client_side_validation && header.nil?
        fail ArgumentError, "Missing the required parameter 'header' when calling SystemApi.auditing_enable_request_header"
      end
      # verify the required parameter 'auditing_enable_request_header_request' is set
      if @api_client.config.client_side_validation && auditing_enable_request_header_request.nil?
        fail ArgumentError, "Missing the required parameter 'auditing_enable_request_header_request' when calling SystemApi.auditing_enable_request_header"
      end
      # resource path
      local_var_path = '/sys/config/auditing/request-headers/{header}'.sub('{' + 'header' + '}', CGI.escape(header.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(auditing_enable_request_header_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.auditing_enable_request_header",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#auditing_enable_request_header\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # List the enabled audit devices.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def auditing_list_enabled_devices(opts = {})
      auditing_list_enabled_devices_with_http_info(opts)
      nil
    end

    # List the enabled audit devices.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def auditing_list_enabled_devices_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.auditing_list_enabled_devices ...'
      end
      # resource path
      local_var_path = '/sys/audit'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.auditing_list_enabled_devices",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#auditing_list_enabled_devices\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # List the request headers that are configured to be audited.
    # @param [Hash] opts the optional parameters
    # @return [AuditingListRequestHeadersResponse]
    def auditing_list_request_headers(opts = {})
      data, _status_code, _headers = auditing_list_request_headers_with_http_info(opts)
      data
    end

    # List the request headers that are configured to be audited.
    # @param [Hash] opts the optional parameters
    # @return [Array<(AuditingListRequestHeadersResponse, Integer, Hash)>] AuditingListRequestHeadersResponse data, response status code and response headers
    def auditing_list_request_headers_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.auditing_list_request_headers ...'
      end
      # resource path
      local_var_path = '/sys/config/auditing/request-headers'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'AuditingListRequestHeadersResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.auditing_list_request_headers",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#auditing_list_request_headers\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # List the information for the given request header.
    # @param header [String]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def auditing_read_request_header_information(header, opts = {})
      auditing_read_request_header_information_with_http_info(header, opts)
      nil
    end

    # List the information for the given request header.
    # @param header [String]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def auditing_read_request_header_information_with_http_info(header, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.auditing_read_request_header_information ...'
      end
      # verify the required parameter 'header' is set
      if @api_client.config.client_side_validation && header.nil?
        fail ArgumentError, "Missing the required parameter 'header' when calling SystemApi.auditing_read_request_header_information"
      end
      # resource path
      local_var_path = '/sys/config/auditing/request-headers/{header}'.sub('{' + 'header' + '}', CGI.escape(header.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.auditing_read_request_header_information",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#auditing_read_request_header_information\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Disable the auth method at the given auth path
    # @param path [String] The path to mount to. Cannot be delimited. Example: \&quot;user\&quot;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def auth_disable_method(path, opts = {})
      auth_disable_method_with_http_info(path, opts)
      nil
    end

    # Disable the auth method at the given auth path
    # @param path [String] The path to mount to. Cannot be delimited. Example: \&quot;user\&quot;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def auth_disable_method_with_http_info(path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.auth_disable_method ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SystemApi.auth_disable_method"
      end
      # resource path
      local_var_path = '/sys/auth/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.auth_disable_method",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#auth_disable_method\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Enables a new auth method.
    # After enabling, the auth method can be accessed and configured via the auth path specified as part of the URL. This auth path will be nested under the auth prefix.  For example, enable the \"foo\" auth method will make it accessible at /auth/foo.
    # @param path [String] The path to mount to. Cannot be delimited. Example: \&quot;user\&quot;
    # @param auth_enable_method_request [AuthEnableMethodRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def auth_enable_method(path, auth_enable_method_request, opts = {})
      auth_enable_method_with_http_info(path, auth_enable_method_request, opts)
      nil
    end

    # Enables a new auth method.
    # After enabling, the auth method can be accessed and configured via the auth path specified as part of the URL. This auth path will be nested under the auth prefix.  For example, enable the \&quot;foo\&quot; auth method will make it accessible at /auth/foo.
    # @param path [String] The path to mount to. Cannot be delimited. Example: \&quot;user\&quot;
    # @param auth_enable_method_request [AuthEnableMethodRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def auth_enable_method_with_http_info(path, auth_enable_method_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.auth_enable_method ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SystemApi.auth_enable_method"
      end
      # verify the required parameter 'auth_enable_method_request' is set
      if @api_client.config.client_side_validation && auth_enable_method_request.nil?
        fail ArgumentError, "Missing the required parameter 'auth_enable_method_request' when calling SystemApi.auth_enable_method"
      end
      # resource path
      local_var_path = '/sys/auth/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(auth_enable_method_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.auth_enable_method",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#auth_enable_method\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param [Hash] opts the optional parameters
    # @return [nil]
    def auth_list_enabled_methods(opts = {})
      auth_list_enabled_methods_with_http_info(opts)
      nil
    end

    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def auth_list_enabled_methods_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.auth_list_enabled_methods ...'
      end
      # resource path
      local_var_path = '/sys/auth'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.auth_list_enabled_methods",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#auth_list_enabled_methods\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Read the configuration of the auth engine at the given path.
    # @param path [String] The path to mount to. Cannot be delimited. Example: \&quot;user\&quot;
    # @param [Hash] opts the optional parameters
    # @return [AuthReadConfigurationResponse]
    def auth_read_configuration(path, opts = {})
      data, _status_code, _headers = auth_read_configuration_with_http_info(path, opts)
      data
    end

    # Read the configuration of the auth engine at the given path.
    # @param path [String] The path to mount to. Cannot be delimited. Example: \&quot;user\&quot;
    # @param [Hash] opts the optional parameters
    # @return [Array<(AuthReadConfigurationResponse, Integer, Hash)>] AuthReadConfigurationResponse data, response status code and response headers
    def auth_read_configuration_with_http_info(path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.auth_read_configuration ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SystemApi.auth_read_configuration"
      end
      # resource path
      local_var_path = '/sys/auth/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'AuthReadConfigurationResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.auth_read_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#auth_read_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Reads the given auth path's configuration.
    # This endpoint requires sudo capability on the final path, but the same functionality can be achieved without sudo via `sys/mounts/auth/[auth-path]/tune`.
    # @param path [String] Tune the configuration parameters for an auth path.
    # @param [Hash] opts the optional parameters
    # @return [AuthReadTuningInformationResponse]
    def auth_read_tuning_information(path, opts = {})
      data, _status_code, _headers = auth_read_tuning_information_with_http_info(path, opts)
      data
    end

    # Reads the given auth path&#39;s configuration.
    # This endpoint requires sudo capability on the final path, but the same functionality can be achieved without sudo via &#x60;sys/mounts/auth/[auth-path]/tune&#x60;.
    # @param path [String] Tune the configuration parameters for an auth path.
    # @param [Hash] opts the optional parameters
    # @return [Array<(AuthReadTuningInformationResponse, Integer, Hash)>] AuthReadTuningInformationResponse data, response status code and response headers
    def auth_read_tuning_information_with_http_info(path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.auth_read_tuning_information ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SystemApi.auth_read_tuning_information"
      end
      # resource path
      local_var_path = '/sys/auth/{path}/tune'.sub('{' + 'path' + '}', CGI.escape(path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'AuthReadTuningInformationResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.auth_read_tuning_information",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#auth_read_tuning_information\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Tune configuration parameters for a given auth path.
    # This endpoint requires sudo capability on the final path, but the same functionality can be achieved without sudo via `sys/mounts/auth/[auth-path]/tune`.
    # @param path [String] Tune the configuration parameters for an auth path.
    # @param auth_tune_configuration_parameters_request [AuthTuneConfigurationParametersRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def auth_tune_configuration_parameters(path, auth_tune_configuration_parameters_request, opts = {})
      auth_tune_configuration_parameters_with_http_info(path, auth_tune_configuration_parameters_request, opts)
      nil
    end

    # Tune configuration parameters for a given auth path.
    # This endpoint requires sudo capability on the final path, but the same functionality can be achieved without sudo via &#x60;sys/mounts/auth/[auth-path]/tune&#x60;.
    # @param path [String] Tune the configuration parameters for an auth path.
    # @param auth_tune_configuration_parameters_request [AuthTuneConfigurationParametersRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def auth_tune_configuration_parameters_with_http_info(path, auth_tune_configuration_parameters_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.auth_tune_configuration_parameters ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SystemApi.auth_tune_configuration_parameters"
      end
      # verify the required parameter 'auth_tune_configuration_parameters_request' is set
      if @api_client.config.client_side_validation && auth_tune_configuration_parameters_request.nil?
        fail ArgumentError, "Missing the required parameter 'auth_tune_configuration_parameters_request' when calling SystemApi.auth_tune_configuration_parameters"
      end
      # resource path
      local_var_path = '/sys/auth/{path}/tune'.sub('{' + 'path' + '}', CGI.escape(path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(auth_tune_configuration_parameters_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.auth_tune_configuration_parameters",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#auth_tune_configuration_parameters\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Information about the host instance that this OpenBao server is running on.
    # Information about the host instance that this OpenBao server is running on.   The information that gets collected includes host hardware information, and CPU,   disk, and memory utilization
    # @param [Hash] opts the optional parameters
    # @return [CollectHostInformationResponse]
    def collect_host_information(opts = {})
      data, _status_code, _headers = collect_host_information_with_http_info(opts)
      data
    end

    # Information about the host instance that this OpenBao server is running on.
    # Information about the host instance that this OpenBao server is running on.   The information that gets collected includes host hardware information, and CPU,   disk, and memory utilization
    # @param [Hash] opts the optional parameters
    # @return [Array<(CollectHostInformationResponse, Integer, Hash)>] CollectHostInformationResponse data, response status code and response headers
    def collect_host_information_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.collect_host_information ...'
      end
      # resource path
      local_var_path = '/sys/host-info'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'CollectHostInformationResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.collect_host_information",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#collect_host_information\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # reports in-flight requests
    # This path responds to the following HTTP methods.   GET /    Returns a map of in-flight requests.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def collect_in_flight_request_information(opts = {})
      collect_in_flight_request_information_with_http_info(opts)
      nil
    end

    # reports in-flight requests
    # This path responds to the following HTTP methods.   GET /    Returns a map of in-flight requests.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def collect_in_flight_request_information_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.collect_in_flight_request_information ...'
      end
      # resource path
      local_var_path = '/sys/in-flight-req'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.collect_in_flight_request_information",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#collect_in_flight_request_information\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Configure the CORS settings.
    # @param cors_configure_request [CorsConfigureRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def cors_configure(cors_configure_request, opts = {})
      cors_configure_with_http_info(cors_configure_request, opts)
      nil
    end

    # Configure the CORS settings.
    # @param cors_configure_request [CorsConfigureRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def cors_configure_with_http_info(cors_configure_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.cors_configure ...'
      end
      # verify the required parameter 'cors_configure_request' is set
      if @api_client.config.client_side_validation && cors_configure_request.nil?
        fail ArgumentError, "Missing the required parameter 'cors_configure_request' when calling SystemApi.cors_configure"
      end
      # resource path
      local_var_path = '/sys/config/cors'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(cors_configure_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.cors_configure",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#cors_configure\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Remove any CORS settings.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def cors_delete_configuration(opts = {})
      cors_delete_configuration_with_http_info(opts)
      nil
    end

    # Remove any CORS settings.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def cors_delete_configuration_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.cors_delete_configuration ...'
      end
      # resource path
      local_var_path = '/sys/config/cors'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.cors_delete_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#cors_delete_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Return the current CORS settings.
    # @param [Hash] opts the optional parameters
    # @return [CorsReadConfigurationResponse]
    def cors_read_configuration(opts = {})
      data, _status_code, _headers = cors_read_configuration_with_http_info(opts)
      data
    end

    # Return the current CORS settings.
    # @param [Hash] opts the optional parameters
    # @return [Array<(CorsReadConfigurationResponse, Integer, Hash)>] CorsReadConfigurationResponse data, response status code and response headers
    def cors_read_configuration_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.cors_read_configuration ...'
      end
      # resource path
      local_var_path = '/sys/config/cors'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'CorsReadConfigurationResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.cors_read_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#cors_read_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Decodes the encoded token with the otp.
    # @param decode_request [DecodeRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def decode(decode_request, opts = {})
      decode_with_http_info(decode_request, opts)
      nil
    end

    # Decodes the encoded token with the otp.
    # @param decode_request [DecodeRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def decode_with_http_info(decode_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.decode ...'
      end
      # verify the required parameter 'decode_request' is set
      if @api_client.config.client_side_validation && decode_request.nil?
        fail ArgumentError, "Missing the required parameter 'decode_request' when calling SystemApi.decode"
      end
      # resource path
      local_var_path = '/sys/decode-token'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(decode_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.decode",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#decode\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param encryption_key_configure_rotation_request [EncryptionKeyConfigureRotationRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def encryption_key_configure_rotation(encryption_key_configure_rotation_request, opts = {})
      encryption_key_configure_rotation_with_http_info(encryption_key_configure_rotation_request, opts)
      nil
    end

    # @param encryption_key_configure_rotation_request [EncryptionKeyConfigureRotationRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def encryption_key_configure_rotation_with_http_info(encryption_key_configure_rotation_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.encryption_key_configure_rotation ...'
      end
      # verify the required parameter 'encryption_key_configure_rotation_request' is set
      if @api_client.config.client_side_validation && encryption_key_configure_rotation_request.nil?
        fail ArgumentError, "Missing the required parameter 'encryption_key_configure_rotation_request' when calling SystemApi.encryption_key_configure_rotation"
      end
      # resource path
      local_var_path = '/sys/rotate/config'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(encryption_key_configure_rotation_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.encryption_key_configure_rotation",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#encryption_key_configure_rotation\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param [Hash] opts the optional parameters
    # @return [EncryptionKeyReadRotationConfigurationResponse]
    def encryption_key_read_rotation_configuration(opts = {})
      data, _status_code, _headers = encryption_key_read_rotation_configuration_with_http_info(opts)
      data
    end

    # @param [Hash] opts the optional parameters
    # @return [Array<(EncryptionKeyReadRotationConfigurationResponse, Integer, Hash)>] EncryptionKeyReadRotationConfigurationResponse data, response status code and response headers
    def encryption_key_read_rotation_configuration_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.encryption_key_read_rotation_configuration ...'
      end
      # resource path
      local_var_path = '/sys/rotate/config'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'EncryptionKeyReadRotationConfigurationResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.encryption_key_read_rotation_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#encryption_key_read_rotation_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param [Hash] opts the optional parameters
    # @return [nil]
    def encryption_key_rotate(opts = {})
      encryption_key_rotate_with_http_info(opts)
      nil
    end

    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def encryption_key_rotate_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.encryption_key_rotate ...'
      end
      # resource path
      local_var_path = '/sys/rotate'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.encryption_key_rotate",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#encryption_key_rotate\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Provides information about the backend encryption key.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def encryption_key_status(opts = {})
      encryption_key_status_with_http_info(opts)
      nil
    end

    # Provides information about the backend encryption key.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def encryption_key_status_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.encryption_key_status ...'
      end
      # resource path
      local_var_path = '/sys/key-status'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.encryption_key_status",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#encryption_key_status\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param generate_hash_request [GenerateHashRequest]
    # @param [Hash] opts the optional parameters
    # @return [GenerateHashResponse]
    def generate_hash(generate_hash_request, opts = {})
      data, _status_code, _headers = generate_hash_with_http_info(generate_hash_request, opts)
      data
    end

    # @param generate_hash_request [GenerateHashRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(GenerateHashResponse, Integer, Hash)>] GenerateHashResponse data, response status code and response headers
    def generate_hash_with_http_info(generate_hash_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.generate_hash ...'
      end
      # verify the required parameter 'generate_hash_request' is set
      if @api_client.config.client_side_validation && generate_hash_request.nil?
        fail ArgumentError, "Missing the required parameter 'generate_hash_request' when calling SystemApi.generate_hash"
      end
      # resource path
      local_var_path = '/sys/tools/hash'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(generate_hash_request)

      # return_type
      return_type = opts[:debug_return_type] || 'GenerateHashResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.generate_hash",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#generate_hash\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param urlalgorithm [String] Algorithm to use (POST URL parameter)
    # @param generate_hash_with_algorithm_request [GenerateHashWithAlgorithmRequest]
    # @param [Hash] opts the optional parameters
    # @return [GenerateHashWithAlgorithmResponse]
    def generate_hash_with_algorithm(urlalgorithm, generate_hash_with_algorithm_request, opts = {})
      data, _status_code, _headers = generate_hash_with_algorithm_with_http_info(urlalgorithm, generate_hash_with_algorithm_request, opts)
      data
    end

    # @param urlalgorithm [String] Algorithm to use (POST URL parameter)
    # @param generate_hash_with_algorithm_request [GenerateHashWithAlgorithmRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(GenerateHashWithAlgorithmResponse, Integer, Hash)>] GenerateHashWithAlgorithmResponse data, response status code and response headers
    def generate_hash_with_algorithm_with_http_info(urlalgorithm, generate_hash_with_algorithm_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.generate_hash_with_algorithm ...'
      end
      # verify the required parameter 'urlalgorithm' is set
      if @api_client.config.client_side_validation && urlalgorithm.nil?
        fail ArgumentError, "Missing the required parameter 'urlalgorithm' when calling SystemApi.generate_hash_with_algorithm"
      end
      # verify the required parameter 'generate_hash_with_algorithm_request' is set
      if @api_client.config.client_side_validation && generate_hash_with_algorithm_request.nil?
        fail ArgumentError, "Missing the required parameter 'generate_hash_with_algorithm_request' when calling SystemApi.generate_hash_with_algorithm"
      end
      # resource path
      local_var_path = '/sys/tools/hash/{urlalgorithm}'.sub('{' + 'urlalgorithm' + '}', CGI.escape(urlalgorithm.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(generate_hash_with_algorithm_request)

      # return_type
      return_type = opts[:debug_return_type] || 'GenerateHashWithAlgorithmResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.generate_hash_with_algorithm",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#generate_hash_with_algorithm\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param generate_random_request [GenerateRandomRequest]
    # @param [Hash] opts the optional parameters
    # @return [GenerateRandomResponse]
    def generate_random(generate_random_request, opts = {})
      data, _status_code, _headers = generate_random_with_http_info(generate_random_request, opts)
      data
    end

    # @param generate_random_request [GenerateRandomRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(GenerateRandomResponse, Integer, Hash)>] GenerateRandomResponse data, response status code and response headers
    def generate_random_with_http_info(generate_random_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.generate_random ...'
      end
      # verify the required parameter 'generate_random_request' is set
      if @api_client.config.client_side_validation && generate_random_request.nil?
        fail ArgumentError, "Missing the required parameter 'generate_random_request' when calling SystemApi.generate_random"
      end
      # resource path
      local_var_path = '/sys/tools/random'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(generate_random_request)

      # return_type
      return_type = opts[:debug_return_type] || 'GenerateRandomResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.generate_random",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#generate_random\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param urlbytes [String] The number of bytes to generate (POST URL parameter)
    # @param generate_random_with_bytes_request [GenerateRandomWithBytesRequest]
    # @param [Hash] opts the optional parameters
    # @return [GenerateRandomWithBytesResponse]
    def generate_random_with_bytes(urlbytes, generate_random_with_bytes_request, opts = {})
      data, _status_code, _headers = generate_random_with_bytes_with_http_info(urlbytes, generate_random_with_bytes_request, opts)
      data
    end

    # @param urlbytes [String] The number of bytes to generate (POST URL parameter)
    # @param generate_random_with_bytes_request [GenerateRandomWithBytesRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(GenerateRandomWithBytesResponse, Integer, Hash)>] GenerateRandomWithBytesResponse data, response status code and response headers
    def generate_random_with_bytes_with_http_info(urlbytes, generate_random_with_bytes_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.generate_random_with_bytes ...'
      end
      # verify the required parameter 'urlbytes' is set
      if @api_client.config.client_side_validation && urlbytes.nil?
        fail ArgumentError, "Missing the required parameter 'urlbytes' when calling SystemApi.generate_random_with_bytes"
      end
      # verify the required parameter 'generate_random_with_bytes_request' is set
      if @api_client.config.client_side_validation && generate_random_with_bytes_request.nil?
        fail ArgumentError, "Missing the required parameter 'generate_random_with_bytes_request' when calling SystemApi.generate_random_with_bytes"
      end
      # resource path
      local_var_path = '/sys/tools/random/{urlbytes}'.sub('{' + 'urlbytes' + '}', CGI.escape(urlbytes.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(generate_random_with_bytes_request)

      # return_type
      return_type = opts[:debug_return_type] || 'GenerateRandomWithBytesResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.generate_random_with_bytes",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#generate_random_with_bytes\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param source [String] Which system to source random data from, ether \&quot;platform\&quot;, \&quot;seal\&quot;, or \&quot;all\&quot;.
    # @param generate_random_with_source_request [GenerateRandomWithSourceRequest]
    # @param [Hash] opts the optional parameters
    # @return [GenerateRandomWithSourceResponse]
    def generate_random_with_source(source, generate_random_with_source_request, opts = {})
      data, _status_code, _headers = generate_random_with_source_with_http_info(source, generate_random_with_source_request, opts)
      data
    end

    # @param source [String] Which system to source random data from, ether \&quot;platform\&quot;, \&quot;seal\&quot;, or \&quot;all\&quot;.
    # @param generate_random_with_source_request [GenerateRandomWithSourceRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(GenerateRandomWithSourceResponse, Integer, Hash)>] GenerateRandomWithSourceResponse data, response status code and response headers
    def generate_random_with_source_with_http_info(source, generate_random_with_source_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.generate_random_with_source ...'
      end
      # verify the required parameter 'source' is set
      if @api_client.config.client_side_validation && source.nil?
        fail ArgumentError, "Missing the required parameter 'source' when calling SystemApi.generate_random_with_source"
      end
      # verify the required parameter 'generate_random_with_source_request' is set
      if @api_client.config.client_side_validation && generate_random_with_source_request.nil?
        fail ArgumentError, "Missing the required parameter 'generate_random_with_source_request' when calling SystemApi.generate_random_with_source"
      end
      # resource path
      local_var_path = '/sys/tools/random/{source}'.sub('{' + 'source' + '}', CGI.escape(source.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(generate_random_with_source_request)

      # return_type
      return_type = opts[:debug_return_type] || 'GenerateRandomWithSourceResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.generate_random_with_source",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#generate_random_with_source\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param source [String] Which system to source random data from, ether \&quot;platform\&quot;, \&quot;seal\&quot;, or \&quot;all\&quot;.
    # @param urlbytes [String] The number of bytes to generate (POST URL parameter)
    # @param generate_random_with_source_and_bytes_request [GenerateRandomWithSourceAndBytesRequest]
    # @param [Hash] opts the optional parameters
    # @return [GenerateRandomWithSourceAndBytesResponse]
    def generate_random_with_source_and_bytes(source, urlbytes, generate_random_with_source_and_bytes_request, opts = {})
      data, _status_code, _headers = generate_random_with_source_and_bytes_with_http_info(source, urlbytes, generate_random_with_source_and_bytes_request, opts)
      data
    end

    # @param source [String] Which system to source random data from, ether \&quot;platform\&quot;, \&quot;seal\&quot;, or \&quot;all\&quot;.
    # @param urlbytes [String] The number of bytes to generate (POST URL parameter)
    # @param generate_random_with_source_and_bytes_request [GenerateRandomWithSourceAndBytesRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(GenerateRandomWithSourceAndBytesResponse, Integer, Hash)>] GenerateRandomWithSourceAndBytesResponse data, response status code and response headers
    def generate_random_with_source_and_bytes_with_http_info(source, urlbytes, generate_random_with_source_and_bytes_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.generate_random_with_source_and_bytes ...'
      end
      # verify the required parameter 'source' is set
      if @api_client.config.client_side_validation && source.nil?
        fail ArgumentError, "Missing the required parameter 'source' when calling SystemApi.generate_random_with_source_and_bytes"
      end
      # verify the required parameter 'urlbytes' is set
      if @api_client.config.client_side_validation && urlbytes.nil?
        fail ArgumentError, "Missing the required parameter 'urlbytes' when calling SystemApi.generate_random_with_source_and_bytes"
      end
      # verify the required parameter 'generate_random_with_source_and_bytes_request' is set
      if @api_client.config.client_side_validation && generate_random_with_source_and_bytes_request.nil?
        fail ArgumentError, "Missing the required parameter 'generate_random_with_source_and_bytes_request' when calling SystemApi.generate_random_with_source_and_bytes"
      end
      # resource path
      local_var_path = '/sys/tools/random/{source}/{urlbytes}'.sub('{' + 'source' + '}', CGI.escape(source.to_s)).sub('{' + 'urlbytes' + '}', CGI.escape(urlbytes.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(generate_random_with_source_and_bytes_request)

      # return_type
      return_type = opts[:debug_return_type] || 'GenerateRandomWithSourceAndBytesResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.generate_random_with_source_and_bytes",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#generate_random_with_source_and_bytes\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Check the HA status of an OpenBao cluster
    # @param [Hash] opts the optional parameters
    # @return [HaStatusResponse]
    def ha_status(opts = {})
      data, _status_code, _headers = ha_status_with_http_info(opts)
      data
    end

    # Check the HA status of an OpenBao cluster
    # @param [Hash] opts the optional parameters
    # @return [Array<(HaStatusResponse, Integer, Hash)>] HaStatusResponse data, response status code and response headers
    def ha_status_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.ha_status ...'
      end
      # resource path
      local_var_path = '/sys/ha-status'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'HaStatusResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.ha_status",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#ha_status\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Initialize a new OpenBao instance.
    # The OpenBao instance must not have been previously initialized. The recovery options, as well as the stored shares option, are only available when using OpenBao HSM.
    # @param initialize_system_request [InitializeSystemRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def initialize_system(initialize_system_request, opts = {})
      initialize_system_with_http_info(initialize_system_request, opts)
      nil
    end

    # Initialize a new OpenBao instance.
    # The OpenBao instance must not have been previously initialized. The recovery options, as well as the stored shares option, are only available when using OpenBao HSM.
    # @param initialize_system_request [InitializeSystemRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def initialize_system_with_http_info(initialize_system_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.initialize_system ...'
      end
      # verify the required parameter 'initialize_system_request' is set
      if @api_client.config.client_side_validation && initialize_system_request.nil?
        fail ArgumentError, "Missing the required parameter 'initialize_system_request' when calling SystemApi.initialize_system"
      end
      # resource path
      local_var_path = '/sys/init'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(initialize_system_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.initialize_system",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#initialize_system\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Backwards compatibility is not guaranteed for this API
    # @param [Hash] opts the optional parameters
    # @return [InternalCountEntitiesResponse]
    def internal_count_entities(opts = {})
      data, _status_code, _headers = internal_count_entities_with_http_info(opts)
      data
    end

    # Backwards compatibility is not guaranteed for this API
    # @param [Hash] opts the optional parameters
    # @return [Array<(InternalCountEntitiesResponse, Integer, Hash)>] InternalCountEntitiesResponse data, response status code and response headers
    def internal_count_entities_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.internal_count_entities ...'
      end
      # resource path
      local_var_path = '/sys/internal/counters/entities'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'InternalCountEntitiesResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.internal_count_entities",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#internal_count_entities\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Backwards compatibility is not guaranteed for this API
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def internal_count_requests(opts = {})
      internal_count_requests_with_http_info(opts)
      nil
    end

    # Backwards compatibility is not guaranteed for this API
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def internal_count_requests_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.internal_count_requests ...'
      end
      # resource path
      local_var_path = '/sys/internal/counters/requests'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.internal_count_requests",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#internal_count_requests\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Backwards compatibility is not guaranteed for this API
    # @param [Hash] opts the optional parameters
    # @return [InternalCountTokensResponse]
    def internal_count_tokens(opts = {})
      data, _status_code, _headers = internal_count_tokens_with_http_info(opts)
      data
    end

    # Backwards compatibility is not guaranteed for this API
    # @param [Hash] opts the optional parameters
    # @return [Array<(InternalCountTokensResponse, Integer, Hash)>] InternalCountTokensResponse data, response status code and response headers
    def internal_count_tokens_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.internal_count_tokens ...'
      end
      # resource path
      local_var_path = '/sys/internal/counters/tokens'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'InternalCountTokensResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.internal_count_tokens",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#internal_count_tokens\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param [Hash] opts the optional parameters
    # @option opts [Boolean] :generic_mount_paths Use generic mount paths (default to false)
    # @return [nil]
    def internal_generate_open_api_document(opts = {})
      internal_generate_open_api_document_with_http_info(opts)
      nil
    end

    # @param [Hash] opts the optional parameters
    # @option opts [Boolean] :generic_mount_paths Use generic mount paths (default to false)
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def internal_generate_open_api_document_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.internal_generate_open_api_document ...'
      end
      # resource path
      local_var_path = '/sys/internal/specs/openapi'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'generic_mount_paths'] = opts[:'generic_mount_paths'] if !opts[:'generic_mount_paths'].nil?

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.internal_generate_open_api_document",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#internal_generate_open_api_document\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param internal_generate_open_api_document_with_parameters_request [InternalGenerateOpenApiDocumentWithParametersRequest]
    # @param [Hash] opts the optional parameters
    # @option opts [Boolean] :generic_mount_paths Use generic mount paths (default to false)
    # @return [nil]
    def internal_generate_open_api_document_with_parameters(internal_generate_open_api_document_with_parameters_request, opts = {})
      internal_generate_open_api_document_with_parameters_with_http_info(internal_generate_open_api_document_with_parameters_request, opts)
      nil
    end

    # @param internal_generate_open_api_document_with_parameters_request [InternalGenerateOpenApiDocumentWithParametersRequest]
    # @param [Hash] opts the optional parameters
    # @option opts [Boolean] :generic_mount_paths Use generic mount paths (default to false)
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def internal_generate_open_api_document_with_parameters_with_http_info(internal_generate_open_api_document_with_parameters_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.internal_generate_open_api_document_with_parameters ...'
      end
      # verify the required parameter 'internal_generate_open_api_document_with_parameters_request' is set
      if @api_client.config.client_side_validation && internal_generate_open_api_document_with_parameters_request.nil?
        fail ArgumentError, "Missing the required parameter 'internal_generate_open_api_document_with_parameters_request' when calling SystemApi.internal_generate_open_api_document_with_parameters"
      end
      # resource path
      local_var_path = '/sys/internal/specs/openapi'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'generic_mount_paths'] = opts[:'generic_mount_paths'] if !opts[:'generic_mount_paths'].nil?

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(internal_generate_open_api_document_with_parameters_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.internal_generate_open_api_document_with_parameters",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#internal_generate_open_api_document_with_parameters\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Expose the route entry and mount entry tables present in the router
    # @param tag [String] Name of subtree being observed
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def internal_inspect_router(tag, opts = {})
      internal_inspect_router_with_http_info(tag, opts)
      nil
    end

    # Expose the route entry and mount entry tables present in the router
    # @param tag [String] Name of subtree being observed
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def internal_inspect_router_with_http_info(tag, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.internal_inspect_router ...'
      end
      # verify the required parameter 'tag' is set
      if @api_client.config.client_side_validation && tag.nil?
        fail ArgumentError, "Missing the required parameter 'tag' when calling SystemApi.internal_inspect_router"
      end
      # resource path
      local_var_path = '/sys/internal/inspect/router/{tag}'.sub('{' + 'tag' + '}', CGI.escape(tag.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.internal_inspect_router",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#internal_inspect_router\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Lists enabled feature flags.
    # @param [Hash] opts the optional parameters
    # @return [InternalUiListEnabledFeatureFlagsResponse]
    def internal_ui_list_enabled_feature_flags(opts = {})
      data, _status_code, _headers = internal_ui_list_enabled_feature_flags_with_http_info(opts)
      data
    end

    # Lists enabled feature flags.
    # @param [Hash] opts the optional parameters
    # @return [Array<(InternalUiListEnabledFeatureFlagsResponse, Integer, Hash)>] InternalUiListEnabledFeatureFlagsResponse data, response status code and response headers
    def internal_ui_list_enabled_feature_flags_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.internal_ui_list_enabled_feature_flags ...'
      end
      # resource path
      local_var_path = '/sys/internal/ui/feature-flags'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'InternalUiListEnabledFeatureFlagsResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.internal_ui_list_enabled_feature_flags",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#internal_ui_list_enabled_feature_flags\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Lists all enabled and visible auth and secrets mounts.
    # @param [Hash] opts the optional parameters
    # @return [InternalUiListEnabledVisibleMountsResponse]
    def internal_ui_list_enabled_visible_mounts(opts = {})
      data, _status_code, _headers = internal_ui_list_enabled_visible_mounts_with_http_info(opts)
      data
    end

    # Lists all enabled and visible auth and secrets mounts.
    # @param [Hash] opts the optional parameters
    # @return [Array<(InternalUiListEnabledVisibleMountsResponse, Integer, Hash)>] InternalUiListEnabledVisibleMountsResponse data, response status code and response headers
    def internal_ui_list_enabled_visible_mounts_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.internal_ui_list_enabled_visible_mounts ...'
      end
      # resource path
      local_var_path = '/sys/internal/ui/mounts'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'InternalUiListEnabledVisibleMountsResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.internal_ui_list_enabled_visible_mounts",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#internal_ui_list_enabled_visible_mounts\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Backwards compatibility is not guaranteed for this API
    # @param [Hash] opts the optional parameters
    # @return [InternalUiListNamespacesResponse]
    def internal_ui_list_namespaces(opts = {})
      data, _status_code, _headers = internal_ui_list_namespaces_with_http_info(opts)
      data
    end

    # Backwards compatibility is not guaranteed for this API
    # @param [Hash] opts the optional parameters
    # @return [Array<(InternalUiListNamespacesResponse, Integer, Hash)>] InternalUiListNamespacesResponse data, response status code and response headers
    def internal_ui_list_namespaces_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.internal_ui_list_namespaces ...'
      end
      # resource path
      local_var_path = '/sys/internal/ui/namespaces'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'InternalUiListNamespacesResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.internal_ui_list_namespaces",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#internal_ui_list_namespaces\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Return information about the given mount.
    # @param path [String] The path of the mount.
    # @param [Hash] opts the optional parameters
    # @return [InternalUiReadMountInformationResponse]
    def internal_ui_read_mount_information(path, opts = {})
      data, _status_code, _headers = internal_ui_read_mount_information_with_http_info(path, opts)
      data
    end

    # Return information about the given mount.
    # @param path [String] The path of the mount.
    # @param [Hash] opts the optional parameters
    # @return [Array<(InternalUiReadMountInformationResponse, Integer, Hash)>] InternalUiReadMountInformationResponse data, response status code and response headers
    def internal_ui_read_mount_information_with_http_info(path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.internal_ui_read_mount_information ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SystemApi.internal_ui_read_mount_information"
      end
      # resource path
      local_var_path = '/sys/internal/ui/mounts/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'InternalUiReadMountInformationResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.internal_ui_read_mount_information",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#internal_ui_read_mount_information\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Backwards compatibility is not guaranteed for this API
    # @param [Hash] opts the optional parameters
    # @return [InternalUiReadResultantAclResponse]
    def internal_ui_read_resultant_acl(opts = {})
      data, _status_code, _headers = internal_ui_read_resultant_acl_with_http_info(opts)
      data
    end

    # Backwards compatibility is not guaranteed for this API
    # @param [Hash] opts the optional parameters
    # @return [Array<(InternalUiReadResultantAclResponse, Integer, Hash)>] InternalUiReadResultantAclResponse data, response status code and response headers
    def internal_ui_read_resultant_acl_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.internal_ui_read_resultant_acl ...'
      end
      # resource path
      local_var_path = '/sys/internal/ui/resultant-acl'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'InternalUiReadResultantAclResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.internal_ui_read_resultant_acl",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#internal_ui_read_resultant_acl\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Returns the high availability status and current leader instance of OpenBao.
    # @param [Hash] opts the optional parameters
    # @return [LeaderStatusResponse]
    def leader_status(opts = {})
      data, _status_code, _headers = leader_status_with_http_info(opts)
      data
    end

    # Returns the high availability status and current leader instance of OpenBao.
    # @param [Hash] opts the optional parameters
    # @return [Array<(LeaderStatusResponse, Integer, Hash)>] LeaderStatusResponse data, response status code and response headers
    def leader_status_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.leader_status ...'
      end
      # resource path
      local_var_path = '/sys/leader'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'LeaderStatusResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.leader_status",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#leader_status\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param [Hash] opts the optional parameters
    # @return [LeasesCountResponse]
    def leases_count(opts = {})
      data, _status_code, _headers = leases_count_with_http_info(opts)
      data
    end

    # @param [Hash] opts the optional parameters
    # @return [Array<(LeasesCountResponse, Integer, Hash)>] LeasesCountResponse data, response status code and response headers
    def leases_count_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.leases_count ...'
      end
      # resource path
      local_var_path = '/sys/leases/count'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'LeasesCountResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.leases_count",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#leases_count\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Revokes all secrets or tokens generated under a given prefix immediately
    # Unlike `/sys/leases/revoke-prefix`, this path ignores backend errors encountered during revocation. This is potentially very dangerous and should only be used in specific emergency situations where errors in the backend or the connected backend service prevent normal revocation.  By ignoring these errors, OpenBao abdicates responsibility for ensuring that the issued credentials or secrets are properly revoked and/or cleaned up. Access to this endpoint should be tightly controlled.
    # @param prefix [String] The path to revoke keys under. Example: \&quot;prod/aws/ops\&quot;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def leases_force_revoke_lease_with_prefix(prefix, opts = {})
      leases_force_revoke_lease_with_prefix_with_http_info(prefix, opts)
      nil
    end

    # Revokes all secrets or tokens generated under a given prefix immediately
    # Unlike &#x60;/sys/leases/revoke-prefix&#x60;, this path ignores backend errors encountered during revocation. This is potentially very dangerous and should only be used in specific emergency situations where errors in the backend or the connected backend service prevent normal revocation.  By ignoring these errors, OpenBao abdicates responsibility for ensuring that the issued credentials or secrets are properly revoked and/or cleaned up. Access to this endpoint should be tightly controlled.
    # @param prefix [String] The path to revoke keys under. Example: \&quot;prod/aws/ops\&quot;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def leases_force_revoke_lease_with_prefix_with_http_info(prefix, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.leases_force_revoke_lease_with_prefix ...'
      end
      # verify the required parameter 'prefix' is set
      if @api_client.config.client_side_validation && prefix.nil?
        fail ArgumentError, "Missing the required parameter 'prefix' when calling SystemApi.leases_force_revoke_lease_with_prefix"
      end
      # resource path
      local_var_path = '/sys/leases/revoke-force/{prefix}'.sub('{' + 'prefix' + '}', CGI.escape(prefix.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.leases_force_revoke_lease_with_prefix",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#leases_force_revoke_lease_with_prefix\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Revokes all secrets or tokens generated under a given prefix immediately
    # Unlike `/sys/leases/revoke-prefix`, this path ignores backend errors encountered during revocation. This is potentially very dangerous and should only be used in specific emergency situations where errors in the backend or the connected backend service prevent normal revocation.  By ignoring these errors, OpenBao abdicates responsibility for ensuring that the issued credentials or secrets are properly revoked and/or cleaned up. Access to this endpoint should be tightly controlled.
    # @param prefix [String] The path to revoke keys under. Example: \&quot;prod/aws/ops\&quot;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def leases_force_revoke_lease_with_prefix2(prefix, opts = {})
      leases_force_revoke_lease_with_prefix2_with_http_info(prefix, opts)
      nil
    end

    # Revokes all secrets or tokens generated under a given prefix immediately
    # Unlike &#x60;/sys/leases/revoke-prefix&#x60;, this path ignores backend errors encountered during revocation. This is potentially very dangerous and should only be used in specific emergency situations where errors in the backend or the connected backend service prevent normal revocation.  By ignoring these errors, OpenBao abdicates responsibility for ensuring that the issued credentials or secrets are properly revoked and/or cleaned up. Access to this endpoint should be tightly controlled.
    # @param prefix [String] The path to revoke keys under. Example: \&quot;prod/aws/ops\&quot;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def leases_force_revoke_lease_with_prefix2_with_http_info(prefix, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.leases_force_revoke_lease_with_prefix2 ...'
      end
      # verify the required parameter 'prefix' is set
      if @api_client.config.client_side_validation && prefix.nil?
        fail ArgumentError, "Missing the required parameter 'prefix' when calling SystemApi.leases_force_revoke_lease_with_prefix2"
      end
      # resource path
      local_var_path = '/sys/revoke-force/{prefix}'.sub('{' + 'prefix' + '}', CGI.escape(prefix.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.leases_force_revoke_lease_with_prefix2",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#leases_force_revoke_lease_with_prefix2\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param [Hash] opts the optional parameters
    # @return [LeasesListResponse]
    def leases_list(opts = {})
      data, _status_code, _headers = leases_list_with_http_info(opts)
      data
    end

    # @param [Hash] opts the optional parameters
    # @return [Array<(LeasesListResponse, Integer, Hash)>] LeasesListResponse data, response status code and response headers
    def leases_list_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.leases_list ...'
      end
      # resource path
      local_var_path = '/sys/leases'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'LeasesListResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.leases_list",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#leases_list\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [LeasesLookUpResponse]
    def leases_look_up(list, opts = {})
      data, _status_code, _headers = leases_look_up_with_http_info(list, opts)
      data
    end

    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(LeasesLookUpResponse, Integer, Hash)>] LeasesLookUpResponse data, response status code and response headers
    def leases_look_up_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.leases_look_up ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SystemApi.leases_look_up"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/sys/leases/lookup/'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'LeasesLookUpResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.leases_look_up",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#leases_look_up\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param prefix [String] The path to list leases under. Example: \&quot;aws/creds/deploy\&quot;
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [LeasesLookUpWithPrefixResponse]
    def leases_look_up_with_prefix(prefix, list, opts = {})
      data, _status_code, _headers = leases_look_up_with_prefix_with_http_info(prefix, list, opts)
      data
    end

    # @param prefix [String] The path to list leases under. Example: \&quot;aws/creds/deploy\&quot;
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(LeasesLookUpWithPrefixResponse, Integer, Hash)>] LeasesLookUpWithPrefixResponse data, response status code and response headers
    def leases_look_up_with_prefix_with_http_info(prefix, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.leases_look_up_with_prefix ...'
      end
      # verify the required parameter 'prefix' is set
      if @api_client.config.client_side_validation && prefix.nil?
        fail ArgumentError, "Missing the required parameter 'prefix' when calling SystemApi.leases_look_up_with_prefix"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SystemApi.leases_look_up_with_prefix"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/sys/leases/lookup/{prefix}'.sub('{' + 'prefix' + '}', CGI.escape(prefix.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'LeasesLookUpWithPrefixResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.leases_look_up_with_prefix",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#leases_look_up_with_prefix\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param leases_read_lease_request [LeasesReadLeaseRequest]
    # @param [Hash] opts the optional parameters
    # @return [LeasesReadLeaseResponse]
    def leases_read_lease(leases_read_lease_request, opts = {})
      data, _status_code, _headers = leases_read_lease_with_http_info(leases_read_lease_request, opts)
      data
    end

    # @param leases_read_lease_request [LeasesReadLeaseRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(LeasesReadLeaseResponse, Integer, Hash)>] LeasesReadLeaseResponse data, response status code and response headers
    def leases_read_lease_with_http_info(leases_read_lease_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.leases_read_lease ...'
      end
      # verify the required parameter 'leases_read_lease_request' is set
      if @api_client.config.client_side_validation && leases_read_lease_request.nil?
        fail ArgumentError, "Missing the required parameter 'leases_read_lease_request' when calling SystemApi.leases_read_lease"
      end
      # resource path
      local_var_path = '/sys/leases/lookup'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(leases_read_lease_request)

      # return_type
      return_type = opts[:debug_return_type] || 'LeasesReadLeaseResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.leases_read_lease",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#leases_read_lease\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Renews a lease, requesting to extend the lease.
    # @param leases_renew_lease_request [LeasesRenewLeaseRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def leases_renew_lease(leases_renew_lease_request, opts = {})
      leases_renew_lease_with_http_info(leases_renew_lease_request, opts)
      nil
    end

    # Renews a lease, requesting to extend the lease.
    # @param leases_renew_lease_request [LeasesRenewLeaseRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def leases_renew_lease_with_http_info(leases_renew_lease_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.leases_renew_lease ...'
      end
      # verify the required parameter 'leases_renew_lease_request' is set
      if @api_client.config.client_side_validation && leases_renew_lease_request.nil?
        fail ArgumentError, "Missing the required parameter 'leases_renew_lease_request' when calling SystemApi.leases_renew_lease"
      end
      # resource path
      local_var_path = '/sys/leases/renew'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(leases_renew_lease_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.leases_renew_lease",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#leases_renew_lease\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Renews a lease, requesting to extend the lease.
    # @param leases_renew_lease2_request [LeasesRenewLease2Request]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def leases_renew_lease2(leases_renew_lease2_request, opts = {})
      leases_renew_lease2_with_http_info(leases_renew_lease2_request, opts)
      nil
    end

    # Renews a lease, requesting to extend the lease.
    # @param leases_renew_lease2_request [LeasesRenewLease2Request]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def leases_renew_lease2_with_http_info(leases_renew_lease2_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.leases_renew_lease2 ...'
      end
      # verify the required parameter 'leases_renew_lease2_request' is set
      if @api_client.config.client_side_validation && leases_renew_lease2_request.nil?
        fail ArgumentError, "Missing the required parameter 'leases_renew_lease2_request' when calling SystemApi.leases_renew_lease2"
      end
      # resource path
      local_var_path = '/sys/renew'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(leases_renew_lease2_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.leases_renew_lease2",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#leases_renew_lease2\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Renews a lease, requesting to extend the lease.
    # @param url_lease_id [String] The lease identifier to renew. This is included with a lease.
    # @param leases_renew_lease_with_id_request [LeasesRenewLeaseWithIdRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def leases_renew_lease_with_id(url_lease_id, leases_renew_lease_with_id_request, opts = {})
      leases_renew_lease_with_id_with_http_info(url_lease_id, leases_renew_lease_with_id_request, opts)
      nil
    end

    # Renews a lease, requesting to extend the lease.
    # @param url_lease_id [String] The lease identifier to renew. This is included with a lease.
    # @param leases_renew_lease_with_id_request [LeasesRenewLeaseWithIdRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def leases_renew_lease_with_id_with_http_info(url_lease_id, leases_renew_lease_with_id_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.leases_renew_lease_with_id ...'
      end
      # verify the required parameter 'url_lease_id' is set
      if @api_client.config.client_side_validation && url_lease_id.nil?
        fail ArgumentError, "Missing the required parameter 'url_lease_id' when calling SystemApi.leases_renew_lease_with_id"
      end
      # verify the required parameter 'leases_renew_lease_with_id_request' is set
      if @api_client.config.client_side_validation && leases_renew_lease_with_id_request.nil?
        fail ArgumentError, "Missing the required parameter 'leases_renew_lease_with_id_request' when calling SystemApi.leases_renew_lease_with_id"
      end
      # resource path
      local_var_path = '/sys/leases/renew/{url_lease_id}'.sub('{' + 'url_lease_id' + '}', CGI.escape(url_lease_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(leases_renew_lease_with_id_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.leases_renew_lease_with_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#leases_renew_lease_with_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Renews a lease, requesting to extend the lease.
    # @param url_lease_id [String] The lease identifier to renew. This is included with a lease.
    # @param leases_renew_lease_with_id2_request [LeasesRenewLeaseWithId2Request]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def leases_renew_lease_with_id2(url_lease_id, leases_renew_lease_with_id2_request, opts = {})
      leases_renew_lease_with_id2_with_http_info(url_lease_id, leases_renew_lease_with_id2_request, opts)
      nil
    end

    # Renews a lease, requesting to extend the lease.
    # @param url_lease_id [String] The lease identifier to renew. This is included with a lease.
    # @param leases_renew_lease_with_id2_request [LeasesRenewLeaseWithId2Request]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def leases_renew_lease_with_id2_with_http_info(url_lease_id, leases_renew_lease_with_id2_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.leases_renew_lease_with_id2 ...'
      end
      # verify the required parameter 'url_lease_id' is set
      if @api_client.config.client_side_validation && url_lease_id.nil?
        fail ArgumentError, "Missing the required parameter 'url_lease_id' when calling SystemApi.leases_renew_lease_with_id2"
      end
      # verify the required parameter 'leases_renew_lease_with_id2_request' is set
      if @api_client.config.client_side_validation && leases_renew_lease_with_id2_request.nil?
        fail ArgumentError, "Missing the required parameter 'leases_renew_lease_with_id2_request' when calling SystemApi.leases_renew_lease_with_id2"
      end
      # resource path
      local_var_path = '/sys/renew/{url_lease_id}'.sub('{' + 'url_lease_id' + '}', CGI.escape(url_lease_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(leases_renew_lease_with_id2_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.leases_renew_lease_with_id2",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#leases_renew_lease_with_id2\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Revokes a lease immediately.
    # @param leases_revoke_lease_request [LeasesRevokeLeaseRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def leases_revoke_lease(leases_revoke_lease_request, opts = {})
      leases_revoke_lease_with_http_info(leases_revoke_lease_request, opts)
      nil
    end

    # Revokes a lease immediately.
    # @param leases_revoke_lease_request [LeasesRevokeLeaseRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def leases_revoke_lease_with_http_info(leases_revoke_lease_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.leases_revoke_lease ...'
      end
      # verify the required parameter 'leases_revoke_lease_request' is set
      if @api_client.config.client_side_validation && leases_revoke_lease_request.nil?
        fail ArgumentError, "Missing the required parameter 'leases_revoke_lease_request' when calling SystemApi.leases_revoke_lease"
      end
      # resource path
      local_var_path = '/sys/leases/revoke'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(leases_revoke_lease_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.leases_revoke_lease",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#leases_revoke_lease\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Revokes a lease immediately.
    # @param leases_revoke_lease2_request [LeasesRevokeLease2Request]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def leases_revoke_lease2(leases_revoke_lease2_request, opts = {})
      leases_revoke_lease2_with_http_info(leases_revoke_lease2_request, opts)
      nil
    end

    # Revokes a lease immediately.
    # @param leases_revoke_lease2_request [LeasesRevokeLease2Request]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def leases_revoke_lease2_with_http_info(leases_revoke_lease2_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.leases_revoke_lease2 ...'
      end
      # verify the required parameter 'leases_revoke_lease2_request' is set
      if @api_client.config.client_side_validation && leases_revoke_lease2_request.nil?
        fail ArgumentError, "Missing the required parameter 'leases_revoke_lease2_request' when calling SystemApi.leases_revoke_lease2"
      end
      # resource path
      local_var_path = '/sys/revoke'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(leases_revoke_lease2_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.leases_revoke_lease2",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#leases_revoke_lease2\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Revokes a lease immediately.
    # @param url_lease_id [String] The lease identifier to renew. This is included with a lease.
    # @param leases_revoke_lease_with_id_request [LeasesRevokeLeaseWithIdRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def leases_revoke_lease_with_id(url_lease_id, leases_revoke_lease_with_id_request, opts = {})
      leases_revoke_lease_with_id_with_http_info(url_lease_id, leases_revoke_lease_with_id_request, opts)
      nil
    end

    # Revokes a lease immediately.
    # @param url_lease_id [String] The lease identifier to renew. This is included with a lease.
    # @param leases_revoke_lease_with_id_request [LeasesRevokeLeaseWithIdRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def leases_revoke_lease_with_id_with_http_info(url_lease_id, leases_revoke_lease_with_id_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.leases_revoke_lease_with_id ...'
      end
      # verify the required parameter 'url_lease_id' is set
      if @api_client.config.client_side_validation && url_lease_id.nil?
        fail ArgumentError, "Missing the required parameter 'url_lease_id' when calling SystemApi.leases_revoke_lease_with_id"
      end
      # verify the required parameter 'leases_revoke_lease_with_id_request' is set
      if @api_client.config.client_side_validation && leases_revoke_lease_with_id_request.nil?
        fail ArgumentError, "Missing the required parameter 'leases_revoke_lease_with_id_request' when calling SystemApi.leases_revoke_lease_with_id"
      end
      # resource path
      local_var_path = '/sys/leases/revoke/{url_lease_id}'.sub('{' + 'url_lease_id' + '}', CGI.escape(url_lease_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(leases_revoke_lease_with_id_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.leases_revoke_lease_with_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#leases_revoke_lease_with_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Revokes a lease immediately.
    # @param url_lease_id [String] The lease identifier to renew. This is included with a lease.
    # @param leases_revoke_lease_with_id2_request [LeasesRevokeLeaseWithId2Request]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def leases_revoke_lease_with_id2(url_lease_id, leases_revoke_lease_with_id2_request, opts = {})
      leases_revoke_lease_with_id2_with_http_info(url_lease_id, leases_revoke_lease_with_id2_request, opts)
      nil
    end

    # Revokes a lease immediately.
    # @param url_lease_id [String] The lease identifier to renew. This is included with a lease.
    # @param leases_revoke_lease_with_id2_request [LeasesRevokeLeaseWithId2Request]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def leases_revoke_lease_with_id2_with_http_info(url_lease_id, leases_revoke_lease_with_id2_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.leases_revoke_lease_with_id2 ...'
      end
      # verify the required parameter 'url_lease_id' is set
      if @api_client.config.client_side_validation && url_lease_id.nil?
        fail ArgumentError, "Missing the required parameter 'url_lease_id' when calling SystemApi.leases_revoke_lease_with_id2"
      end
      # verify the required parameter 'leases_revoke_lease_with_id2_request' is set
      if @api_client.config.client_side_validation && leases_revoke_lease_with_id2_request.nil?
        fail ArgumentError, "Missing the required parameter 'leases_revoke_lease_with_id2_request' when calling SystemApi.leases_revoke_lease_with_id2"
      end
      # resource path
      local_var_path = '/sys/revoke/{url_lease_id}'.sub('{' + 'url_lease_id' + '}', CGI.escape(url_lease_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(leases_revoke_lease_with_id2_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.leases_revoke_lease_with_id2",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#leases_revoke_lease_with_id2\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Revokes all secrets (via a lease ID prefix) or tokens (via the tokens' path property) generated under a given prefix immediately.
    # @param prefix [String] The path to revoke keys under. Example: \&quot;prod/aws/ops\&quot;
    # @param leases_revoke_lease_with_prefix_request [LeasesRevokeLeaseWithPrefixRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def leases_revoke_lease_with_prefix(prefix, leases_revoke_lease_with_prefix_request, opts = {})
      leases_revoke_lease_with_prefix_with_http_info(prefix, leases_revoke_lease_with_prefix_request, opts)
      nil
    end

    # Revokes all secrets (via a lease ID prefix) or tokens (via the tokens&#39; path property) generated under a given prefix immediately.
    # @param prefix [String] The path to revoke keys under. Example: \&quot;prod/aws/ops\&quot;
    # @param leases_revoke_lease_with_prefix_request [LeasesRevokeLeaseWithPrefixRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def leases_revoke_lease_with_prefix_with_http_info(prefix, leases_revoke_lease_with_prefix_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.leases_revoke_lease_with_prefix ...'
      end
      # verify the required parameter 'prefix' is set
      if @api_client.config.client_side_validation && prefix.nil?
        fail ArgumentError, "Missing the required parameter 'prefix' when calling SystemApi.leases_revoke_lease_with_prefix"
      end
      # verify the required parameter 'leases_revoke_lease_with_prefix_request' is set
      if @api_client.config.client_side_validation && leases_revoke_lease_with_prefix_request.nil?
        fail ArgumentError, "Missing the required parameter 'leases_revoke_lease_with_prefix_request' when calling SystemApi.leases_revoke_lease_with_prefix"
      end
      # resource path
      local_var_path = '/sys/leases/revoke-prefix/{prefix}'.sub('{' + 'prefix' + '}', CGI.escape(prefix.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(leases_revoke_lease_with_prefix_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.leases_revoke_lease_with_prefix",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#leases_revoke_lease_with_prefix\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Revokes all secrets (via a lease ID prefix) or tokens (via the tokens' path property) generated under a given prefix immediately.
    # @param prefix [String] The path to revoke keys under. Example: \&quot;prod/aws/ops\&quot;
    # @param leases_revoke_lease_with_prefix2_request [LeasesRevokeLeaseWithPrefix2Request]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def leases_revoke_lease_with_prefix2(prefix, leases_revoke_lease_with_prefix2_request, opts = {})
      leases_revoke_lease_with_prefix2_with_http_info(prefix, leases_revoke_lease_with_prefix2_request, opts)
      nil
    end

    # Revokes all secrets (via a lease ID prefix) or tokens (via the tokens&#39; path property) generated under a given prefix immediately.
    # @param prefix [String] The path to revoke keys under. Example: \&quot;prod/aws/ops\&quot;
    # @param leases_revoke_lease_with_prefix2_request [LeasesRevokeLeaseWithPrefix2Request]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def leases_revoke_lease_with_prefix2_with_http_info(prefix, leases_revoke_lease_with_prefix2_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.leases_revoke_lease_with_prefix2 ...'
      end
      # verify the required parameter 'prefix' is set
      if @api_client.config.client_side_validation && prefix.nil?
        fail ArgumentError, "Missing the required parameter 'prefix' when calling SystemApi.leases_revoke_lease_with_prefix2"
      end
      # verify the required parameter 'leases_revoke_lease_with_prefix2_request' is set
      if @api_client.config.client_side_validation && leases_revoke_lease_with_prefix2_request.nil?
        fail ArgumentError, "Missing the required parameter 'leases_revoke_lease_with_prefix2_request' when calling SystemApi.leases_revoke_lease_with_prefix2"
      end
      # resource path
      local_var_path = '/sys/revoke-prefix/{prefix}'.sub('{' + 'prefix' + '}', CGI.escape(prefix.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(leases_revoke_lease_with_prefix2_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.leases_revoke_lease_with_prefix2",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#leases_revoke_lease_with_prefix2\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param [Hash] opts the optional parameters
    # @return [nil]
    def leases_tidy(opts = {})
      leases_tidy_with_http_info(opts)
      nil
    end

    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def leases_tidy_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.leases_tidy ...'
      end
      # resource path
      local_var_path = '/sys/leases/tidy'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.leases_tidy",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#leases_tidy\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Report the locked user count metrics, for this namespace and all child namespaces.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def locked_users_list(opts = {})
      locked_users_list_with_http_info(opts)
      nil
    end

    # Report the locked user count metrics, for this namespace and all child namespaces.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def locked_users_list_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.locked_users_list ...'
      end
      # resource path
      local_var_path = '/sys/locked-users'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.locked_users_list",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#locked_users_list\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Unlocks the user with given mount_accessor and alias_identifier
    # @param alias_identifier [String] It is the name of the alias (user). For example, if the alias belongs to userpass backend, the name should be a valid username within userpass auth method. If the alias belongs to an approle auth method, the name should be a valid RoleID
    # @param mount_accessor [String] MountAccessor is the identifier of the mount entry to which the user belongs
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def locked_users_unlock(alias_identifier, mount_accessor, opts = {})
      locked_users_unlock_with_http_info(alias_identifier, mount_accessor, opts)
      nil
    end

    # Unlocks the user with given mount_accessor and alias_identifier
    # @param alias_identifier [String] It is the name of the alias (user). For example, if the alias belongs to userpass backend, the name should be a valid username within userpass auth method. If the alias belongs to an approle auth method, the name should be a valid RoleID
    # @param mount_accessor [String] MountAccessor is the identifier of the mount entry to which the user belongs
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def locked_users_unlock_with_http_info(alias_identifier, mount_accessor, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.locked_users_unlock ...'
      end
      # verify the required parameter 'alias_identifier' is set
      if @api_client.config.client_side_validation && alias_identifier.nil?
        fail ArgumentError, "Missing the required parameter 'alias_identifier' when calling SystemApi.locked_users_unlock"
      end
      # verify the required parameter 'mount_accessor' is set
      if @api_client.config.client_side_validation && mount_accessor.nil?
        fail ArgumentError, "Missing the required parameter 'mount_accessor' when calling SystemApi.locked_users_unlock"
      end
      # resource path
      local_var_path = '/sys/locked-users/{mount_accessor}/unlock/{alias_identifier}'.sub('{' + 'alias_identifier' + '}', CGI.escape(alias_identifier.to_s)).sub('{' + 'mount_accessor' + '}', CGI.escape(mount_accessor.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.locked_users_unlock",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#locked_users_unlock\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Read the log level for all existing loggers.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def loggers_read_verbosity_level(opts = {})
      loggers_read_verbosity_level_with_http_info(opts)
      nil
    end

    # Read the log level for all existing loggers.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def loggers_read_verbosity_level_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.loggers_read_verbosity_level ...'
      end
      # resource path
      local_var_path = '/sys/loggers'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.loggers_read_verbosity_level",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#loggers_read_verbosity_level\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Read the log level for a single logger.
    # @param name [String] The name of the logger to be modified.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def loggers_read_verbosity_level_for(name, opts = {})
      loggers_read_verbosity_level_for_with_http_info(name, opts)
      nil
    end

    # Read the log level for a single logger.
    # @param name [String] The name of the logger to be modified.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def loggers_read_verbosity_level_for_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.loggers_read_verbosity_level_for ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SystemApi.loggers_read_verbosity_level_for"
      end
      # resource path
      local_var_path = '/sys/loggers/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.loggers_read_verbosity_level_for",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#loggers_read_verbosity_level_for\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Revert the all loggers to use log level provided in config.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def loggers_revert_verbosity_level(opts = {})
      loggers_revert_verbosity_level_with_http_info(opts)
      nil
    end

    # Revert the all loggers to use log level provided in config.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def loggers_revert_verbosity_level_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.loggers_revert_verbosity_level ...'
      end
      # resource path
      local_var_path = '/sys/loggers'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.loggers_revert_verbosity_level",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#loggers_revert_verbosity_level\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Revert a single logger to use log level provided in config.
    # @param name [String] The name of the logger to be modified.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def loggers_revert_verbosity_level_for(name, opts = {})
      loggers_revert_verbosity_level_for_with_http_info(name, opts)
      nil
    end

    # Revert a single logger to use log level provided in config.
    # @param name [String] The name of the logger to be modified.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def loggers_revert_verbosity_level_for_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.loggers_revert_verbosity_level_for ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SystemApi.loggers_revert_verbosity_level_for"
      end
      # resource path
      local_var_path = '/sys/loggers/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.loggers_revert_verbosity_level_for",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#loggers_revert_verbosity_level_for\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Modify the log level for all existing loggers.
    # @param loggers_update_verbosity_level_request [LoggersUpdateVerbosityLevelRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def loggers_update_verbosity_level(loggers_update_verbosity_level_request, opts = {})
      loggers_update_verbosity_level_with_http_info(loggers_update_verbosity_level_request, opts)
      nil
    end

    # Modify the log level for all existing loggers.
    # @param loggers_update_verbosity_level_request [LoggersUpdateVerbosityLevelRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def loggers_update_verbosity_level_with_http_info(loggers_update_verbosity_level_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.loggers_update_verbosity_level ...'
      end
      # verify the required parameter 'loggers_update_verbosity_level_request' is set
      if @api_client.config.client_side_validation && loggers_update_verbosity_level_request.nil?
        fail ArgumentError, "Missing the required parameter 'loggers_update_verbosity_level_request' when calling SystemApi.loggers_update_verbosity_level"
      end
      # resource path
      local_var_path = '/sys/loggers'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(loggers_update_verbosity_level_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.loggers_update_verbosity_level",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#loggers_update_verbosity_level\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Modify the log level of a single logger.
    # @param name [String] The name of the logger to be modified.
    # @param loggers_update_verbosity_level_for_request [LoggersUpdateVerbosityLevelForRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def loggers_update_verbosity_level_for(name, loggers_update_verbosity_level_for_request, opts = {})
      loggers_update_verbosity_level_for_with_http_info(name, loggers_update_verbosity_level_for_request, opts)
      nil
    end

    # Modify the log level of a single logger.
    # @param name [String] The name of the logger to be modified.
    # @param loggers_update_verbosity_level_for_request [LoggersUpdateVerbosityLevelForRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def loggers_update_verbosity_level_for_with_http_info(name, loggers_update_verbosity_level_for_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.loggers_update_verbosity_level_for ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SystemApi.loggers_update_verbosity_level_for"
      end
      # verify the required parameter 'loggers_update_verbosity_level_for_request' is set
      if @api_client.config.client_side_validation && loggers_update_verbosity_level_for_request.nil?
        fail ArgumentError, "Missing the required parameter 'loggers_update_verbosity_level_for_request' when calling SystemApi.loggers_update_verbosity_level_for"
      end
      # resource path
      local_var_path = '/sys/loggers/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(loggers_update_verbosity_level_for_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.loggers_update_verbosity_level_for",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#loggers_update_verbosity_level_for\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param [Hash] opts the optional parameters
    # @option opts [String] :format Format to export metrics into. Currently accepts only \&quot;prometheus\&quot;.
    # @return [nil]
    def metrics(opts = {})
      metrics_with_http_info(opts)
      nil
    end

    # @param [Hash] opts the optional parameters
    # @option opts [String] :format Format to export metrics into. Currently accepts only \&quot;prometheus\&quot;.
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def metrics_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.metrics ...'
      end
      # resource path
      local_var_path = '/sys/metrics'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'format'] = opts[:'format'] if !opts[:'format'].nil?

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.metrics",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#metrics\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Validates the login for the given MFA methods. Upon successful validation, it returns an auth response containing the client token
    # @param mfa_validate_request [MfaValidateRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_validate(mfa_validate_request, opts = {})
      mfa_validate_with_http_info(mfa_validate_request, opts)
      nil
    end

    # Validates the login for the given MFA methods. Upon successful validation, it returns an auth response containing the client token
    # @param mfa_validate_request [MfaValidateRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_validate_with_http_info(mfa_validate_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.mfa_validate ...'
      end
      # verify the required parameter 'mfa_validate_request' is set
      if @api_client.config.client_side_validation && mfa_validate_request.nil?
        fail ArgumentError, "Missing the required parameter 'mfa_validate_request' when calling SystemApi.mfa_validate"
      end
      # resource path
      local_var_path = '/sys/mfa/validate'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(mfa_validate_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.mfa_validate",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#mfa_validate\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param [Hash] opts the optional parameters
    # @option opts [String] :log_format Output format of logs. Supported values are \&quot;standard\&quot; and \&quot;json\&quot;. The default is \&quot;standard\&quot;. (default to 'standard')
    # @option opts [String] :log_level Log level to view system logs at. Currently supported values are \&quot;trace\&quot;, \&quot;debug\&quot;, \&quot;info\&quot;, \&quot;warn\&quot;, \&quot;error\&quot;.
    # @return [nil]
    def monitor(opts = {})
      monitor_with_http_info(opts)
      nil
    end

    # @param [Hash] opts the optional parameters
    # @option opts [String] :log_format Output format of logs. Supported values are \&quot;standard\&quot; and \&quot;json\&quot;. The default is \&quot;standard\&quot;. (default to 'standard')
    # @option opts [String] :log_level Log level to view system logs at. Currently supported values are \&quot;trace\&quot;, \&quot;debug\&quot;, \&quot;info\&quot;, \&quot;warn\&quot;, \&quot;error\&quot;.
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def monitor_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.monitor ...'
      end
      # resource path
      local_var_path = '/sys/monitor'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'log_format'] = opts[:'log_format'] if !opts[:'log_format'].nil?
      query_params[:'log_level'] = opts[:'log_level'] if !opts[:'log_level'].nil?

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.monitor",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#monitor\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Disable the mount point specified at the given path.
    # @param path [String] The path to mount to. Example: \&quot;aws/east\&quot;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mounts_disable_secrets_engine(path, opts = {})
      mounts_disable_secrets_engine_with_http_info(path, opts)
      nil
    end

    # Disable the mount point specified at the given path.
    # @param path [String] The path to mount to. Example: \&quot;aws/east\&quot;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mounts_disable_secrets_engine_with_http_info(path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.mounts_disable_secrets_engine ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SystemApi.mounts_disable_secrets_engine"
      end
      # resource path
      local_var_path = '/sys/mounts/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.mounts_disable_secrets_engine",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#mounts_disable_secrets_engine\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Enable a new secrets engine at the given path.
    # @param path [String] The path to mount to. Example: \&quot;aws/east\&quot;
    # @param mounts_enable_secrets_engine_request [MountsEnableSecretsEngineRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mounts_enable_secrets_engine(path, mounts_enable_secrets_engine_request, opts = {})
      mounts_enable_secrets_engine_with_http_info(path, mounts_enable_secrets_engine_request, opts)
      nil
    end

    # Enable a new secrets engine at the given path.
    # @param path [String] The path to mount to. Example: \&quot;aws/east\&quot;
    # @param mounts_enable_secrets_engine_request [MountsEnableSecretsEngineRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mounts_enable_secrets_engine_with_http_info(path, mounts_enable_secrets_engine_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.mounts_enable_secrets_engine ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SystemApi.mounts_enable_secrets_engine"
      end
      # verify the required parameter 'mounts_enable_secrets_engine_request' is set
      if @api_client.config.client_side_validation && mounts_enable_secrets_engine_request.nil?
        fail ArgumentError, "Missing the required parameter 'mounts_enable_secrets_engine_request' when calling SystemApi.mounts_enable_secrets_engine"
      end
      # resource path
      local_var_path = '/sys/mounts/{path}'.sub('{' + 'path' + '}', path.to_s)

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(mounts_enable_secrets_engine_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.mounts_enable_secrets_engine",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#mounts_enable_secrets_engine\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mounts_list_secrets_engines(opts = {})
      mounts_list_secrets_engines_with_http_info(opts)
      nil
    end

    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mounts_list_secrets_engines_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.mounts_list_secrets_engines ...'
      end
      # resource path
      local_var_path = '/sys/mounts'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.mounts_list_secrets_engines",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#mounts_list_secrets_engines\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Read the configuration of the secret engine at the given path.
    # @param path [String] The path to mount to. Example: \&quot;aws/east\&quot;
    # @param [Hash] opts the optional parameters
    # @return [MountsReadConfigurationResponse]
    def mounts_read_configuration(path, opts = {})
      data, _status_code, _headers = mounts_read_configuration_with_http_info(path, opts)
      data
    end

    # Read the configuration of the secret engine at the given path.
    # @param path [String] The path to mount to. Example: \&quot;aws/east\&quot;
    # @param [Hash] opts the optional parameters
    # @return [Array<(MountsReadConfigurationResponse, Integer, Hash)>] MountsReadConfigurationResponse data, response status code and response headers
    def mounts_read_configuration_with_http_info(path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.mounts_read_configuration ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SystemApi.mounts_read_configuration"
      end
      # resource path
      local_var_path = '/sys/mounts/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'MountsReadConfigurationResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.mounts_read_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#mounts_read_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param path [String] The path to mount to. Example: \&quot;aws/east\&quot;
    # @param [Hash] opts the optional parameters
    # @return [MountsReadTuningInformationResponse]
    def mounts_read_tuning_information(path, opts = {})
      data, _status_code, _headers = mounts_read_tuning_information_with_http_info(path, opts)
      data
    end

    # @param path [String] The path to mount to. Example: \&quot;aws/east\&quot;
    # @param [Hash] opts the optional parameters
    # @return [Array<(MountsReadTuningInformationResponse, Integer, Hash)>] MountsReadTuningInformationResponse data, response status code and response headers
    def mounts_read_tuning_information_with_http_info(path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.mounts_read_tuning_information ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SystemApi.mounts_read_tuning_information"
      end
      # resource path
      local_var_path = '/sys/mounts/{path}/tune'.sub('{' + 'path' + '}', CGI.escape(path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'MountsReadTuningInformationResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.mounts_read_tuning_information",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#mounts_read_tuning_information\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param path [String] The path to mount to. Example: \&quot;aws/east\&quot;
    # @param mounts_tune_configuration_parameters_request [MountsTuneConfigurationParametersRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mounts_tune_configuration_parameters(path, mounts_tune_configuration_parameters_request, opts = {})
      mounts_tune_configuration_parameters_with_http_info(path, mounts_tune_configuration_parameters_request, opts)
      nil
    end

    # @param path [String] The path to mount to. Example: \&quot;aws/east\&quot;
    # @param mounts_tune_configuration_parameters_request [MountsTuneConfigurationParametersRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mounts_tune_configuration_parameters_with_http_info(path, mounts_tune_configuration_parameters_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.mounts_tune_configuration_parameters ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SystemApi.mounts_tune_configuration_parameters"
      end
      # verify the required parameter 'mounts_tune_configuration_parameters_request' is set
      if @api_client.config.client_side_validation && mounts_tune_configuration_parameters_request.nil?
        fail ArgumentError, "Missing the required parameter 'mounts_tune_configuration_parameters_request' when calling SystemApi.mounts_tune_configuration_parameters"
      end
      # resource path
      local_var_path = '/sys/mounts/{path}/tune'.sub('{' + 'path' + '}', CGI.escape(path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(mounts_tune_configuration_parameters_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.mounts_tune_configuration_parameters",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#mounts_tune_configuration_parameters\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param [Hash] opts the optional parameters
    # @return [PluginsCatalogListPluginsResponse]
    def plugins_catalog_list_plugins(opts = {})
      data, _status_code, _headers = plugins_catalog_list_plugins_with_http_info(opts)
      data
    end

    # @param [Hash] opts the optional parameters
    # @return [Array<(PluginsCatalogListPluginsResponse, Integer, Hash)>] PluginsCatalogListPluginsResponse data, response status code and response headers
    def plugins_catalog_list_plugins_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.plugins_catalog_list_plugins ...'
      end
      # resource path
      local_var_path = '/sys/plugins/catalog'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PluginsCatalogListPluginsResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.plugins_catalog_list_plugins",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#plugins_catalog_list_plugins\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # List the plugins in the catalog.
    # @param type [String] The type of the plugin, may be auth, secret, or database
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [PluginsCatalogListPluginsWithTypeResponse]
    def plugins_catalog_list_plugins_with_type(type, list, opts = {})
      data, _status_code, _headers = plugins_catalog_list_plugins_with_type_with_http_info(type, list, opts)
      data
    end

    # List the plugins in the catalog.
    # @param type [String] The type of the plugin, may be auth, secret, or database
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(PluginsCatalogListPluginsWithTypeResponse, Integer, Hash)>] PluginsCatalogListPluginsWithTypeResponse data, response status code and response headers
    def plugins_catalog_list_plugins_with_type_with_http_info(type, list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.plugins_catalog_list_plugins_with_type ...'
      end
      # verify the required parameter 'type' is set
      if @api_client.config.client_side_validation && type.nil?
        fail ArgumentError, "Missing the required parameter 'type' when calling SystemApi.plugins_catalog_list_plugins_with_type"
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SystemApi.plugins_catalog_list_plugins_with_type"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/sys/plugins/catalog/{type}'.sub('{' + 'type' + '}', CGI.escape(type.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PluginsCatalogListPluginsWithTypeResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.plugins_catalog_list_plugins_with_type",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#plugins_catalog_list_plugins_with_type\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Return the configuration data for the plugin with the given name.
    # @param name [String] The name of the plugin
    # @param [Hash] opts the optional parameters
    # @return [PluginsCatalogReadPluginConfigurationResponse]
    def plugins_catalog_read_plugin_configuration(name, opts = {})
      data, _status_code, _headers = plugins_catalog_read_plugin_configuration_with_http_info(name, opts)
      data
    end

    # Return the configuration data for the plugin with the given name.
    # @param name [String] The name of the plugin
    # @param [Hash] opts the optional parameters
    # @return [Array<(PluginsCatalogReadPluginConfigurationResponse, Integer, Hash)>] PluginsCatalogReadPluginConfigurationResponse data, response status code and response headers
    def plugins_catalog_read_plugin_configuration_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.plugins_catalog_read_plugin_configuration ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SystemApi.plugins_catalog_read_plugin_configuration"
      end
      # resource path
      local_var_path = '/sys/plugins/catalog/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PluginsCatalogReadPluginConfigurationResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.plugins_catalog_read_plugin_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#plugins_catalog_read_plugin_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Return the configuration data for the plugin with the given name.
    # @param name [String] The name of the plugin
    # @param type [String] The type of the plugin, may be auth, secret, or database
    # @param [Hash] opts the optional parameters
    # @return [PluginsCatalogReadPluginConfigurationWithTypeResponse]
    def plugins_catalog_read_plugin_configuration_with_type(name, type, opts = {})
      data, _status_code, _headers = plugins_catalog_read_plugin_configuration_with_type_with_http_info(name, type, opts)
      data
    end

    # Return the configuration data for the plugin with the given name.
    # @param name [String] The name of the plugin
    # @param type [String] The type of the plugin, may be auth, secret, or database
    # @param [Hash] opts the optional parameters
    # @return [Array<(PluginsCatalogReadPluginConfigurationWithTypeResponse, Integer, Hash)>] PluginsCatalogReadPluginConfigurationWithTypeResponse data, response status code and response headers
    def plugins_catalog_read_plugin_configuration_with_type_with_http_info(name, type, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.plugins_catalog_read_plugin_configuration_with_type ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SystemApi.plugins_catalog_read_plugin_configuration_with_type"
      end
      # verify the required parameter 'type' is set
      if @api_client.config.client_side_validation && type.nil?
        fail ArgumentError, "Missing the required parameter 'type' when calling SystemApi.plugins_catalog_read_plugin_configuration_with_type"
      end
      # resource path
      local_var_path = '/sys/plugins/catalog/{type}/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'type' + '}', CGI.escape(type.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PluginsCatalogReadPluginConfigurationWithTypeResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.plugins_catalog_read_plugin_configuration_with_type",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#plugins_catalog_read_plugin_configuration_with_type\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Register a new plugin, or updates an existing one with the supplied name.
    # @param name [String] The name of the plugin
    # @param plugins_catalog_register_plugin_request [PluginsCatalogRegisterPluginRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def plugins_catalog_register_plugin(name, plugins_catalog_register_plugin_request, opts = {})
      plugins_catalog_register_plugin_with_http_info(name, plugins_catalog_register_plugin_request, opts)
      nil
    end

    # Register a new plugin, or updates an existing one with the supplied name.
    # @param name [String] The name of the plugin
    # @param plugins_catalog_register_plugin_request [PluginsCatalogRegisterPluginRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def plugins_catalog_register_plugin_with_http_info(name, plugins_catalog_register_plugin_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.plugins_catalog_register_plugin ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SystemApi.plugins_catalog_register_plugin"
      end
      # verify the required parameter 'plugins_catalog_register_plugin_request' is set
      if @api_client.config.client_side_validation && plugins_catalog_register_plugin_request.nil?
        fail ArgumentError, "Missing the required parameter 'plugins_catalog_register_plugin_request' when calling SystemApi.plugins_catalog_register_plugin"
      end
      # resource path
      local_var_path = '/sys/plugins/catalog/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(plugins_catalog_register_plugin_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.plugins_catalog_register_plugin",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#plugins_catalog_register_plugin\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Register a new plugin, or updates an existing one with the supplied name.
    # @param name [String] The name of the plugin
    # @param type [String] The type of the plugin, may be auth, secret, or database
    # @param plugins_catalog_register_plugin_with_type_request [PluginsCatalogRegisterPluginWithTypeRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def plugins_catalog_register_plugin_with_type(name, type, plugins_catalog_register_plugin_with_type_request, opts = {})
      plugins_catalog_register_plugin_with_type_with_http_info(name, type, plugins_catalog_register_plugin_with_type_request, opts)
      nil
    end

    # Register a new plugin, or updates an existing one with the supplied name.
    # @param name [String] The name of the plugin
    # @param type [String] The type of the plugin, may be auth, secret, or database
    # @param plugins_catalog_register_plugin_with_type_request [PluginsCatalogRegisterPluginWithTypeRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def plugins_catalog_register_plugin_with_type_with_http_info(name, type, plugins_catalog_register_plugin_with_type_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.plugins_catalog_register_plugin_with_type ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SystemApi.plugins_catalog_register_plugin_with_type"
      end
      # verify the required parameter 'type' is set
      if @api_client.config.client_side_validation && type.nil?
        fail ArgumentError, "Missing the required parameter 'type' when calling SystemApi.plugins_catalog_register_plugin_with_type"
      end
      # verify the required parameter 'plugins_catalog_register_plugin_with_type_request' is set
      if @api_client.config.client_side_validation && plugins_catalog_register_plugin_with_type_request.nil?
        fail ArgumentError, "Missing the required parameter 'plugins_catalog_register_plugin_with_type_request' when calling SystemApi.plugins_catalog_register_plugin_with_type"
      end
      # resource path
      local_var_path = '/sys/plugins/catalog/{type}/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'type' + '}', CGI.escape(type.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(plugins_catalog_register_plugin_with_type_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.plugins_catalog_register_plugin_with_type",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#plugins_catalog_register_plugin_with_type\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Remove the plugin with the given name.
    # @param name [String] The name of the plugin
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def plugins_catalog_remove_plugin(name, opts = {})
      plugins_catalog_remove_plugin_with_http_info(name, opts)
      nil
    end

    # Remove the plugin with the given name.
    # @param name [String] The name of the plugin
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def plugins_catalog_remove_plugin_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.plugins_catalog_remove_plugin ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SystemApi.plugins_catalog_remove_plugin"
      end
      # resource path
      local_var_path = '/sys/plugins/catalog/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.plugins_catalog_remove_plugin",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#plugins_catalog_remove_plugin\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Remove the plugin with the given name.
    # @param name [String] The name of the plugin
    # @param type [String] The type of the plugin, may be auth, secret, or database
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def plugins_catalog_remove_plugin_with_type(name, type, opts = {})
      plugins_catalog_remove_plugin_with_type_with_http_info(name, type, opts)
      nil
    end

    # Remove the plugin with the given name.
    # @param name [String] The name of the plugin
    # @param type [String] The type of the plugin, may be auth, secret, or database
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def plugins_catalog_remove_plugin_with_type_with_http_info(name, type, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.plugins_catalog_remove_plugin_with_type ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SystemApi.plugins_catalog_remove_plugin_with_type"
      end
      # verify the required parameter 'type' is set
      if @api_client.config.client_side_validation && type.nil?
        fail ArgumentError, "Missing the required parameter 'type' when calling SystemApi.plugins_catalog_remove_plugin_with_type"
      end
      # resource path
      local_var_path = '/sys/plugins/catalog/{type}/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s)).sub('{' + 'type' + '}', CGI.escape(type.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.plugins_catalog_remove_plugin_with_type",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#plugins_catalog_remove_plugin_with_type\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Reload mounted plugin backends.
    # Either the plugin name (`plugin`) or the desired plugin backend mounts (`mounts`) must be provided, but not both. In the case that the plugin name is provided, all mounted paths that use that plugin backend will be reloaded.  If (`scope`) is provided and is (`global`), the plugin(s) are reloaded globally.
    # @param plugins_reload_backends_request [PluginsReloadBackendsRequest]
    # @param [Hash] opts the optional parameters
    # @return [PluginsReloadBackendsResponse]
    def plugins_reload_backends(plugins_reload_backends_request, opts = {})
      data, _status_code, _headers = plugins_reload_backends_with_http_info(plugins_reload_backends_request, opts)
      data
    end

    # Reload mounted plugin backends.
    # Either the plugin name (&#x60;plugin&#x60;) or the desired plugin backend mounts (&#x60;mounts&#x60;) must be provided, but not both. In the case that the plugin name is provided, all mounted paths that use that plugin backend will be reloaded.  If (&#x60;scope&#x60;) is provided and is (&#x60;global&#x60;), the plugin(s) are reloaded globally.
    # @param plugins_reload_backends_request [PluginsReloadBackendsRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(PluginsReloadBackendsResponse, Integer, Hash)>] PluginsReloadBackendsResponse data, response status code and response headers
    def plugins_reload_backends_with_http_info(plugins_reload_backends_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.plugins_reload_backends ...'
      end
      # verify the required parameter 'plugins_reload_backends_request' is set
      if @api_client.config.client_side_validation && plugins_reload_backends_request.nil?
        fail ArgumentError, "Missing the required parameter 'plugins_reload_backends_request' when calling SystemApi.plugins_reload_backends"
      end
      # resource path
      local_var_path = '/sys/plugins/reload/backend'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(plugins_reload_backends_request)

      # return_type
      return_type = opts[:debug_return_type] || 'PluginsReloadBackendsResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.plugins_reload_backends",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#plugins_reload_backends\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Delete the ACL policy with the given name.
    # @param name [String] The name of the policy. Example: \&quot;ops\&quot;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def policies_delete_acl_policy(name, opts = {})
      policies_delete_acl_policy_with_http_info(name, opts)
      nil
    end

    # Delete the ACL policy with the given name.
    # @param name [String] The name of the policy. Example: \&quot;ops\&quot;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def policies_delete_acl_policy_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.policies_delete_acl_policy ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SystemApi.policies_delete_acl_policy"
      end
      # resource path
      local_var_path = '/sys/policies/acl/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.policies_delete_acl_policy",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#policies_delete_acl_policy\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Delete the policy with the given name.
    # @param name [String] The name of the policy. Example: \&quot;ops\&quot;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def policies_delete_acl_policy2(name, opts = {})
      policies_delete_acl_policy2_with_http_info(name, opts)
      nil
    end

    # Delete the policy with the given name.
    # @param name [String] The name of the policy. Example: \&quot;ops\&quot;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def policies_delete_acl_policy2_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.policies_delete_acl_policy2 ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SystemApi.policies_delete_acl_policy2"
      end
      # resource path
      local_var_path = '/sys/policy/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.policies_delete_acl_policy2",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#policies_delete_acl_policy2\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Delete a password policy.
    # @param name [String] The name of the password policy.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def policies_delete_password_policy(name, opts = {})
      policies_delete_password_policy_with_http_info(name, opts)
      nil
    end

    # Delete a password policy.
    # @param name [String] The name of the password policy.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def policies_delete_password_policy_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.policies_delete_password_policy ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SystemApi.policies_delete_password_policy"
      end
      # resource path
      local_var_path = '/sys/policies/password/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.policies_delete_password_policy",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#policies_delete_password_policy\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Generate a password from an existing password policy.
    # @param name [String] The name of the password policy.
    # @param [Hash] opts the optional parameters
    # @return [PoliciesGeneratePasswordFromPasswordPolicyResponse]
    def policies_generate_password_from_password_policy(name, opts = {})
      data, _status_code, _headers = policies_generate_password_from_password_policy_with_http_info(name, opts)
      data
    end

    # Generate a password from an existing password policy.
    # @param name [String] The name of the password policy.
    # @param [Hash] opts the optional parameters
    # @return [Array<(PoliciesGeneratePasswordFromPasswordPolicyResponse, Integer, Hash)>] PoliciesGeneratePasswordFromPasswordPolicyResponse data, response status code and response headers
    def policies_generate_password_from_password_policy_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.policies_generate_password_from_password_policy ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SystemApi.policies_generate_password_from_password_policy"
      end
      # resource path
      local_var_path = '/sys/policies/password/{name}/generate'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PoliciesGeneratePasswordFromPasswordPolicyResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.policies_generate_password_from_password_policy",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#policies_generate_password_from_password_policy\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param [Hash] opts the optional parameters
    # @option opts [String] :list Return a list if &#x60;true&#x60;
    # @return [PoliciesListResponse]
    def policies_list(opts = {})
      data, _status_code, _headers = policies_list_with_http_info(opts)
      data
    end

    # @param [Hash] opts the optional parameters
    # @option opts [String] :list Return a list if &#x60;true&#x60;
    # @return [Array<(PoliciesListResponse, Integer, Hash)>] PoliciesListResponse data, response status code and response headers
    def policies_list_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.policies_list ...'
      end
      # resource path
      local_var_path = '/sys/policy'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = opts[:'list'] if !opts[:'list'].nil?

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PoliciesListResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.policies_list",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#policies_list\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [PoliciesListAclPoliciesResponse]
    def policies_list_acl_policies(list, opts = {})
      data, _status_code, _headers = policies_list_acl_policies_with_http_info(list, opts)
      data
    end

    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(PoliciesListAclPoliciesResponse, Integer, Hash)>] PoliciesListAclPoliciesResponse data, response status code and response headers
    def policies_list_acl_policies_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.policies_list_acl_policies ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SystemApi.policies_list_acl_policies"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/sys/policies/acl'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PoliciesListAclPoliciesResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.policies_list_acl_policies",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#policies_list_acl_policies\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # List the existing password policies.
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [PoliciesListPasswordPoliciesResponse]
    def policies_list_password_policies(list, opts = {})
      data, _status_code, _headers = policies_list_password_policies_with_http_info(list, opts)
      data
    end

    # List the existing password policies.
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(PoliciesListPasswordPoliciesResponse, Integer, Hash)>] PoliciesListPasswordPoliciesResponse data, response status code and response headers
    def policies_list_password_policies_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.policies_list_password_policies ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SystemApi.policies_list_password_policies"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/sys/policies/password'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PoliciesListPasswordPoliciesResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.policies_list_password_policies",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#policies_list_password_policies\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Retrieve information about the named ACL policy.
    # @param name [String] The name of the policy. Example: \&quot;ops\&quot;
    # @param [Hash] opts the optional parameters
    # @return [PoliciesReadAclPolicyResponse]
    def policies_read_acl_policy(name, opts = {})
      data, _status_code, _headers = policies_read_acl_policy_with_http_info(name, opts)
      data
    end

    # Retrieve information about the named ACL policy.
    # @param name [String] The name of the policy. Example: \&quot;ops\&quot;
    # @param [Hash] opts the optional parameters
    # @return [Array<(PoliciesReadAclPolicyResponse, Integer, Hash)>] PoliciesReadAclPolicyResponse data, response status code and response headers
    def policies_read_acl_policy_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.policies_read_acl_policy ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SystemApi.policies_read_acl_policy"
      end
      # resource path
      local_var_path = '/sys/policies/acl/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PoliciesReadAclPolicyResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.policies_read_acl_policy",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#policies_read_acl_policy\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Retrieve the policy body for the named policy.
    # @param name [String] The name of the policy. Example: \&quot;ops\&quot;
    # @param [Hash] opts the optional parameters
    # @return [PoliciesReadAclPolicy2Response]
    def policies_read_acl_policy2(name, opts = {})
      data, _status_code, _headers = policies_read_acl_policy2_with_http_info(name, opts)
      data
    end

    # Retrieve the policy body for the named policy.
    # @param name [String] The name of the policy. Example: \&quot;ops\&quot;
    # @param [Hash] opts the optional parameters
    # @return [Array<(PoliciesReadAclPolicy2Response, Integer, Hash)>] PoliciesReadAclPolicy2Response data, response status code and response headers
    def policies_read_acl_policy2_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.policies_read_acl_policy2 ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SystemApi.policies_read_acl_policy2"
      end
      # resource path
      local_var_path = '/sys/policy/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PoliciesReadAclPolicy2Response'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.policies_read_acl_policy2",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#policies_read_acl_policy2\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Retrieve an existing password policy.
    # @param name [String] The name of the password policy.
    # @param [Hash] opts the optional parameters
    # @return [PoliciesReadPasswordPolicyResponse]
    def policies_read_password_policy(name, opts = {})
      data, _status_code, _headers = policies_read_password_policy_with_http_info(name, opts)
      data
    end

    # Retrieve an existing password policy.
    # @param name [String] The name of the password policy.
    # @param [Hash] opts the optional parameters
    # @return [Array<(PoliciesReadPasswordPolicyResponse, Integer, Hash)>] PoliciesReadPasswordPolicyResponse data, response status code and response headers
    def policies_read_password_policy_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.policies_read_password_policy ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SystemApi.policies_read_password_policy"
      end
      # resource path
      local_var_path = '/sys/policies/password/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'PoliciesReadPasswordPolicyResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.policies_read_password_policy",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#policies_read_password_policy\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Add a new or update an existing ACL policy.
    # @param name [String] The name of the policy. Example: \&quot;ops\&quot;
    # @param policies_write_acl_policy_request [PoliciesWriteAclPolicyRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def policies_write_acl_policy(name, policies_write_acl_policy_request, opts = {})
      policies_write_acl_policy_with_http_info(name, policies_write_acl_policy_request, opts)
      nil
    end

    # Add a new or update an existing ACL policy.
    # @param name [String] The name of the policy. Example: \&quot;ops\&quot;
    # @param policies_write_acl_policy_request [PoliciesWriteAclPolicyRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def policies_write_acl_policy_with_http_info(name, policies_write_acl_policy_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.policies_write_acl_policy ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SystemApi.policies_write_acl_policy"
      end
      # verify the required parameter 'policies_write_acl_policy_request' is set
      if @api_client.config.client_side_validation && policies_write_acl_policy_request.nil?
        fail ArgumentError, "Missing the required parameter 'policies_write_acl_policy_request' when calling SystemApi.policies_write_acl_policy"
      end
      # resource path
      local_var_path = '/sys/policies/acl/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(policies_write_acl_policy_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.policies_write_acl_policy",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#policies_write_acl_policy\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Add a new or update an existing policy.
    # @param name [String] The name of the policy. Example: \&quot;ops\&quot;
    # @param policies_write_acl_policy2_request [PoliciesWriteAclPolicy2Request]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def policies_write_acl_policy2(name, policies_write_acl_policy2_request, opts = {})
      policies_write_acl_policy2_with_http_info(name, policies_write_acl_policy2_request, opts)
      nil
    end

    # Add a new or update an existing policy.
    # @param name [String] The name of the policy. Example: \&quot;ops\&quot;
    # @param policies_write_acl_policy2_request [PoliciesWriteAclPolicy2Request]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def policies_write_acl_policy2_with_http_info(name, policies_write_acl_policy2_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.policies_write_acl_policy2 ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SystemApi.policies_write_acl_policy2"
      end
      # verify the required parameter 'policies_write_acl_policy2_request' is set
      if @api_client.config.client_side_validation && policies_write_acl_policy2_request.nil?
        fail ArgumentError, "Missing the required parameter 'policies_write_acl_policy2_request' when calling SystemApi.policies_write_acl_policy2"
      end
      # resource path
      local_var_path = '/sys/policy/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(policies_write_acl_policy2_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.policies_write_acl_policy2",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#policies_write_acl_policy2\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Add a new or update an existing password policy.
    # @param name [String] The name of the password policy.
    # @param policies_write_password_policy_request [PoliciesWritePasswordPolicyRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def policies_write_password_policy(name, policies_write_password_policy_request, opts = {})
      policies_write_password_policy_with_http_info(name, policies_write_password_policy_request, opts)
      nil
    end

    # Add a new or update an existing password policy.
    # @param name [String] The name of the password policy.
    # @param policies_write_password_policy_request [PoliciesWritePasswordPolicyRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def policies_write_password_policy_with_http_info(name, policies_write_password_policy_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.policies_write_password_policy ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SystemApi.policies_write_password_policy"
      end
      # verify the required parameter 'policies_write_password_policy_request' is set
      if @api_client.config.client_side_validation && policies_write_password_policy_request.nil?
        fail ArgumentError, "Missing the required parameter 'policies_write_password_policy_request' when calling SystemApi.policies_write_password_policy"
      end
      # resource path
      local_var_path = '/sys/policies/password/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(policies_write_password_policy_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.policies_write_password_policy",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#policies_write_password_policy\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Returns stack traces that led to blocking on synchronization primitives
    # Returns stack traces that led to blocking on synchronization primitives
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pprof_blocking(opts = {})
      pprof_blocking_with_http_info(opts)
      nil
    end

    # Returns stack traces that led to blocking on synchronization primitives
    # Returns stack traces that led to blocking on synchronization primitives
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pprof_blocking_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.pprof_blocking ...'
      end
      # resource path
      local_var_path = '/sys/pprof/block'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.pprof_blocking",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#pprof_blocking\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Returns the running program's command line.
    # Returns the running program's command line, with arguments separated by NUL bytes.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pprof_command_line(opts = {})
      pprof_command_line_with_http_info(opts)
      nil
    end

    # Returns the running program&#39;s command line.
    # Returns the running program&#39;s command line, with arguments separated by NUL bytes.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pprof_command_line_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.pprof_command_line ...'
      end
      # resource path
      local_var_path = '/sys/pprof/cmdline'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.pprof_command_line",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#pprof_command_line\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Returns a pprof-formatted cpu profile payload.
    # Returns a pprof-formatted cpu profile payload. Profiling lasts for duration specified in seconds GET parameter, or for 30 seconds if not specified.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pprof_cpu_profile(opts = {})
      pprof_cpu_profile_with_http_info(opts)
      nil
    end

    # Returns a pprof-formatted cpu profile payload.
    # Returns a pprof-formatted cpu profile payload. Profiling lasts for duration specified in seconds GET parameter, or for 30 seconds if not specified.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pprof_cpu_profile_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.pprof_cpu_profile ...'
      end
      # resource path
      local_var_path = '/sys/pprof/profile'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.pprof_cpu_profile",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#pprof_cpu_profile\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Returns the execution trace in binary form.
    # Returns  the execution trace in binary form. Tracing lasts for duration specified in seconds GET parameter, or for 1 second if not specified.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pprof_execution_trace(opts = {})
      pprof_execution_trace_with_http_info(opts)
      nil
    end

    # Returns the execution trace in binary form.
    # Returns  the execution trace in binary form. Tracing lasts for duration specified in seconds GET parameter, or for 1 second if not specified.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pprof_execution_trace_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.pprof_execution_trace ...'
      end
      # resource path
      local_var_path = '/sys/pprof/trace'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.pprof_execution_trace",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#pprof_execution_trace\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Returns stack traces of all current goroutines.
    # Returns stack traces of all current goroutines.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pprof_goroutines(opts = {})
      pprof_goroutines_with_http_info(opts)
      nil
    end

    # Returns stack traces of all current goroutines.
    # Returns stack traces of all current goroutines.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pprof_goroutines_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.pprof_goroutines ...'
      end
      # resource path
      local_var_path = '/sys/pprof/goroutine'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.pprof_goroutines",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#pprof_goroutines\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Returns an HTML page listing the available profiles.
    # Returns an HTML page listing the available  profiles. This should be mainly accessed via browsers or applications that can  render pages.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pprof_index(opts = {})
      pprof_index_with_http_info(opts)
      nil
    end

    # Returns an HTML page listing the available profiles.
    # Returns an HTML page listing the available  profiles. This should be mainly accessed via browsers or applications that can  render pages.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pprof_index_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.pprof_index ...'
      end
      # resource path
      local_var_path = '/sys/pprof'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.pprof_index",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#pprof_index\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Returns a sampling of all past memory allocations.
    # Returns a sampling of all past memory allocations.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pprof_memory_allocations(opts = {})
      pprof_memory_allocations_with_http_info(opts)
      nil
    end

    # Returns a sampling of all past memory allocations.
    # Returns a sampling of all past memory allocations.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pprof_memory_allocations_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.pprof_memory_allocations ...'
      end
      # resource path
      local_var_path = '/sys/pprof/allocs'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.pprof_memory_allocations",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#pprof_memory_allocations\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Returns a sampling of memory allocations of live object.
    # Returns a sampling of memory allocations of live object.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pprof_memory_allocations_live(opts = {})
      pprof_memory_allocations_live_with_http_info(opts)
      nil
    end

    # Returns a sampling of memory allocations of live object.
    # Returns a sampling of memory allocations of live object.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pprof_memory_allocations_live_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.pprof_memory_allocations_live ...'
      end
      # resource path
      local_var_path = '/sys/pprof/heap'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.pprof_memory_allocations_live",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#pprof_memory_allocations_live\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Returns stack traces of holders of contended mutexes
    # Returns stack traces of holders of contended mutexes
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pprof_mutexes(opts = {})
      pprof_mutexes_with_http_info(opts)
      nil
    end

    # Returns stack traces of holders of contended mutexes
    # Returns stack traces of holders of contended mutexes
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pprof_mutexes_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.pprof_mutexes ...'
      end
      # resource path
      local_var_path = '/sys/pprof/mutex'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.pprof_mutexes",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#pprof_mutexes\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Returns the program counters listed in the request.
    # Returns the program counters listed in the request.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pprof_symbols(opts = {})
      pprof_symbols_with_http_info(opts)
      nil
    end

    # Returns the program counters listed in the request.
    # Returns the program counters listed in the request.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pprof_symbols_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.pprof_symbols ...'
      end
      # resource path
      local_var_path = '/sys/pprof/symbol'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.pprof_symbols",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#pprof_symbols\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Returns stack traces that led to the creation of new OS threads
    # Returns stack traces that led to the creation of new OS threads
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def pprof_thread_creations(opts = {})
      pprof_thread_creations_with_http_info(opts)
      nil
    end

    # Returns stack traces that led to the creation of new OS threads
    # Returns stack traces that led to the creation of new OS threads
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def pprof_thread_creations_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.pprof_thread_creations ...'
      end
      # resource path
      local_var_path = '/sys/pprof/threadcreate'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.pprof_thread_creations",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#pprof_thread_creations\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param query_token_accessor_capabilities_request [QueryTokenAccessorCapabilitiesRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def query_token_accessor_capabilities(query_token_accessor_capabilities_request, opts = {})
      query_token_accessor_capabilities_with_http_info(query_token_accessor_capabilities_request, opts)
      nil
    end

    # @param query_token_accessor_capabilities_request [QueryTokenAccessorCapabilitiesRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def query_token_accessor_capabilities_with_http_info(query_token_accessor_capabilities_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.query_token_accessor_capabilities ...'
      end
      # verify the required parameter 'query_token_accessor_capabilities_request' is set
      if @api_client.config.client_side_validation && query_token_accessor_capabilities_request.nil?
        fail ArgumentError, "Missing the required parameter 'query_token_accessor_capabilities_request' when calling SystemApi.query_token_accessor_capabilities"
      end
      # resource path
      local_var_path = '/sys/capabilities-accessor'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(query_token_accessor_capabilities_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.query_token_accessor_capabilities",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#query_token_accessor_capabilities\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param query_token_capabilities_request [QueryTokenCapabilitiesRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def query_token_capabilities(query_token_capabilities_request, opts = {})
      query_token_capabilities_with_http_info(query_token_capabilities_request, opts)
      nil
    end

    # @param query_token_capabilities_request [QueryTokenCapabilitiesRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def query_token_capabilities_with_http_info(query_token_capabilities_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.query_token_capabilities ...'
      end
      # verify the required parameter 'query_token_capabilities_request' is set
      if @api_client.config.client_side_validation && query_token_capabilities_request.nil?
        fail ArgumentError, "Missing the required parameter 'query_token_capabilities_request' when calling SystemApi.query_token_capabilities"
      end
      # resource path
      local_var_path = '/sys/capabilities'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(query_token_capabilities_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.query_token_capabilities",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#query_token_capabilities\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param query_token_self_capabilities_request [QueryTokenSelfCapabilitiesRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def query_token_self_capabilities(query_token_self_capabilities_request, opts = {})
      query_token_self_capabilities_with_http_info(query_token_self_capabilities_request, opts)
      nil
    end

    # @param query_token_self_capabilities_request [QueryTokenSelfCapabilitiesRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def query_token_self_capabilities_with_http_info(query_token_self_capabilities_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.query_token_self_capabilities ...'
      end
      # verify the required parameter 'query_token_self_capabilities_request' is set
      if @api_client.config.client_side_validation && query_token_self_capabilities_request.nil?
        fail ArgumentError, "Missing the required parameter 'query_token_self_capabilities_request' when calling SystemApi.query_token_self_capabilities"
      end
      # resource path
      local_var_path = '/sys/capabilities-self'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(query_token_self_capabilities_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.query_token_self_capabilities",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#query_token_self_capabilities\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param rate_limit_quotas_configure_request [RateLimitQuotasConfigureRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def rate_limit_quotas_configure(rate_limit_quotas_configure_request, opts = {})
      rate_limit_quotas_configure_with_http_info(rate_limit_quotas_configure_request, opts)
      nil
    end

    # @param rate_limit_quotas_configure_request [RateLimitQuotasConfigureRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def rate_limit_quotas_configure_with_http_info(rate_limit_quotas_configure_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.rate_limit_quotas_configure ...'
      end
      # verify the required parameter 'rate_limit_quotas_configure_request' is set
      if @api_client.config.client_side_validation && rate_limit_quotas_configure_request.nil?
        fail ArgumentError, "Missing the required parameter 'rate_limit_quotas_configure_request' when calling SystemApi.rate_limit_quotas_configure"
      end
      # resource path
      local_var_path = '/sys/quotas/config'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(rate_limit_quotas_configure_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.rate_limit_quotas_configure",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#rate_limit_quotas_configure\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the quota rule.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def rate_limit_quotas_delete(name, opts = {})
      rate_limit_quotas_delete_with_http_info(name, opts)
      nil
    end

    # @param name [String] Name of the quota rule.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def rate_limit_quotas_delete_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.rate_limit_quotas_delete ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SystemApi.rate_limit_quotas_delete"
      end
      # resource path
      local_var_path = '/sys/quotas/rate-limit/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.rate_limit_quotas_delete",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#rate_limit_quotas_delete\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [RateLimitQuotasListResponse]
    def rate_limit_quotas_list(list, opts = {})
      data, _status_code, _headers = rate_limit_quotas_list_with_http_info(list, opts)
      data
    end

    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(RateLimitQuotasListResponse, Integer, Hash)>] RateLimitQuotasListResponse data, response status code and response headers
    def rate_limit_quotas_list_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.rate_limit_quotas_list ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SystemApi.rate_limit_quotas_list"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/sys/quotas/rate-limit'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'RateLimitQuotasListResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.rate_limit_quotas_list",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#rate_limit_quotas_list\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the quota rule.
    # @param [Hash] opts the optional parameters
    # @return [RateLimitQuotasReadResponse]
    def rate_limit_quotas_read(name, opts = {})
      data, _status_code, _headers = rate_limit_quotas_read_with_http_info(name, opts)
      data
    end

    # @param name [String] Name of the quota rule.
    # @param [Hash] opts the optional parameters
    # @return [Array<(RateLimitQuotasReadResponse, Integer, Hash)>] RateLimitQuotasReadResponse data, response status code and response headers
    def rate_limit_quotas_read_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.rate_limit_quotas_read ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SystemApi.rate_limit_quotas_read"
      end
      # resource path
      local_var_path = '/sys/quotas/rate-limit/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'RateLimitQuotasReadResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.rate_limit_quotas_read",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#rate_limit_quotas_read\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param [Hash] opts the optional parameters
    # @return [RateLimitQuotasReadConfigurationResponse]
    def rate_limit_quotas_read_configuration(opts = {})
      data, _status_code, _headers = rate_limit_quotas_read_configuration_with_http_info(opts)
      data
    end

    # @param [Hash] opts the optional parameters
    # @return [Array<(RateLimitQuotasReadConfigurationResponse, Integer, Hash)>] RateLimitQuotasReadConfigurationResponse data, response status code and response headers
    def rate_limit_quotas_read_configuration_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.rate_limit_quotas_read_configuration ...'
      end
      # resource path
      local_var_path = '/sys/quotas/config'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'RateLimitQuotasReadConfigurationResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.rate_limit_quotas_read_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#rate_limit_quotas_read_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the quota rule.
    # @param rate_limit_quotas_write_request [RateLimitQuotasWriteRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def rate_limit_quotas_write(name, rate_limit_quotas_write_request, opts = {})
      rate_limit_quotas_write_with_http_info(name, rate_limit_quotas_write_request, opts)
      nil
    end

    # @param name [String] Name of the quota rule.
    # @param rate_limit_quotas_write_request [RateLimitQuotasWriteRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def rate_limit_quotas_write_with_http_info(name, rate_limit_quotas_write_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.rate_limit_quotas_write ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling SystemApi.rate_limit_quotas_write"
      end
      # verify the required parameter 'rate_limit_quotas_write_request' is set
      if @api_client.config.client_side_validation && rate_limit_quotas_write_request.nil?
        fail ArgumentError, "Missing the required parameter 'rate_limit_quotas_write_request' when calling SystemApi.rate_limit_quotas_write"
      end
      # resource path
      local_var_path = '/sys/quotas/rate-limit/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(rate_limit_quotas_write_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.rate_limit_quotas_write",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#rate_limit_quotas_write\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Delete the key with given path.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def raw_delete(opts = {})
      raw_delete_with_http_info(opts)
      nil
    end

    # Delete the key with given path.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def raw_delete_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.raw_delete ...'
      end
      # resource path
      local_var_path = '/sys/raw'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.raw_delete",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#raw_delete\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Delete the key with given path.
    # @param path [String]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def raw_delete_path(path, opts = {})
      raw_delete_path_with_http_info(path, opts)
      nil
    end

    # Delete the key with given path.
    # @param path [String]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def raw_delete_path_with_http_info(path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.raw_delete_path ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SystemApi.raw_delete_path"
      end
      # resource path
      local_var_path = '/sys/raw/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.raw_delete_path",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#raw_delete_path\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Read the value of the key at the given path.
    # @param [Hash] opts the optional parameters
    # @option opts [String] :list Return a list if &#x60;true&#x60;
    # @return [RawReadResponse]
    def raw_read(opts = {})
      data, _status_code, _headers = raw_read_with_http_info(opts)
      data
    end

    # Read the value of the key at the given path.
    # @param [Hash] opts the optional parameters
    # @option opts [String] :list Return a list if &#x60;true&#x60;
    # @return [Array<(RawReadResponse, Integer, Hash)>] RawReadResponse data, response status code and response headers
    def raw_read_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.raw_read ...'
      end
      # resource path
      local_var_path = '/sys/raw'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = opts[:'list'] if !opts[:'list'].nil?

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'RawReadResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.raw_read",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#raw_read\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Read the value of the key at the given path.
    # @param path [String]
    # @param [Hash] opts the optional parameters
    # @option opts [String] :list Return a list if &#x60;true&#x60;
    # @return [RawReadPathResponse]
    def raw_read_path(path, opts = {})
      data, _status_code, _headers = raw_read_path_with_http_info(path, opts)
      data
    end

    # Read the value of the key at the given path.
    # @param path [String]
    # @param [Hash] opts the optional parameters
    # @option opts [String] :list Return a list if &#x60;true&#x60;
    # @return [Array<(RawReadPathResponse, Integer, Hash)>] RawReadPathResponse data, response status code and response headers
    def raw_read_path_with_http_info(path, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.raw_read_path ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SystemApi.raw_read_path"
      end
      # resource path
      local_var_path = '/sys/raw/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = opts[:'list'] if !opts[:'list'].nil?

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'RawReadPathResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.raw_read_path",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#raw_read_path\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Update the value of the key at the given path.
    # @param raw_write_request [RawWriteRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def raw_write(raw_write_request, opts = {})
      raw_write_with_http_info(raw_write_request, opts)
      nil
    end

    # Update the value of the key at the given path.
    # @param raw_write_request [RawWriteRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def raw_write_with_http_info(raw_write_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.raw_write ...'
      end
      # verify the required parameter 'raw_write_request' is set
      if @api_client.config.client_side_validation && raw_write_request.nil?
        fail ArgumentError, "Missing the required parameter 'raw_write_request' when calling SystemApi.raw_write"
      end
      # resource path
      local_var_path = '/sys/raw'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(raw_write_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.raw_write",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#raw_write\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Update the value of the key at the given path.
    # @param path [String]
    # @param raw_write_path_request [RawWritePathRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def raw_write_path(path, raw_write_path_request, opts = {})
      raw_write_path_with_http_info(path, raw_write_path_request, opts)
      nil
    end

    # Update the value of the key at the given path.
    # @param path [String]
    # @param raw_write_path_request [RawWritePathRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def raw_write_path_with_http_info(path, raw_write_path_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.raw_write_path ...'
      end
      # verify the required parameter 'path' is set
      if @api_client.config.client_side_validation && path.nil?
        fail ArgumentError, "Missing the required parameter 'path' when calling SystemApi.raw_write_path"
      end
      # verify the required parameter 'raw_write_path_request' is set
      if @api_client.config.client_side_validation && raw_write_path_request.nil?
        fail ArgumentError, "Missing the required parameter 'raw_write_path_request' when calling SystemApi.raw_write_path"
      end
      # resource path
      local_var_path = '/sys/raw/{path}'.sub('{' + 'path' + '}', CGI.escape(path.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(raw_write_path_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.raw_write_path",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#raw_write_path\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Returns the health status of OpenBao.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def read_health_status(opts = {})
      read_health_status_with_http_info(opts)
      nil
    end

    # Returns the health status of OpenBao.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def read_health_status_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.read_health_status ...'
      end
      # resource path
      local_var_path = '/sys/health'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.read_health_status",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#read_health_status\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Returns the initialization status of OpenBao.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def read_initialization_status(opts = {})
      read_initialization_status_with_http_info(opts)
      nil
    end

    # Returns the initialization status of OpenBao.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def read_initialization_status_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.read_initialization_status ...'
      end
      # resource path
      local_var_path = '/sys/init'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.read_initialization_status",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#read_initialization_status\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Return a sanitized version of the OpenBao server configuration.
    # The sanitized output strips configuration values in the storage, HA storage, and seals stanzas, which may contain sensitive values such as API tokens. It also removes any token or secret fields in other stanzas, such as the circonus_api_token from telemetry.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def read_sanitized_configuration_state(opts = {})
      read_sanitized_configuration_state_with_http_info(opts)
      nil
    end

    # Return a sanitized version of the OpenBao server configuration.
    # The sanitized output strips configuration values in the storage, HA storage, and seals stanzas, which may contain sensitive values such as API tokens. It also removes any token or secret fields in other stanzas, such as the circonus_api_token from telemetry.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def read_sanitized_configuration_state_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.read_sanitized_configuration_state ...'
      end
      # resource path
      local_var_path = '/sys/config/state/sanitized'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.read_sanitized_configuration_state",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#read_sanitized_configuration_state\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Look up wrapping properties for the given token.
    # @param read_wrapping_properties_request [ReadWrappingPropertiesRequest]
    # @param [Hash] opts the optional parameters
    # @return [ReadWrappingPropertiesResponse]
    def read_wrapping_properties(read_wrapping_properties_request, opts = {})
      data, _status_code, _headers = read_wrapping_properties_with_http_info(read_wrapping_properties_request, opts)
      data
    end

    # Look up wrapping properties for the given token.
    # @param read_wrapping_properties_request [ReadWrappingPropertiesRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(ReadWrappingPropertiesResponse, Integer, Hash)>] ReadWrappingPropertiesResponse data, response status code and response headers
    def read_wrapping_properties_with_http_info(read_wrapping_properties_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.read_wrapping_properties ...'
      end
      # verify the required parameter 'read_wrapping_properties_request' is set
      if @api_client.config.client_side_validation && read_wrapping_properties_request.nil?
        fail ArgumentError, "Missing the required parameter 'read_wrapping_properties_request' when calling SystemApi.read_wrapping_properties"
      end
      # resource path
      local_var_path = '/sys/wrapping/lookup'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(read_wrapping_properties_request)

      # return_type
      return_type = opts[:debug_return_type] || 'ReadWrappingPropertiesResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.read_wrapping_properties",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#read_wrapping_properties\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Look up wrapping properties for the requester's token.
    # @param [Hash] opts the optional parameters
    # @return [ReadWrappingProperties2Response]
    def read_wrapping_properties2(opts = {})
      data, _status_code, _headers = read_wrapping_properties2_with_http_info(opts)
      data
    end

    # Look up wrapping properties for the requester&#39;s token.
    # @param [Hash] opts the optional parameters
    # @return [Array<(ReadWrappingProperties2Response, Integer, Hash)>] ReadWrappingProperties2Response data, response status code and response headers
    def read_wrapping_properties2_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.read_wrapping_properties2 ...'
      end
      # resource path
      local_var_path = '/sys/wrapping/lookup'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'ReadWrappingProperties2Response'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.read_wrapping_properties2",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#read_wrapping_properties2\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Cancels any in-progress rekey.
    # This clears the rekey settings as well as any progress made. This must be called to change the parameters of the rekey. Note: verification is still a part of a rekey. If rekeying is canceled during the verification flow, the current unseal keys remain valid.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def rekey_attempt_cancel(opts = {})
      rekey_attempt_cancel_with_http_info(opts)
      nil
    end

    # Cancels any in-progress rekey.
    # This clears the rekey settings as well as any progress made. This must be called to change the parameters of the rekey. Note: verification is still a part of a rekey. If rekeying is canceled during the verification flow, the current unseal keys remain valid.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def rekey_attempt_cancel_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.rekey_attempt_cancel ...'
      end
      # resource path
      local_var_path = '/sys/rekey/init'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.rekey_attempt_cancel",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#rekey_attempt_cancel\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Initializes a new rekey attempt.
    # Only a single rekey attempt can take place at a time, and changing the parameters of a rekey requires canceling and starting a new rekey, which will also provide a new nonce.
    # @param rekey_attempt_initialize_request [RekeyAttemptInitializeRequest]
    # @param [Hash] opts the optional parameters
    # @return [RekeyAttemptInitializeResponse]
    def rekey_attempt_initialize(rekey_attempt_initialize_request, opts = {})
      data, _status_code, _headers = rekey_attempt_initialize_with_http_info(rekey_attempt_initialize_request, opts)
      data
    end

    # Initializes a new rekey attempt.
    # Only a single rekey attempt can take place at a time, and changing the parameters of a rekey requires canceling and starting a new rekey, which will also provide a new nonce.
    # @param rekey_attempt_initialize_request [RekeyAttemptInitializeRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(RekeyAttemptInitializeResponse, Integer, Hash)>] RekeyAttemptInitializeResponse data, response status code and response headers
    def rekey_attempt_initialize_with_http_info(rekey_attempt_initialize_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.rekey_attempt_initialize ...'
      end
      # verify the required parameter 'rekey_attempt_initialize_request' is set
      if @api_client.config.client_side_validation && rekey_attempt_initialize_request.nil?
        fail ArgumentError, "Missing the required parameter 'rekey_attempt_initialize_request' when calling SystemApi.rekey_attempt_initialize"
      end
      # resource path
      local_var_path = '/sys/rekey/init'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(rekey_attempt_initialize_request)

      # return_type
      return_type = opts[:debug_return_type] || 'RekeyAttemptInitializeResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.rekey_attempt_initialize",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#rekey_attempt_initialize\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Reads the configuration and progress of the current rekey attempt.
    # @param [Hash] opts the optional parameters
    # @return [RekeyAttemptReadProgressResponse]
    def rekey_attempt_read_progress(opts = {})
      data, _status_code, _headers = rekey_attempt_read_progress_with_http_info(opts)
      data
    end

    # Reads the configuration and progress of the current rekey attempt.
    # @param [Hash] opts the optional parameters
    # @return [Array<(RekeyAttemptReadProgressResponse, Integer, Hash)>] RekeyAttemptReadProgressResponse data, response status code and response headers
    def rekey_attempt_read_progress_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.rekey_attempt_read_progress ...'
      end
      # resource path
      local_var_path = '/sys/rekey/init'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'RekeyAttemptReadProgressResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.rekey_attempt_read_progress",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#rekey_attempt_read_progress\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Enter a single unseal key share to progress the rekey of the OpenBao.
    # @param rekey_attempt_update_request [RekeyAttemptUpdateRequest]
    # @param [Hash] opts the optional parameters
    # @return [RekeyAttemptUpdateResponse]
    def rekey_attempt_update(rekey_attempt_update_request, opts = {})
      data, _status_code, _headers = rekey_attempt_update_with_http_info(rekey_attempt_update_request, opts)
      data
    end

    # Enter a single unseal key share to progress the rekey of the OpenBao.
    # @param rekey_attempt_update_request [RekeyAttemptUpdateRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(RekeyAttemptUpdateResponse, Integer, Hash)>] RekeyAttemptUpdateResponse data, response status code and response headers
    def rekey_attempt_update_with_http_info(rekey_attempt_update_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.rekey_attempt_update ...'
      end
      # verify the required parameter 'rekey_attempt_update_request' is set
      if @api_client.config.client_side_validation && rekey_attempt_update_request.nil?
        fail ArgumentError, "Missing the required parameter 'rekey_attempt_update_request' when calling SystemApi.rekey_attempt_update"
      end
      # resource path
      local_var_path = '/sys/rekey/update'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(rekey_attempt_update_request)

      # return_type
      return_type = opts[:debug_return_type] || 'RekeyAttemptUpdateResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.rekey_attempt_update",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#rekey_attempt_update\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Delete the backup copy of PGP-encrypted unseal keys.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def rekey_delete_backup_key(opts = {})
      rekey_delete_backup_key_with_http_info(opts)
      nil
    end

    # Delete the backup copy of PGP-encrypted unseal keys.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def rekey_delete_backup_key_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.rekey_delete_backup_key ...'
      end
      # resource path
      local_var_path = '/sys/rekey/backup'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.rekey_delete_backup_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#rekey_delete_backup_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param [Hash] opts the optional parameters
    # @return [nil]
    def rekey_delete_backup_recovery_key(opts = {})
      rekey_delete_backup_recovery_key_with_http_info(opts)
      nil
    end

    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def rekey_delete_backup_recovery_key_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.rekey_delete_backup_recovery_key ...'
      end
      # resource path
      local_var_path = '/sys/rekey/recovery-key-backup'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.rekey_delete_backup_recovery_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#rekey_delete_backup_recovery_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Return the backup copy of PGP-encrypted unseal keys.
    # @param [Hash] opts the optional parameters
    # @return [RekeyReadBackupKeyResponse]
    def rekey_read_backup_key(opts = {})
      data, _status_code, _headers = rekey_read_backup_key_with_http_info(opts)
      data
    end

    # Return the backup copy of PGP-encrypted unseal keys.
    # @param [Hash] opts the optional parameters
    # @return [Array<(RekeyReadBackupKeyResponse, Integer, Hash)>] RekeyReadBackupKeyResponse data, response status code and response headers
    def rekey_read_backup_key_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.rekey_read_backup_key ...'
      end
      # resource path
      local_var_path = '/sys/rekey/backup'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'RekeyReadBackupKeyResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.rekey_read_backup_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#rekey_read_backup_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param [Hash] opts the optional parameters
    # @return [RekeyReadBackupRecoveryKeyResponse]
    def rekey_read_backup_recovery_key(opts = {})
      data, _status_code, _headers = rekey_read_backup_recovery_key_with_http_info(opts)
      data
    end

    # @param [Hash] opts the optional parameters
    # @return [Array<(RekeyReadBackupRecoveryKeyResponse, Integer, Hash)>] RekeyReadBackupRecoveryKeyResponse data, response status code and response headers
    def rekey_read_backup_recovery_key_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.rekey_read_backup_recovery_key ...'
      end
      # resource path
      local_var_path = '/sys/rekey/recovery-key-backup'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'RekeyReadBackupRecoveryKeyResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.rekey_read_backup_recovery_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#rekey_read_backup_recovery_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Cancel any in-progress rekey verification operation.
    # This clears any progress made and resets the nonce. Unlike a `DELETE` against `sys/rekey/init`, this only resets the current verification operation, not the entire rekey atttempt.
    # @param [Hash] opts the optional parameters
    # @return [RekeyVerificationCancelResponse]
    def rekey_verification_cancel(opts = {})
      data, _status_code, _headers = rekey_verification_cancel_with_http_info(opts)
      data
    end

    # Cancel any in-progress rekey verification operation.
    # This clears any progress made and resets the nonce. Unlike a &#x60;DELETE&#x60; against &#x60;sys/rekey/init&#x60;, this only resets the current verification operation, not the entire rekey atttempt.
    # @param [Hash] opts the optional parameters
    # @return [Array<(RekeyVerificationCancelResponse, Integer, Hash)>] RekeyVerificationCancelResponse data, response status code and response headers
    def rekey_verification_cancel_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.rekey_verification_cancel ...'
      end
      # resource path
      local_var_path = '/sys/rekey/verify'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'RekeyVerificationCancelResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.rekey_verification_cancel",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#rekey_verification_cancel\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Read the configuration and progress of the current rekey verification attempt.
    # @param [Hash] opts the optional parameters
    # @return [RekeyVerificationReadProgressResponse]
    def rekey_verification_read_progress(opts = {})
      data, _status_code, _headers = rekey_verification_read_progress_with_http_info(opts)
      data
    end

    # Read the configuration and progress of the current rekey verification attempt.
    # @param [Hash] opts the optional parameters
    # @return [Array<(RekeyVerificationReadProgressResponse, Integer, Hash)>] RekeyVerificationReadProgressResponse data, response status code and response headers
    def rekey_verification_read_progress_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.rekey_verification_read_progress ...'
      end
      # resource path
      local_var_path = '/sys/rekey/verify'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'RekeyVerificationReadProgressResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.rekey_verification_read_progress",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#rekey_verification_read_progress\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Enter a single new key share to progress the rekey verification operation.
    # @param rekey_verification_update_request [RekeyVerificationUpdateRequest]
    # @param [Hash] opts the optional parameters
    # @return [RekeyVerificationUpdateResponse]
    def rekey_verification_update(rekey_verification_update_request, opts = {})
      data, _status_code, _headers = rekey_verification_update_with_http_info(rekey_verification_update_request, opts)
      data
    end

    # Enter a single new key share to progress the rekey verification operation.
    # @param rekey_verification_update_request [RekeyVerificationUpdateRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(RekeyVerificationUpdateResponse, Integer, Hash)>] RekeyVerificationUpdateResponse data, response status code and response headers
    def rekey_verification_update_with_http_info(rekey_verification_update_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.rekey_verification_update ...'
      end
      # verify the required parameter 'rekey_verification_update_request' is set
      if @api_client.config.client_side_validation && rekey_verification_update_request.nil?
        fail ArgumentError, "Missing the required parameter 'rekey_verification_update_request' when calling SystemApi.rekey_verification_update"
      end
      # resource path
      local_var_path = '/sys/rekey/verify'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(rekey_verification_update_request)

      # return_type
      return_type = opts[:debug_return_type] || 'RekeyVerificationUpdateResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.rekey_verification_update",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#rekey_verification_update\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Reload the given subsystem
    # @param subsystem [String]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def reload_subsystem(subsystem, opts = {})
      reload_subsystem_with_http_info(subsystem, opts)
      nil
    end

    # Reload the given subsystem
    # @param subsystem [String]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def reload_subsystem_with_http_info(subsystem, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.reload_subsystem ...'
      end
      # verify the required parameter 'subsystem' is set
      if @api_client.config.client_side_validation && subsystem.nil?
        fail ArgumentError, "Missing the required parameter 'subsystem' when calling SystemApi.reload_subsystem"
      end
      # resource path
      local_var_path = '/sys/config/reload/{subsystem}'.sub('{' + 'subsystem' + '}', CGI.escape(subsystem.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.reload_subsystem",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#reload_subsystem\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Initiate a mount migration
    # @param remount_request [RemountRequest]
    # @param [Hash] opts the optional parameters
    # @return [RemountResponse]
    def remount(remount_request, opts = {})
      data, _status_code, _headers = remount_with_http_info(remount_request, opts)
      data
    end

    # Initiate a mount migration
    # @param remount_request [RemountRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(RemountResponse, Integer, Hash)>] RemountResponse data, response status code and response headers
    def remount_with_http_info(remount_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.remount ...'
      end
      # verify the required parameter 'remount_request' is set
      if @api_client.config.client_side_validation && remount_request.nil?
        fail ArgumentError, "Missing the required parameter 'remount_request' when calling SystemApi.remount"
      end
      # resource path
      local_var_path = '/sys/remount'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(remount_request)

      # return_type
      return_type = opts[:debug_return_type] || 'RemountResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.remount",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#remount\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Check status of a mount migration
    # @param migration_id [String] The ID of the migration operation
    # @param [Hash] opts the optional parameters
    # @return [RemountStatusResponse]
    def remount_status(migration_id, opts = {})
      data, _status_code, _headers = remount_status_with_http_info(migration_id, opts)
      data
    end

    # Check status of a mount migration
    # @param migration_id [String] The ID of the migration operation
    # @param [Hash] opts the optional parameters
    # @return [Array<(RemountStatusResponse, Integer, Hash)>] RemountStatusResponse data, response status code and response headers
    def remount_status_with_http_info(migration_id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.remount_status ...'
      end
      # verify the required parameter 'migration_id' is set
      if @api_client.config.client_side_validation && migration_id.nil?
        fail ArgumentError, "Missing the required parameter 'migration_id' when calling SystemApi.remount_status"
      end
      # resource path
      local_var_path = '/sys/remount/status/{migration_id}'.sub('{' + 'migration_id' + '}', CGI.escape(migration_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'RemountStatusResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.remount_status",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#remount_status\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param rewrap_request [RewrapRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def rewrap(rewrap_request, opts = {})
      rewrap_with_http_info(rewrap_request, opts)
      nil
    end

    # @param rewrap_request [RewrapRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def rewrap_with_http_info(rewrap_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.rewrap ...'
      end
      # verify the required parameter 'rewrap_request' is set
      if @api_client.config.client_side_validation && rewrap_request.nil?
        fail ArgumentError, "Missing the required parameter 'rewrap_request' when calling SystemApi.rewrap"
      end
      # resource path
      local_var_path = '/sys/wrapping/rewrap'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(rewrap_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.rewrap",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#rewrap\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Cancels any in-progress root generation attempt.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def root_token_generation_cancel(opts = {})
      root_token_generation_cancel_with_http_info(opts)
      nil
    end

    # Cancels any in-progress root generation attempt.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def root_token_generation_cancel_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.root_token_generation_cancel ...'
      end
      # resource path
      local_var_path = '/sys/generate-root/attempt'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.root_token_generation_cancel",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#root_token_generation_cancel\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Cancels any in-progress root generation attempt.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def root_token_generation_cancel2(opts = {})
      root_token_generation_cancel2_with_http_info(opts)
      nil
    end

    # Cancels any in-progress root generation attempt.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def root_token_generation_cancel2_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.root_token_generation_cancel2 ...'
      end
      # resource path
      local_var_path = '/sys/generate-root'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.root_token_generation_cancel2",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#root_token_generation_cancel2\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Initializes a new root generation attempt.
    # Only a single root generation attempt can take place at a time. One (and only one) of otp or pgp_key are required.
    # @param root_token_generation_initialize_request [RootTokenGenerationInitializeRequest]
    # @param [Hash] opts the optional parameters
    # @return [RootTokenGenerationInitializeResponse]
    def root_token_generation_initialize(root_token_generation_initialize_request, opts = {})
      data, _status_code, _headers = root_token_generation_initialize_with_http_info(root_token_generation_initialize_request, opts)
      data
    end

    # Initializes a new root generation attempt.
    # Only a single root generation attempt can take place at a time. One (and only one) of otp or pgp_key are required.
    # @param root_token_generation_initialize_request [RootTokenGenerationInitializeRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(RootTokenGenerationInitializeResponse, Integer, Hash)>] RootTokenGenerationInitializeResponse data, response status code and response headers
    def root_token_generation_initialize_with_http_info(root_token_generation_initialize_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.root_token_generation_initialize ...'
      end
      # verify the required parameter 'root_token_generation_initialize_request' is set
      if @api_client.config.client_side_validation && root_token_generation_initialize_request.nil?
        fail ArgumentError, "Missing the required parameter 'root_token_generation_initialize_request' when calling SystemApi.root_token_generation_initialize"
      end
      # resource path
      local_var_path = '/sys/generate-root/attempt'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(root_token_generation_initialize_request)

      # return_type
      return_type = opts[:debug_return_type] || 'RootTokenGenerationInitializeResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.root_token_generation_initialize",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#root_token_generation_initialize\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Initializes a new root generation attempt.
    # Only a single root generation attempt can take place at a time. One (and only one) of otp or pgp_key are required.
    # @param root_token_generation_initialize2_request [RootTokenGenerationInitialize2Request]
    # @param [Hash] opts the optional parameters
    # @return [RootTokenGenerationInitialize2Response]
    def root_token_generation_initialize2(root_token_generation_initialize2_request, opts = {})
      data, _status_code, _headers = root_token_generation_initialize2_with_http_info(root_token_generation_initialize2_request, opts)
      data
    end

    # Initializes a new root generation attempt.
    # Only a single root generation attempt can take place at a time. One (and only one) of otp or pgp_key are required.
    # @param root_token_generation_initialize2_request [RootTokenGenerationInitialize2Request]
    # @param [Hash] opts the optional parameters
    # @return [Array<(RootTokenGenerationInitialize2Response, Integer, Hash)>] RootTokenGenerationInitialize2Response data, response status code and response headers
    def root_token_generation_initialize2_with_http_info(root_token_generation_initialize2_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.root_token_generation_initialize2 ...'
      end
      # verify the required parameter 'root_token_generation_initialize2_request' is set
      if @api_client.config.client_side_validation && root_token_generation_initialize2_request.nil?
        fail ArgumentError, "Missing the required parameter 'root_token_generation_initialize2_request' when calling SystemApi.root_token_generation_initialize2"
      end
      # resource path
      local_var_path = '/sys/generate-root'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(root_token_generation_initialize2_request)

      # return_type
      return_type = opts[:debug_return_type] || 'RootTokenGenerationInitialize2Response'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.root_token_generation_initialize2",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#root_token_generation_initialize2\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Read the configuration and progress of the current root generation attempt.
    # @param [Hash] opts the optional parameters
    # @return [RootTokenGenerationReadProgressResponse]
    def root_token_generation_read_progress(opts = {})
      data, _status_code, _headers = root_token_generation_read_progress_with_http_info(opts)
      data
    end

    # Read the configuration and progress of the current root generation attempt.
    # @param [Hash] opts the optional parameters
    # @return [Array<(RootTokenGenerationReadProgressResponse, Integer, Hash)>] RootTokenGenerationReadProgressResponse data, response status code and response headers
    def root_token_generation_read_progress_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.root_token_generation_read_progress ...'
      end
      # resource path
      local_var_path = '/sys/generate-root/attempt'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'RootTokenGenerationReadProgressResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.root_token_generation_read_progress",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#root_token_generation_read_progress\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Read the configuration and progress of the current root generation attempt.
    # @param [Hash] opts the optional parameters
    # @return [RootTokenGenerationReadProgress2Response]
    def root_token_generation_read_progress2(opts = {})
      data, _status_code, _headers = root_token_generation_read_progress2_with_http_info(opts)
      data
    end

    # Read the configuration and progress of the current root generation attempt.
    # @param [Hash] opts the optional parameters
    # @return [Array<(RootTokenGenerationReadProgress2Response, Integer, Hash)>] RootTokenGenerationReadProgress2Response data, response status code and response headers
    def root_token_generation_read_progress2_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.root_token_generation_read_progress2 ...'
      end
      # resource path
      local_var_path = '/sys/generate-root'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'RootTokenGenerationReadProgress2Response'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.root_token_generation_read_progress2",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#root_token_generation_read_progress2\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Enter a single unseal key share to progress the root generation attempt.
    # If the threshold number of unseal key shares is reached, OpenBao will complete the root generation and issue the new token. Otherwise, this API must be called multiple times until that threshold is met. The attempt nonce must be provided with each call.
    # @param root_token_generation_update_request [RootTokenGenerationUpdateRequest]
    # @param [Hash] opts the optional parameters
    # @return [RootTokenGenerationUpdateResponse]
    def root_token_generation_update(root_token_generation_update_request, opts = {})
      data, _status_code, _headers = root_token_generation_update_with_http_info(root_token_generation_update_request, opts)
      data
    end

    # Enter a single unseal key share to progress the root generation attempt.
    # If the threshold number of unseal key shares is reached, OpenBao will complete the root generation and issue the new token. Otherwise, this API must be called multiple times until that threshold is met. The attempt nonce must be provided with each call.
    # @param root_token_generation_update_request [RootTokenGenerationUpdateRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(RootTokenGenerationUpdateResponse, Integer, Hash)>] RootTokenGenerationUpdateResponse data, response status code and response headers
    def root_token_generation_update_with_http_info(root_token_generation_update_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.root_token_generation_update ...'
      end
      # verify the required parameter 'root_token_generation_update_request' is set
      if @api_client.config.client_side_validation && root_token_generation_update_request.nil?
        fail ArgumentError, "Missing the required parameter 'root_token_generation_update_request' when calling SystemApi.root_token_generation_update"
      end
      # resource path
      local_var_path = '/sys/generate-root/update'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(root_token_generation_update_request)

      # return_type
      return_type = opts[:debug_return_type] || 'RootTokenGenerationUpdateResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.root_token_generation_update",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#root_token_generation_update\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Seal the OpenBao instance.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def seal(opts = {})
      seal_with_http_info(opts)
      nil
    end

    # Seal the OpenBao instance.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def seal_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.seal ...'
      end
      # resource path
      local_var_path = '/sys/seal'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.seal",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#seal\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Check the seal status of an OpenBao instance.
    # @param [Hash] opts the optional parameters
    # @return [SealStatusResponse]
    def seal_status(opts = {})
      data, _status_code, _headers = seal_status_with_http_info(opts)
      data
    end

    # Check the seal status of an OpenBao instance.
    # @param [Hash] opts the optional parameters
    # @return [Array<(SealStatusResponse, Integer, Hash)>] SealStatusResponse data, response status code and response headers
    def seal_status_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.seal_status ...'
      end
      # resource path
      local_var_path = '/sys/seal-status'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'SealStatusResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.seal_status",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#seal_status\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Cause the node to give up active status.
    # This endpoint forces the node to give up active status. If the node does not have active status, this endpoint does nothing. Note that the node will sleep for ten seconds before attempting to grab the active lock again, but if no standby nodes grab the active lock in the interim, the same node may become the active node again.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def step_down_leader(opts = {})
      step_down_leader_with_http_info(opts)
      nil
    end

    # Cause the node to give up active status.
    # This endpoint forces the node to give up active status. If the node does not have active status, this endpoint does nothing. Note that the node will sleep for ten seconds before attempting to grab the active lock again, but if no standby nodes grab the active lock in the interim, the same node may become the active node again.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def step_down_leader_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.step_down_leader ...'
      end
      # resource path
      local_var_path = '/sys/step-down'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.step_down_leader",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#step_down_leader\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Configure the values to be returned for the UI header.
    # @param header [String] The name of the header.
    # @param ui_headers_configure_request [UiHeadersConfigureRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ui_headers_configure(header, ui_headers_configure_request, opts = {})
      ui_headers_configure_with_http_info(header, ui_headers_configure_request, opts)
      nil
    end

    # Configure the values to be returned for the UI header.
    # @param header [String] The name of the header.
    # @param ui_headers_configure_request [UiHeadersConfigureRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ui_headers_configure_with_http_info(header, ui_headers_configure_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.ui_headers_configure ...'
      end
      # verify the required parameter 'header' is set
      if @api_client.config.client_side_validation && header.nil?
        fail ArgumentError, "Missing the required parameter 'header' when calling SystemApi.ui_headers_configure"
      end
      # verify the required parameter 'ui_headers_configure_request' is set
      if @api_client.config.client_side_validation && ui_headers_configure_request.nil?
        fail ArgumentError, "Missing the required parameter 'ui_headers_configure_request' when calling SystemApi.ui_headers_configure"
      end
      # resource path
      local_var_path = '/sys/config/ui/headers/{header}'.sub('{' + 'header' + '}', CGI.escape(header.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(ui_headers_configure_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.ui_headers_configure",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#ui_headers_configure\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Remove a UI header.
    # @param header [String] The name of the header.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def ui_headers_delete_configuration(header, opts = {})
      ui_headers_delete_configuration_with_http_info(header, opts)
      nil
    end

    # Remove a UI header.
    # @param header [String] The name of the header.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def ui_headers_delete_configuration_with_http_info(header, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.ui_headers_delete_configuration ...'
      end
      # verify the required parameter 'header' is set
      if @api_client.config.client_side_validation && header.nil?
        fail ArgumentError, "Missing the required parameter 'header' when calling SystemApi.ui_headers_delete_configuration"
      end
      # resource path
      local_var_path = '/sys/config/ui/headers/{header}'.sub('{' + 'header' + '}', CGI.escape(header.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.ui_headers_delete_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#ui_headers_delete_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Return a list of configured UI headers.
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [UiHeadersListResponse]
    def ui_headers_list(list, opts = {})
      data, _status_code, _headers = ui_headers_list_with_http_info(list, opts)
      data
    end

    # Return a list of configured UI headers.
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(UiHeadersListResponse, Integer, Hash)>] UiHeadersListResponse data, response status code and response headers
    def ui_headers_list_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.ui_headers_list ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SystemApi.ui_headers_list"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/sys/config/ui/headers'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'UiHeadersListResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.ui_headers_list",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#ui_headers_list\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Return the given UI header's configuration
    # @param header [String] The name of the header.
    # @param [Hash] opts the optional parameters
    # @return [UiHeadersReadConfigurationResponse]
    def ui_headers_read_configuration(header, opts = {})
      data, _status_code, _headers = ui_headers_read_configuration_with_http_info(header, opts)
      data
    end

    # Return the given UI header&#39;s configuration
    # @param header [String] The name of the header.
    # @param [Hash] opts the optional parameters
    # @return [Array<(UiHeadersReadConfigurationResponse, Integer, Hash)>] UiHeadersReadConfigurationResponse data, response status code and response headers
    def ui_headers_read_configuration_with_http_info(header, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.ui_headers_read_configuration ...'
      end
      # verify the required parameter 'header' is set
      if @api_client.config.client_side_validation && header.nil?
        fail ArgumentError, "Missing the required parameter 'header' when calling SystemApi.ui_headers_read_configuration"
      end
      # resource path
      local_var_path = '/sys/config/ui/headers/{header}'.sub('{' + 'header' + '}', CGI.escape(header.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'UiHeadersReadConfigurationResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.ui_headers_read_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#ui_headers_read_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Unseal the OpenBao instance.
    # @param unseal_request [UnsealRequest]
    # @param [Hash] opts the optional parameters
    # @return [UnsealResponse]
    def unseal(unseal_request, opts = {})
      data, _status_code, _headers = unseal_with_http_info(unseal_request, opts)
      data
    end

    # Unseal the OpenBao instance.
    # @param unseal_request [UnsealRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(UnsealResponse, Integer, Hash)>] UnsealResponse data, response status code and response headers
    def unseal_with_http_info(unseal_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.unseal ...'
      end
      # verify the required parameter 'unseal_request' is set
      if @api_client.config.client_side_validation && unseal_request.nil?
        fail ArgumentError, "Missing the required parameter 'unseal_request' when calling SystemApi.unseal"
      end
      # resource path
      local_var_path = '/sys/unseal'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(unseal_request)

      # return_type
      return_type = opts[:debug_return_type] || 'UnsealResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.unseal",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#unseal\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param unwrap_request [UnwrapRequest]
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def unwrap(unwrap_request, opts = {})
      unwrap_with_http_info(unwrap_request, opts)
      nil
    end

    # @param unwrap_request [UnwrapRequest]
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def unwrap_with_http_info(unwrap_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.unwrap ...'
      end
      # verify the required parameter 'unwrap_request' is set
      if @api_client.config.client_side_validation && unwrap_request.nil?
        fail ArgumentError, "Missing the required parameter 'unwrap_request' when calling SystemApi.unwrap"
      end
      # resource path
      local_var_path = '/sys/wrapping/unwrap'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(unwrap_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.unwrap",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#unwrap\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Returns map of historical version change entries
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [VersionHistoryResponse]
    def version_history(list, opts = {})
      data, _status_code, _headers = version_history_with_http_info(list, opts)
      data
    end

    # Returns map of historical version change entries
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(VersionHistoryResponse, Integer, Hash)>] VersionHistoryResponse data, response status code and response headers
    def version_history_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.version_history ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling SystemApi.version_history"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/sys/version-history'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'VersionHistoryResponse'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.version_history",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#version_history\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param [Hash] opts the optional parameters
    # @return [nil]
    def wrap(opts = {})
      wrap_with_http_info(opts)
      nil
    end

    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def wrap_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: SystemApi.wrap ...'
      end
      # resource path
      local_var_path = '/sys/wrapping/wrap'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"SystemApi.wrap",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: SystemApi#wrap\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end
  end
end
