// Code generated by smithy-go-codegen DO NOT EDIT.

package redshiftserverless

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/redshiftserverless/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a snapshot copy configuration that lets you copy snapshots to another
// Amazon Web Services Region.
func (c *Client) CreateSnapshotCopyConfiguration(ctx context.Context, params *CreateSnapshotCopyConfigurationInput, optFns ...func(*Options)) (*CreateSnapshotCopyConfigurationOutput, error) {
	if params == nil {
		params = &CreateSnapshotCopyConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateSnapshotCopyConfiguration", params, optFns, c.addOperationCreateSnapshotCopyConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateSnapshotCopyConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateSnapshotCopyConfigurationInput struct {

	// The destination Amazon Web Services Region that you want to copy snapshots to.
	//
	// This member is required.
	DestinationRegion *string

	// The name of the namespace to copy snapshots from.
	//
	// This member is required.
	NamespaceName *string

	// The KMS key to use to encrypt your snapshots in the destination Amazon Web
	// Services Region.
	DestinationKmsKeyId *string

	// The retention period of the snapshots that you copy to the destination Amazon
	// Web Services Region.
	SnapshotRetentionPeriod *int32

	noSmithyDocumentSerde
}

type CreateSnapshotCopyConfigurationOutput struct {

	// The snapshot copy configuration object that is returned.
	//
	// This member is required.
	SnapshotCopyConfiguration *types.SnapshotCopyConfiguration

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateSnapshotCopyConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateSnapshotCopyConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateSnapshotCopyConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateSnapshotCopyConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateSnapshotCopyConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateSnapshotCopyConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateSnapshotCopyConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateSnapshotCopyConfiguration",
	}
}
