// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The access configuration for the cluster.
type AccessConfigResponse struct {

	// The current authentication mode of the cluster.
	AuthenticationMode AuthenticationMode

	// Specifies whether or not the cluster creator IAM principal was set as a cluster
	// admin access entry during cluster creation time.
	BootstrapClusterCreatorAdminPermissions *bool

	noSmithyDocumentSerde
}

// An access entry allows an IAM principal (user or role) to access your cluster.
// Access entries can replace the need to maintain the aws-auth ConfigMap for
// authentication. For more information about access entries, see [Access entries]in the Amazon
// EKS User Guide.
//
// [Access entries]: https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html
type AccessEntry struct {

	// The ARN of the access entry.
	AccessEntryArn *string

	// The name of your cluster.
	ClusterName *string

	// The Unix epoch timestamp at object creation.
	CreatedAt *time.Time

	// A name that you've specified in a Kubernetes RoleBinding or ClusterRoleBinding
	// object so that Kubernetes authorizes the principalARN access to cluster objects.
	KubernetesGroups []string

	// The Unix epoch timestamp for the last modification to the object.
	ModifiedAt *time.Time

	// The ARN of the IAM principal for the access entry. If you ever delete the IAM
	// principal with this ARN, the access entry isn't automatically deleted. We
	// recommend that you delete the access entry with an ARN for an IAM principal that
	// you delete. If you don't delete the access entry and ever recreate the IAM
	// principal, even if it has the same ARN, the access entry won't work. This is
	// because even though the ARN is the same for the recreated IAM principal, the
	// roleID or userID (you can see this with the Security Token Service
	// GetCallerIdentity API) is different for the recreated IAM principal than it was
	// for the original IAM principal. Even though you don't see the IAM principal's
	// roleID or userID for an access entry, Amazon EKS stores it with the access
	// entry.
	PrincipalArn *string

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to any
	// other cluster or Amazon Web Services resources.
	Tags map[string]string

	// The type of the access entry.
	Type *string

	// The name of a user that can authenticate to your cluster.
	Username *string

	noSmithyDocumentSerde
}

// An access policy includes permissions that allow Amazon EKS to authorize an IAM
// principal to work with Kubernetes objects on your cluster. The policies are
// managed by Amazon EKS, but they're not IAM policies. You can't view the
// permissions in the policies using the API. The permissions for many of the
// policies are similar to the Kubernetes cluster-admin , admin , edit , and view
// cluster roles. For more information about these cluster roles, see [User-facing roles]in the
// Kubernetes documentation. To view the contents of the policies, see [Access policy permissions]in the
// Amazon EKS User Guide.
//
// [User-facing roles]: https://kubernetes.io/docs/reference/access-authn-authz/rbac/#user-facing-roles
// [Access policy permissions]: https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html#access-policy-permissions
type AccessPolicy struct {

	// The ARN of the access policy.
	Arn *string

	// The name of the access policy.
	Name *string

	noSmithyDocumentSerde
}

// The scope of an AccessPolicy that's associated to an AccessEntry .
type AccessScope struct {

	// A Kubernetes namespace that an access policy is scoped to. A value is required
	// if you specified namespace for Type .
	Namespaces []string

	// The scope type of an access policy.
	Type AccessScopeType

	noSmithyDocumentSerde
}

// An Amazon EKS add-on. For more information, see [Amazon EKS add-ons] in the Amazon EKS User Guide.
//
// [Amazon EKS add-ons]: https://docs.aws.amazon.com/eks/latest/userguide/eks-add-ons.html
type Addon struct {

	// The Amazon Resource Name (ARN) of the add-on.
	AddonArn *string

	// The name of the add-on.
	AddonName *string

	// The version of the add-on.
	AddonVersion *string

	// The name of your cluster.
	ClusterName *string

	// The configuration values that you provided.
	ConfigurationValues *string

	// The Unix epoch timestamp at object creation.
	CreatedAt *time.Time

	// An object that represents the health of the add-on.
	Health *AddonHealth

	// Information about an Amazon EKS add-on from the Amazon Web Services Marketplace.
	MarketplaceInformation *MarketplaceInformation

	// The Unix epoch timestamp for the last modification to the object.
	ModifiedAt *time.Time

	// The owner of the add-on.
	Owner *string

	// The publisher of the add-on.
	Publisher *string

	// The Amazon Resource Name (ARN) of the IAM role that's bound to the Kubernetes
	// ServiceAccount object that the add-on uses.
	ServiceAccountRoleArn *string

	// The status of the add-on.
	Status AddonStatus

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to any
	// other cluster or Amazon Web Services resources.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The health of the add-on.
type AddonHealth struct {

	// An object representing the health issues for an add-on.
	Issues []AddonIssue

	noSmithyDocumentSerde
}

// Information about an add-on.
type AddonInfo struct {

	// The name of the add-on.
	AddonName *string

	// An object representing information about available add-on versions and
	// compatible Kubernetes versions.
	AddonVersions []AddonVersionInfo

	// Information about the add-on from the Amazon Web Services Marketplace.
	MarketplaceInformation *MarketplaceInformation

	// The owner of the add-on.
	Owner *string

	// The publisher of the add-on.
	Publisher *string

	// The type of the add-on.
	Type *string

	noSmithyDocumentSerde
}

// An issue related to an add-on.
type AddonIssue struct {

	// A code that describes the type of issue.
	Code AddonIssueCode

	// A message that provides details about the issue and what might cause it.
	Message *string

	// The resource IDs of the issue.
	ResourceIds []string

	noSmithyDocumentSerde
}

// Information about an add-on version.
type AddonVersionInfo struct {

	// The version of the add-on.
	AddonVersion *string

	// The architectures that the version supports.
	Architecture []string

	// An object representing the compatibilities of a version.
	Compatibilities []Compatibility

	// Whether the add-on requires configuration.
	RequiresConfiguration bool

	noSmithyDocumentSerde
}

// An access policy association.
type AssociatedAccessPolicy struct {

	// The scope of the access policy.
	AccessScope *AccessScope

	// The date and time the AccessPolicy was associated with an AccessEntry .
	AssociatedAt *time.Time

	// The Unix epoch timestamp for the last modification to the object.
	ModifiedAt *time.Time

	// The ARN of the AccessPolicy .
	PolicyArn *string

	noSmithyDocumentSerde
}

// An Auto Scaling group that is associated with an Amazon EKS managed node group.
type AutoScalingGroup struct {

	// The name of the Auto Scaling group associated with an Amazon EKS managed node
	// group.
	Name *string

	noSmithyDocumentSerde
}

// An object representing the certificate-authority-data for your cluster.
type Certificate struct {

	// The Base64-encoded certificate data required to communicate with your cluster.
	// Add this to the certificate-authority-data section of the kubeconfig file for
	// your cluster.
	Data *string

	noSmithyDocumentSerde
}

// Details about clients using the deprecated resources.
type ClientStat struct {

	// The timestamp of the last request seen from the Kubernetes client.
	LastRequestTime *time.Time

	// The number of requests from the Kubernetes client seen over the last 30 days.
	NumberOfRequestsLast30Days int32

	// The user agent of the Kubernetes client using the deprecated resource.
	UserAgent *string

	noSmithyDocumentSerde
}

// An object representing an Amazon EKS cluster.
type Cluster struct {

	// The access configuration for the cluster.
	AccessConfig *AccessConfigResponse

	// The Amazon Resource Name (ARN) of the cluster.
	Arn *string

	// The certificate-authority-data for your cluster.
	CertificateAuthority *Certificate

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string

	// The configuration used to connect to a cluster for registration.
	ConnectorConfig *ConnectorConfigResponse

	// The Unix epoch timestamp at object creation.
	CreatedAt *time.Time

	// The encryption configuration for the cluster.
	EncryptionConfig []EncryptionConfig

	// The endpoint for your Kubernetes API server.
	Endpoint *string

	// An object representing the health of your local Amazon EKS cluster on an Amazon
	// Web Services Outpost. This object isn't available for clusters on the Amazon Web
	// Services cloud.
	Health *ClusterHealth

	// The ID of your local Amazon EKS cluster on an Amazon Web Services Outpost. This
	// property isn't available for an Amazon EKS cluster on the Amazon Web Services
	// cloud.
	Id *string

	// The identity provider information for the cluster.
	Identity *Identity

	// The Kubernetes network configuration for the cluster.
	KubernetesNetworkConfig *KubernetesNetworkConfigResponse

	// The logging configuration for your cluster.
	Logging *Logging

	// The name of your cluster.
	Name *string

	// An object representing the configuration of your local Amazon EKS cluster on an
	// Amazon Web Services Outpost. This object isn't available for clusters on the
	// Amazon Web Services cloud.
	OutpostConfig *OutpostConfigResponse

	// The platform version of your Amazon EKS cluster. For more information about
	// clusters deployed on the Amazon Web Services Cloud, see [Platform versions]in the Amazon EKS User
	// Guide . For more information about local clusters deployed on an Outpost, see [Amazon EKS local cluster platform versions]
	// in the Amazon EKS User Guide .
	//
	// [Platform versions]: https://docs.aws.amazon.com/eks/latest/userguide/platform-versions.html
	// [Amazon EKS local cluster platform versions]: https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-platform-versions.html
	PlatformVersion *string

	// The VPC configuration used by the cluster control plane. Amazon EKS VPC
	// resources have specific requirements to work properly with Kubernetes. For more
	// information, see [Cluster VPC considerations]and [Cluster security group considerations] in the Amazon EKS User Guide.
	//
	// [Cluster security group considerations]: https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html
	// [Cluster VPC considerations]: https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html
	ResourcesVpcConfig *VpcConfigResponse

	// The Amazon Resource Name (ARN) of the IAM role that provides permissions for
	// the Kubernetes control plane to make calls to Amazon Web Services API operations
	// on your behalf.
	RoleArn *string

	// The current status of the cluster.
	Status ClusterStatus

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to any
	// other cluster or Amazon Web Services resources.
	Tags map[string]string

	// The Kubernetes server version for the cluster.
	Version *string

	noSmithyDocumentSerde
}

// An object representing the health of your local Amazon EKS cluster on an Amazon
// Web Services Outpost. You can't use this API with an Amazon EKS cluster on the
// Amazon Web Services cloud.
type ClusterHealth struct {

	// An object representing the health issues of your local Amazon EKS cluster on an
	// Amazon Web Services Outpost.
	Issues []ClusterIssue

	noSmithyDocumentSerde
}

// An issue with your local Amazon EKS cluster on an Amazon Web Services Outpost.
// You can't use this API with an Amazon EKS cluster on the Amazon Web Services
// cloud.
type ClusterIssue struct {

	// The error code of the issue.
	Code ClusterIssueCode

	// A description of the issue.
	Message *string

	// The resource IDs that the issue relates to.
	ResourceIds []string

	noSmithyDocumentSerde
}

// Compatibility information.
type Compatibility struct {

	// The supported Kubernetes version of the cluster.
	ClusterVersion *string

	// The supported default version.
	DefaultVersion bool

	// The supported compute platform.
	PlatformVersions []string

	noSmithyDocumentSerde
}

// The configuration sent to a cluster for configuration.
type ConnectorConfigRequest struct {

	// The cloud provider for the target cluster to connect.
	//
	// This member is required.
	Provider ConnectorConfigProvider

	// The Amazon Resource Name (ARN) of the role that is authorized to request the
	// connector configuration.
	//
	// This member is required.
	RoleArn *string

	noSmithyDocumentSerde
}

// The full description of your connected cluster.
type ConnectorConfigResponse struct {

	// A unique code associated with the cluster for registration purposes.
	ActivationCode *string

	// The expiration time of the connected cluster. The cluster's YAML file must be
	// applied through the native provider.
	ActivationExpiry *time.Time

	// A unique ID associated with the cluster for registration purposes.
	ActivationId *string

	// The cluster's cloud service provider.
	Provider *string

	// The Amazon Resource Name (ARN) of the role to communicate with services from
	// the connected Kubernetes cluster.
	RoleArn *string

	noSmithyDocumentSerde
}

// The placement configuration for all the control plane instances of your local
// Amazon EKS cluster on an Amazon Web Services Outpost. For more information, see [Capacity considerations]
// in the Amazon EKS User Guide.
//
// [Capacity considerations]: https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html
type ControlPlanePlacementRequest struct {

	// The name of the placement group for the Kubernetes control plane instances.
	// This setting can't be changed after cluster creation.
	GroupName *string

	noSmithyDocumentSerde
}

// The placement configuration for all the control plane instances of your local
// Amazon EKS cluster on an Amazon Web Services Outpost. For more information, see [Capacity considerations]
// in the Amazon EKS User Guide.
//
// [Capacity considerations]: https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html
type ControlPlanePlacementResponse struct {

	// The name of the placement group for the Kubernetes control plane instances.
	GroupName *string

	noSmithyDocumentSerde
}

// The access configuration information for the cluster.
type CreateAccessConfigRequest struct {

	// The desired authentication mode for the cluster. If you create a cluster by
	// using the EKS API, Amazon Web Services SDKs, or CloudFormation, the default is
	// CONFIG_MAP . If you create the cluster by using the Amazon Web Services
	// Management Console, the default value is API_AND_CONFIG_MAP .
	AuthenticationMode AuthenticationMode

	// Specifies whether or not the cluster creator IAM principal was set as a cluster
	// admin access entry during cluster creation time. The default value is true .
	BootstrapClusterCreatorAdminPermissions *bool

	noSmithyDocumentSerde
}

// The summary information about deprecated resource usage for an insight check in
// the UPGRADE_READINESS category.
type DeprecationDetail struct {

	// Details about Kubernetes clients using the deprecated resources.
	ClientStats []ClientStat

	// The newer version of the resource to migrate to if applicable.
	ReplacedWith *string

	// The version of the software where the newer resource version became available
	// to migrate to if applicable.
	StartServingReplacementVersion *string

	// The version of the software where the deprecated resource version will stop
	// being served.
	StopServingVersion *string

	// The deprecated version of the resource.
	Usage *string

	noSmithyDocumentSerde
}

// An EKS Anywhere subscription authorizing the customer to support for licensed
// clusters and access to EKS Anywhere Curated Packages.
type EksAnywhereSubscription struct {

	// The Amazon Resource Name (ARN) for the subscription.
	Arn *string

	// A boolean indicating whether or not a subscription will auto renew when it
	// expires.
	AutoRenew bool

	// The Unix timestamp in seconds for when the subscription was created.
	CreatedAt *time.Time

	// The Unix timestamp in seconds for when the subscription is effective.
	EffectiveDate *time.Time

	// The Unix timestamp in seconds for when the subscription will expire or auto
	// renew, depending on the auto renew configuration of the subscription object.
	ExpirationDate *time.Time

	// UUID identifying a subscription.
	Id *string

	// Amazon Web Services License Manager ARN associated with the subscription.
	LicenseArns []string

	// The number of licenses included in a subscription. Valid values are between 1
	// and 100.
	LicenseQuantity int32

	// The type of licenses included in the subscription. Valid value is CLUSTER. With
	// the CLUSTER license type, each license covers support for a single EKS Anywhere
	// cluster.
	LicenseType EksAnywhereSubscriptionLicenseType

	// The status of a subscription.
	Status *string

	// The metadata for a subscription to assist with categorization and organization.
	// Each tag consists of a key and an optional value. Subscription tags do not
	// propagate to any other resources associated with the subscription.
	Tags map[string]string

	// An EksAnywhereSubscriptionTerm object.
	Term *EksAnywhereSubscriptionTerm

	noSmithyDocumentSerde
}

// An object representing the term duration and term unit type of your
// subscription. This determines the term length of your subscription. Valid values
// are MONTHS for term unit and 12 or 36 for term duration, indicating a 12 month
// or 36 month subscription.
type EksAnywhereSubscriptionTerm struct {

	// The duration of the subscription term. Valid values are 12 and 36, indicating a
	// 12 month or 36 month subscription.
	Duration int32

	// The term unit of the subscription. Valid value is MONTHS .
	Unit EksAnywhereSubscriptionTermUnit

	noSmithyDocumentSerde
}

// The encryption configuration for the cluster.
type EncryptionConfig struct {

	// Key Management Service (KMS) key. Either the ARN or the alias can be used.
	Provider *Provider

	// Specifies the resources to be encrypted. The only supported value is secrets .
	Resources []string

	noSmithyDocumentSerde
}

// An object representing an error when an asynchronous operation fails.
type ErrorDetail struct {

	// A brief description of the error.
	//
	//   - SubnetNotFound: We couldn't find one of the subnets associated with the
	//   cluster.
	//
	//   - SecurityGroupNotFound: We couldn't find one of the security groups
	//   associated with the cluster.
	//
	//   - EniLimitReached: You have reached the elastic network interface limit for
	//   your account.
	//
	//   - IpNotAvailable: A subnet associated with the cluster doesn't have any
	//   available IP addresses.
	//
	//   - AccessDenied: You don't have permissions to perform the specified operation.
	//
	//   - OperationNotPermitted: The service role associated with the cluster doesn't
	//   have the required access permissions for Amazon EKS.
	//
	//   - VpcIdNotFound: We couldn't find the VPC associated with the cluster.
	ErrorCode ErrorCode

	// A more complete description of the error.
	ErrorMessage *string

	// An optional field that contains the resource IDs associated with the error.
	ResourceIds []string

	noSmithyDocumentSerde
}

// An object representing an Fargate profile.
type FargateProfile struct {

	// The name of your cluster.
	ClusterName *string

	// The Unix epoch timestamp at object creation.
	CreatedAt *time.Time

	// The full Amazon Resource Name (ARN) of the Fargate profile.
	FargateProfileArn *string

	// The name of the Fargate profile.
	FargateProfileName *string

	// The Amazon Resource Name (ARN) of the Pod execution role to use for any Pod
	// that matches the selectors in the Fargate profile. For more information, see [Pod execution role]Pod
	// in the Amazon EKS User Guide.
	//
	// [Pod execution role]: https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html
	PodExecutionRoleArn *string

	// The selectors to match for a Pod to use this Fargate profile.
	Selectors []FargateProfileSelector

	// The current status of the Fargate profile.
	Status FargateProfileStatus

	// The IDs of subnets to launch a Pod into.
	Subnets []string

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to any
	// other cluster or Amazon Web Services resources.
	Tags map[string]string

	noSmithyDocumentSerde
}

// An object representing an Fargate profile selector.
type FargateProfileSelector struct {

	// The Kubernetes labels that the selector should match. A pod must contain all of
	// the labels that are specified in the selector for it to be considered a match.
	Labels map[string]string

	// The Kubernetes namespace that the selector should match.
	Namespace *string

	noSmithyDocumentSerde
}

// An object representing an identity provider.
type Identity struct {

	// An object representing the [OpenID Connect] identity provider information.
	//
	// [OpenID Connect]: https://openid.net/connect/
	Oidc *OIDC

	noSmithyDocumentSerde
}

// An object representing an identity provider configuration.
type IdentityProviderConfig struct {

	// The name of the identity provider configuration.
	//
	// This member is required.
	Name *string

	// The type of the identity provider configuration. The only type available is oidc
	// .
	//
	// This member is required.
	Type *string

	noSmithyDocumentSerde
}

// The full description of your identity configuration.
type IdentityProviderConfigResponse struct {

	// An object representing an OpenID Connect (OIDC) identity provider configuration.
	Oidc *OidcIdentityProviderConfig

	noSmithyDocumentSerde
}

// A check that provides recommendations to remedy potential upgrade-impacting
// issues.
type Insight struct {

	// Links to sources that provide additional context on the insight.
	AdditionalInfo map[string]string

	// The category of the insight.
	Category Category

	// Summary information that relates to the category of the insight. Currently only
	// returned with certain insights having category UPGRADE_READINESS .
	CategorySpecificSummary *InsightCategorySpecificSummary

	// The description of the insight which includes alert criteria, remediation
	// recommendation, and additional resources (contains Markdown).
	Description *string

	// The ID of the insight.
	Id *string

	// An object containing more detail on the status of the insight resource.
	InsightStatus *InsightStatus

	// The Kubernetes minor version associated with an insight if applicable.
	KubernetesVersion *string

	// The time Amazon EKS last successfully completed a refresh of this insight check
	// on the cluster.
	LastRefreshTime *time.Time

	// The time the status of the insight last changed.
	LastTransitionTime *time.Time

	// The name of the insight.
	Name *string

	// A summary of how to remediate the finding of this insight if applicable.
	Recommendation *string

	// The details about each resource listed in the insight check result.
	Resources []InsightResourceDetail

	noSmithyDocumentSerde
}

// Summary information that relates to the category of the insight. Currently only
// returned with certain insights having category UPGRADE_READINESS .
type InsightCategorySpecificSummary struct {

	// The summary information about deprecated resource usage for an insight check in
	// the UPGRADE_READINESS category.
	DeprecationDetails []DeprecationDetail

	noSmithyDocumentSerde
}

// Returns information about the resource being evaluated.
type InsightResourceDetail struct {

	// The Amazon Resource Name (ARN) if applicable.
	Arn *string

	// An object containing more detail on the status of the insight resource.
	InsightStatus *InsightStatus

	// The Kubernetes resource URI if applicable.
	KubernetesResourceUri *string

	noSmithyDocumentSerde
}

// The criteria to use for the insights.
type InsightsFilter struct {

	// The categories to use to filter insights.
	Categories []Category

	// The Kubernetes versions to use to filter the insights.
	KubernetesVersions []string

	// The statuses to use to filter the insights.
	Statuses []InsightStatusValue

	noSmithyDocumentSerde
}

// The status of the insight.
type InsightStatus struct {

	// Explanation on the reasoning for the status of the resource.
	Reason *string

	// The status of the resource.
	Status InsightStatusValue

	noSmithyDocumentSerde
}

// The summarized description of the insight.
type InsightSummary struct {

	// The category of the insight.
	Category Category

	// The description of the insight which includes alert criteria, remediation
	// recommendation, and additional resources (contains Markdown).
	Description *string

	// The ID of the insight.
	Id *string

	// An object containing more detail on the status of the insight.
	InsightStatus *InsightStatus

	// The Kubernetes minor version associated with an insight if applicable.
	KubernetesVersion *string

	// The time Amazon EKS last successfully completed a refresh of this insight check
	// on the cluster.
	LastRefreshTime *time.Time

	// The time the status of the insight last changed.
	LastTransitionTime *time.Time

	// The name of the insight.
	Name *string

	noSmithyDocumentSerde
}

// An object representing an issue with an Amazon EKS resource.
type Issue struct {

	// A brief description of the error.
	//
	//   - AccessDenied: Amazon EKS or one or more of your managed nodes is failing to
	//   authenticate or authorize with your Kubernetes cluster API server.
	//
	//   - AsgInstanceLaunchFailures: Your Auto Scaling group is experiencing failures
	//   while attempting to launch instances.
	//
	//   - AutoScalingGroupNotFound: We couldn't find the Auto Scaling group
	//   associated with the managed node group. You may be able to recreate an Auto
	//   Scaling group with the same settings to recover.
	//
	//   - ClusterUnreachable: Amazon EKS or one or more of your managed nodes is
	//   unable to to communicate with your Kubernetes cluster API server. This can
	//   happen if there are network disruptions or if API servers are timing out
	//   processing requests.
	//
	//   - Ec2LaunchTemplateNotFound: We couldn't find the Amazon EC2 launch template
	//   for your managed node group. You may be able to recreate a launch template with
	//   the same settings to recover.
	//
	//   - Ec2LaunchTemplateVersionMismatch: The Amazon EC2 launch template version
	//   for your managed node group does not match the version that Amazon EKS created.
	//   You may be able to revert to the version that Amazon EKS created to recover.
	//
	//   - Ec2SecurityGroupDeletionFailure: We could not delete the remote access
	//   security group for your managed node group. Remove any dependencies from the
	//   security group.
	//
	//   - Ec2SecurityGroupNotFound: We couldn't find the cluster security group for
	//   the cluster. You must recreate your cluster.
	//
	//   - Ec2SubnetInvalidConfiguration: One or more Amazon EC2 subnets specified for
	//   a node group do not automatically assign public IP addresses to instances
	//   launched into it. If you want your instances to be assigned a public IP address,
	//   then you need to enable the auto-assign public IP address setting for the
	//   subnet. See [Modifying the public IPv4 addressing attribute for your subnet]IPv4 in the Amazon VPC User Guide.
	//
	//   - IamInstanceProfileNotFound: We couldn't find the IAM instance profile for
	//   your managed node group. You may be able to recreate an instance profile with
	//   the same settings to recover.
	//
	//   - IamNodeRoleNotFound: We couldn't find the IAM role for your managed node
	//   group. You may be able to recreate an IAM role with the same settings to
	//   recover.
	//
	//   - InstanceLimitExceeded: Your Amazon Web Services account is unable to launch
	//   any more instances of the specified instance type. You may be able to request an
	//   Amazon EC2 instance limit increase to recover.
	//
	//   - InsufficientFreeAddresses: One or more of the subnets associated with your
	//   managed node group does not have enough available IP addresses for new nodes.
	//
	//   - InternalFailure: These errors are usually caused by an Amazon EKS
	//   server-side issue.
	//
	//   - NodeCreationFailure: Your launched instances are unable to register with
	//   your Amazon EKS cluster. Common causes of this failure are insufficient [node IAM role]
	//   permissions or lack of outbound internet access for the nodes.
	//
	// [Modifying the public IPv4 addressing attribute for your subnet]: https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html#subnet-public-ip
	// [node IAM role]: https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html
	Code NodegroupIssueCode

	// The error message associated with the issue.
	Message *string

	// The Amazon Web Services resources that are afflicted by this issue.
	ResourceIds []string

	noSmithyDocumentSerde
}

// The Kubernetes network configuration for the cluster.
type KubernetesNetworkConfigRequest struct {

	// Specify which IP family is used to assign Kubernetes pod and service IP
	// addresses. If you don't specify a value, ipv4 is used by default. You can only
	// specify an IP family when you create a cluster and can't change this value once
	// the cluster is created. If you specify ipv6 , the VPC and subnets that you
	// specify for cluster creation must have both IPv4 and IPv6 CIDR blocks assigned
	// to them. You can't specify ipv6 for clusters in China Regions.
	//
	// You can only specify ipv6 for 1.21 and later clusters that use version 1.10.1
	// or later of the Amazon VPC CNI add-on. If you specify ipv6 , then ensure that
	// your VPC meets the requirements listed in the considerations listed in [Assigning IPv6 addresses to pods and services]in the
	// Amazon EKS User Guide. Kubernetes assigns services IPv6 addresses from the
	// unique local address range (fc00::/7) . You can't specify a custom IPv6 CIDR
	// block. Pod addresses are assigned from the subnet's IPv6 CIDR.
	//
	// [Assigning IPv6 addresses to pods and services]: https://docs.aws.amazon.com/eks/latest/userguide/cni-ipv6.html
	IpFamily IpFamily

	// Don't specify a value if you select ipv6 for ipFamily. The CIDR block to assign
	// Kubernetes service IP addresses from. If you don't specify a block, Kubernetes
	// assigns addresses from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR blocks.
	// We recommend that you specify a block that does not overlap with resources in
	// other networks that are peered or connected to your VPC. The block must meet the
	// following requirements:
	//
	//   - Within one of the following private IP address blocks: 10.0.0.0/8 ,
	//   172.16.0.0/12 , or 192.168.0.0/16 .
	//
	//   - Doesn't overlap with any CIDR block assigned to the VPC that you selected
	//   for VPC.
	//
	//   - Between /24 and /12 .
	//
	// You can only specify a custom CIDR block when you create a cluster. You can't
	// change this value after the cluster is created.
	ServiceIpv4Cidr *string

	noSmithyDocumentSerde
}

// The Kubernetes network configuration for the cluster. The response contains a
// value for serviceIpv6Cidr or serviceIpv4Cidr, but not both.
type KubernetesNetworkConfigResponse struct {

	// The IP family used to assign Kubernetes Pod and Service objects IP addresses.
	// The IP family is always ipv4 , unless you have a 1.21 or later cluster running
	// version 1.10.1 or later of the Amazon VPC CNI plugin for Kubernetes and
	// specified ipv6 when you created the cluster.
	IpFamily IpFamily

	// The CIDR block that Kubernetes Pod and Service object IP addresses are assigned
	// from. Kubernetes assigns addresses from an IPv4 CIDR block assigned to a subnet
	// that the node is in. If you didn't specify a CIDR block when you created the
	// cluster, then Kubernetes assigns addresses from either the 10.100.0.0/16 or
	// 172.20.0.0/16 CIDR blocks. If this was specified, then it was specified when the
	// cluster was created and it can't be changed.
	ServiceIpv4Cidr *string

	// The CIDR block that Kubernetes pod and service IP addresses are assigned from
	// if you created a 1.21 or later cluster with version 1.10.1 or later of the
	// Amazon VPC CNI add-on and specified ipv6 for ipFamily when you created the
	// cluster. Kubernetes assigns service addresses from the unique local address
	// range ( fc00::/7 ) because you can't specify a custom IPv6 CIDR block when you
	// create the cluster.
	ServiceIpv6Cidr *string

	noSmithyDocumentSerde
}

// An object representing a node group launch template specification. The launch
// template can't include [SubnetId]SubnetId , [IamInstanceProfile]IamInstanceProfile , [RequestSpotInstances]RequestSpotInstances , [HibernationOptions]
// HibernationOptions , or [TerminateInstances]TerminateInstances , or the node group deployment or
// update will fail. For more information about launch templates, see [CreateLaunchTemplate]
// CreateLaunchTemplate in the Amazon EC2 API Reference. For more information about
// using launch templates with Amazon EKS, see [Launch template support]in the Amazon EKS User Guide.
//
// You must specify either the launch template ID or the launch template name in
// the request, but not both.
//
// [HibernationOptions]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_HibernationOptionsRequest.html
// [CreateLaunchTemplate]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html
// [RequestSpotInstances]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html
// [Launch template support]: https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html
// [IamInstanceProfile]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html
// [SubnetId]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html
// [TerminateInstances]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TerminateInstances.html
type LaunchTemplateSpecification struct {

	// The ID of the launch template.
	//
	// You must specify either the launch template ID or the launch template name in
	// the request, but not both.
	Id *string

	// The name of the launch template.
	//
	// You must specify either the launch template name or the launch template ID in
	// the request, but not both.
	Name *string

	// The version number of the launch template to use. If no version is specified,
	// then the template's default version is used.
	Version *string

	noSmithyDocumentSerde
}

// An object representing the logging configuration for resources in your cluster.
type Logging struct {

	// The cluster control plane logging configuration for your cluster.
	ClusterLogging []LogSetup

	noSmithyDocumentSerde
}

// An object representing the enabled or disabled Kubernetes control plane logs
// for your cluster.
type LogSetup struct {

	// If a log type is enabled, that log type exports its control plane logs to
	// CloudWatch Logs. If a log type isn't enabled, that log type doesn't export its
	// control plane logs. Each individual log type can be enabled or disabled
	// independently.
	Enabled *bool

	// The available cluster control plane log types.
	Types []LogType

	noSmithyDocumentSerde
}

// Information about an Amazon EKS add-on from the Amazon Web Services Marketplace.
type MarketplaceInformation struct {

	// The product ID from the Amazon Web Services Marketplace.
	ProductId *string

	// The product URL from the Amazon Web Services Marketplace.
	ProductUrl *string

	noSmithyDocumentSerde
}

// An object representing an Amazon EKS managed node group.
type Nodegroup struct {

	// If the node group was deployed using a launch template with a custom AMI, then
	// this is CUSTOM . For node groups that weren't deployed using a launch template,
	// this is the AMI type that was specified in the node group configuration.
	AmiType AMITypes

	// The capacity type of your managed node group.
	CapacityType CapacityTypes

	// The name of your cluster.
	ClusterName *string

	// The Unix epoch timestamp at object creation.
	CreatedAt *time.Time

	// If the node group wasn't deployed with a launch template, then this is the disk
	// size in the node group configuration. If the node group was deployed with a
	// launch template, then this is null .
	DiskSize *int32

	// The health status of the node group. If there are issues with your node group's
	// health, they are listed here.
	Health *NodegroupHealth

	// If the node group wasn't deployed with a launch template, then this is the
	// instance type that is associated with the node group. If the node group was
	// deployed with a launch template, then this is null .
	InstanceTypes []string

	// The Kubernetes labels applied to the nodes in the node group.
	//
	// Only labels that are applied with the Amazon EKS API are shown here. There may
	// be other Kubernetes labels applied to the nodes in this group.
	Labels map[string]string

	// If a launch template was used to create the node group, then this is the launch
	// template that was used.
	LaunchTemplate *LaunchTemplateSpecification

	// The Unix epoch timestamp for the last modification to the object.
	ModifiedAt *time.Time

	// The IAM role associated with your node group. The Amazon EKS node kubelet
	// daemon makes calls to Amazon Web Services APIs on your behalf. Nodes receive
	// permissions for these API calls through an IAM instance profile and associated
	// policies.
	NodeRole *string

	// The Amazon Resource Name (ARN) associated with the managed node group.
	NodegroupArn *string

	// The name associated with an Amazon EKS managed node group.
	NodegroupName *string

	// If the node group was deployed using a launch template with a custom AMI, then
	// this is the AMI ID that was specified in the launch template. For node groups
	// that weren't deployed using a launch template, this is the version of the Amazon
	// EKS optimized AMI that the node group was deployed with.
	ReleaseVersion *string

	// If the node group wasn't deployed with a launch template, then this is the
	// remote access configuration that is associated with the node group. If the node
	// group was deployed with a launch template, then this is null .
	RemoteAccess *RemoteAccessConfig

	// The resources associated with the node group, such as Auto Scaling groups and
	// security groups for remote access.
	Resources *NodegroupResources

	// The scaling configuration details for the Auto Scaling group that is associated
	// with your node group.
	ScalingConfig *NodegroupScalingConfig

	// The current status of the managed node group.
	Status NodegroupStatus

	// The subnets that were specified for the Auto Scaling group that is associated
	// with your node group.
	Subnets []string

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to any
	// other cluster or Amazon Web Services resources.
	Tags map[string]string

	// The Kubernetes taints to be applied to the nodes in the node group when they
	// are created. Effect is one of No_Schedule , Prefer_No_Schedule , or No_Execute .
	// Kubernetes taints can be used together with tolerations to control how workloads
	// are scheduled to your nodes. For more information, see [Node taints on managed node groups].
	//
	// [Node taints on managed node groups]: https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html
	Taints []Taint

	// The node group update configuration.
	UpdateConfig *NodegroupUpdateConfig

	// The Kubernetes version of the managed node group.
	Version *string

	noSmithyDocumentSerde
}

// An object representing the health status of the node group.
type NodegroupHealth struct {

	// Any issues that are associated with the node group.
	Issues []Issue

	noSmithyDocumentSerde
}

// An object representing the resources associated with the node group, such as
// Auto Scaling groups and security groups for remote access.
type NodegroupResources struct {

	// The Auto Scaling groups associated with the node group.
	AutoScalingGroups []AutoScalingGroup

	// The remote access security group associated with the node group. This security
	// group controls SSH access to the nodes.
	RemoteAccessSecurityGroup *string

	noSmithyDocumentSerde
}

// An object representing the scaling configuration details for the Auto Scaling
// group that is associated with your node group. When creating a node group, you
// must specify all or none of the properties. When updating a node group, you can
// specify any or none of the properties.
type NodegroupScalingConfig struct {

	// The current number of nodes that the managed node group should maintain.
	//
	// If you use the Kubernetes [Cluster Autoscaler], you shouldn't change the desiredSize value
	// directly, as this can cause the Cluster Autoscaler to suddenly scale up or scale
	// down.
	//
	// Whenever this parameter changes, the number of worker nodes in the node group
	// is updated to the specified size. If this parameter is given a value that is
	// smaller than the current number of running worker nodes, the necessary number of
	// worker nodes are terminated to match the given value.
	//
	// When using CloudFormation, no action occurs if you remove this parameter from
	// your CFN template.
	//
	// This parameter can be different from minSize in some cases, such as when
	// starting with extra hosts for testing. This parameter can also be different when
	// you want to start with an estimated number of needed hosts, but let the Cluster
	// Autoscaler reduce the number if there are too many. When the Cluster Autoscaler
	// is used, the desiredSize parameter is altered by the Cluster Autoscaler (but
	// can be out-of-date for short periods of time). the Cluster Autoscaler doesn't
	// scale a managed node group lower than minSize or higher than maxSize .
	//
	// [Cluster Autoscaler]: https://github.com/kubernetes/autoscaler#kubernetes-autoscaler
	DesiredSize *int32

	// The maximum number of nodes that the managed node group can scale out to. For
	// information about the maximum number that you can specify, see [Amazon EKS service quotas]in the Amazon
	// EKS User Guide.
	//
	// [Amazon EKS service quotas]: https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html
	MaxSize *int32

	// The minimum number of nodes that the managed node group can scale in to.
	MinSize *int32

	noSmithyDocumentSerde
}

// The node group update configuration.
type NodegroupUpdateConfig struct {

	// The maximum number of nodes unavailable at once during a version update. Nodes
	// are updated in parallel. This value or maxUnavailablePercentage is required to
	// have a value.The maximum number is 100.
	MaxUnavailable *int32

	// The maximum percentage of nodes unavailable during a version update. This
	// percentage of nodes are updated in parallel, up to 100 nodes at once. This value
	// or maxUnavailable is required to have a value.
	MaxUnavailablePercentage *int32

	noSmithyDocumentSerde
}

// An object representing the [OpenID Connect] (OIDC) identity provider information for the
// cluster.
//
// [OpenID Connect]: https://openid.net/connect/
type OIDC struct {

	// The issuer URL for the OIDC identity provider.
	Issuer *string

	noSmithyDocumentSerde
}

// An object representing the configuration for an OpenID Connect (OIDC) identity
// provider.
type OidcIdentityProviderConfig struct {

	// This is also known as audience. The ID of the client application that makes
	// authentication requests to the OIDC identity provider.
	ClientId *string

	// The name of your cluster.
	ClusterName *string

	// The JSON web token (JWT) claim that the provider uses to return your groups.
	GroupsClaim *string

	// The prefix that is prepended to group claims to prevent clashes with existing
	// names (such as system: groups). For example, the value oidc: creates group
	// names like oidc:engineering and oidc:infra . The prefix can't contain system:
	GroupsPrefix *string

	// The ARN of the configuration.
	IdentityProviderConfigArn *string

	// The name of the configuration.
	IdentityProviderConfigName *string

	// The URL of the OIDC identity provider that allows the API server to discover
	// public signing keys for verifying tokens.
	IssuerUrl *string

	// The key-value pairs that describe required claims in the identity token. If
	// set, each claim is verified to be present in the token with a matching value.
	RequiredClaims map[string]string

	// The status of the OIDC identity provider.
	Status ConfigStatus

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to any
	// other cluster or Amazon Web Services resources.
	Tags map[string]string

	// The JSON Web token (JWT) claim that is used as the username.
	UsernameClaim *string

	// The prefix that is prepended to username claims to prevent clashes with
	// existing names. The prefix can't contain system:
	UsernamePrefix *string

	noSmithyDocumentSerde
}

// An object representing an OpenID Connect (OIDC) configuration. Before
// associating an OIDC identity provider to your cluster, review the considerations
// in [Authenticating users for your cluster from an OIDC identity provider]in the Amazon EKS User Guide.
//
// [Authenticating users for your cluster from an OIDC identity provider]: https://docs.aws.amazon.com/eks/latest/userguide/authenticate-oidc-identity-provider.html
type OidcIdentityProviderConfigRequest struct {

	// This is also known as audience. The ID for the client application that makes
	// authentication requests to the OIDC identity provider.
	//
	// This member is required.
	ClientId *string

	// The name of the OIDC provider configuration.
	//
	// This member is required.
	IdentityProviderConfigName *string

	// The URL of the OIDC identity provider that allows the API server to discover
	// public signing keys for verifying tokens. The URL must begin with https:// and
	// should correspond to the iss claim in the provider's OIDC ID tokens. Based on
	// the OIDC standard, path components are allowed but query parameters are not.
	// Typically the URL consists of only a hostname, like https://server.example.org
	// or https://example.com . This URL should point to the level below
	// .well-known/openid-configuration and must be publicly accessible over the
	// internet.
	//
	// This member is required.
	IssuerUrl *string

	// The JWT claim that the provider uses to return your groups.
	GroupsClaim *string

	// The prefix that is prepended to group claims to prevent clashes with existing
	// names (such as system: groups). For example, the value oidc: will create group
	// names like oidc:engineering and oidc:infra .
	GroupsPrefix *string

	// The key value pairs that describe required claims in the identity token. If
	// set, each claim is verified to be present in the token with a matching value.
	// For the maximum number of claims that you can require, see [Amazon EKS service quotas]in the Amazon EKS
	// User Guide.
	//
	// [Amazon EKS service quotas]: https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html
	RequiredClaims map[string]string

	// The JSON Web Token (JWT) claim to use as the username. The default is sub ,
	// which is expected to be a unique identifier of the end user. You can choose
	// other claims, such as email or name , depending on the OIDC identity provider.
	// Claims other than email are prefixed with the issuer URL to prevent naming
	// clashes with other plug-ins.
	UsernameClaim *string

	// The prefix that is prepended to username claims to prevent clashes with
	// existing names. If you do not provide this field, and username is a value other
	// than email , the prefix defaults to issuerurl# . You can use the value - to
	// disable all prefixing.
	UsernamePrefix *string

	noSmithyDocumentSerde
}

// The configuration of your local Amazon EKS cluster on an Amazon Web Services
// Outpost. Before creating a cluster on an Outpost, review [Creating a local cluster on an Outpost]in the Amazon EKS User
// Guide. This API isn't available for Amazon EKS clusters on the Amazon Web
// Services cloud.
//
// [Creating a local cluster on an Outpost]: https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-local-cluster-create.html
type OutpostConfigRequest struct {

	// The Amazon EC2 instance type that you want to use for your local Amazon EKS
	// cluster on Outposts. Choose an instance type based on the number of nodes that
	// your cluster will have. For more information, see [Capacity considerations]in the Amazon EKS User Guide.
	//
	// The instance type that you specify is used for all Kubernetes control plane
	// instances. The instance type can't be changed after cluster creation. The
	// control plane is not automatically scaled by Amazon EKS.
	//
	// [Capacity considerations]: https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html
	//
	// This member is required.
	ControlPlaneInstanceType *string

	// The ARN of the Outpost that you want to use for your local Amazon EKS cluster
	// on Outposts. Only a single Outpost ARN is supported.
	//
	// This member is required.
	OutpostArns []string

	// An object representing the placement configuration for all the control plane
	// instances of your local Amazon EKS cluster on an Amazon Web Services Outpost.
	// For more information, see [Capacity considerations]in the Amazon EKS User Guide.
	//
	// [Capacity considerations]: https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html
	ControlPlanePlacement *ControlPlanePlacementRequest

	noSmithyDocumentSerde
}

// An object representing the configuration of your local Amazon EKS cluster on an
// Amazon Web Services Outpost. This API isn't available for Amazon EKS clusters on
// the Amazon Web Services cloud.
type OutpostConfigResponse struct {

	// The Amazon EC2 instance type used for the control plane. The instance type is
	// the same for all control plane instances.
	//
	// This member is required.
	ControlPlaneInstanceType *string

	// The ARN of the Outpost that you specified for use with your local Amazon EKS
	// cluster on Outposts.
	//
	// This member is required.
	OutpostArns []string

	// An object representing the placement configuration for all the control plane
	// instances of your local Amazon EKS cluster on an Amazon Web Services Outpost.
	// For more information, see [Capacity considerations]in the Amazon EKS User Guide.
	//
	// [Capacity considerations]: https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html
	ControlPlanePlacement *ControlPlanePlacementResponse

	noSmithyDocumentSerde
}

// Amazon EKS Pod Identity associations provide the ability to manage credentials
// for your applications, similar to the way that Amazon EC2 instance profiles
// provide credentials to Amazon EC2 instances.
type PodIdentityAssociation struct {

	// The Amazon Resource Name (ARN) of the association.
	AssociationArn *string

	// The ID of the association.
	AssociationId *string

	// The name of the cluster that the association is in.
	ClusterName *string

	// The timestamp that the association was created at.
	CreatedAt *time.Time

	// The most recent timestamp that the association was modified at
	ModifiedAt *time.Time

	// The name of the Kubernetes namespace inside the cluster to create the
	// association in. The service account and the pods that use the service account
	// must be in this namespace.
	Namespace *string

	// The Amazon Resource Name (ARN) of the IAM role to associate with the service
	// account. The EKS Pod Identity agent manages credentials to assume this role for
	// applications in the containers in the pods that use this service account.
	RoleArn *string

	// The name of the Kubernetes service account inside the cluster to associate the
	// IAM credentials with.
	ServiceAccount *string

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to any
	// other cluster or Amazon Web Services resources.
	//
	// The following basic restrictions apply to tags:
	//
	//   - Maximum number of tags per resource – 50
	//
	//   - For each resource, each tag key must be unique, and each tag key can have
	//   only one value.
	//
	//   - Maximum key length – 128 Unicode characters in UTF-8
	//
	//   - Maximum value length – 256 Unicode characters in UTF-8
	//
	//   - If your tagging schema is used across multiple services and resources,
	//   remember that other services may have restrictions on allowed characters.
	//   Generally allowed characters are: letters, numbers, and spaces representable in
	//   UTF-8, and the following characters: + - = . _ : / @.
	//
	//   - Tag keys and values are case-sensitive.
	//
	//   - Do not use aws: , AWS: , or any upper or lowercase combination of such as a
	//   prefix for either keys or values as it is reserved for Amazon Web Services use.
	//   You cannot edit or delete tag keys or values with this prefix. Tags with this
	//   prefix do not count against your tags per resource limit.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The summarized description of the association.
//
// Each summary is simplified by removing these fields compared to the full PodIdentityAssociation:
//
//   - The IAM role: roleArn
//
//   - The timestamp that the association was created at: createdAt
//
//   - The most recent timestamp that the association was modified at:. modifiedAt
//
//   - The tags on the association: tags
type PodIdentityAssociationSummary struct {

	// The Amazon Resource Name (ARN) of the association.
	AssociationArn *string

	// The ID of the association.
	AssociationId *string

	// The name of the cluster that the association is in.
	ClusterName *string

	// The name of the Kubernetes namespace inside the cluster to create the
	// association in. The service account and the pods that use the service account
	// must be in this namespace.
	Namespace *string

	// The name of the Kubernetes service account inside the cluster to associate the
	// IAM credentials with.
	ServiceAccount *string

	noSmithyDocumentSerde
}

// Identifies the Key Management Service (KMS) key used to encrypt the secrets.
type Provider struct {

	// Amazon Resource Name (ARN) or alias of the KMS key. The KMS key must be
	// symmetric and created in the same Amazon Web Services Region as the cluster. If
	// the KMS key was created in a different account, the [IAM principal]must have access to the KMS
	// key. For more information, see [Allowing users in other accounts to use a KMS key]in the Key Management Service Developer Guide.
	//
	// [IAM principal]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html
	// [Allowing users in other accounts to use a KMS key]: https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html
	KeyArn *string

	noSmithyDocumentSerde
}

// An object representing the remote access configuration for the managed node
// group.
type RemoteAccessConfig struct {

	// The Amazon EC2 SSH key name that provides access for SSH communication with the
	// nodes in the managed node group. For more information, see [Amazon EC2 key pairs and Linux instances]in the Amazon
	// Elastic Compute Cloud User Guide for Linux Instances. For Windows, an Amazon EC2
	// SSH key is used to obtain the RDP password. For more information, see [Amazon EC2 key pairs and Windows instances]in the
	// Amazon Elastic Compute Cloud User Guide for Windows Instances.
	//
	// [Amazon EC2 key pairs and Windows instances]: https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-key-pairs.html
	// [Amazon EC2 key pairs and Linux instances]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
	Ec2SshKey *string

	// The security group IDs that are allowed SSH access (port 22) to the nodes. For
	// Windows, the port is 3389. If you specify an Amazon EC2 SSH key but don't
	// specify a source security group when you create a managed node group, then the
	// port on the nodes is opened to the internet ( 0.0.0.0/0 ). For more information,
	// see [Security Groups for Your VPC]in the Amazon Virtual Private Cloud User Guide.
	//
	// [Security Groups for Your VPC]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html
	SourceSecurityGroups []string

	noSmithyDocumentSerde
}

// A property that allows a node to repel a Pod . For more information, see [Node taints on managed node groups] in
// the Amazon EKS User Guide.
//
// [Node taints on managed node groups]: https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html
type Taint struct {

	// The effect of the taint.
	Effect TaintEffect

	// The key of the taint.
	Key *string

	// The value of the taint.
	Value *string

	noSmithyDocumentSerde
}

// An object representing an asynchronous update.
type Update struct {

	// The Unix epoch timestamp at object creation.
	CreatedAt *time.Time

	// Any errors associated with a Failed update.
	Errors []ErrorDetail

	// A UUID that is used to track the update.
	Id *string

	// A key-value map that contains the parameters associated with the update.
	Params []UpdateParam

	// The current status of the update.
	Status UpdateStatus

	// The type of the update.
	Type UpdateType

	noSmithyDocumentSerde
}

// The access configuration information for the cluster.
type UpdateAccessConfigRequest struct {

	// The desired authentication mode for the cluster.
	AuthenticationMode AuthenticationMode

	noSmithyDocumentSerde
}

// An object representing a Kubernetes label change for a managed node group.
type UpdateLabelsPayload struct {

	// The Kubernetes labels to add or update.
	AddOrUpdateLabels map[string]string

	// The Kubernetes labels to remove.
	RemoveLabels []string

	noSmithyDocumentSerde
}

// An object representing the details of an update request.
type UpdateParam struct {

	// The keys associated with an update request.
	Type UpdateParamType

	// The value of the keys submitted as part of an update request.
	Value *string

	noSmithyDocumentSerde
}

// An object representing the details of an update to a taints payload. For more
// information, see [Node taints on managed node groups]in the Amazon EKS User Guide.
//
// [Node taints on managed node groups]: https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html
type UpdateTaintsPayload struct {

	// Kubernetes taints to be added or updated.
	AddOrUpdateTaints []Taint

	// Kubernetes taints to remove.
	RemoveTaints []Taint

	noSmithyDocumentSerde
}

// An object representing the VPC configuration to use for an Amazon EKS cluster.
type VpcConfigRequest struct {

	// Set this value to true to enable private access for your cluster's Kubernetes
	// API server endpoint. If you enable private access, Kubernetes API requests from
	// within your cluster's VPC use the private VPC endpoint. The default value for
	// this parameter is false , which disables private access for your Kubernetes API
	// server. If you disable private access and you have nodes or Fargate pods in the
	// cluster, then ensure that publicAccessCidrs includes the necessary CIDR blocks
	// for communication with the nodes or Fargate pods. For more information, see [Amazon EKS cluster endpoint access control]in
	// the Amazon EKS User Guide .
	//
	// [Amazon EKS cluster endpoint access control]: https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html
	EndpointPrivateAccess *bool

	// Set this value to false to disable public access to your cluster's Kubernetes
	// API server endpoint. If you disable public access, your cluster's Kubernetes API
	// server can only receive requests from within the cluster VPC. The default value
	// for this parameter is true , which enables public access for your Kubernetes API
	// server. For more information, see [Amazon EKS cluster endpoint access control]in the Amazon EKS User Guide .
	//
	// [Amazon EKS cluster endpoint access control]: https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html
	EndpointPublicAccess *bool

	// The CIDR blocks that are allowed access to your cluster's public Kubernetes API
	// server endpoint. Communication to the endpoint from addresses outside of the
	// CIDR blocks that you specify is denied. The default value is 0.0.0.0/0 . If
	// you've disabled private endpoint access, make sure that you specify the
	// necessary CIDR blocks for every node and Fargate Pod in the cluster. For more
	// information, see [Amazon EKS cluster endpoint access control]in the Amazon EKS User Guide .
	//
	// [Amazon EKS cluster endpoint access control]: https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html
	PublicAccessCidrs []string

	// Specify one or more security groups for the cross-account elastic network
	// interfaces that Amazon EKS creates to use that allow communication between your
	// nodes and the Kubernetes control plane. If you don't specify any security
	// groups, then familiarize yourself with the difference between Amazon EKS
	// defaults for clusters deployed with Kubernetes. For more information, see [Amazon EKS security group considerations]in
	// the Amazon EKS User Guide .
	//
	// [Amazon EKS security group considerations]: https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html
	SecurityGroupIds []string

	// Specify subnets for your Amazon EKS nodes. Amazon EKS creates cross-account
	// elastic network interfaces in these subnets to allow communication between your
	// nodes and the Kubernetes control plane.
	SubnetIds []string

	noSmithyDocumentSerde
}

// An object representing an Amazon EKS cluster VPC configuration response.
type VpcConfigResponse struct {

	// The cluster security group that was created by Amazon EKS for the cluster.
	// Managed node groups use this security group for control-plane-to-data-plane
	// communication.
	ClusterSecurityGroupId *string

	// This parameter indicates whether the Amazon EKS private API server endpoint is
	// enabled. If the Amazon EKS private API server endpoint is enabled, Kubernetes
	// API requests that originate from within your cluster's VPC use the private VPC
	// endpoint instead of traversing the internet. If this value is disabled and you
	// have nodes or Fargate pods in the cluster, then ensure that publicAccessCidrs
	// includes the necessary CIDR blocks for communication with the nodes or Fargate
	// pods. For more information, see [Amazon EKS cluster endpoint access control]in the Amazon EKS User Guide .
	//
	// [Amazon EKS cluster endpoint access control]: https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html
	EndpointPrivateAccess bool

	// Whether the public API server endpoint is enabled.
	EndpointPublicAccess bool

	// The CIDR blocks that are allowed access to your cluster's public Kubernetes API
	// server endpoint.
	PublicAccessCidrs []string

	// The security groups associated with the cross-account elastic network
	// interfaces that are used to allow communication between your nodes and the
	// Kubernetes control plane.
	SecurityGroupIds []string

	// The subnets associated with your cluster.
	SubnetIds []string

	// The VPC associated with your cluster.
	VpcId *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
