// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudsearch

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudsearch/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Configures the availability options for a domain. Enabling the Multi-AZ option
// expands an Amazon CloudSearch domain to an additional Availability Zone in the
// same Region to increase fault tolerance in the event of a service disruption.
// Changes to the Multi-AZ option can take about half an hour to become active. For
// more information, see [Configuring Availability Options]in the Amazon CloudSearch Developer Guide.
//
// [Configuring Availability Options]: http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html
func (c *Client) UpdateAvailabilityOptions(ctx context.Context, params *UpdateAvailabilityOptionsInput, optFns ...func(*Options)) (*UpdateAvailabilityOptionsOutput, error) {
	if params == nil {
		params = &UpdateAvailabilityOptionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateAvailabilityOptions", params, optFns, c.addOperationUpdateAvailabilityOptionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateAvailabilityOptionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Container for the parameters to the UpdateAvailabilityOptions operation. Specifies the name of the
// domain you want to update and the Multi-AZ availability option.
type UpdateAvailabilityOptionsInput struct {

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start with a
	// letter or number and can contain the following characters: a-z (lowercase), 0-9,
	// and - (hyphen).
	//
	// This member is required.
	DomainName *string

	// You expand an existing search domain to a second Availability Zone by setting
	// the Multi-AZ option to true. Similarly, you can turn off the Multi-AZ option to
	// downgrade the domain to a single Availability Zone by setting the Multi-AZ
	// option to false .
	//
	// This member is required.
	MultiAZ *bool

	noSmithyDocumentSerde
}

// The result of a UpdateAvailabilityOptions request. Contains the status of the
// domain's availability options.
type UpdateAvailabilityOptionsOutput struct {

	// The newly-configured availability options. Indicates whether Multi-AZ is
	// enabled for the domain.
	AvailabilityOptions *types.AvailabilityOptionsStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateAvailabilityOptionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpUpdateAvailabilityOptions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpUpdateAvailabilityOptions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateAvailabilityOptions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateAvailabilityOptionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateAvailabilityOptions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateAvailabilityOptions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateAvailabilityOptions",
	}
}
