//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armkeyvault

import "time"

// AccessPolicyEntry - An identity that have access to the key vault. All identities in the array must use the same tenant
// ID as the key vault's tenant ID.
type AccessPolicyEntry struct {
	// REQUIRED; The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault.
	// The object ID must be unique for the list of access policies.
	ObjectID *string `json:"objectId,omitempty"`

	// REQUIRED; Permissions the identity has for keys, secrets and certificates.
	Permissions *Permissions `json:"permissions,omitempty"`

	// REQUIRED; The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
	TenantID *string `json:"tenantId,omitempty"`

	// Application ID of the client making request on behalf of a principal
	ApplicationID *string `json:"applicationId,omitempty"`
}

type Action struct {
	// The type of action.
	Type *KeyRotationPolicyActionType `json:"type,omitempty"`
}

// Attributes - The object attributes managed by the KeyVault service.
type Attributes struct {
	// Determines whether the object is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Expiry date in seconds since 1970-01-01T00:00:00Z.
	Expires *time.Time `json:"exp,omitempty"`

	// Not before date in seconds since 1970-01-01T00:00:00Z.
	NotBefore *time.Time `json:"nbf,omitempty"`

	// READ-ONLY; Creation time in seconds since 1970-01-01T00:00:00Z.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; Last updated time in seconds since 1970-01-01T00:00:00Z.
	Updated *time.Time `json:"updated,omitempty" azure:"ro"`
}

// CheckNameAvailabilityResult - The CheckNameAvailability operation response.
type CheckNameAvailabilityResult struct {
	// READ-ONLY; An error message explaining the Reason value in more detail.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; A boolean value that indicates whether the name is available for you to use. If true, the name is available.
	// If false, the name has already been taken or is invalid and cannot be used.
	NameAvailable *bool `json:"nameAvailable,omitempty" azure:"ro"`

	// READ-ONLY; The reason that a vault name could not be used. The Reason element is only returned if NameAvailable is false.
	Reason *Reason `json:"reason,omitempty" azure:"ro"`
}

// CloudError - An error response from Key Vault resource provider
type CloudError struct {
	// An error response from Key Vault resource provider
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody - An error response from Key Vault resource provider
type CloudErrorBody struct {
	// Error code. This is a mnemonic that can be consumed programmatically.
	Code *string `json:"code,omitempty"`

	// User friendly error message. The message is typically localized and may vary with service version.
	Message *string `json:"message,omitempty"`
}

type DeletedManagedHsm struct {
	// Properties of the deleted managed HSM
	Properties *DeletedManagedHsmProperties `json:"properties,omitempty"`

	// READ-ONLY; The Azure Resource Manager resource ID for the deleted managed HSM Pool.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the managed HSM Pool.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type of the managed HSM Pool.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeletedManagedHsmListResult - List of deleted managed HSM Pools
type DeletedManagedHsmListResult struct {
	// The URL to get the next set of deleted managed HSM Pools.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of deleted managed HSM Pools.
	Value []*DeletedManagedHsm `json:"value,omitempty"`
}

// DeletedManagedHsmProperties - Properties of the deleted managed HSM.
type DeletedManagedHsmProperties struct {
	// READ-ONLY; The deleted date.
	DeletionDate *time.Time `json:"deletionDate,omitempty" azure:"ro"`

	// READ-ONLY; The location of the original managed HSM.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The resource id of the original managed HSM.
	MhsmID *string `json:"mhsmId,omitempty" azure:"ro"`

	// READ-ONLY; Purge protection status of the original managed HSM.
	PurgeProtectionEnabled *bool `json:"purgeProtectionEnabled,omitempty" azure:"ro"`

	// READ-ONLY; The scheduled purged date.
	ScheduledPurgeDate *time.Time `json:"scheduledPurgeDate,omitempty" azure:"ro"`

	// READ-ONLY; Tags of the original managed HSM.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`
}

// DeletedVault - Deleted vault information with extended details.
type DeletedVault struct {
	// Properties of the vault
	Properties *DeletedVaultProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource ID for the deleted key vault.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the key vault.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type of the key vault.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeletedVaultListResult - List of vaults
type DeletedVaultListResult struct {
	// The URL to get the next set of deleted vaults.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of deleted vaults.
	Value []*DeletedVault `json:"value,omitempty"`
}

// DeletedVaultProperties - Properties of the deleted vault.
type DeletedVaultProperties struct {
	// READ-ONLY; The deleted date.
	DeletionDate *time.Time `json:"deletionDate,omitempty" azure:"ro"`

	// READ-ONLY; The location of the original vault.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Purge protection status of the original vault.
	PurgeProtectionEnabled *bool `json:"purgeProtectionEnabled,omitempty" azure:"ro"`

	// READ-ONLY; The scheduled purged date.
	ScheduledPurgeDate *time.Time `json:"scheduledPurgeDate,omitempty" azure:"ro"`

	// READ-ONLY; Tags of the original vault.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; The resource id of the original vault.
	VaultID *string `json:"vaultId,omitempty" azure:"ro"`
}

// DimensionProperties - Type of operation: get, read, delete, etc.
type DimensionProperties struct {
	// Display name of dimension.
	DisplayName *string `json:"displayName,omitempty"`

	// Name of dimension.
	Name *string `json:"name,omitempty"`

	// Property to specify whether the dimension should be exported for Shoebox.
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// Error - The server error.
type Error struct {
	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The inner error, contains a more specific error code.
	InnerError *Error `json:"innererror,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// IPRule - A rule governing the accessibility of a vault from a specific ip address or ip range.
type IPRule struct {
	// REQUIRED; An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address) or '124.56.78.0/24' (all addresses
	// that start with 124.56.78).
	Value *string `json:"value,omitempty"`
}

// Key - The key resource.
type Key struct {
	// REQUIRED; The properties of the key.
	Properties *KeyProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure location of the key vault resource.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Name of the key vault resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Tags assigned to the key vault resource.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type of the key vault resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// KeyAttributes - The object attributes managed by the Azure Key Vault service.
type KeyAttributes struct {
	// Determines whether or not the object is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Expiry date in seconds since 1970-01-01T00:00:00Z.
	Expires *int64 `json:"exp,omitempty"`

	// Indicates if the private key can be exported.
	Exportable *bool `json:"exportable,omitempty"`

	// Not before date in seconds since 1970-01-01T00:00:00Z.
	NotBefore *int64 `json:"nbf,omitempty"`

	// READ-ONLY; Creation time in seconds since 1970-01-01T00:00:00Z.
	Created *int64 `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; The deletion recovery level currently in effect for the object. If it contains 'Purgeable', then the object
	// can be permanently deleted by a privileged user; otherwise, only the system can purge the
	// object at the end of the retention interval.
	RecoveryLevel *DeletionRecoveryLevel `json:"recoveryLevel,omitempty" azure:"ro"`

	// READ-ONLY; Last updated time in seconds since 1970-01-01T00:00:00Z.
	Updated *int64 `json:"updated,omitempty" azure:"ro"`
}

// KeyCreateParameters - The parameters used to create a key.
type KeyCreateParameters struct {
	// REQUIRED; The properties of the key to be created.
	Properties *KeyProperties `json:"properties,omitempty"`

	// The tags that will be assigned to the key.
	Tags map[string]*string `json:"tags,omitempty"`
}

// KeyListResult - The page of keys.
type KeyListResult struct {
	// The URL to get the next page of keys.
	NextLink *string `json:"nextLink,omitempty"`

	// The key resources.
	Value []*Key `json:"value,omitempty"`
}

// KeyProperties - The properties of the key.
type KeyProperties struct {
	// The attributes of the key.
	Attributes *KeyAttributes `json:"attributes,omitempty"`

	// The elliptic curve name. For valid values, see JsonWebKeyCurveName.
	CurveName *JSONWebKeyCurveName   `json:"curveName,omitempty"`
	KeyOps    []*JSONWebKeyOperation `json:"keyOps,omitempty"`

	// The key size in bits. For example: 2048, 3072, or 4096 for RSA.
	KeySize *int32 `json:"keySize,omitempty"`

	// The type of the key. For valid values, see JsonWebKeyType.
	Kty *JSONWebKeyType `json:"kty,omitempty"`

	// Key release policy in response. It will be used for both output and input. Omitted if empty
	ReleasePolicy *KeyReleasePolicy `json:"release_policy,omitempty"`

	// Key rotation policy in response. It will be used for both output and input. Omitted if empty
	RotationPolicy *RotationPolicy `json:"rotationPolicy,omitempty"`

	// READ-ONLY; The URI to retrieve the current version of the key.
	KeyURI *string `json:"keyUri,omitempty" azure:"ro"`

	// READ-ONLY; The URI to retrieve the specific version of the key.
	KeyURIWithVersion *string `json:"keyUriWithVersion,omitempty" azure:"ro"`
}

type KeyReleasePolicy struct {
	// Content type and version of key release policy
	ContentType *string `json:"contentType,omitempty"`

	// Blob encoding the policy rules under which the key can be released.
	Data []byte `json:"data,omitempty"`
}

type KeyRotationPolicyAttributes struct {
	// The expiration time for the new key version. It should be in ISO8601 format. Eg: 'P90D', 'P1Y'.
	ExpiryTime *string `json:"expiryTime,omitempty"`

	// READ-ONLY; Creation time in seconds since 1970-01-01T00:00:00Z.
	Created *int64 `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; Last updated time in seconds since 1970-01-01T00:00:00Z.
	Updated *int64 `json:"updated,omitempty" azure:"ro"`
}

// KeysClientCreateIfNotExistOptions contains the optional parameters for the KeysClient.CreateIfNotExist method.
type KeysClientCreateIfNotExistOptions struct {
	// placeholder for future optional parameters
}

// KeysClientGetOptions contains the optional parameters for the KeysClient.Get method.
type KeysClientGetOptions struct {
	// placeholder for future optional parameters
}

// KeysClientGetVersionOptions contains the optional parameters for the KeysClient.GetVersion method.
type KeysClientGetVersionOptions struct {
	// placeholder for future optional parameters
}

// KeysClientListOptions contains the optional parameters for the KeysClient.List method.
type KeysClientListOptions struct {
	// placeholder for future optional parameters
}

// KeysClientListVersionsOptions contains the optional parameters for the KeysClient.ListVersions method.
type KeysClientListVersionsOptions struct {
	// placeholder for future optional parameters
}

type LifetimeAction struct {
	// The action of key rotation policy lifetimeAction.
	Action *Action `json:"action,omitempty"`

	// The trigger of key rotation policy lifetimeAction.
	Trigger *Trigger `json:"trigger,omitempty"`
}

// LogSpecification - Log specification of operation.
type LogSpecification struct {
	// Blob duration of specification.
	BlobDuration *string `json:"blobDuration,omitempty"`

	// Display name of log specification.
	DisplayName *string `json:"displayName,omitempty"`

	// Name of log specification.
	Name *string `json:"name,omitempty"`
}

// MHSMIPRule - A rule governing the accessibility of a managed hsm pool from a specific ip address or ip range.
type MHSMIPRule struct {
	// REQUIRED; An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address) or '124.56.78.0/24' (all addresses
	// that start with 124.56.78).
	Value *string `json:"value,omitempty"`
}

// MHSMNetworkRuleSet - A set of rules governing the network accessibility of a managed hsm pool.
type MHSMNetworkRuleSet struct {
	// Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'. If not specified the default is 'AzureServices'.
	Bypass *NetworkRuleBypassOptions `json:"bypass,omitempty"`

	// The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property
	// has been evaluated.
	DefaultAction *NetworkRuleAction `json:"defaultAction,omitempty"`

	// The list of IP address rules.
	IPRules []*MHSMIPRule `json:"ipRules,omitempty"`

	// The list of virtual network rules.
	VirtualNetworkRules []*MHSMVirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
}

// MHSMPrivateEndpoint - Private endpoint object properties.
type MHSMPrivateEndpoint struct {
	// READ-ONLY; Full identifier of the private endpoint resource.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// MHSMPrivateEndpointConnection - Private endpoint connection resource.
type MHSMPrivateEndpointConnection struct {
	// Modified whenever there is a change in the state of private endpoint connection.
	Etag *string `json:"etag,omitempty"`

	// The supported Azure location where the managed HSM Pool should be created.
	Location *string `json:"location,omitempty"`

	// Resource properties.
	Properties *MHSMPrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// SKU details
	SKU *ManagedHsmSKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The Azure Resource Manager resource ID for the managed HSM Pool.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the managed HSM Pool.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the key vault resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The resource type of the managed HSM Pool.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MHSMPrivateEndpointConnectionItem - Private endpoint connection item.
type MHSMPrivateEndpointConnectionItem struct {
	// Private endpoint connection properties.
	Properties *MHSMPrivateEndpointConnectionProperties `json:"properties,omitempty"`
}

// MHSMPrivateEndpointConnectionProperties - Properties of the private endpoint connection resource.
type MHSMPrivateEndpointConnectionProperties struct {
	// Properties of the private endpoint object.
	PrivateEndpoint *MHSMPrivateEndpoint `json:"privateEndpoint,omitempty"`

	// Approval state of the private link connection.
	PrivateLinkServiceConnectionState *MHSMPrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// Provisioning state of the private endpoint connection.
	ProvisioningState *PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty"`
}

// MHSMPrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the MHSMPrivateEndpointConnectionsClient.BeginDelete
// method.
type MHSMPrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MHSMPrivateEndpointConnectionsClientGetOptions contains the optional parameters for the MHSMPrivateEndpointConnectionsClient.Get
// method.
type MHSMPrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// MHSMPrivateEndpointConnectionsClientListByResourceOptions contains the optional parameters for the MHSMPrivateEndpointConnectionsClient.ListByResource
// method.
type MHSMPrivateEndpointConnectionsClientListByResourceOptions struct {
	// placeholder for future optional parameters
}

// MHSMPrivateEndpointConnectionsClientPutOptions contains the optional parameters for the MHSMPrivateEndpointConnectionsClient.Put
// method.
type MHSMPrivateEndpointConnectionsClientPutOptions struct {
	// placeholder for future optional parameters
}

// MHSMPrivateEndpointConnectionsListResult - List of private endpoint connections associated with a managed HSM Pools
type MHSMPrivateEndpointConnectionsListResult struct {
	// The URL to get the next set of managed HSM Pools.
	NextLink *string `json:"nextLink,omitempty"`

	// The private endpoint connection associated with a managed HSM Pools.
	Value []*MHSMPrivateEndpointConnection `json:"value,omitempty"`
}

// MHSMPrivateLinkResource - A private link resource
type MHSMPrivateLinkResource struct {
	// The supported Azure location where the managed HSM Pool should be created.
	Location *string `json:"location,omitempty"`

	// Resource properties.
	Properties *MHSMPrivateLinkResourceProperties `json:"properties,omitempty"`

	// SKU details
	SKU *ManagedHsmSKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The Azure Resource Manager resource ID for the managed HSM Pool.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the managed HSM Pool.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the key vault resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The resource type of the managed HSM Pool.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MHSMPrivateLinkResourceListResult - A list of private link resources
type MHSMPrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*MHSMPrivateLinkResource `json:"value,omitempty"`
}

// MHSMPrivateLinkResourceProperties - Properties of a private link resource.
type MHSMPrivateLinkResourceProperties struct {
	// Required DNS zone names of the the private link resource.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`

	// READ-ONLY; Group identifier of private link resource.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; Required member names of private link resource.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// MHSMPrivateLinkResourcesClientListByMHSMResourceOptions contains the optional parameters for the MHSMPrivateLinkResourcesClient.ListByMHSMResource
// method.
type MHSMPrivateLinkResourcesClientListByMHSMResourceOptions struct {
	// placeholder for future optional parameters
}

// MHSMPrivateLinkServiceConnectionState - An object that represents the approval state of the private link connection.
type MHSMPrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *ActionsRequired `json:"actionsRequired,omitempty"`

	// The reason for approval or rejection.
	Description *string `json:"description,omitempty"`

	// Indicates whether the connection has been approved, rejected or removed by the key vault owner.
	Status *PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
}

// MHSMVirtualNetworkRule - A rule governing the accessibility of a managed hsm pool from a specific virtual network.
type MHSMVirtualNetworkRule struct {
	// REQUIRED; Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
	ID *string `json:"id,omitempty"`
}

// ManagedHsm - Resource information with extended details.
type ManagedHsm struct {
	// The supported Azure location where the managed HSM Pool should be created.
	Location *string `json:"location,omitempty"`

	// Properties of the managed HSM
	Properties *ManagedHsmProperties `json:"properties,omitempty"`

	// SKU details
	SKU *ManagedHsmSKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The Azure Resource Manager resource ID for the managed HSM Pool.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the managed HSM Pool.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the key vault resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The resource type of the managed HSM Pool.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedHsmError - The error exception.
type ManagedHsmError struct {
	// READ-ONLY; The server error.
	Error *Error `json:"error,omitempty" azure:"ro"`
}

// ManagedHsmListResult - List of managed HSM Pools
type ManagedHsmListResult struct {
	// The URL to get the next set of managed HSM Pools.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of managed HSM Pools.
	Value []*ManagedHsm `json:"value,omitempty"`
}

// ManagedHsmProperties - Properties of the managed HSM Pool
type ManagedHsmProperties struct {
	// The create mode to indicate whether the resource is being created or is being recovered from a deleted resource.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Property specifying whether protection against purge is enabled for this managed HSM pool. Setting this property to true
	// activates protection against purge for this managed HSM pool and its content -
	// only the Managed HSM service may initiate a hard, irrecoverable deletion. The setting is effective only if soft delete
	// is also enabled. Enabling this functionality is irreversible.
	EnablePurgeProtection *bool `json:"enablePurgeProtection,omitempty"`

	// Property to specify whether the 'soft delete' functionality is enabled for this managed HSM pool. If it's not set to any
	// value(true or false) when creating new managed HSM pool, it will be set to true
	// by default. Once set to true, it cannot be reverted to false.
	EnableSoftDelete *bool `json:"enableSoftDelete,omitempty"`

	// Array of initial administrators object ids for this managed hsm pool.
	InitialAdminObjectIDs []*string `json:"initialAdminObjectIds,omitempty"`

	// Rules governing the accessibility of the key vault from specific network locations.
	NetworkACLs *MHSMNetworkRuleSet `json:"networkAcls,omitempty"`

	// Control permission for data plane traffic coming from public networks while private endpoint is enabled.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// softDelete data retention days. It accepts >=7 and <=90.
	SoftDeleteRetentionInDays *int32 `json:"softDeleteRetentionInDays,omitempty"`

	// The Azure Active Directory tenant ID that should be used for authenticating requests to the managed HSM pool.
	TenantID *string `json:"tenantId,omitempty"`

	// READ-ONLY; The URI of the managed hsm pool for performing operations on keys.
	HsmURI *string `json:"hsmUri,omitempty" azure:"ro"`

	// READ-ONLY; List of private endpoint connections associated with the managed hsm pool.
	PrivateEndpointConnections []*MHSMPrivateEndpointConnectionItem `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The scheduled purge date in UTC.
	ScheduledPurgeDate *time.Time `json:"scheduledPurgeDate,omitempty" azure:"ro"`

	// READ-ONLY; Resource Status Message.
	StatusMessage *string `json:"statusMessage,omitempty" azure:"ro"`
}

// ManagedHsmResource - Managed HSM resource
type ManagedHsmResource struct {
	// The supported Azure location where the managed HSM Pool should be created.
	Location *string `json:"location,omitempty"`

	// SKU details
	SKU *ManagedHsmSKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The Azure Resource Manager resource ID for the managed HSM Pool.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the managed HSM Pool.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the key vault resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The resource type of the managed HSM Pool.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedHsmSKU - SKU details
type ManagedHsmSKU struct {
	// REQUIRED; SKU Family of the managed HSM Pool
	Family *ManagedHsmSKUFamily `json:"family,omitempty"`

	// REQUIRED; SKU of the managed HSM Pool
	Name *ManagedHsmSKUName `json:"name,omitempty"`
}

// ManagedHsmsClientBeginCreateOrUpdateOptions contains the optional parameters for the ManagedHsmsClient.BeginCreateOrUpdate
// method.
type ManagedHsmsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedHsmsClientBeginDeleteOptions contains the optional parameters for the ManagedHsmsClient.BeginDelete method.
type ManagedHsmsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedHsmsClientBeginPurgeDeletedOptions contains the optional parameters for the ManagedHsmsClient.BeginPurgeDeleted
// method.
type ManagedHsmsClientBeginPurgeDeletedOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedHsmsClientBeginUpdateOptions contains the optional parameters for the ManagedHsmsClient.BeginUpdate method.
type ManagedHsmsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedHsmsClientGetDeletedOptions contains the optional parameters for the ManagedHsmsClient.GetDeleted method.
type ManagedHsmsClientGetDeletedOptions struct {
	// placeholder for future optional parameters
}

// ManagedHsmsClientGetOptions contains the optional parameters for the ManagedHsmsClient.Get method.
type ManagedHsmsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedHsmsClientListByResourceGroupOptions contains the optional parameters for the ManagedHsmsClient.ListByResourceGroup
// method.
type ManagedHsmsClientListByResourceGroupOptions struct {
	// Maximum number of results to return.
	Top *int32
}

// ManagedHsmsClientListBySubscriptionOptions contains the optional parameters for the ManagedHsmsClient.ListBySubscription
// method.
type ManagedHsmsClientListBySubscriptionOptions struct {
	// Maximum number of results to return.
	Top *int32
}

// ManagedHsmsClientListDeletedOptions contains the optional parameters for the ManagedHsmsClient.ListDeleted method.
type ManagedHsmsClientListDeletedOptions struct {
	// placeholder for future optional parameters
}

// MetricSpecification - Metric specification of operation.
type MetricSpecification struct {
	// The metric aggregation type. Possible values include: 'Average', 'Count', 'Total'.
	AggregationType *string `json:"aggregationType,omitempty"`

	// The dimensions of metric
	Dimensions []*DimensionProperties `json:"dimensions,omitempty"`

	// Display description of metric specification.
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// Display name of metric specification.
	DisplayName *string `json:"displayName,omitempty"`

	// Property to specify whether to fill gap with zero.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`

	// The internal metric name.
	InternalMetricName *string `json:"internalMetricName,omitempty"`

	// The metric lock aggregation type.
	LockAggregationType *string `json:"lockAggregationType,omitempty"`

	// Name of metric specification.
	Name *string `json:"name,omitempty"`

	// The supported aggregation types for the metrics.
	SupportedAggregationTypes []*string `json:"supportedAggregationTypes,omitempty"`

	// The supported time grain types for the metrics.
	SupportedTimeGrainTypes []*string `json:"supportedTimeGrainTypes,omitempty"`

	// The metric unit. Possible values include: 'Bytes', 'Count', 'Milliseconds'.
	Unit *string `json:"unit,omitempty"`
}

// NetworkRuleSet - A set of rules governing the network accessibility of a vault.
type NetworkRuleSet struct {
	// Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'. If not specified the default is 'AzureServices'.
	Bypass *NetworkRuleBypassOptions `json:"bypass,omitempty"`

	// The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property
	// has been evaluated.
	DefaultAction *NetworkRuleAction `json:"defaultAction,omitempty"`

	// The list of IP address rules.
	IPRules []*IPRule `json:"ipRules,omitempty"`

	// The list of virtual network rules.
	VirtualNetworkRules []*VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
}

// Operation - Key Vault REST API operation definition.
type Operation struct {
	// Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Property to specify whether the action is a data action.
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`

	// Properties of operation, include metric specifications.
	OperationProperties *OperationProperties `json:"properties,omitempty"`

	// The origin of operations.
	Origin *string `json:"origin,omitempty"`
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// Description of operation.
	Description *string `json:"description,omitempty"`

	// Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft Key Vault.
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed etc.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list Storage operations. It contains a list of operations and a URL link
// to get the next set of results.
type OperationListResult struct {
	// The URL to get the next set of operations.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Storage operations supported by the Storage resource provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationProperties - Properties of operation, include metric specifications.
type OperationProperties struct {
	// One property of operation, include metric specifications.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// Permissions the identity has for keys, secrets, certificates and storage.
type Permissions struct {
	// Permissions to certificates
	Certificates []*CertificatePermissions `json:"certificates,omitempty"`

	// Permissions to keys
	Keys []*KeyPermissions `json:"keys,omitempty"`

	// Permissions to secrets
	Secrets []*SecretPermissions `json:"secrets,omitempty"`

	// Permissions to storage accounts
	Storage []*StoragePermissions `json:"storage,omitempty"`
}

// PrivateEndpoint - Private endpoint object properties.
type PrivateEndpoint struct {
	// READ-ONLY; Full identifier of the private endpoint resource.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// PrivateEndpointConnection - Private endpoint connection resource.
type PrivateEndpointConnection struct {
	// Modified whenever there is a change in the state of private endpoint connection.
	Etag *string `json:"etag,omitempty"`

	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure location of the key vault resource.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Name of the key vault resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Tags assigned to the key vault resource.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type of the key vault resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionItem - Private endpoint connection item.
type PrivateEndpointConnectionItem struct {
	// Modified whenever there is a change in the state of private endpoint connection.
	Etag *string `json:"etag,omitempty"`

	// Id of private endpoint connection.
	ID *string `json:"id,omitempty"`

	// Private endpoint connection properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`
}

// PrivateEndpointConnectionListResult - List of private endpoint connections.
type PrivateEndpointConnectionListResult struct {
	// The URL to get the next set of private endpoint connections.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of private endpoint connections.
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of the private endpoint connection resource.
type PrivateEndpointConnectionProperties struct {
	// Properties of the private endpoint object.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// Approval state of the private link connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// Provisioning state of the private endpoint connection.
	ProvisioningState *PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListByResourceOptions contains the optional parameters for the PrivateEndpointConnectionsClient.ListByResource
// method.
type PrivateEndpointConnectionsClientListByResourceOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientPutOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Put
// method.
type PrivateEndpointConnectionsClientPutOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure location of the key vault resource.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Name of the key vault resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Tags assigned to the key vault resource.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type of the key vault resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// Required DNS zone names of the the private link resource.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`

	// READ-ONLY; Group identifier of private link resource.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; Required member names of private link resource.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientListByVaultOptions contains the optional parameters for the PrivateLinkResourcesClient.ListByVault
// method.
type PrivateLinkResourcesClientListByVaultOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServiceConnectionState - An object that represents the approval state of the private link connection.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *ActionsRequired `json:"actionsRequired,omitempty"`

	// The reason for approval or rejection.
	Description *string `json:"description,omitempty"`

	// Indicates whether the connection has been approved, rejected or removed by the key vault owner.
	Status *PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
}

// Resource - Key Vault resource
type Resource struct {
	// READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure location of the key vault resource.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Name of the key vault resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Tags assigned to the key vault resource.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type of the key vault resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceListResult - List of vault resources.
type ResourceListResult struct {
	// The URL to get the next set of vault resources.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of vault resources.
	Value []*Resource `json:"value,omitempty"`
}

type RotationPolicy struct {
	// The attributes of key rotation policy.
	Attributes *KeyRotationPolicyAttributes `json:"attributes,omitempty"`

	// The lifetimeActions for key rotation action.
	LifetimeActions []*LifetimeAction `json:"lifetimeActions,omitempty"`
}

// SKU details
type SKU struct {
	// REQUIRED; SKU family name
	Family *SKUFamily `json:"family,omitempty"`

	// REQUIRED; SKU name to specify whether the key vault is a standard vault or a premium vault.
	Name *SKUName `json:"name,omitempty"`
}

// Secret - Resource information with extended details.
type Secret struct {
	// REQUIRED; Properties of the secret
	Properties *SecretProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure location of the key vault resource.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Name of the key vault resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Tags assigned to the key vault resource.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type of the key vault resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SecretAttributes - The secret management attributes.
type SecretAttributes struct {
	// Determines whether the object is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Expiry date in seconds since 1970-01-01T00:00:00Z.
	Expires *time.Time `json:"exp,omitempty"`

	// Not before date in seconds since 1970-01-01T00:00:00Z.
	NotBefore *time.Time `json:"nbf,omitempty"`

	// READ-ONLY; Creation time in seconds since 1970-01-01T00:00:00Z.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; Last updated time in seconds since 1970-01-01T00:00:00Z.
	Updated *time.Time `json:"updated,omitempty" azure:"ro"`
}

// SecretCreateOrUpdateParameters - Parameters for creating or updating a secret
type SecretCreateOrUpdateParameters struct {
	// REQUIRED; Properties of the secret
	Properties *SecretProperties `json:"properties,omitempty"`

	// The tags that will be assigned to the secret.
	Tags map[string]*string `json:"tags,omitempty"`
}

// SecretListResult - List of secrets
type SecretListResult struct {
	// The URL to get the next set of secrets.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of secrets.
	Value []*Secret `json:"value,omitempty"`
}

// SecretPatchParameters - Parameters for patching a secret
type SecretPatchParameters struct {
	// Properties of the secret
	Properties *SecretPatchProperties `json:"properties,omitempty"`

	// The tags that will be assigned to the secret.
	Tags map[string]*string `json:"tags,omitempty"`
}

// SecretPatchProperties - Properties of the secret
type SecretPatchProperties struct {
	// The attributes of the secret.
	Attributes *SecretAttributes `json:"attributes,omitempty"`

	// The content type of the secret.
	ContentType *string `json:"contentType,omitempty"`

	// The value of the secret.
	Value *string `json:"value,omitempty"`
}

// SecretProperties - Properties of the secret
type SecretProperties struct {
	// The attributes of the secret.
	Attributes *SecretAttributes `json:"attributes,omitempty"`

	// The content type of the secret.
	ContentType *string `json:"contentType,omitempty"`

	// The value of the secret. NOTE: 'value' will never be returned from the service, as APIs using this model are is intended
	// for internal use in ARM deployments. Users should use the data-plane REST
	// service for interaction with vault secrets.
	Value *string `json:"value,omitempty"`

	// READ-ONLY; The URI to retrieve the current version of the secret.
	SecretURI *string `json:"secretUri,omitempty" azure:"ro"`

	// READ-ONLY; The URI to retrieve the specific version of the secret.
	SecretURIWithVersion *string `json:"secretUriWithVersion,omitempty" azure:"ro"`
}

// SecretsClientCreateOrUpdateOptions contains the optional parameters for the SecretsClient.CreateOrUpdate method.
type SecretsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SecretsClientGetOptions contains the optional parameters for the SecretsClient.Get method.
type SecretsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SecretsClientListOptions contains the optional parameters for the SecretsClient.List method.
type SecretsClientListOptions struct {
	// Maximum number of results to return.
	Top *int32
}

// SecretsClientUpdateOptions contains the optional parameters for the SecretsClient.Update method.
type SecretsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ServiceSpecification - One property of operation, include log specifications.
type ServiceSpecification struct {
	// Log specifications of operation.
	LogSpecifications []*LogSpecification `json:"logSpecifications,omitempty"`

	// Metric specifications of operation.
	MetricSpecifications []*MetricSpecification `json:"metricSpecifications,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the key vault resource.
type SystemData struct {
	// The timestamp of the key vault resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the key vault resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the key vault resource.
	CreatedByType *IdentityType `json:"createdByType,omitempty"`

	// The timestamp of the key vault resource last modification (UTC).
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the key vault resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the key vault resource.
	LastModifiedByType *IdentityType `json:"lastModifiedByType,omitempty"`
}

type Trigger struct {
	// The time duration after key creation to rotate the key. It only applies to rotate. It will be in ISO 8601 duration format.
	// Eg: 'P90D', 'P1Y'.
	TimeAfterCreate *string `json:"timeAfterCreate,omitempty"`

	// The time duration before key expiring to rotate or notify. It will be in ISO 8601 duration format. Eg: 'P90D', 'P1Y'.
	TimeBeforeExpiry *string `json:"timeBeforeExpiry,omitempty"`
}

// Vault - Resource information with extended details.
type Vault struct {
	// REQUIRED; Properties of the vault
	Properties *VaultProperties `json:"properties,omitempty"`

	// Azure location of the key vault resource.
	Location *string `json:"location,omitempty"`

	// Tags assigned to the key vault resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the key vault resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System metadata for the key vault.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type of the key vault resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VaultAccessPolicyParameters - Parameters for updating the access policy in a vault
type VaultAccessPolicyParameters struct {
	// REQUIRED; Properties of the access policy
	Properties *VaultAccessPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the access policy.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource type of the access policy.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The resource name of the access policy.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource name of the access policy.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VaultAccessPolicyProperties - Properties of the vault access policy
type VaultAccessPolicyProperties struct {
	// REQUIRED; An array of 0 to 16 identities that have access to the key vault. All identities in the array must use the same
	// tenant ID as the key vault's tenant ID.
	AccessPolicies []*AccessPolicyEntry `json:"accessPolicies,omitempty"`
}

// VaultCheckNameAvailabilityParameters - The parameters used to check the availability of the vault name.
type VaultCheckNameAvailabilityParameters struct {
	// REQUIRED; The vault name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; The type of resource, Microsoft.KeyVault/vaults
	Type *string `json:"type,omitempty"`
}

// VaultCreateOrUpdateParameters - Parameters for creating or updating a vault
type VaultCreateOrUpdateParameters struct {
	// REQUIRED; The supported Azure location where the key vault should be created.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Properties of the vault
	Properties *VaultProperties `json:"properties,omitempty"`

	// The tags that will be assigned to the key vault.
	Tags map[string]*string `json:"tags,omitempty"`
}

// VaultListResult - List of vaults
type VaultListResult struct {
	// The URL to get the next set of vaults.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of vaults.
	Value []*Vault `json:"value,omitempty"`
}

// VaultPatchParameters - Parameters for creating or updating a vault
type VaultPatchParameters struct {
	// Properties of the vault
	Properties *VaultPatchProperties `json:"properties,omitempty"`

	// The tags that will be assigned to the key vault.
	Tags map[string]*string `json:"tags,omitempty"`
}

// VaultPatchProperties - Properties of the vault
type VaultPatchProperties struct {
	// An array of 0 to 16 identities that have access to the key vault. All identities in the array must use the same tenant
	// ID as the key vault's tenant ID.
	AccessPolicies []*AccessPolicyEntry `json:"accessPolicies,omitempty"`

	// The vault's create mode to indicate whether the vault need to be recovered or not.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Property specifying whether protection against purge is enabled for this vault. Setting this property to true activates
	// protection against purge for this vault and its content - only the Key Vault
	// service may initiate a hard, irrecoverable deletion. The setting is effective only if soft delete is also enabled. Enabling
	// this functionality is irreversible - that is, the property does not accept
	// false as its value.
	EnablePurgeProtection *bool `json:"enablePurgeProtection,omitempty"`

	// Property that controls how data actions are authorized. When true, the key vault will use Role Based Access Control (RBAC)
	// for authorization of data actions, and the access policies specified in vault
	// properties will be ignored (warning: this is a preview feature). When false, the key vault will use the access policies
	// specified in vault properties, and any policy stored on Azure Resource Manager
	// will be ignored. If null or not specified, the value of this property will not change.
	EnableRbacAuthorization *bool `json:"enableRbacAuthorization,omitempty"`

	// Property to specify whether the 'soft delete' functionality is enabled for this key vault. Once set to true, it cannot
	// be reverted to false.
	EnableSoftDelete *bool `json:"enableSoftDelete,omitempty"`

	// Property to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key
	// vault.
	EnabledForDeployment *bool `json:"enabledForDeployment,omitempty"`

	// Property to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
	EnabledForDiskEncryption *bool `json:"enabledForDiskEncryption,omitempty"`

	// Property to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
	EnabledForTemplateDeployment *bool `json:"enabledForTemplateDeployment,omitempty"`

	// A collection of rules governing the accessibility of the vault from specific network locations.
	NetworkACLs *NetworkRuleSet `json:"networkAcls,omitempty"`

	// Property to specify whether the vault will accept traffic from public internet. If set to 'disabled' all traffic except
	// private endpoint traffic and that that originates from trusted services will be
	// blocked. This will override the set firewall rules, meaning that even if the firewall rules are present we will not honor
	// the rules.
	PublicNetworkAccess *string `json:"publicNetworkAccess,omitempty"`

	// SKU details
	SKU *SKU `json:"sku,omitempty"`

	// softDelete data retention days. It accepts >=7 and <=90.
	SoftDeleteRetentionInDays *int32 `json:"softDeleteRetentionInDays,omitempty"`

	// The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
	TenantID *string `json:"tenantId,omitempty"`
}

// VaultProperties - Properties of the vault
type VaultProperties struct {
	// REQUIRED; SKU details
	SKU *SKU `json:"sku,omitempty"`

	// REQUIRED; The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
	TenantID *string `json:"tenantId,omitempty"`

	// An array of 0 to 1024 identities that have access to the key vault. All identities in the array must use the same tenant
	// ID as the key vault's tenant ID. When createMode is set to recover, access
	// policies are not required. Otherwise, access policies are required.
	AccessPolicies []*AccessPolicyEntry `json:"accessPolicies,omitempty"`

	// The vault's create mode to indicate whether the vault need to be recovered or not.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Property specifying whether protection against purge is enabled for this vault. Setting this property to true activates
	// protection against purge for this vault and its content - only the Key Vault
	// service may initiate a hard, irrecoverable deletion. The setting is effective only if soft delete is also enabled. Enabling
	// this functionality is irreversible - that is, the property does not accept
	// false as its value.
	EnablePurgeProtection *bool `json:"enablePurgeProtection,omitempty"`

	// Property that controls how data actions are authorized. When true, the key vault will use Role Based Access Control (RBAC)
	// for authorization of data actions, and the access policies specified in vault
	// properties will be ignored (warning: this is a preview feature). When false, the key vault will use the access policies
	// specified in vault properties, and any policy stored on Azure Resource Manager
	// will be ignored. If null or not specified, the vault is created with the default value of false. Note that management actions
	// are always authorized with RBAC.
	EnableRbacAuthorization *bool `json:"enableRbacAuthorization,omitempty"`

	// Property to specify whether the 'soft delete' functionality is enabled for this key vault. If it's not set to any value(true
	// or false) when creating new key vault, it will be set to true by default.
	// Once set to true, it cannot be reverted to false.
	EnableSoftDelete *bool `json:"enableSoftDelete,omitempty"`

	// Property to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key
	// vault.
	EnabledForDeployment *bool `json:"enabledForDeployment,omitempty"`

	// Property to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
	EnabledForDiskEncryption *bool `json:"enabledForDiskEncryption,omitempty"`

	// Property to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
	EnabledForTemplateDeployment *bool `json:"enabledForTemplateDeployment,omitempty"`

	// Rules governing the accessibility of the key vault from specific network locations.
	NetworkACLs *NetworkRuleSet `json:"networkAcls,omitempty"`

	// Provisioning state of the vault.
	ProvisioningState *VaultProvisioningState `json:"provisioningState,omitempty"`

	// Property to specify whether the vault will accept traffic from public internet. If set to 'disabled' all traffic except
	// private endpoint traffic and that that originates from trusted services will be
	// blocked. This will override the set firewall rules, meaning that even if the firewall rules are present we will not honor
	// the rules.
	PublicNetworkAccess *string `json:"publicNetworkAccess,omitempty"`

	// softDelete data retention days. It accepts >=7 and <=90.
	SoftDeleteRetentionInDays *int32 `json:"softDeleteRetentionInDays,omitempty"`

	// The URI of the vault for performing operations on keys and secrets.
	VaultURI *string `json:"vaultUri,omitempty"`

	// READ-ONLY; The resource id of HSM Pool.
	HsmPoolResourceID *string `json:"hsmPoolResourceId,omitempty" azure:"ro"`

	// READ-ONLY; List of private endpoint connections associated with the key vault.
	PrivateEndpointConnections []*PrivateEndpointConnectionItem `json:"privateEndpointConnections,omitempty" azure:"ro"`
}

// VaultsClientBeginCreateOrUpdateOptions contains the optional parameters for the VaultsClient.BeginCreateOrUpdate method.
type VaultsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VaultsClientBeginPurgeDeletedOptions contains the optional parameters for the VaultsClient.BeginPurgeDeleted method.
type VaultsClientBeginPurgeDeletedOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VaultsClientCheckNameAvailabilityOptions contains the optional parameters for the VaultsClient.CheckNameAvailability method.
type VaultsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// VaultsClientDeleteOptions contains the optional parameters for the VaultsClient.Delete method.
type VaultsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// VaultsClientGetDeletedOptions contains the optional parameters for the VaultsClient.GetDeleted method.
type VaultsClientGetDeletedOptions struct {
	// placeholder for future optional parameters
}

// VaultsClientGetOptions contains the optional parameters for the VaultsClient.Get method.
type VaultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// VaultsClientListByResourceGroupOptions contains the optional parameters for the VaultsClient.ListByResourceGroup method.
type VaultsClientListByResourceGroupOptions struct {
	// Maximum number of results to return.
	Top *int32
}

// VaultsClientListBySubscriptionOptions contains the optional parameters for the VaultsClient.ListBySubscription method.
type VaultsClientListBySubscriptionOptions struct {
	// Maximum number of results to return.
	Top *int32
}

// VaultsClientListDeletedOptions contains the optional parameters for the VaultsClient.ListDeleted method.
type VaultsClientListDeletedOptions struct {
	// placeholder for future optional parameters
}

// VaultsClientListOptions contains the optional parameters for the VaultsClient.List method.
type VaultsClientListOptions struct {
	// Maximum number of results to return.
	Top *int32
}

// VaultsClientUpdateAccessPolicyOptions contains the optional parameters for the VaultsClient.UpdateAccessPolicy method.
type VaultsClientUpdateAccessPolicyOptions struct {
	// placeholder for future optional parameters
}

// VaultsClientUpdateOptions contains the optional parameters for the VaultsClient.Update method.
type VaultsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkRule - A rule governing the accessibility of a vault from a specific virtual network.
type VirtualNetworkRule struct {
	// REQUIRED; Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
	ID *string `json:"id,omitempty"`

	// Property to specify whether NRP will ignore the check if parent subnet has serviceEndpoints configured.
	IgnoreMissingVnetServiceEndpoint *bool `json:"ignoreMissingVnetServiceEndpoint,omitempty"`
}
