//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcustomerinsights

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// WidgetTypesClient contains the methods for the WidgetTypes group.
// Don't use this type directly, use NewWidgetTypesClient() instead.
type WidgetTypesClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewWidgetTypesClient creates a new instance of WidgetTypesClient with the specified values.
// subscriptionID - Gets subscription credentials which uniquely identify Microsoft Azure subscription. The subscription ID
// forms part of the URI for every service call.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewWidgetTypesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*WidgetTypesClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &WidgetTypesClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// Get - Gets a widget type in the specified hub.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-04-26
// resourceGroupName - The name of the resource group.
// hubName - The name of the hub.
// widgetTypeName - The name of the widget type.
// options - WidgetTypesClientGetOptions contains the optional parameters for the WidgetTypesClient.Get method.
func (client *WidgetTypesClient) Get(ctx context.Context, resourceGroupName string, hubName string, widgetTypeName string, options *WidgetTypesClientGetOptions) (WidgetTypesClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, hubName, widgetTypeName, options)
	if err != nil {
		return WidgetTypesClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return WidgetTypesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return WidgetTypesClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *WidgetTypesClient) getCreateRequest(ctx context.Context, resourceGroupName string, hubName string, widgetTypeName string, options *WidgetTypesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/widgetTypes/{widgetTypeName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hubName == "" {
		return nil, errors.New("parameter hubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hubName}", url.PathEscape(hubName))
	if widgetTypeName == "" {
		return nil, errors.New("parameter widgetTypeName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{widgetTypeName}", url.PathEscape(widgetTypeName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-04-26")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *WidgetTypesClient) getHandleResponse(resp *http.Response) (WidgetTypesClientGetResponse, error) {
	result := WidgetTypesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WidgetTypeResourceFormat); err != nil {
		return WidgetTypesClientGetResponse{}, err
	}
	return result, nil
}

// NewListByHubPager - Gets all available widget types in the specified hub.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-04-26
// resourceGroupName - The name of the resource group.
// hubName - The name of the hub.
// options - WidgetTypesClientListByHubOptions contains the optional parameters for the WidgetTypesClient.ListByHub method.
func (client *WidgetTypesClient) NewListByHubPager(resourceGroupName string, hubName string, options *WidgetTypesClientListByHubOptions) *runtime.Pager[WidgetTypesClientListByHubResponse] {
	return runtime.NewPager(runtime.PagingHandler[WidgetTypesClientListByHubResponse]{
		More: func(page WidgetTypesClientListByHubResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WidgetTypesClientListByHubResponse) (WidgetTypesClientListByHubResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByHubCreateRequest(ctx, resourceGroupName, hubName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return WidgetTypesClientListByHubResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return WidgetTypesClientListByHubResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return WidgetTypesClientListByHubResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByHubHandleResponse(resp)
		},
	})
}

// listByHubCreateRequest creates the ListByHub request.
func (client *WidgetTypesClient) listByHubCreateRequest(ctx context.Context, resourceGroupName string, hubName string, options *WidgetTypesClientListByHubOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/widgetTypes"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hubName == "" {
		return nil, errors.New("parameter hubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hubName}", url.PathEscape(hubName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-04-26")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByHubHandleResponse handles the ListByHub response.
func (client *WidgetTypesClient) listByHubHandleResponse(resp *http.Response) (WidgetTypesClientListByHubResponse, error) {
	result := WidgetTypesClientListByHubResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WidgetTypeListResult); err != nil {
		return WidgetTypesClientListByHubResponse{}, err
	}
	return result, nil
}
