// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/confidentialcomputing/v1/service.proto

package confidentialcomputingpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// SigningAlgorithm enumerates all the supported signing algorithms.
type SigningAlgorithm int32

const (
	// Unspecified signing algorithm.
	SigningAlgorithm_SIGNING_ALGORITHM_UNSPECIFIED SigningAlgorithm = 0
	// RSASSA-PSS with a SHA256 digest.
	SigningAlgorithm_RSASSA_PSS_SHA256 SigningAlgorithm = 1
	// RSASSA-PKCS1 v1.5 with a SHA256 digest.
	SigningAlgorithm_RSASSA_PKCS1V15_SHA256 SigningAlgorithm = 2
	// ECDSA on the P-256 Curve with a SHA256 digest.
	SigningAlgorithm_ECDSA_P256_SHA256 SigningAlgorithm = 3
)

// Enum value maps for SigningAlgorithm.
var (
	SigningAlgorithm_name = map[int32]string{
		0: "SIGNING_ALGORITHM_UNSPECIFIED",
		1: "RSASSA_PSS_SHA256",
		2: "RSASSA_PKCS1V15_SHA256",
		3: "ECDSA_P256_SHA256",
	}
	SigningAlgorithm_value = map[string]int32{
		"SIGNING_ALGORITHM_UNSPECIFIED": 0,
		"RSASSA_PSS_SHA256":             1,
		"RSASSA_PKCS1V15_SHA256":        2,
		"ECDSA_P256_SHA256":             3,
	}
)

func (x SigningAlgorithm) Enum() *SigningAlgorithm {
	p := new(SigningAlgorithm)
	*p = x
	return p
}

func (x SigningAlgorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SigningAlgorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_confidentialcomputing_v1_service_proto_enumTypes[0].Descriptor()
}

func (SigningAlgorithm) Type() protoreflect.EnumType {
	return &file_google_cloud_confidentialcomputing_v1_service_proto_enumTypes[0]
}

func (x SigningAlgorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SigningAlgorithm.Descriptor instead.
func (SigningAlgorithm) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_confidentialcomputing_v1_service_proto_rawDescGZIP(), []int{0}
}

// Token type enum contains the different types of token responses Confidential
// Space supports
type TokenType int32

const (
	// Unspecified token type
	TokenType_TOKEN_TYPE_UNSPECIFIED TokenType = 0
	// OpenID Connect (OIDC) token type
	TokenType_TOKEN_TYPE_OIDC TokenType = 1
)

// Enum value maps for TokenType.
var (
	TokenType_name = map[int32]string{
		0: "TOKEN_TYPE_UNSPECIFIED",
		1: "TOKEN_TYPE_OIDC",
	}
	TokenType_value = map[string]int32{
		"TOKEN_TYPE_UNSPECIFIED": 0,
		"TOKEN_TYPE_OIDC":        1,
	}
)

func (x TokenType) Enum() *TokenType {
	p := new(TokenType)
	*p = x
	return p
}

func (x TokenType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TokenType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_confidentialcomputing_v1_service_proto_enumTypes[1].Descriptor()
}

func (TokenType) Type() protoreflect.EnumType {
	return &file_google_cloud_confidentialcomputing_v1_service_proto_enumTypes[1]
}

func (x TokenType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TokenType.Descriptor instead.
func (TokenType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_confidentialcomputing_v1_service_proto_rawDescGZIP(), []int{1}
}

// A Challenge from the server used to guarantee freshness of attestations
type Challenge struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name for this Challenge in the format
	// `projects/*/locations/*/challenges/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time at which this Challenge was created
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which this Challenge will no longer be usable. It
	// is also the expiration time for any tokens generated from this Challenge.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Output only. Indicates if this challenge has been used to generate a token.
	Used bool `protobuf:"varint,4,opt,name=used,proto3" json:"used,omitempty"`
	// Output only. Identical to nonce, but as a string.
	TpmNonce string `protobuf:"bytes,6,opt,name=tpm_nonce,json=tpmNonce,proto3" json:"tpm_nonce,omitempty"`
}

func (x *Challenge) Reset() {
	*x = Challenge{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Challenge) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Challenge) ProtoMessage() {}

func (x *Challenge) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Challenge.ProtoReflect.Descriptor instead.
func (*Challenge) Descriptor() ([]byte, []int) {
	return file_google_cloud_confidentialcomputing_v1_service_proto_rawDescGZIP(), []int{0}
}

func (x *Challenge) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Challenge) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Challenge) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *Challenge) GetUsed() bool {
	if x != nil {
		return x.Used
	}
	return false
}

func (x *Challenge) GetTpmNonce() string {
	if x != nil {
		return x.TpmNonce
	}
	return ""
}

// Message for creating a Challenge
type CreateChallengeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the location where the Challenge will be
	// used, in the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Challenge to be created. Currently this field can be empty as
	// all the Challenge fields are set by the server.
	Challenge *Challenge `protobuf:"bytes,2,opt,name=challenge,proto3" json:"challenge,omitempty"`
}

func (x *CreateChallengeRequest) Reset() {
	*x = CreateChallengeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateChallengeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateChallengeRequest) ProtoMessage() {}

func (x *CreateChallengeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateChallengeRequest.ProtoReflect.Descriptor instead.
func (*CreateChallengeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_confidentialcomputing_v1_service_proto_rawDescGZIP(), []int{1}
}

func (x *CreateChallengeRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateChallengeRequest) GetChallenge() *Challenge {
	if x != nil {
		return x.Challenge
	}
	return nil
}

// A request for an OIDC token, providing all the necessary information needed
// for this service to verify the plaform state of the requestor.
type VerifyAttestationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Challenge whose nonce was used to generate the
	// attestation, in the format `projects/*/locations/*/challenges/*`. The
	// provided Challenge will be consumed, and cannot be used again.
	Challenge string `protobuf:"bytes,1,opt,name=challenge,proto3" json:"challenge,omitempty"`
	// Optional. Credentials used to populate the "emails" claim in the
	// claims_token.
	GcpCredentials *GcpCredentials `protobuf:"bytes,2,opt,name=gcp_credentials,json=gcpCredentials,proto3" json:"gcp_credentials,omitempty"`
	// Required. The TPM-specific data provided by the attesting platform, used to
	// populate any of the claims regarding platform state.
	TpmAttestation *TpmAttestation `protobuf:"bytes,3,opt,name=tpm_attestation,json=tpmAttestation,proto3" json:"tpm_attestation,omitempty"`
	// Optional. Optional information related to the Confidential Space TEE.
	ConfidentialSpaceInfo *ConfidentialSpaceInfo `protobuf:"bytes,4,opt,name=confidential_space_info,json=confidentialSpaceInfo,proto3" json:"confidential_space_info,omitempty"`
	// Optional. A collection of optional, workload-specified claims that modify
	// the token output.
	TokenOptions *TokenOptions `protobuf:"bytes,5,opt,name=token_options,json=tokenOptions,proto3" json:"token_options,omitempty"`
}

func (x *VerifyAttestationRequest) Reset() {
	*x = VerifyAttestationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VerifyAttestationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyAttestationRequest) ProtoMessage() {}

func (x *VerifyAttestationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyAttestationRequest.ProtoReflect.Descriptor instead.
func (*VerifyAttestationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_confidentialcomputing_v1_service_proto_rawDescGZIP(), []int{2}
}

func (x *VerifyAttestationRequest) GetChallenge() string {
	if x != nil {
		return x.Challenge
	}
	return ""
}

func (x *VerifyAttestationRequest) GetGcpCredentials() *GcpCredentials {
	if x != nil {
		return x.GcpCredentials
	}
	return nil
}

func (x *VerifyAttestationRequest) GetTpmAttestation() *TpmAttestation {
	if x != nil {
		return x.TpmAttestation
	}
	return nil
}

func (x *VerifyAttestationRequest) GetConfidentialSpaceInfo() *ConfidentialSpaceInfo {
	if x != nil {
		return x.ConfidentialSpaceInfo
	}
	return nil
}

func (x *VerifyAttestationRequest) GetTokenOptions() *TokenOptions {
	if x != nil {
		return x.TokenOptions
	}
	return nil
}

// A response once an attestation has been successfully verified, containing a
// signed OIDC token.
type VerifyAttestationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Same as claims_token, but as a string.
	OidcClaimsToken string `protobuf:"bytes,2,opt,name=oidc_claims_token,json=oidcClaimsToken,proto3" json:"oidc_claims_token,omitempty"`
	// Output only. A list of messages that carry the partial error details
	// related to VerifyAttestation.
	PartialErrors []*status.Status `protobuf:"bytes,3,rep,name=partial_errors,json=partialErrors,proto3" json:"partial_errors,omitempty"`
}

func (x *VerifyAttestationResponse) Reset() {
	*x = VerifyAttestationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VerifyAttestationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyAttestationResponse) ProtoMessage() {}

func (x *VerifyAttestationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyAttestationResponse.ProtoReflect.Descriptor instead.
func (*VerifyAttestationResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_confidentialcomputing_v1_service_proto_rawDescGZIP(), []int{3}
}

func (x *VerifyAttestationResponse) GetOidcClaimsToken() string {
	if x != nil {
		return x.OidcClaimsToken
	}
	return ""
}

func (x *VerifyAttestationResponse) GetPartialErrors() []*status.Status {
	if x != nil {
		return x.PartialErrors
	}
	return nil
}

// Credentials issued by GCP which are linked to the platform attestation. These
// will be verified server-side as part of attestaion verification.
type GcpCredentials struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Same as id_tokens, but as a string.
	ServiceAccountIdTokens []string `protobuf:"bytes,2,rep,name=service_account_id_tokens,json=serviceAccountIdTokens,proto3" json:"service_account_id_tokens,omitempty"`
}

func (x *GcpCredentials) Reset() {
	*x = GcpCredentials{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcpCredentials) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcpCredentials) ProtoMessage() {}

func (x *GcpCredentials) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcpCredentials.ProtoReflect.Descriptor instead.
func (*GcpCredentials) Descriptor() ([]byte, []int) {
	return file_google_cloud_confidentialcomputing_v1_service_proto_rawDescGZIP(), []int{4}
}

func (x *GcpCredentials) GetServiceAccountIdTokens() []string {
	if x != nil {
		return x.ServiceAccountIdTokens
	}
	return nil
}

// Options to modify claims in the token to generate custom-purpose tokens.
type TokenOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Optional string to issue the token with a custom audience claim.
	// Required if one or more nonces are specified.
	Audience string `protobuf:"bytes,1,opt,name=audience,proto3" json:"audience,omitempty"`
	// Optional. Optional parameter to place one or more nonces in the eat_nonce
	// claim in the output token. The minimum size for JSON-encoded EATs is 10
	// bytes and the maximum size is 74 bytes.
	Nonce []string `protobuf:"bytes,2,rep,name=nonce,proto3" json:"nonce,omitempty"`
	// Optional. Optional token type to select what type of token to return.
	TokenType TokenType `protobuf:"varint,3,opt,name=token_type,json=tokenType,proto3,enum=google.cloud.confidentialcomputing.v1.TokenType" json:"token_type,omitempty"`
}

func (x *TokenOptions) Reset() {
	*x = TokenOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TokenOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TokenOptions) ProtoMessage() {}

func (x *TokenOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TokenOptions.ProtoReflect.Descriptor instead.
func (*TokenOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_confidentialcomputing_v1_service_proto_rawDescGZIP(), []int{5}
}

func (x *TokenOptions) GetAudience() string {
	if x != nil {
		return x.Audience
	}
	return ""
}

func (x *TokenOptions) GetNonce() []string {
	if x != nil {
		return x.Nonce
	}
	return nil
}

func (x *TokenOptions) GetTokenType() TokenType {
	if x != nil {
		return x.TokenType
	}
	return TokenType_TOKEN_TYPE_UNSPECIFIED
}

// TPM2 data containing everything necessary to validate any platform state
// measured into the TPM.
type TpmAttestation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// TPM2 PCR Quotes generated by calling TPM2_Quote on each PCR bank.
	Quotes []*TpmAttestation_Quote `protobuf:"bytes,1,rep,name=quotes,proto3" json:"quotes,omitempty"`
	// The binary TCG Event Log containing events measured into the TPM by the
	// platform firmware and operating system. Formatted as described in the
	// "TCG PC Client Platform Firmware Profile Specification".
	TcgEventLog []byte `protobuf:"bytes,2,opt,name=tcg_event_log,json=tcgEventLog,proto3" json:"tcg_event_log,omitempty"`
	// An Event Log containing additional events measured into the TPM that are
	// not already present in the tcg_event_log. Formatted as described in the
	// "Canonical Event Log Format" TCG Specification.
	CanonicalEventLog []byte `protobuf:"bytes,3,opt,name=canonical_event_log,json=canonicalEventLog,proto3" json:"canonical_event_log,omitempty"`
	// DER-encoded X.509 certificate of the Attestation Key (otherwise known as
	// an AK or a TPM restricted signing key) used to generate the quotes.
	AkCert []byte `protobuf:"bytes,4,opt,name=ak_cert,json=akCert,proto3" json:"ak_cert,omitempty"`
	// List of DER-encoded X.509 certificates which, together with the ak_cert,
	// chain back to a trusted Root Certificate.
	CertChain [][]byte `protobuf:"bytes,5,rep,name=cert_chain,json=certChain,proto3" json:"cert_chain,omitempty"`
}

func (x *TpmAttestation) Reset() {
	*x = TpmAttestation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TpmAttestation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TpmAttestation) ProtoMessage() {}

func (x *TpmAttestation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TpmAttestation.ProtoReflect.Descriptor instead.
func (*TpmAttestation) Descriptor() ([]byte, []int) {
	return file_google_cloud_confidentialcomputing_v1_service_proto_rawDescGZIP(), []int{6}
}

func (x *TpmAttestation) GetQuotes() []*TpmAttestation_Quote {
	if x != nil {
		return x.Quotes
	}
	return nil
}

func (x *TpmAttestation) GetTcgEventLog() []byte {
	if x != nil {
		return x.TcgEventLog
	}
	return nil
}

func (x *TpmAttestation) GetCanonicalEventLog() []byte {
	if x != nil {
		return x.CanonicalEventLog
	}
	return nil
}

func (x *TpmAttestation) GetAkCert() []byte {
	if x != nil {
		return x.AkCert
	}
	return nil
}

func (x *TpmAttestation) GetCertChain() [][]byte {
	if x != nil {
		return x.CertChain
	}
	return nil
}

// ConfidentialSpaceInfo contains information related to the Confidential Space
// TEE.
type ConfidentialSpaceInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A list of signed entities containing container image signatures
	// that can be used for server-side signature verification.
	SignedEntities []*SignedEntity `protobuf:"bytes,1,rep,name=signed_entities,json=signedEntities,proto3" json:"signed_entities,omitempty"`
}

func (x *ConfidentialSpaceInfo) Reset() {
	*x = ConfidentialSpaceInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfidentialSpaceInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfidentialSpaceInfo) ProtoMessage() {}

func (x *ConfidentialSpaceInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfidentialSpaceInfo.ProtoReflect.Descriptor instead.
func (*ConfidentialSpaceInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_confidentialcomputing_v1_service_proto_rawDescGZIP(), []int{7}
}

func (x *ConfidentialSpaceInfo) GetSignedEntities() []*SignedEntity {
	if x != nil {
		return x.SignedEntities
	}
	return nil
}

// SignedEntity represents an OCI image object containing everything necessary
// to verify container image signatures.
type SignedEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A list of container image signatures attached to an OCI image
	// object.
	ContainerImageSignatures []*ContainerImageSignature `protobuf:"bytes,1,rep,name=container_image_signatures,json=containerImageSignatures,proto3" json:"container_image_signatures,omitempty"`
}

func (x *SignedEntity) Reset() {
	*x = SignedEntity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignedEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignedEntity) ProtoMessage() {}

func (x *SignedEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignedEntity.ProtoReflect.Descriptor instead.
func (*SignedEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_confidentialcomputing_v1_service_proto_rawDescGZIP(), []int{8}
}

func (x *SignedEntity) GetContainerImageSignatures() []*ContainerImageSignature {
	if x != nil {
		return x.ContainerImageSignatures
	}
	return nil
}

// ContainerImageSignature holds necessary metadata to verify a container image
// signature.
type ContainerImageSignature struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The binary signature payload following the SimpleSigning format
	// https://github.com/sigstore/cosign/blob/main/specs/SIGNATURE_SPEC.md#simple-signing.
	// This payload includes the container image digest.
	Payload []byte `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	// Optional. A signature over the payload.
	// The container image digest is incorporated into the signature as follows:
	// 1. Generate a SimpleSigning format payload that includes the container
	// image digest.
	// 2. Generate a signature over SHA256 digest of the payload.
	// The signature generation process can be represented as follows:
	// `Sign(sha256(SimpleSigningPayload(sha256(Image Manifest))))`
	Signature []byte `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
	// Optional. Reserved for future use.
	PublicKey []byte `protobuf:"bytes,3,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// Optional. Reserved for future use.
	SigAlg SigningAlgorithm `protobuf:"varint,4,opt,name=sig_alg,json=sigAlg,proto3,enum=google.cloud.confidentialcomputing.v1.SigningAlgorithm" json:"sig_alg,omitempty"`
}

func (x *ContainerImageSignature) Reset() {
	*x = ContainerImageSignature{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContainerImageSignature) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContainerImageSignature) ProtoMessage() {}

func (x *ContainerImageSignature) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContainerImageSignature.ProtoReflect.Descriptor instead.
func (*ContainerImageSignature) Descriptor() ([]byte, []int) {
	return file_google_cloud_confidentialcomputing_v1_service_proto_rawDescGZIP(), []int{9}
}

func (x *ContainerImageSignature) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *ContainerImageSignature) GetSignature() []byte {
	if x != nil {
		return x.Signature
	}
	return nil
}

func (x *ContainerImageSignature) GetPublicKey() []byte {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

func (x *ContainerImageSignature) GetSigAlg() SigningAlgorithm {
	if x != nil {
		return x.SigAlg
	}
	return SigningAlgorithm_SIGNING_ALGORITHM_UNSPECIFIED
}

// Information about Platform Control Registers (PCRs) including a signature
// over their values, which can be used for remote validation.
type TpmAttestation_Quote struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The hash algorithm of the PCR bank being quoted, encoded as a TPM_ALG_ID
	HashAlgo int32 `protobuf:"varint,1,opt,name=hash_algo,json=hashAlgo,proto3" json:"hash_algo,omitempty"`
	// Raw binary values of each PCRs being quoted.
	PcrValues map[int32][]byte `protobuf:"bytes,2,rep,name=pcr_values,json=pcrValues,proto3" json:"pcr_values,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// TPM2 quote, encoded as a TPMS_ATTEST
	RawQuote []byte `protobuf:"bytes,3,opt,name=raw_quote,json=rawQuote,proto3" json:"raw_quote,omitempty"`
	// TPM2 signature, encoded as a TPMT_SIGNATURE
	RawSignature []byte `protobuf:"bytes,4,opt,name=raw_signature,json=rawSignature,proto3" json:"raw_signature,omitempty"`
}

func (x *TpmAttestation_Quote) Reset() {
	*x = TpmAttestation_Quote{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TpmAttestation_Quote) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TpmAttestation_Quote) ProtoMessage() {}

func (x *TpmAttestation_Quote) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TpmAttestation_Quote.ProtoReflect.Descriptor instead.
func (*TpmAttestation_Quote) Descriptor() ([]byte, []int) {
	return file_google_cloud_confidentialcomputing_v1_service_proto_rawDescGZIP(), []int{6, 0}
}

func (x *TpmAttestation_Quote) GetHashAlgo() int32 {
	if x != nil {
		return x.HashAlgo
	}
	return 0
}

func (x *TpmAttestation_Quote) GetPcrValues() map[int32][]byte {
	if x != nil {
		return x.PcrValues
	}
	return nil
}

func (x *TpmAttestation_Quote) GetRawQuote() []byte {
	if x != nil {
		return x.RawQuote
	}
	return nil
}

func (x *TpmAttestation_Quote) GetRawSignature() []byte {
	if x != nil {
		return x.RawSignature
	}
	return nil
}

var File_google_cloud_confidentialcomputing_v1_service_proto protoreflect.FileDescriptor

var file_google_cloud_confidentialcomputing_v1_service_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd3, 0x02, 0x0a, 0x09, 0x43, 0x68,
	0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x75, 0x73, 0x65, 0x64, 0x12, 0x20, 0x0a,
	0x09, 0x74, 0x70, 0x6d, 0x5f, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x74, 0x70, 0x6d, 0x4e, 0x6f, 0x6e, 0x63, 0x65, 0x3a,
	0x6e, 0xea, 0x41, 0x6b, 0x0a, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x68, 0x61, 0x6c, 0x6c,
	0x65, 0x6e, 0x67, 0x65, 0x12, 0x39, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x68,
	0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x73, 0x2f, 0x7b, 0x75, 0x75, 0x69, 0x64, 0x7d, 0x22,
	0xb0, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65,
	0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x53, 0x0a,
	0x09, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e,
	0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e,
	0x67, 0x65, 0x22, 0x94, 0x04, 0x0a, 0x18, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x41, 0x74, 0x74,
	0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x54, 0x0a, 0x09, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x52, 0x09, 0x63, 0x68, 0x61, 0x6c,
	0x6c, 0x65, 0x6e, 0x67, 0x65, 0x12, 0x63, 0x0a, 0x0f, 0x67, 0x63, 0x70, 0x5f, 0x63, 0x72, 0x65,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63, 0x70, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x61, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x67, 0x63, 0x70, 0x43,
	0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x63, 0x0a, 0x0f, 0x74, 0x70,
	0x6d, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x70, 0x6d, 0x41,
	0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0e, 0x74, 0x70, 0x6d, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x79, 0x0a, 0x17, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x5f,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x61, 0x6c, 0x53, 0x70, 0x61, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x15, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x53, 0x70, 0x61, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x5d, 0x0a, 0x0d, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x8c, 0x01, 0x0a, 0x19, 0x56, 0x65,
	0x72, 0x69, 0x66, 0x79, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2f, 0x0a, 0x11, 0x6f, 0x69, 0x64, 0x63, 0x5f,
	0x63, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x6f, 0x69, 0x64, 0x63, 0x43, 0x6c, 0x61,
	0x69, 0x6d, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x3e, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x61, 0x6c, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x61, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x22, 0x4b, 0x0a, 0x0e, 0x47, 0x63, 0x70, 0x43,
	0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x39, 0x0a, 0x19, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x64,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x16, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x64, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x22, 0xa0, 0x01, 0x0a, 0x0c, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1f, 0x0a, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x61,
	0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x6e, 0x6f, 0x6e, 0x63, 0x65,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x6e, 0x6f, 0x6e,
	0x63, 0x65, 0x12, 0x54, 0x0a, 0x0a, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x22, 0x83, 0x04, 0x0a, 0x0e, 0x54, 0x70, 0x6d,
	0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x06, 0x71,
	0x75, 0x6f, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x70, 0x6d, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x65, 0x52, 0x06, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x73,
	0x12, 0x22, 0x0a, 0x0d, 0x74, 0x63, 0x67, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x6f,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x74, 0x63, 0x67, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x4c, 0x6f, 0x67, 0x12, 0x2e, 0x0a, 0x13, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61,
	0x6c, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x6f, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x11, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x4c, 0x6f, 0x67, 0x12, 0x17, 0x0a, 0x07, 0x61, 0x6b, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x61, 0x6b, 0x43, 0x65, 0x72, 0x74, 0x12, 0x1d, 0x0a,
	0x0a, 0x63, 0x65, 0x72, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0c, 0x52, 0x09, 0x63, 0x65, 0x72, 0x74, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x1a, 0x8f, 0x02, 0x0a,
	0x05, 0x51, 0x75, 0x6f, 0x74, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x68, 0x61, 0x73, 0x68, 0x5f, 0x61,
	0x6c, 0x67, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x68, 0x61, 0x73, 0x68, 0x41,
	0x6c, 0x67, 0x6f, 0x12, 0x69, 0x0a, 0x0a, 0x70, 0x63, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x70, 0x6d, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x51,
	0x75, 0x6f, 0x74, 0x65, 0x2e, 0x50, 0x63, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x09, 0x70, 0x63, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x1b,
	0x0a, 0x09, 0x72, 0x61, 0x77, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x08, 0x72, 0x61, 0x77, 0x51, 0x75, 0x6f, 0x74, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72,
	0x61, 0x77, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0c, 0x72, 0x61, 0x77, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x1a, 0x3c, 0x0a, 0x0e, 0x50, 0x63, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x7a,
	0x0a, 0x15, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x53, 0x70,
	0x61, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x61, 0x0a, 0x0f, 0x73, 0x69, 0x67, 0x6e, 0x65,
	0x64, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x69, 0x67, 0x6e,
	0x65, 0x64, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x22, 0x92, 0x01, 0x0a, 0x0c, 0x53,
	0x69, 0x67, 0x6e, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x81, 0x01, 0x0a, 0x1a,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x22,
	0xd6, 0x01, 0x0a, 0x17, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x70,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x21, 0x0a, 0x09, 0x73, 0x69,
	0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65,
	0x79, 0x12, 0x55, 0x0a, 0x07, 0x73, 0x69, 0x67, 0x5f, 0x61, 0x6c, 0x67, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x69,
	0x6e, 0x67, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x73, 0x69, 0x67, 0x41, 0x6c, 0x67, 0x2a, 0x7f, 0x0a, 0x10, 0x53, 0x69, 0x67, 0x6e,
	0x69, 0x6e, 0x67, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x21, 0x0a, 0x1d,
	0x53, 0x49, 0x47, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x4c, 0x47, 0x4f, 0x52, 0x49, 0x54, 0x48,
	0x4d, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x15, 0x0a, 0x11, 0x52, 0x53, 0x41, 0x53, 0x53, 0x41, 0x5f, 0x50, 0x53, 0x53, 0x5f, 0x53, 0x48,
	0x41, 0x32, 0x35, 0x36, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x53, 0x41, 0x53, 0x53, 0x41,
	0x5f, 0x50, 0x4b, 0x43, 0x53, 0x31, 0x56, 0x31, 0x35, 0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36,
	0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x45, 0x43, 0x44, 0x53, 0x41, 0x5f, 0x50, 0x32, 0x35, 0x36,
	0x5f, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x03, 0x2a, 0x3c, 0x0a, 0x09, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x4f, 0x49, 0x44, 0x43, 0x10, 0x01, 0x32, 0xb7, 0x04, 0x0a, 0x15, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x12, 0xd8, 0x01, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6c,
	0x6c, 0x65, 0x6e, 0x67, 0x65, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61,
	0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x22, 0x54, 0xda, 0x41, 0x10, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3b, 0x3a, 0x09, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x22, 0x2e, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x73, 0x12, 0xe8, 0x01, 0x0a,
	0x11, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x69, 0x66,
	0x79, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x69,
	0x66, 0x79, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x50, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x3a, 0x01, 0x2a,
	0x22, 0x45, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x41, 0x74, 0x74, 0x65,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x58, 0xca, 0x41, 0x24, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x42, 0x97, 0x02, 0x0a, 0x29, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x42,
	0x0c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x70, 0x62, 0x3b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x70, 0x62,
	0xaa, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x28, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x43, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_confidentialcomputing_v1_service_proto_rawDescOnce sync.Once
	file_google_cloud_confidentialcomputing_v1_service_proto_rawDescData = file_google_cloud_confidentialcomputing_v1_service_proto_rawDesc
)

func file_google_cloud_confidentialcomputing_v1_service_proto_rawDescGZIP() []byte {
	file_google_cloud_confidentialcomputing_v1_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_confidentialcomputing_v1_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_confidentialcomputing_v1_service_proto_rawDescData)
	})
	return file_google_cloud_confidentialcomputing_v1_service_proto_rawDescData
}

var file_google_cloud_confidentialcomputing_v1_service_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_confidentialcomputing_v1_service_proto_goTypes = []interface{}{
	(SigningAlgorithm)(0),             // 0: google.cloud.confidentialcomputing.v1.SigningAlgorithm
	(TokenType)(0),                    // 1: google.cloud.confidentialcomputing.v1.TokenType
	(*Challenge)(nil),                 // 2: google.cloud.confidentialcomputing.v1.Challenge
	(*CreateChallengeRequest)(nil),    // 3: google.cloud.confidentialcomputing.v1.CreateChallengeRequest
	(*VerifyAttestationRequest)(nil),  // 4: google.cloud.confidentialcomputing.v1.VerifyAttestationRequest
	(*VerifyAttestationResponse)(nil), // 5: google.cloud.confidentialcomputing.v1.VerifyAttestationResponse
	(*GcpCredentials)(nil),            // 6: google.cloud.confidentialcomputing.v1.GcpCredentials
	(*TokenOptions)(nil),              // 7: google.cloud.confidentialcomputing.v1.TokenOptions
	(*TpmAttestation)(nil),            // 8: google.cloud.confidentialcomputing.v1.TpmAttestation
	(*ConfidentialSpaceInfo)(nil),     // 9: google.cloud.confidentialcomputing.v1.ConfidentialSpaceInfo
	(*SignedEntity)(nil),              // 10: google.cloud.confidentialcomputing.v1.SignedEntity
	(*ContainerImageSignature)(nil),   // 11: google.cloud.confidentialcomputing.v1.ContainerImageSignature
	(*TpmAttestation_Quote)(nil),      // 12: google.cloud.confidentialcomputing.v1.TpmAttestation.Quote
	nil,                               // 13: google.cloud.confidentialcomputing.v1.TpmAttestation.Quote.PcrValuesEntry
	(*timestamppb.Timestamp)(nil),     // 14: google.protobuf.Timestamp
	(*status.Status)(nil),             // 15: google.rpc.Status
}
var file_google_cloud_confidentialcomputing_v1_service_proto_depIdxs = []int32{
	14, // 0: google.cloud.confidentialcomputing.v1.Challenge.create_time:type_name -> google.protobuf.Timestamp
	14, // 1: google.cloud.confidentialcomputing.v1.Challenge.expire_time:type_name -> google.protobuf.Timestamp
	2,  // 2: google.cloud.confidentialcomputing.v1.CreateChallengeRequest.challenge:type_name -> google.cloud.confidentialcomputing.v1.Challenge
	6,  // 3: google.cloud.confidentialcomputing.v1.VerifyAttestationRequest.gcp_credentials:type_name -> google.cloud.confidentialcomputing.v1.GcpCredentials
	8,  // 4: google.cloud.confidentialcomputing.v1.VerifyAttestationRequest.tpm_attestation:type_name -> google.cloud.confidentialcomputing.v1.TpmAttestation
	9,  // 5: google.cloud.confidentialcomputing.v1.VerifyAttestationRequest.confidential_space_info:type_name -> google.cloud.confidentialcomputing.v1.ConfidentialSpaceInfo
	7,  // 6: google.cloud.confidentialcomputing.v1.VerifyAttestationRequest.token_options:type_name -> google.cloud.confidentialcomputing.v1.TokenOptions
	15, // 7: google.cloud.confidentialcomputing.v1.VerifyAttestationResponse.partial_errors:type_name -> google.rpc.Status
	1,  // 8: google.cloud.confidentialcomputing.v1.TokenOptions.token_type:type_name -> google.cloud.confidentialcomputing.v1.TokenType
	12, // 9: google.cloud.confidentialcomputing.v1.TpmAttestation.quotes:type_name -> google.cloud.confidentialcomputing.v1.TpmAttestation.Quote
	10, // 10: google.cloud.confidentialcomputing.v1.ConfidentialSpaceInfo.signed_entities:type_name -> google.cloud.confidentialcomputing.v1.SignedEntity
	11, // 11: google.cloud.confidentialcomputing.v1.SignedEntity.container_image_signatures:type_name -> google.cloud.confidentialcomputing.v1.ContainerImageSignature
	0,  // 12: google.cloud.confidentialcomputing.v1.ContainerImageSignature.sig_alg:type_name -> google.cloud.confidentialcomputing.v1.SigningAlgorithm
	13, // 13: google.cloud.confidentialcomputing.v1.TpmAttestation.Quote.pcr_values:type_name -> google.cloud.confidentialcomputing.v1.TpmAttestation.Quote.PcrValuesEntry
	3,  // 14: google.cloud.confidentialcomputing.v1.ConfidentialComputing.CreateChallenge:input_type -> google.cloud.confidentialcomputing.v1.CreateChallengeRequest
	4,  // 15: google.cloud.confidentialcomputing.v1.ConfidentialComputing.VerifyAttestation:input_type -> google.cloud.confidentialcomputing.v1.VerifyAttestationRequest
	2,  // 16: google.cloud.confidentialcomputing.v1.ConfidentialComputing.CreateChallenge:output_type -> google.cloud.confidentialcomputing.v1.Challenge
	5,  // 17: google.cloud.confidentialcomputing.v1.ConfidentialComputing.VerifyAttestation:output_type -> google.cloud.confidentialcomputing.v1.VerifyAttestationResponse
	16, // [16:18] is the sub-list for method output_type
	14, // [14:16] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_cloud_confidentialcomputing_v1_service_proto_init() }
func file_google_cloud_confidentialcomputing_v1_service_proto_init() {
	if File_google_cloud_confidentialcomputing_v1_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Challenge); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateChallengeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VerifyAttestationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VerifyAttestationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcpCredentials); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TokenOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TpmAttestation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfidentialSpaceInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignedEntity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContainerImageSignature); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TpmAttestation_Quote); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_confidentialcomputing_v1_service_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_confidentialcomputing_v1_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_confidentialcomputing_v1_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_confidentialcomputing_v1_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_confidentialcomputing_v1_service_proto_msgTypes,
	}.Build()
	File_google_cloud_confidentialcomputing_v1_service_proto = out.File
	file_google_cloud_confidentialcomputing_v1_service_proto_rawDesc = nil
	file_google_cloud_confidentialcomputing_v1_service_proto_goTypes = nil
	file_google_cloud_confidentialcomputing_v1_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ConfidentialComputingClient is the client API for ConfidentialComputing service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ConfidentialComputingClient interface {
	// Creates a new Challenge in a given project and location.
	CreateChallenge(ctx context.Context, in *CreateChallengeRequest, opts ...grpc.CallOption) (*Challenge, error)
	// Verifies the provided attestation info, returning a signed OIDC token.
	VerifyAttestation(ctx context.Context, in *VerifyAttestationRequest, opts ...grpc.CallOption) (*VerifyAttestationResponse, error)
}

type confidentialComputingClient struct {
	cc grpc.ClientConnInterface
}

func NewConfidentialComputingClient(cc grpc.ClientConnInterface) ConfidentialComputingClient {
	return &confidentialComputingClient{cc}
}

func (c *confidentialComputingClient) CreateChallenge(ctx context.Context, in *CreateChallengeRequest, opts ...grpc.CallOption) (*Challenge, error) {
	out := new(Challenge)
	err := c.cc.Invoke(ctx, "/google.cloud.confidentialcomputing.v1.ConfidentialComputing/CreateChallenge", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *confidentialComputingClient) VerifyAttestation(ctx context.Context, in *VerifyAttestationRequest, opts ...grpc.CallOption) (*VerifyAttestationResponse, error) {
	out := new(VerifyAttestationResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.confidentialcomputing.v1.ConfidentialComputing/VerifyAttestation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConfidentialComputingServer is the server API for ConfidentialComputing service.
type ConfidentialComputingServer interface {
	// Creates a new Challenge in a given project and location.
	CreateChallenge(context.Context, *CreateChallengeRequest) (*Challenge, error)
	// Verifies the provided attestation info, returning a signed OIDC token.
	VerifyAttestation(context.Context, *VerifyAttestationRequest) (*VerifyAttestationResponse, error)
}

// UnimplementedConfidentialComputingServer can be embedded to have forward compatible implementations.
type UnimplementedConfidentialComputingServer struct {
}

func (*UnimplementedConfidentialComputingServer) CreateChallenge(context.Context, *CreateChallengeRequest) (*Challenge, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateChallenge not implemented")
}
func (*UnimplementedConfidentialComputingServer) VerifyAttestation(context.Context, *VerifyAttestationRequest) (*VerifyAttestationResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method VerifyAttestation not implemented")
}

func RegisterConfidentialComputingServer(s *grpc.Server, srv ConfidentialComputingServer) {
	s.RegisterService(&_ConfidentialComputing_serviceDesc, srv)
}

func _ConfidentialComputing_CreateChallenge_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateChallengeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfidentialComputingServer).CreateChallenge(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.confidentialcomputing.v1.ConfidentialComputing/CreateChallenge",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfidentialComputingServer).CreateChallenge(ctx, req.(*CreateChallengeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfidentialComputing_VerifyAttestation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VerifyAttestationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfidentialComputingServer).VerifyAttestation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.confidentialcomputing.v1.ConfidentialComputing/VerifyAttestation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfidentialComputingServer).VerifyAttestation(ctx, req.(*VerifyAttestationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ConfidentialComputing_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.confidentialcomputing.v1.ConfidentialComputing",
	HandlerType: (*ConfidentialComputingServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateChallenge",
			Handler:    _ConfidentialComputing_CreateChallenge_Handler,
		},
		{
			MethodName: "VerifyAttestation",
			Handler:    _ConfidentialComputing_VerifyAttestation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/confidentialcomputing/v1/service.proto",
}
