/***************************************************************
 * Name:      svd_vidfmt.cpp
 * Purpose:   video formats table
 * Author:    Tomasz Pawlak (tomasz.pawlak @ wp.eu)
 * Copyright: Tomasz Pawlak (C) 2014-2025
 * License:   GPLv3+
 **************************************************************/

#include "vmap.h"

/* VDB: Video Data Block : VIC values
   Notes:
   Parentheses indicate instances where pixels are repeated to meet the minimum speed
   requirements of the interface. For example, in the 720x240p case, the pixels on each line
   are double-clocked. In the (2880)x480i case, the number of pixels on each line, and thus
   the number of times that they are repeated, is variable, and is sent to the DTV monitor by
   the source device.
*/

sm_vmap SVD_vidfmt_map = {
//        Code Name
{1,   {0, "DMT0659   4:3", "640x480p @ 59.94/60Hz"         }},
{2,   {0, "480p      4:3", "720x480p @ 59.94/60Hz"         }},
{3,   {0, "480pH    16:9", "720x480pH @ 59.94/60Hz"        }},
{4,   {0, "720p     16:9", "1280x720p @ 59.94/60Hz"        }},
{5,   {0, "1080i    16:9", "1920x1080i @ 59.94/60Hz"       }},
{6,   {0, "480i      4:3", "720(1440)x480i @ 59.94/60Hz"   }},
{7,   {0, "480iH    16:9", "720(1440)x480i @ 59.94/60Hz"   }},
{8,   {0, "240p      4:3", "720(1440)x240p @ 59.94/60Hz"   }},
{9,   {0, "240pH    16:9", "720(1440)x240pH @ 59.94/60Hz"  }},
{10,  {0, "480i4x    4:3", "(2880)x480i @ 59.94/60Hz"      }},
{11,  {0, "480i4xH  16:9", "(2880)x480i @ 59.94/60Hz"      }},
{12,  {0, "240p4x    4:3", "(2880)x240p @ 59.94/60Hz"      }},
{13,  {0, "240p4xH  16:9", "(2880)x240p @ 59.94/60Hz"      }},
{14,  {0, "480p2x    4:3", "1440x480p @ 59.94/60Hz"        }},
{15,  {0, "480p2xH  16:9", "1440x480p @ 59.94/60Hz"        }},
{16,  {0, "1080p    16:9", "1920x1080p @ 59.94/60Hz"       }},
{17,  {0, "576p      4:3", "720x576p @ 50Hz"               }},
{18,  {0, "576pH    16:9", "720x576pH @ 50Hz"              }},
{19,  {0, "720p50   16:9", "1280x720p @ 50Hz"              }},
{20,  {0, "1080i25  16:9", "1920x1080i(1125 Vtotal) @ 50Hz"}},
{21,  {0, "576i      4:3", "720(1440)x576i @ 50Hz"         }},
{22,  {0, "576iH    16:9", "720(1440)x576iH @ 50Hz"        }},
{23,  {0, "288p      4:3", "720(1440)x288p @ 50Hz"         }},
{24,  {0, "288pH    16:9", "720(1440)x288pH @ 50Hz"        }},
{25,  {0, "576i4x    4:3", "(2880)x576i @ 50Hz"            }},
{26,  {0, "576i4xH  16:9", "(2880)x576i @ 50Hz"            }},
{27,  {0, "288p4x    4:3", "(2880)x288p @ 50Hz"            }},
{28,  {0, "288p4xH  16:9", "(2880)x288p @ 50Hz"            }},
{29,  {0, "576p2x    4:3", "1440x576p @ 50Hz"              }},
{30,  {0, "576p2xH  16:9", "1440x576p @ 50Hz"              }},
{31,  {0, "1080p50  16:9", "1920x1080p @ 50Hz"             }},
{32,  {0, "1080p24  16:9", "1920x1080p @ 23.98/24Hz"       }},
{33,  {0, "1080p25  16:9", "1920x1080p @ 25Hz"             }},
{34,  {0, "1080p30  16:9", "1920x1080p @ 29.97/30Hz"       }},
{35,  {0, "480p4x    4:3", "(2880)x480p @ 59.94/60Hz"      }},
{36,  {0, "480p4xH  16:9", "(2880)x480p @ 59.94/60Hz"      }},
{37,  {0, "576p4x    4:3", "(2880)x576p @ 50Hz"            }},
{38,  {0, "576p4xH  16:9", "(2880)x576p @ 50Hz"            }},
{39,  {0, "1080i25  16:9", "1920x1080i(1250 VTotal) @ 50Hz"}},
{40,  {0, "1080i50  16:9", "1920x1080i @ 100Hz"            }},
{41,  {0, "720p100  16:9", "1280x720p @ 100Hz"             }},
{42,  {0, "576p100   4:3", "720x576p @ 100Hz"              }},
{43,  {0, "576p100H 16:9", "720x576p @ 100Hz"              }},
{44,  {0, "576i50    4:3", "720(1440)x576i @ 100Hz"        }},
{45,  {0, "576i50H  16:9", "720(1440)x576i @ 100Hz"        }},
{46,  {0, "1080i60  16:9", "1920x1080i @ 119.88/120Hz"     }},
{47,  {0, "720p120  16:9", "1280x720p @ 119.88/120Hz"      }},
{48,  {0, "480p119   4:3", "720x480p @ 119.88/120Hz"       }},
{49,  {0, "480p119H 16:9", "720x480p @ 119.88/120Hz"       }},
{50,  {0, "480i59    4:3", "720(1440)x480i @ 119.88/120Hz" }},
{51,  {0, "480i59H  16:9", "720(1440)x480i @ 119.88/120Hz" }},
{52,  {0, "576p200   4:3", "720x576p @ 200Hz"              }},
{53,  {0, "576p200H 16:9", "720x576p @ 200Hz"              }},
{54,  {0, "576i100   4:3", "720(1440)x576i @ 200Hz"        }},
{55,  {0, "576i100H 16:9", "720(1440)x576i @ 200Hz"        }},
{56,  {0, "480p239   4:3", "720x480p @ 239.76/240Hz"       }},
{57,  {0, "480p239H 16:9", "720x480p @ 239.76/240Hz"       }},
{58,  {0, "480i119   4:3", "720(1440)x480i @ 239.76/240Hz" }},
{59,  {0, "480i119H 16:9", "720(1440)x480i @ 239.76/240Hz" }},
{60,  {0, "720p24   16:9", "1280x720p @ 23.98/24Hz"        }},
{61,  {0, "720p25   16:9", "1280x720p @ 25Hz"              }},
{62,  {0, "720p30   16:9", "1280x720p @ 29.97/30Hz"        }},
{63,  {0, "1080p120 16:9", "1920x1080p @ 119.88/120Hz"     }},

//Here Code Names are not official.
{64,  {0, "1080p100 16:9", "1920x1080p @ 100Hz"        }},

//Video Codes 65..127 *must not* have the native flag set,
//to be distinguishable from codes in range 193..255 (8-bit VIC)
{65,  {0, "720p24   64:27", "1280x720p @ 23.98/24Hz"   }},
{66,  {0, "720p25   64:27", "1280x720p @ 25Hz"         }},
{67,  {0, "720p30   64:27", "1280x720p @ 29.97/30Hz"   }},
{68,  {0, "720p50   64:27", "1280x720p @ 50Hz"         }},
{69,  {0, "720p60   64:27", "1280x720p @ 59.94/60Hz"   }},
{70,  {0, "720p100  64:27", "1280x720p @ 100Hz"        }},
{71,  {0, "720p120  64:27", "1280x720p @ 119.88/120Hz" }},

{72,  {0, "1080p24  64:27", "1920x1080p @ 23.98/24Hz"  }},
{73,  {0, "1080p25  64:27", "1920x1080p @ 25Hz"        }},
{74,  {0, "1080p30  64:27", "1920x1080p @ 29.97/30Hz"  }},
{75,  {0, "1080p50  64:27", "1920x1080p @ 50Hz"        }},
{76,  {0, "1080p60  64:27", "1920x1080p @ 59.94/60Hz"  }},
{77,  {0, "1080p100 64:27", "1920x1080p @ 100Hz"       }},
{78,  {0, "1080p120 64:27", "1920x1080p @ 119.88/120Hz"}},

{79,  {0, "720p24   64:27", "1680x720p @ 23.98/24Hz"   }},
{80,  {0, "720p25   64:27", "1680x720p @ 25Hz"         }},
{81,  {0, "720p30   64:27", "1680x720p @ 29.97/30Hz"   }},
{82,  {0, "720p50   64:27", "1680x720p @ 50Hz"         }},
{83,  {0, "720p60   64:27", "1680x720p @ 59.94/60Hz"   }},
{84,  {0, "720p100  64:27", "1680x720p @ 100Hz"        }},
{85,  {0, "720p120  64:27", "1680x720p @ 119.88/120Hz" }},

{86,  {0, "1080p24  64:27", "2560x1080p @ 23.98/24Hz"  }},
{87,  {0, "1080p25  64:27", "2560x1080p @ 25Hz"        }},
{88,  {0, "1080p30  64:27", "2560x1080p @ 29.97/30Hz"  }},
{89,  {0, "1080p50  64:27", "2560x1080p @ 50Hz"        }},
{90,  {0, "1080p60  64:27", "2560x1080p @ 59.94/60Hz"  }},
{91,  {0, "1080p100 64:27", "2560x1080p @ 100Hz"       }},
{92,  {0, "1080p120 64:27", "2560x1080p @ 119.88/120Hz"}},

{93,  {0, "2160p24  16:9" , "3840x2160p @ 23.98/24Hz"  }},
{94,  {0, "2160p25  16:9" , "3840x2160p @ 25Hz"        }},
{95,  {0, "2160p30  16:9" , "3840x2160p @ 29.97/30Hz"  }},
{96,  {0, "2160p50  16:9" , "3840x2160p @ 50Hz"        }},
{97,  {0, "2160p60  16:9" , "3840x2160p @ 59.94/60Hz"  }},

{98,  {0, "2160p24 256:135","4096x2160p @ 23.98/24Hz"  }},
{99,  {0, "2160p25 256:135","4096x2160p @ 25Hz"        }},
{100, {0, "2160p30 256:135","4096x2160p @ 29.97/30Hz"  }},
{101, {0, "2160p50 256:135","4096x2160p @ 50Hz"        }},
{102, {0, "2160p60 256:135","4096x2160p @ 59.94/60Hz"  }},

{103, {0, "2160p24  64:27", "3840x2160p @ 23.98/24Hz"  }},
{104, {0, "2160p25  64:27", "3840x2160p @ 25Hz"        }},
{105, {0, "2160p30  64:27", "3840x2160p @ 29.97/30Hz"  }},
{106, {0, "2160p50  64:27", "3840x2160p @ 50Hz"        }},
{107, {0, "2160p60  64:27", "3840x2160p @ 59.94/60Hz"  }},

{108, {0, "720p48   16:9" , "1280x720p @ 47.95/48Hz"   }},
{109, {0, "720p48   64:27", "1280x720p @ 47.95/48Hz"   }},
{110, {0, "720p48   64:27", "1680x720p @ 47.95/48Hz"   }},
{111, {0, "1080p48  16:9" , "1920x1080p @ 47.95/48Hz"  }},
{112, {0, "1080p48  64:27", "1920x1080p @ 47.95/48Hz"  }},
{113, {0, "1080p48  64:27", "2560x1080p @ 47.95/48Hz"  }},
{114, {0, "2160p48  16:9" , "3840x2160p @ 47.95/48Hz"  }},
{115, {0, "2160p48 256:135","4096x2160p @ 47.95/48Hz"  }},
{116, {0, "2160p48  64:27", "3840x2160p @ 47.95/48Hz"  }},

{117, {0, "2160p100 16:9" , "3840x2160p @ 100Hz"       }},
{118, {0, "2160p120 16:9" , "3840x2160p @ 119.88/120Hz"}},
{119, {0, "2160p100 64:27", "3840x2160p @ 100Hz"       }},
{120, {0, "2160p120 64:27", "3840x2160p @ 119.88/120Hz"}},

{121, {0, "2160p24  64:27", "5120x2160p @ 23.98/24Hz"  }},
{122, {0, "2160p25  64:27", "5120x2160p @ 25Hz"        }},
{123, {0, "2160p30  64:27", "5120x2160p @ 29.97/30Hz"  }},
{124, {0, "2160p48  64:27", "5120x2160p @ 47.95/48Hz"  }},
{125, {0, "2160p50  64:27", "5120x2160p @ 50Hz"        }},
{126, {0, "2160p60  64:27", "5120x2160p @ 59.94/60Hz"  }},
{127, {0, "2160p100 64:27", "5120x2160p @ 100Hz"       }},

//Video code 128 is reserved

//Video codes 129..192 mean that the Native flag is set,
//effective VIC is obtained by masking the native flag, resulting range is 1..64

//Video codes 193..219: 8-bit VIC
{193, {0, "2160p120 64:27", "5120x2160p @ 119.88/120Hz" }},

{194, {0, "4320p24  16:9" , "7680x4320p @ 23.98/24Hz"   }},
{195, {0, "4320p25  16:9" , "7680x4320p @ 25Hz"         }},
{196, {0, "4320p30  16:9" , "7680x4320p @ 29.97/30Hz"   }},
{197, {0, "4320p48  16:9" , "7680x4320p @ 47.95/48Hz"   }},
{198, {0, "4320p50  16:9" , "7680x4320p @ 50Hz"         }},
{199, {0, "4320p60  16:9" , "7680x4320p @ 59.94/60Hz"   }},
{200, {0, "4320p100 16:9" , "7680x4320p @ 100Hz"        }},
{201, {0, "4320p120 16:9" , "7680x4320p @ 119.88/120Hz" }},

{202, {0, "4320p24  64:27", "7680x4320p @ 23.98/24Hz"   }},
{203, {0, "4320p25  64:27", "7680x4320p @ 25Hz"         }},
{204, {0, "4320p30  64:27", "7680x4320p @ 29.97/30Hz"   }},
{205, {0, "4320p48  64:27", "7680x4320p @ 47.95/48Hz"   }},
{206, {0, "4320p50  64:27", "7680x4320p @ 50Hz"         }},
{207, {0, "4320p60  64:27", "7680x4320p @ 59.94/60Hz"   }},
{208, {0, "4320p100 64:27", "7680x4320p @ 100Hz"        }},
{209, {0, "4320p120 64:27", "7680x4320p @ 119.88/120Hz" }},

{210, {0, "4320p24  64:27", "10240x4320p @ 23.98/24Hz"  }},
{211, {0, "4320p25  64:27", "10240x4320p @ 25Hz"        }},
{212, {0, "4320p30  64:27", "10240x4320p @ 29.97/30Hz"  }},
{213, {0, "4320p48  64:27", "10240x4320p @ 47.95/48Hz"  }},
{214, {0, "4320p50  64:27", "10240x4320p @ 50Hz"        }},
{215, {0, "4320p60  64:27", "10240x4320p @ 59.94/60Hz"  }},
{216, {0, "4320p100 64:27", "10240x4320p @ 100Hz"       }},
{217, {0, "4320p120 64:27", "10240x4320p @ 119.88/120Hz"}},

{218, {0, "2160p100 256:135","4096x2160p @ 100Hz"       }},
{219, {0, "2160p120 256:135","4096x2160p @ 119.88/120Hz"}}

//Video codes 220-255 are reserved for future use in G spec

};

/* VESA DMT timings
   RB: Reduced Blanking
   IL: InterLaced

  NOTE: The order of byte values is the same as listed in the VESA document,
        but in the EDID structure values are written in reversed order.
*/

vfmt_t dmt_table[] = {  /*
DMT-ID   STD2      CVT3  */
{0x00, 0x0101,        0, "<not used>"     },
{0x01,      0,        0, "640x350 @ 85Hz" },
{0x02, 0x3119,        0, "640x400 @ 85Hz" },
{0x03,      0,        0, "720x400 @ 85Hz" },
{0x04, 0x3140,        0, "640x480 @ 60Hz" },
{0x05, 0x314C,        0, "640x480 @ 72Hz" },
{0x06, 0x314F,        0, "640x480 @ 75Hz" },
{0x07, 0x3159,        0, "640x480 @ 85Hz" },

{0x08,      0,        0, "800x600 @ 56Hz" },
{0x09, 0x4540,        0, "800x600 @ 60Hz" },
{0x0A, 0x454C,        0, "800x600 @ 72Hz" },
{0x0B, 0x454F,        0, "800x600 @ 75Hz" },
{0x0C, 0x4559,        0, "800x600 @ 85Hz" },
{0x0D,      0,        0, "800x600 @ 120Hz (RB)"},

{0x0E,      0,        0, "848x480 @ 60Hz" },

{0x0F,      0,        0, "1024x768 @ 43Hz (IL)"},
{0x10, 0x6140,        0, "1024x768 @ 60Hz"},
{0x11, 0x614A,        0, "1024x768 @ 70Hz"},
{0x12, 0x614F,        0, "1024x768 @ 75Hz"},
{0x13, 0x6159,        0, "1024x768 @ 85Hz"},
{0x14,      0,        0, "1024x768 @ 120Hz (RB)"},

{0x15, 0x714F,        0, "1152x864 @ 75Hz"},

{0x55, 0x81C0,        0, "1280x720 @ 60Hz"},

{0x16,      0, 0x7F1C21, "1280x768 @ 60Hz (RB)"},
{0x17,      0, 0x7F1C28, "1280x768 @ 60Hz"},
{0x18,      0, 0x7F1C44, "1280x768 @ 75Hz"},
{0x19,      0, 0x7F1C62, "1280x768 @ 85Hz"},
{0x1A,      0,        0, "1280x768 @ 120Hz (RB)"},

{0x1B,      0, 0x8F1821, "1280x800 @ 60Hz (RB)"},
{0x1C, 0x8100, 0x8F1828, "1280x800 @ 60Hz"},
{0x1D, 0x810F, 0x8F1844, "1280x800 @ 75Hz"},
{0x1E, 0x8119, 0x8F1862, "1280x800 @ 85Hz"},
{0x1F,      0,        0, "1280x800 @ 120Hz (RB)"},

{0x20, 0x8140,        0, "1280x960 @ 60Hz"},
{0x21, 0x8159,        0, "1280x960 @ 85Hz"},
{0x22,      0,        0, "1280x960 @ 120Hz (RB)"},

{0x23, 0x8180,        0, "1280x1024 @ 60Hz"},
{0x24, 0x818F,        0, "1280x1024 @ 75Hz"},
{0x25, 0x8199,        0, "1280x1024 @ 85Hz"},
{0x26,      0,        0, "1280x1024 @ 120Hz (RB)"},

{0x27,      0,        0, "1360x768 @ 60Hz" },
{0x28,      0,        0, "1360x768 @ 120Hz (RB)"},
{0x51,      0,        0, "1366x768 @ 60Hz" },
{0x56,      0,        0, "1366x768 @ 60Hz (RB)"},

{0x29,      0, 0x0C2021, "1400x1050 @ 60Hz (RB)"},
{0x2A, 0x9040, 0x0C2028, "1400x1050 @ 60Hz"},
{0x2B, 0x904F, 0x0C2044, "1400x1050 @ 75Hz"},
{0x2C, 0x9059, 0x0C2062, "1400x1050 @ 85Hz"},
{0x2D,      0,        0, "1400x1050 @ 120Hz (RB)"},

{0x2E,      0, 0xC11821, "1440x900 @ 60Hz (RB)"},
{0x2F, 0x9500, 0xC11828, "1440x900 @ 60Hz" },
{0x30, 0x950F, 0xC11844, "1440x900 @ 75Hz" },
{0x31, 0x9519, 0xC11868, "1440x900 @ 85Hz" },
{0x32,      0,        0, "1440x900 @ 120Hz (RB)"},

{0x53, 0xA9C0,        0, "1600x900 @ 60Hz (RB)"},

{0x33, 0xA940,        0, "1600x1200 @ 60Hz"},
{0x34, 0xA945,        0, "1600x1200 @ 65Hz"},
{0x35, 0xA94A,        0, "1600x1200 @ 70Hz"},
{0x36, 0xA94F,        0, "1600x1200 @ 75Hz"},
{0x37, 0xA959,        0, "1600x1200 @ 85Hz"},
{0x38,      0,        0, "1600x1200 @ 120Hz (RB)"},

{0x39,      0, 0x0C2821, "1680x1050 @ 60Hz (RB)"},
{0x3A, 0xB300, 0x0C2828, "1680x1050 @ 60Hz"},
{0x3B, 0xB30F, 0x0C2844, "1680x1050 @ 75Hz"},
{0x3C, 0xB319, 0x0C2868, "1680x1050 @ 85Hz"},
{0x3D,      0,        0, "1680x1050 @ 120Hz (RB)"},

{0x3E, 0xC140,        0, "1792x1344 @ 60Hz"},
{0x3F, 0xC14F,        0, "1792x1344 @ 75Hz"},
{0x40,      0,        0, "1792x1344 @ 120Hz (RB)"},

{0x41, 0xC940,        0, "1856x1392 @ 60Hz"},
{0x42, 0xC94F,        0, "1856x1392 @ 75Hz"},
{0x43,      0,        0, "1856x1392 @ 120Hz (RB)"},

{0x52, 0xD1C0,        0, "1920x1080 @ 60Hz"},

{0x44,      0, 0x572821, "1920x1200 @ 60Hz (RB)"},
{0x45, 0xD100, 0x572828, "1920x1200 @ 60Hz"},
{0x46, 0xD10F, 0x572844, "1920x1200 @ 75Hz"},
{0x47, 0xD119, 0x572862, "1920x1200 @ 85Hz"},
{0x48,      0,        0, "1920x1200 @ 120Hz (RB)"},

{0x49, 0xD140,        0, "1920x1440 @ 60Hz"},
{0x4A, 0xD14F,        0, "1920x1440 @ 75Hz"},
{0x4B,      0,        0, "1920x1440 @ 120Hz (RB)"},

{0x54, 0xE1C0,        0, "2048x1152 @ 60Hz"},

{0x4C,      0, 0x1F3821, "2560x1600 @ 60Hz (RB)"},
{0x4D,      0, 0x1F3828, "2560x1600 @ 60Hz"},
{0x4E,      0, 0x1F3844, "2560x1600 @ 75Hz"},
{0x4F,      0, 0x1F3862, "2560x1600 @ 85Hz"},
{0x50,      0,        0, "2560x1600 @ 120Hz (RB)"},

{0x57,      0,        0, "4096x2160 @ 60Hz (RB2)"},
{0x58,      0,        0, "4096x2160 @ 59.94Hz (RB2)"},

{0x00,      0,        0, NULL}
};

//ET3: Estabilished Timings 3 Descriptor
//Mode names (matching ET3 bit order)
const char* ET3_mode[] = {
//byte 6
"1152_864_75", //bit 0
"1024_768_85",
"800_600_85",
"848_480_60",
"640_480_85",
"720_400_85",
"640_400_85",
"640_350_85", //bit 7
//byte 7
"1280_1024_85",
"1280_1024_60",
"1280_960_85",
"1280_960_60",
"1280_768_85",
"1280_768_75",
"1280_768_60",
"1280_768_60_RB", //Reduced Blanking
//byte 8
"1400_1050_75",
"1400_1050_60",
"1400_1050_60_RB",
"1440_900_85",
"1440_900_75",
"1440_900_60",
"1440_900_60_RB",
"1360_768_60",
//byte 9
"1600_1200_70",
"1600_1200_65",
"1600_1200_60",
"1680_1050_85",
"1680_1050_75",
"1680_1050_60",
"1680_1050_60_RB",
"1400_1050_85",
//byte 10
"1920_1200_60",
"1920_1200_60_RB",
"1856_1392_75",
"1856_1392_60",
"1792_1344_75",
"1792_1344_60",
"1600_1200_85",
"1600_1200_75",
//byte 11
"1920_1440_75", //bit 4
"1920_1440_60",
"1920_1200_85",
"1920_1200_75", //bit 7
"res11_03",     //bits 0..3
};

