% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowMedians.R
\name{rowMedians}
\alias{rowMedians}
\alias{rowMedians,matrix_OR_array_OR_table_OR_numeric-method}
\alias{rowMedians,ANY-method}
\alias{colMedians}
\alias{colMedians,matrix_OR_array_OR_table_OR_numeric-method}
\alias{colMedians,ANY-method}
\title{Calculates the median for each row (column) of a matrix-like object}
\usage{
rowMedians(x, rows = NULL, cols = NULL, na.rm = FALSE, ...)

\S4method{rowMedians}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL, cols = NULL, na.rm = FALSE, dim. = dim(x), ...)

\S4method{rowMedians}{ANY}(x, rows = NULL, cols = NULL, na.rm = FALSE, ...)

colMedians(x, rows = NULL, cols = NULL, na.rm = FALSE, ...)

\S4method{colMedians}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL, cols = NULL, na.rm = FALSE, dim. = dim(x), ...)

\S4method{colMedians}{ANY}(x, rows = NULL, cols = NULL, na.rm = FALSE, ...)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, \code{\link{NA}}s
are excluded first, otherwise not.}

\item{...}{Additional arguments passed to specific methods.}

\item{dim.}{An \code{\link{integer}} \code{\link{vector}} of length two
specifying the dimension of \code{x}, essential when x is a
\code{\link{numeric}} vector. Note, that this is not a generic
argument and not all methods need provide it.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the median for each row (column) of a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowMedians}
/ \code{matrixStats::colMedians}.
}
\examples{
  mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
  mat[2, 1] <- NA
  mat[3, 3] <- Inf
  mat[4, 1] <- 0
  
  print(mat)
  
  rowMedians(mat)
  colMedians(mat)
  
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowMedians}()} and
\code{matrixStats::\link[matrixStats:rowMedians]{colMedians}()} which are
used when the input is a \code{matrix} or \code{numeric} vector.
\item For mean estimates, see \code{\link{rowMeans2}()} and
\code{\link[base:colSums]{rowMeans}()}.
}
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
